/*
 * Decompiled with CFR 0.152.
 */
package jogamp.openal;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.util.SecurityUtil;
import com.jogamp.openal.ALC;
import com.jogamp.openal.ALCcontext;
import com.jogamp.openal.ALCdevice;
import com.jogamp.openal.ALException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.security.PrivilegedAction;
import jogamp.openal.ALCProcAddressTable;
import jogamp.openal.ALImpl;

public abstract class ALCAbstractImpl
implements ALC {
    private static final ALCProcAddressTable alcProcAddressTable = SecurityUtil.doPrivileged(new PrivilegedAction<ALCProcAddressTable>(){

        @Override
        public ALCProcAddressTable run() {
            ALCProcAddressTable aLCProcAddressTable = new ALCProcAddressTable();
            aLCProcAddressTable.reset(ALImpl.alDynamicLookupHelper);
            return aLCProcAddressTable;
        }
    });

    @Override
    public ALCcontext alcCreateContext(ALCdevice aLCdevice, IntBuffer intBuffer) {
        boolean bl = Buffers.isDirect(intBuffer);
        long l = ALCAbstractImpl.alcProcAddressTable._addressof_alcCreateContext;
        if (l == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "alcCreateContext"));
        }
        ByteBuffer byteBuffer = this.dispatch_alcCreateContext1(aLCdevice == null ? null : aLCdevice.getBuffer(), bl ? intBuffer : Buffers.getArray(intBuffer), bl ? Buffers.getDirectBufferByteOffset(intBuffer) : Buffers.getIndirectBufferByteOffset(intBuffer), bl, l);
        if (byteBuffer == null) {
            return null;
        }
        return ALCcontext.create(Buffers.nativeOrder(byteBuffer));
    }

    private native ByteBuffer dispatch_alcCreateContext1(ByteBuffer var1, Object var2, int var3, boolean var4, long var5);

    @Override
    public ALCcontext alcCreateContext(ALCdevice aLCdevice, int[] nArray, int n) {
        if (nArray != null && nArray.length <= n) {
            throw new ALException("array offset argument \"attrlist_offset\" (" + n + ") equals or exceeds array length (" + nArray.length + ")");
        }
        long l = ALCAbstractImpl.alcProcAddressTable._addressof_alcCreateContext;
        if (l == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "alcCreateContext"));
        }
        ByteBuffer byteBuffer = this.dispatch_alcCreateContext1(aLCdevice == null ? null : aLCdevice.getBuffer(), nArray, 4 * n, false, l);
        if (byteBuffer == null) {
            return null;
        }
        return ALCcontext.create(Buffers.nativeOrder(byteBuffer));
    }

    @Override
    public boolean alcMakeContextCurrent(ALCcontext aLCcontext) {
        long l = ALCAbstractImpl.alcProcAddressTable._addressof_alcMakeContextCurrent;
        if (l == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "alcMakeContextCurrent"));
        }
        return this.dispatch_alcMakeContextCurrent1(aLCcontext == null ? null : aLCcontext.getBuffer(), l);
    }

    private native boolean dispatch_alcMakeContextCurrent1(ByteBuffer var1, long var2);

    @Override
    public void alcProcessContext(ALCcontext aLCcontext) {
        long l = ALCAbstractImpl.alcProcAddressTable._addressof_alcProcessContext;
        if (l == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "alcProcessContext"));
        }
        this.dispatch_alcProcessContext1(aLCcontext == null ? null : aLCcontext.getBuffer(), l);
    }

    private native void dispatch_alcProcessContext1(ByteBuffer var1, long var2);

    @Override
    public void alcSuspendContext(ALCcontext aLCcontext) {
        long l = ALCAbstractImpl.alcProcAddressTable._addressof_alcSuspendContext;
        if (l == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "alcSuspendContext"));
        }
        this.dispatch_alcSuspendContext1(aLCcontext == null ? null : aLCcontext.getBuffer(), l);
    }

    private native void dispatch_alcSuspendContext1(ByteBuffer var1, long var2);

    @Override
    public void alcDestroyContext(ALCcontext aLCcontext) {
        long l = ALCAbstractImpl.alcProcAddressTable._addressof_alcDestroyContext;
        if (l == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "alcDestroyContext"));
        }
        this.dispatch_alcDestroyContext1(aLCcontext == null ? null : aLCcontext.getBuffer(), l);
    }

    private native void dispatch_alcDestroyContext1(ByteBuffer var1, long var2);

    @Override
    public ALCcontext alcGetCurrentContext() {
        long l = ALCAbstractImpl.alcProcAddressTable._addressof_alcGetCurrentContext;
        if (l == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "alcGetCurrentContext"));
        }
        ByteBuffer byteBuffer = this.dispatch_alcGetCurrentContext1(l);
        if (byteBuffer == null) {
            return null;
        }
        return ALCcontext.create(Buffers.nativeOrder(byteBuffer));
    }

    private native ByteBuffer dispatch_alcGetCurrentContext1(long var1);

    @Override
    public ALCdevice alcGetContextsDevice(ALCcontext aLCcontext) {
        long l = ALCAbstractImpl.alcProcAddressTable._addressof_alcGetContextsDevice;
        if (l == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "alcGetContextsDevice"));
        }
        ByteBuffer byteBuffer = this.dispatch_alcGetContextsDevice1(aLCcontext == null ? null : aLCcontext.getBuffer(), l);
        if (byteBuffer == null) {
            return null;
        }
        return ALCdevice.create(Buffers.nativeOrder(byteBuffer));
    }

    private native ByteBuffer dispatch_alcGetContextsDevice1(ByteBuffer var1, long var2);

    @Override
    public ALCdevice alcOpenDevice(String string) {
        long l = ALCAbstractImpl.alcProcAddressTable._addressof_alcOpenDevice;
        if (l == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "alcOpenDevice"));
        }
        ByteBuffer byteBuffer = this.dispatch_alcOpenDevice1(string, l);
        if (byteBuffer == null) {
            return null;
        }
        return ALCdevice.create(Buffers.nativeOrder(byteBuffer));
    }

    private native ByteBuffer dispatch_alcOpenDevice1(String var1, long var2);

    @Override
    public boolean alcCloseDevice(ALCdevice aLCdevice) {
        long l = ALCAbstractImpl.alcProcAddressTable._addressof_alcCloseDevice;
        if (l == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "alcCloseDevice"));
        }
        return this.dispatch_alcCloseDevice1(aLCdevice == null ? null : aLCdevice.getBuffer(), l);
    }

    private native boolean dispatch_alcCloseDevice1(ByteBuffer var1, long var2);

    @Override
    public int alcGetError(ALCdevice aLCdevice) {
        long l = ALCAbstractImpl.alcProcAddressTable._addressof_alcGetError;
        if (l == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "alcGetError"));
        }
        return this.dispatch_alcGetError1(aLCdevice == null ? null : aLCdevice.getBuffer(), l);
    }

    private native int dispatch_alcGetError1(ByteBuffer var1, long var2);

    @Override
    public boolean alcIsExtensionPresent(ALCdevice aLCdevice, String string) {
        long l = ALCAbstractImpl.alcProcAddressTable._addressof_alcIsExtensionPresent;
        if (l == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "alcIsExtensionPresent"));
        }
        return this.dispatch_alcIsExtensionPresent1(aLCdevice == null ? null : aLCdevice.getBuffer(), string, l);
    }

    private native boolean dispatch_alcIsExtensionPresent1(ByteBuffer var1, String var2, long var3);

    ByteBuffer alcGetProcAddress(ALCdevice aLCdevice, String string) {
        long l = ALCAbstractImpl.alcProcAddressTable._addressof_alcGetProcAddress;
        if (l == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "alcGetProcAddress"));
        }
        ByteBuffer byteBuffer = this.dispatch_alcGetProcAddress1(aLCdevice == null ? null : aLCdevice.getBuffer(), string, l);
        if (byteBuffer == null) {
            return null;
        }
        Buffers.nativeOrder(byteBuffer);
        return byteBuffer;
    }

    private native ByteBuffer dispatch_alcGetProcAddress1(ByteBuffer var1, String var2, long var3);

    @Override
    public int alcGetEnumValue(ALCdevice aLCdevice, String string) {
        long l = ALCAbstractImpl.alcProcAddressTable._addressof_alcGetEnumValue;
        if (l == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "alcGetEnumValue"));
        }
        return this.dispatch_alcGetEnumValue1(aLCdevice == null ? null : aLCdevice.getBuffer(), string, l);
    }

    private native int dispatch_alcGetEnumValue1(ByteBuffer var1, String var2, long var3);

    @Override
    public void alcGetIntegerv(ALCdevice aLCdevice, int n, int n2, IntBuffer intBuffer) {
        boolean bl = Buffers.isDirect(intBuffer);
        long l = ALCAbstractImpl.alcProcAddressTable._addressof_alcGetIntegerv;
        if (l == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "alcGetIntegerv"));
        }
        this.dispatch_alcGetIntegerv1(aLCdevice == null ? null : aLCdevice.getBuffer(), n, n2, bl ? intBuffer : Buffers.getArray(intBuffer), bl ? Buffers.getDirectBufferByteOffset(intBuffer) : Buffers.getIndirectBufferByteOffset(intBuffer), bl, l);
    }

    private native void dispatch_alcGetIntegerv1(ByteBuffer var1, int var2, int var3, Object var4, int var5, boolean var6, long var7);

    @Override
    public void alcGetIntegerv(ALCdevice aLCdevice, int n, int n2, int[] nArray, int n3) {
        if (nArray != null && nArray.length <= n3) {
            throw new ALException("array offset argument \"values_offset\" (" + n3 + ") equals or exceeds array length (" + nArray.length + ")");
        }
        long l = ALCAbstractImpl.alcProcAddressTable._addressof_alcGetIntegerv;
        if (l == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "alcGetIntegerv"));
        }
        this.dispatch_alcGetIntegerv1(aLCdevice == null ? null : aLCdevice.getBuffer(), n, n2, nArray, 4 * n3, false, l);
    }

    @Override
    public ALCdevice alcCaptureOpenDevice(String string, int n, int n2, int n3) {
        long l = ALCAbstractImpl.alcProcAddressTable._addressof_alcCaptureOpenDevice;
        if (l == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "alcCaptureOpenDevice"));
        }
        ByteBuffer byteBuffer = this.dispatch_alcCaptureOpenDevice1(string, n, n2, n3, l);
        if (byteBuffer == null) {
            return null;
        }
        return ALCdevice.create(Buffers.nativeOrder(byteBuffer));
    }

    private native ByteBuffer dispatch_alcCaptureOpenDevice1(String var1, int var2, int var3, int var4, long var5);

    @Override
    public boolean alcCaptureCloseDevice(ALCdevice aLCdevice) {
        long l = ALCAbstractImpl.alcProcAddressTable._addressof_alcCaptureCloseDevice;
        if (l == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "alcCaptureCloseDevice"));
        }
        return this.dispatch_alcCaptureCloseDevice1(aLCdevice == null ? null : aLCdevice.getBuffer(), l);
    }

    private native boolean dispatch_alcCaptureCloseDevice1(ByteBuffer var1, long var2);

    @Override
    public void alcCaptureStart(ALCdevice aLCdevice) {
        long l = ALCAbstractImpl.alcProcAddressTable._addressof_alcCaptureStart;
        if (l == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "alcCaptureStart"));
        }
        this.dispatch_alcCaptureStart1(aLCdevice == null ? null : aLCdevice.getBuffer(), l);
    }

    private native void dispatch_alcCaptureStart1(ByteBuffer var1, long var2);

    @Override
    public void alcCaptureStop(ALCdevice aLCdevice) {
        long l = ALCAbstractImpl.alcProcAddressTable._addressof_alcCaptureStop;
        if (l == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "alcCaptureStop"));
        }
        this.dispatch_alcCaptureStop1(aLCdevice == null ? null : aLCdevice.getBuffer(), l);
    }

    private native void dispatch_alcCaptureStop1(ByteBuffer var1, long var2);

    @Override
    public void alcCaptureSamples(ALCdevice aLCdevice, Buffer buffer, int n) {
        boolean bl = Buffers.isDirect(buffer);
        long l = ALCAbstractImpl.alcProcAddressTable._addressof_alcCaptureSamples;
        if (l == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "alcCaptureSamples"));
        }
        this.dispatch_alcCaptureSamples1(aLCdevice == null ? null : aLCdevice.getBuffer(), bl ? buffer : Buffers.getArray(buffer), bl ? Buffers.getDirectBufferByteOffset(buffer) : Buffers.getIndirectBufferByteOffset(buffer), bl, n, l);
    }

    private native void dispatch_alcCaptureSamples1(ByteBuffer var1, Object var2, int var3, boolean var4, int var5, long var6);

    public static ALCProcAddressTable getALCProcAddressTable() {
        return alcProcAddressTable;
    }
}

