/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.driver.x11;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.nio.Buffers;
import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.GraphicsConfigurationFactory;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.VisualIDHolder;
import com.jogamp.nativewindow.util.InsetsImmutable;
import com.jogamp.nativewindow.util.Point;
import com.jogamp.nativewindow.x11.X11GraphicsDevice;
import com.jogamp.nativewindow.x11.X11GraphicsScreen;
import com.jogamp.newt.MonitorDevice;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.MonitorEvent;
import com.jogamp.newt.event.MouseEvent;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import jogamp.nativewindow.SurfaceScaleUtils;
import jogamp.nativewindow.x11.X11Lib;
import jogamp.nativewindow.x11.X11Util;
import jogamp.newt.DisplayImpl;
import jogamp.newt.PointerIconImpl;
import jogamp.newt.WindowImpl;
import jogamp.newt.driver.PNGIcon;
import jogamp.newt.driver.x11.DisplayDriver;
import jogamp.newt.driver.x11.ScreenDriver;

public class WindowDriver
extends WindowImpl {
    private static final String WINDOW_CLASS_NAME = "NewtWindow";
    private static final int X11_WHEEL_ONE_UP_BUTTON = 4;
    private static final int X11_WHEEL_ONE_DOWN_BUTTON = 5;
    private static final int X11_WHEEL_TWO_UP_BUTTON = 6;
    private static final int X11_WHEEL_TWO_DOWN_BUTTON = 7;
    private static final int defaultIconDataSize;
    private static final Buffer defaultIconData;
    private volatile MonitorDevice last_monitor;
    volatile boolean tempFSAlwaysOnTop = false;
    private volatile long javaWindowHandle = 0L;
    private X11GraphicsDevice renderDevice;

    private boolean updatePixelScaleByMonitor(MonitorDevice monitorDevice, int[] nArray, boolean bl) {
        boolean bl2 = false;
        if (!this.hasSetPixelScale() && null != monitorDevice) {
            float[] fArray = new float[]{0.0f, 0.0f};
            monitorDevice.getPixelScale(fArray);
            if (DEBUG_IMPLEMENTATION) {
                System.err.println("Window.updatePixelScaleByMonitor: pixel " + this.getSurfaceBounds() + ", window " + this.getBounds());
                System.err.println("Window.updatePixelScaleByMonitor: monitor " + monitorDevice);
                System.err.println("Window.updatePixelScaleByMonitor: has " + this.hasPixelScale[0] + ", new " + fArray[0] + " - " + WindowDriver.getThreadName());
            }
            bl2 = this.applySoftPixelScale(nArray, fArray, bl);
        }
        return bl2;
    }

    @Override
    protected void monitorModeChanged(MonitorEvent monitorEvent, boolean bl) {
        if (this.last_monitor == monitorEvent.getMonitor()) {
            this.updatePixelScaleByMonitor(monitorEvent.getMonitor(), null, true);
        }
    }

    @Override
    public final boolean setSurfaceScale(float[] fArray) {
        super.setSurfaceScale(fArray);
        boolean bl = false;
        if (this.isNativeValid()) {
            bl = this.applySoftPixelScale(null, this.reqPixelScale, true);
        }
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("WindowDriver.setPixelScale: min[" + this.minPixelScale[0] + ", " + this.minPixelScale[1] + "], max[" + this.maxPixelScale[0] + ", " + this.maxPixelScale[1] + "], req[" + this.reqPixelScale[0] + ", " + this.reqPixelScale[1] + "] -> result[" + this.hasPixelScale[0] + ", " + this.hasPixelScale[1] + "] - changed " + bl + ", realized " + this.isNativeValid());
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void createNativeImpl(boolean[] blArray) {
        ScreenDriver screenDriver = (ScreenDriver)this.getScreen();
        DisplayDriver displayDriver = (DisplayDriver)screenDriver.getDisplay();
        AbstractGraphicsDevice abstractGraphicsDevice = displayDriver.getGraphicsDevice();
        long l = X11Util.openDisplay(abstractGraphicsDevice.getConnection());
        if (0L == l) {
            throw new RuntimeException("Error creating display(GfxCfg/Render): " + abstractGraphicsDevice.getConnection());
        }
        this.renderDevice = new X11GraphicsDevice(l, 0, true);
        X11GraphicsScreen x11GraphicsScreen = new X11GraphicsScreen(this.renderDevice, screenDriver.getIndex());
        GraphicsConfigurationFactory graphicsConfigurationFactory = GraphicsConfigurationFactory.getFactory(displayDriver.getGraphicsDevice(), this.capsRequested);
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = graphicsConfigurationFactory.chooseGraphicsConfiguration(this.capsRequested, this.capsRequested, this.capabilitiesChooser, x11GraphicsScreen, 0);
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("X11Window.createNativeImpl() factory: " + graphicsConfigurationFactory + ", chosen config: " + abstractGraphicsConfiguration);
        }
        if (null == abstractGraphicsConfiguration) {
            throw new NativeWindowException("Error choosing GraphicsConfiguration creating window: " + this);
        }
        int n = abstractGraphicsConfiguration.getVisualID(VisualIDHolder.VIDType.NATIVE);
        if (0 == n) {
            throw new NativeWindowException("Chosen Configuration w/o native visual ID: " + abstractGraphicsConfiguration);
        }
        this.setGraphicsConfiguration(abstractGraphicsConfiguration);
        int n2 = this.getReconfigureMask(0, true) & 0x47FF;
        abstractGraphicsDevice.lock();
        if (!this.hasSetPixelScale()) {
            this.updatePixelScaleByMonitor(this.getMainMonitor(), null, false);
        }
        int[] nArray = this.getPixelPosI();
        int[] nArray2 = this.getPixelSizeI();
        try {
            long[] lArray = this.CreateWindow(this.getParentWindowHandle(), abstractGraphicsDevice.getHandle(), screenDriver.getIndex(), n, displayDriver.getJavaObjectAtom(), displayDriver.getWindowDeleteAtom(), displayDriver.getXiOpcode(), nArray[0], nArray[1], nArray2[0], nArray2[1], n2, defaultIconDataSize, defaultIconData, DEBUG_IMPLEMENTATION);
            if (null == lArray || 2 != lArray.length || 0L == lArray[0] || 0L == lArray[1]) {
                throw new NativeWindowException("Error creating window");
            }
            if (DEBUG_IMPLEMENTATION) {
                System.err.println("X11Window.createNativeImpl() handles " + WindowDriver.toHexString(lArray[0]) + ", " + WindowDriver.toHexString(lArray[1]));
            }
            this.setWindowHandle(lArray[0]);
            this.javaWindowHandle = lArray[1];
            this.last_monitor = this.getMainMonitor();
            blArray[0] = this.hasSetPixelScale() && this.applySoftPixelScale(null, this.reqPixelScale, true);
        }
        finally {
            abstractGraphicsDevice.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeNativeImpl() {
        long l = this.javaWindowHandle;
        if (0L != l && null != this.getScreen()) {
            DisplayDriver displayDriver = (DisplayDriver)this.getScreen().getDisplay();
            AbstractGraphicsDevice abstractGraphicsDevice = displayDriver.getGraphicsDevice();
            abstractGraphicsDevice.lock();
            try {
                this.setWindowHandle(0L);
                this.javaWindowHandle = 0L;
                this.CloseWindow0(displayDriver, abstractGraphicsDevice.getHandle(), l, displayDriver.getRandREventBase(), displayDriver.getRandRErrorBase(), displayDriver.getXiOpcode());
            }
            catch (Throwable throwable) {
                if (DEBUG_IMPLEMENTATION) {
                    Exception exception = new Exception("Warning: closeNativeImpl failed - " + Thread.currentThread().getName(), throwable);
                    exception.printStackTrace();
                }
            }
            finally {
                abstractGraphicsDevice.unlock();
                this.last_monitor = null;
            }
        }
        if (null != this.renderDevice) {
            this.renderDevice.close();
            this.renderDevice = null;
        }
    }

    @Override
    protected final int getSupportedReconfigMaskImpl() {
        if (0L == this.javaWindowHandle) {
            return 32765;
        }
        return (0x4909 | WindowDriver.GetSupportedReconfigMask0(this.javaWindowHandle)) & 0xFFFF;
    }

    @Override
    protected boolean reconfigureWindowImpl(int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        InsetsImmutable insetsImmutable;
        if (0 == (0x10 & n5)) {
            insetsImmutable = this.getInsets();
            n7 = n - insetsImmutable.getLeftWidth();
            n6 = n2 - insetsImmutable.getTopHeight();
        } else {
            insetsImmutable = null;
            n7 = n;
            n6 = n2;
        }
        final int[] nArray = SurfaceScaleUtils.scale(new int[2], n7, n6, this.hasPixelScale);
        final int[] nArray2 = SurfaceScaleUtils.scale(new int[2], n3, n4, this.hasPixelScale);
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("X11Window reconfig.0: " + n + "/" + n2 + " -> " + n7 + "/" + n6 + " " + n3 + "x" + n4 + " -> pixel[" + nArray[0] + "/" + nArray[1] + " " + nArray2[0] + "x" + nArray2[1] + "], insets " + insetsImmutable + ", " + WindowDriver.getReconfigStateMaskString(n5));
        }
        if (0 != (0x200000 & n5)) {
            if (0 != (0x800 & n5) && 0 == (0x20 & n5) && 0 == (0x40 & n5)) {
                this.tempFSAlwaysOnTop = true;
                n5 |= 0x20;
                if (DEBUG_IMPLEMENTATION) {
                    System.err.println("X11Window reconfig.2: temporary " + WindowDriver.getReconfigStateMaskString(n5));
                }
            } else {
                this.tempFSAlwaysOnTop = false;
            }
        }
        final int n8 = n5;
        this.runWithLockedDisplayDevice(new DisplayImpl.DisplayRunnable<Object>(){

            @Override
            public Object run(long l) {
                WindowDriver.reconfigureWindow0(l, WindowDriver.this.getScreenIndex(), WindowDriver.this.getParentWindowHandle(), WindowDriver.this.javaWindowHandle, nArray[0], nArray[1], nArray2[0], nArray2[1], n8);
                return null;
            }
        });
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("X11Window reconfig.X: " + this.getX() + "/" + this.getY() + " " + this.getWidth() + "x" + this.getHeight() + ", insets " + this.getInsets() + ", " + this.getStateMaskString());
        }
        return true;
    }

    @Override
    protected boolean focusChanged(boolean bl, boolean bl2) {
        if (this.isNativeValid() && this.isFullscreen() && !this.isAlwaysOnBottom() && this.tempFSAlwaysOnTop && this.hasFocus() != bl2) {
            final int n = this.getReconfigureMask(0x8000000, this.isVisible()) | (bl2 ? 32 : 0);
            if (DEBUG_IMPLEMENTATION) {
                System.err.println("X11Window reconfig.3 (focus): temporary " + WindowDriver.getReconfigStateMaskString(n));
            }
            this.runWithLockedDisplayDevice(new DisplayImpl.DisplayRunnable<Object>(){

                @Override
                public Object run(long l) {
                    WindowDriver.reconfigureWindow0(l, WindowDriver.this.getScreenIndex(), WindowDriver.this.getParentWindowHandle(), WindowDriver.this.javaWindowHandle, WindowDriver.this.getX(), WindowDriver.this.getY(), WindowDriver.this.getWidth(), WindowDriver.this.getHeight(), n);
                    return null;
                }
            });
        }
        return super.focusChanged(bl, bl2);
    }

    @Override
    protected boolean positionChanged(boolean bl, boolean bl2, int n, int n2) {
        boolean bl3 = super.positionChanged(bl, bl2, n, n2);
        if (bl3 && this.isNativeValid()) {
            MonitorDevice monitorDevice = this.getMainMonitor();
            if (null != this.last_monitor && !monitorDevice.equals(this.last_monitor)) {
                int[] nArray = new int[]{0, 0};
                MonitorDevice.Orientation orientation = MonitorDevice.Orientation.clone;
                orientation = monitorDevice.getOrientationTo(this.last_monitor, nArray);
                if (DEBUG_IMPLEMENTATION) {
                    System.err.println("Info: Window Device Changed (P: " + n + "/" + n2 + ", crt_move[orient " + (Object)((Object)orientation) + ", diff " + nArray[0] + "/" + nArray[1] + ") , monitor " + this.last_monitor.getName() + " -> " + monitorDevice.getName() + " - " + Thread.currentThread().getName());
                }
                this.last_monitor = monitorDevice;
                this.updatePixelScaleByMonitor(monitorDevice, nArray, true);
            }
        }
        return bl3;
    }

    protected boolean reparentNotify(long l) {
        if (DEBUG_IMPLEMENTATION) {
            long l2 = this.getParentWindowHandle();
            System.err.println("Window.reparentNotify (" + WindowDriver.getThreadName() + "): " + WindowDriver.toHexString(l2) + " -> " + WindowDriver.toHexString(l));
        }
        return this.isNativeValid();
    }

    @Override
    protected void requestFocusImpl(final boolean bl) {
        this.runWithLockedDisplayDevice(new DisplayImpl.DisplayRunnable<Object>(){

            @Override
            public Object run(long l) {
                WindowDriver.requestFocus0(l, WindowDriver.this.javaWindowHandle, bl);
                return null;
            }
        });
    }

    @Override
    protected void setTitleImpl(final String string) {
        this.runWithLockedDisplayDevice(new DisplayImpl.DisplayRunnable<Object>(){

            @Override
            public Object run(long l) {
                WindowDriver.setTitle0(l, WindowDriver.this.javaWindowHandle, string);
                return null;
            }
        });
    }

    @Override
    protected void setPointerIconImpl(final PointerIconImpl pointerIconImpl) {
        this.runWithLockedDisplayDevice(new DisplayImpl.DisplayRunnable<Object>(){

            @Override
            public Object run(long l) {
                try {
                    WindowDriver.setPointerIcon0(l, WindowDriver.this.javaWindowHandle, null != pointerIconImpl ? pointerIconImpl.validatedHandle() : 0L);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return null;
            }
        });
    }

    @Override
    protected boolean setPointerVisibleImpl(final boolean bl) {
        return this.runWithLockedDisplayDevice(new DisplayImpl.DisplayRunnable<Boolean>(){

            @Override
            public Boolean run(long l) {
                boolean bl2;
                PointerIconImpl pointerIconImpl = (PointerIconImpl)WindowDriver.this.getPointerIcon();
                if (bl && null != pointerIconImpl) {
                    WindowDriver.setPointerIcon0(l, WindowDriver.this.javaWindowHandle, pointerIconImpl.validatedHandle());
                    bl2 = true;
                } else {
                    bl2 = WindowDriver.setPointerVisible0(l, WindowDriver.this.javaWindowHandle, bl);
                }
                return bl2;
            }
        });
    }

    @Override
    protected boolean confinePointerImpl(final boolean bl) {
        return this.runWithLockedDisplayDevice(new DisplayImpl.DisplayRunnable<Boolean>(){

            @Override
            public Boolean run(long l) {
                return WindowDriver.confinePointer0(l, WindowDriver.this.javaWindowHandle, bl);
            }
        });
    }

    @Override
    protected void warpPointerImpl(final int n, final int n2) {
        this.runWithLockedDisplayDevice(new DisplayImpl.DisplayRunnable<Object>(){

            @Override
            public Object run(long l) {
                WindowDriver.warpPointer0(l, WindowDriver.this.javaWindowHandle, n, n2);
                return null;
            }
        });
    }

    @Override
    protected Point getLocationOnScreenImpl(int n, int n2) {
        final int[] nArray = SurfaceScaleUtils.scale(new int[2], n, n2, this.hasPixelScale);
        Point point = this.runWithLockedDisplayDevice(new DisplayImpl.DisplayRunnable<Point>(){

            @Override
            public Point run(long l) {
                return X11Lib.GetRelativeLocation(l, WindowDriver.this.getScreenIndex(), WindowDriver.this.getWindowHandle(), 0L, nArray[0], nArray[1]);
            }
        });
        return this.convertToWindowUnits(point);
    }

    @Override
    protected final void doMouseEvent(boolean bl, boolean bl2, short s, int n, int n2, int n3, short s2, float[] fArray, float f) {
        block0 : switch (s) {
            case 203: {
                switch (s2) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        return;
                    }
                }
                break;
            }
            case 204: {
                boolean bl3 = 0 != (n & 1);
                switch (s2) {
                    case 4: {
                        s = (short)207;
                        s2 = 1;
                        fArray[bl3 ? 0 : 1] = 1.0f;
                        break block0;
                    }
                    case 5: {
                        s = (short)207;
                        s2 = 1;
                        fArray[bl3 ? 0 : 1] = -1.0f;
                        break block0;
                    }
                    case 6: {
                        s = (short)207;
                        s2 = 1;
                        fArray[0] = 1.0f;
                        n |= 1;
                        break block0;
                    }
                    case 7: {
                        s = (short)207;
                        s2 = 1;
                        fArray[0] = -1.0f;
                        n |= 1;
                    }
                }
            }
        }
        super.doMouseEvent(bl, bl2, s, n, n2, n3, s2, fArray, f);
    }

    protected final boolean sendKeyEvent(short s, int n, short s2, short s3, char c, String string) {
        boolean bl = KeyEvent.isModifierKey(s2);
        boolean bl2 = 0 != (0x20000000 & n);
        char c2 = null != string ? string.charAt(0) : c;
        boolean bl3 = true;
        if (!bl2 || !bl) {
            switch (s) {
                case 300: {
                    bl3 = super.sendKeyEvent((short)300, n, s2, s3, c2);
                    break;
                }
                case 301: {
                    bl3 = super.sendKeyEvent((short)301, n, s2, s3, c2);
                }
            }
        }
        return bl3;
    }

    public final boolean sendTouchScreenEvent(short s, int n, int n2, short[] sArray, int[] nArray, int[] nArray2, float[] fArray, float f) {
        int n3 = sArray.length;
        MouseEvent.PointerType[] pointerTypeArray = new MouseEvent.PointerType[n3];
        for (int i = 0; i < n3; ++i) {
            pointerTypeArray[i] = MouseEvent.PointerType.TouchScreen;
        }
        this.doPointerEvent(false, false, pointerTypeArray, s, n, n2, true, sArray, nArray, nArray2, fArray, f, new float[]{0.0f, 0.0f, 0.0f}, 1.0f);
        return this.isNativeValid();
    }

    @Override
    public final boolean sendKeyEvent(short s, int n, short s2, short s3, char c) {
        throw new InternalError("XXX: Adapt Java Code to Native Code Changes");
    }

    @Override
    public final boolean enqueueKeyEvent(boolean bl, short s, int n, short s2, short s3, char c) {
        throw new InternalError("XXX: Adapt Java Code to Native Code Changes");
    }

    private static final String getCurrentThreadName() {
        return Thread.currentThread().getName();
    }

    private static final void dumpStack() {
        ExceptionUtils.dumpStack(System.err);
    }

    private final <T> T runWithLockedDisplayDevice(DisplayImpl.DisplayRunnable<T> displayRunnable) {
        return ((DisplayDriver)this.getScreen().getDisplay()).runWithLockedDisplayDevice(displayRunnable);
    }

    protected static native boolean initIDs0();

    private long[] CreateWindow(long l, long l2, int n, int n2, long l3, long l4, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Buffer buffer, boolean bl) {
        if (!Buffers.isDirect(buffer)) {
            throw new IllegalArgumentException("data buffer is not direct " + buffer);
        }
        return this.CreateWindow0(l, l2, n, n2, l3, l4, n3, n4, n5, n6, n7, n8, n9, buffer, Buffers.getDirectBufferByteOffset(buffer), true, bl);
    }

    private native long[] CreateWindow0(long var1, long var3, int var5, int var6, long var7, long var9, int var11, int var12, int var13, int var14, int var15, int var16, int var17, Object var18, int var19, boolean var20, boolean var21);

    private static native int GetSupportedReconfigMask0(long var0);

    private native void CloseWindow0(DisplayDriver var1, long var2, long var4, int var6, int var7, int var8);

    private static native void reconfigureWindow0(long var0, int var2, long var3, long var5, int var7, int var8, int var9, int var10, int var11);

    private static native void requestFocus0(long var0, long var2, boolean var4);

    private static native void setTitle0(long var0, long var2, String var4);

    private static native void setPointerIcon0(long var0, long var2, long var4);

    private static native boolean setPointerVisible0(long var0, long var2, boolean var4);

    private static native boolean confinePointer0(long var0, long var2, boolean var4);

    private static native void warpPointer0(long var0, long var2, int var4, int var5);

    static {
        ScreenDriver.initSingleton();
        int n = 0;
        int n2 = 0;
        ByteBuffer byteBuffer = null;
        if (PNGIcon.isAvailable()) {
            try {
                int[] nArray = new int[]{0};
                int[] nArray2 = new int[]{0};
                byteBuffer = PNGIcon.arrayToX11BGRAImages(NewtFactory.getWindowIcons(), nArray, nArray2);
                n = nArray[0];
                n2 = nArray2[0];
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        defaultIconDataSize = n;
        defaultIconData = byteBuffer;
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("Def. Icon: data_size " + defaultIconDataSize + " * elem_size " + n2 + " = data " + defaultIconData);
        }
    }
}

