/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.windows;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.ElementBuffer;
import com.jogamp.common.nio.StructAccessor;
import com.jogamp.common.os.MachineDataInfo;
import java.nio.ByteBuffer;
import jogamp.common.os.MachineDataInfoRuntime;

public class RGBQUAD {
    StructAccessor accessor;
    private static final int mdIdx = MachineDataInfoRuntime.getStatic().ordinal();
    private final MachineDataInfo md;
    private static final int[] RGBQUAD_size = new int[]{4, 4, 4, 4, 4, 4, 4, 4, 4, 4};
    private static final int[] rgbBlue_offset = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] rgbGreen_offset = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
    private static final int[] rgbRed_offset = new int[]{2, 2, 2, 2, 2, 2, 2, 2, 2, 2};
    private static final int[] rgbReserved_offset = new int[]{3, 3, 3, 3, 3, 3, 3, 3, 3, 3};

    public static boolean usesNativeCode() {
        return false;
    }

    public static int size() {
        return RGBQUAD_size[mdIdx];
    }

    public static RGBQUAD create() {
        return RGBQUAD.create(Buffers.newDirectByteBuffer(RGBQUAD.size()));
    }

    public static RGBQUAD create(ByteBuffer byteBuffer) {
        return new RGBQUAD(byteBuffer);
    }

    public static RGBQUAD derefPointer(long l) {
        return RGBQUAD.create(ElementBuffer.derefPointer(RGBQUAD.size(), l, 1).getByteBuffer());
    }

    RGBQUAD(ByteBuffer byteBuffer) {
        this.md = MachineDataInfo.StaticConfig.values()[RGBQUAD.mdIdx].md;
        this.accessor = new StructAccessor(byteBuffer);
    }

    public final ByteBuffer getBuffer() {
        return this.accessor.getBuffer();
    }

    public final long getDirectBufferAddress() {
        return this.accessor.getDirectBufferAddress();
    }

    public final byte getRgbBlue() {
        return this.accessor.getByteAt(rgbBlue_offset[mdIdx]);
    }

    public final byte getRgbGreen() {
        return this.accessor.getByteAt(rgbGreen_offset[mdIdx]);
    }

    public final byte getRgbRed() {
        return this.accessor.getByteAt(rgbRed_offset[mdIdx]);
    }

    public final byte getRgbReserved() {
        return this.accessor.getByteAt(rgbReserved_offset[mdIdx]);
    }
}

