/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.drm;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.ElementBuffer;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.common.nio.StructAccessor;
import com.jogamp.common.os.MachineDataInfo;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import jogamp.common.os.MachineDataInfoRuntime;
import jogamp.nativewindow.drm.drmModeModeInfo;

public class drmModeConnector {
    StructAccessor accessor;
    private static final int mdIdx = MachineDataInfoRuntime.getStatic().ordinal();
    private final MachineDataInfo md;
    private static final int[] drmModeConnector_size = new int[]{60, 60, 60, 60, 60, 60, 60, 88, 88, 88};
    private static final int[] connector_id_offset = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] encoder_id_offset = new int[]{4, 4, 4, 4, 4, 4, 4, 4, 4, 4};
    private static final int[] connector_type_offset = new int[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 8};
    private static final int[] connector_type_id_offset = new int[]{12, 12, 12, 12, 12, 12, 12, 12, 12, 12};
    private static final int[] connection_offset = new int[]{16, 16, 16, 16, 16, 16, 16, 16, 16, 16};
    private static final int[] mmWidth_offset = new int[]{20, 20, 20, 20, 20, 20, 20, 20, 20, 20};
    private static final int[] mmHeight_offset = new int[]{24, 24, 24, 24, 24, 24, 24, 24, 24, 24};
    private static final int[] subpixel_offset = new int[]{28, 28, 28, 28, 28, 28, 28, 28, 28, 28};
    private static final int[] count_modes_offset = new int[]{32, 32, 32, 32, 32, 32, 32, 32, 32, 32};
    private static final int[] modes_offset = new int[]{36, 36, 36, 36, 36, 36, 36, 40, 40, 40};
    private static final int[] count_props_offset = new int[]{40, 40, 40, 40, 40, 40, 40, 48, 48, 48};
    private static final int[] props_offset = new int[]{44, 44, 44, 44, 44, 44, 44, 56, 56, 56};
    private static final int[] prop_values_offset = new int[]{48, 48, 48, 48, 48, 48, 48, 64, 64, 64};
    private static final int[] count_encoders_offset = new int[]{52, 52, 52, 52, 52, 52, 52, 72, 72, 72};
    private static final int[] encoders_offset = new int[]{56, 56, 56, 56, 56, 56, 56, 80, 80, 80};

    public static boolean usesNativeCode() {
        return false;
    }

    public static int size() {
        return drmModeConnector_size[mdIdx];
    }

    public static drmModeConnector create() {
        return drmModeConnector.create(Buffers.newDirectByteBuffer(drmModeConnector.size()));
    }

    public static drmModeConnector create(ByteBuffer byteBuffer) {
        return new drmModeConnector(byteBuffer);
    }

    public static drmModeConnector derefPointer(long l) {
        return drmModeConnector.create(ElementBuffer.derefPointer(drmModeConnector.size(), l, 1).getByteBuffer());
    }

    drmModeConnector(ByteBuffer byteBuffer) {
        this.md = MachineDataInfo.StaticConfig.values()[drmModeConnector.mdIdx].md;
        this.accessor = new StructAccessor(byteBuffer);
    }

    public final ByteBuffer getBuffer() {
        return this.accessor.getBuffer();
    }

    public final long getDirectBufferAddress() {
        return this.accessor.getDirectBufferAddress();
    }

    public final int getConnector_id() {
        return this.accessor.getIntAt(connector_id_offset[mdIdx]);
    }

    public final int getEncoder_id() {
        return this.accessor.getIntAt(encoder_id_offset[mdIdx]);
    }

    public final int getConnector_type() {
        return this.accessor.getIntAt(connector_type_offset[mdIdx]);
    }

    public final int getConnector_type_id() {
        return this.accessor.getIntAt(connector_type_id_offset[mdIdx]);
    }

    public final int getConnection() {
        return this.accessor.getIntAt(connection_offset[mdIdx]);
    }

    public final int getMmWidth() {
        return this.accessor.getIntAt(mmWidth_offset[mdIdx]);
    }

    public final int getMmHeight() {
        return this.accessor.getIntAt(mmHeight_offset[mdIdx]);
    }

    public final int getSubpixel() {
        return this.accessor.getIntAt(subpixel_offset[mdIdx]);
    }

    public final int getCount_modes() {
        return this.accessor.getIntAt(count_modes_offset[mdIdx], this.md.intSizeInBytes());
    }

    public final boolean isModesNull() {
        return 0L == PointerBuffer.wrap(this.getBuffer(), modes_offset[mdIdx], 1).get(0);
    }

    public final drmModeModeInfo[] getModes(int n, drmModeModeInfo[] drmModeModeInfoArray, int n2, int n3) {
        if (0 > n || 0 > n2 || 0 > n3 || n2 + n3 > drmModeModeInfoArray.length) {
            throw new IndexOutOfBoundsException("dest[pos " + n2 + ", length " + drmModeModeInfoArray.length + "], srcPos " + n + ", length " + n3);
        }
        int n4 = this.getCount_modes();
        if (n + n3 > n4) {
            throw new IndexOutOfBoundsException("srcPos " + n + " + length " + n3 + " > elemCount " + n4);
        }
        ElementBuffer elementBuffer = ElementBuffer.derefPointer(drmModeModeInfo.size(), this.getBuffer(), modes_offset[mdIdx], n4);
        for (int i = 0; i < n3; ++i) {
            drmModeModeInfoArray[n2 + i] = drmModeModeInfo.create(elementBuffer.slice(n + i, 1));
        }
        return drmModeModeInfoArray;
    }

    public final int getCount_props() {
        return this.accessor.getIntAt(count_props_offset[mdIdx], this.md.intSizeInBytes());
    }

    public final boolean isPropsNull() {
        return 0L == PointerBuffer.wrap(this.getBuffer(), props_offset[mdIdx], 1).get(0);
    }

    public final IntBuffer getProps() {
        return ElementBuffer.derefPointer(4, this.getBuffer(), props_offset[mdIdx], this.getCount_props()).getByteBuffer().asIntBuffer();
    }

    public final int[] getProps(int n, int[] nArray, int n2, int n3) {
        int n4 = this.getCount_props();
        ElementBuffer.derefPointer(4, this.getBuffer(), props_offset[mdIdx], n4).get(n, nArray, n2, n3);
        return nArray;
    }

    public final boolean isProp_valuesNull() {
        return 0L == PointerBuffer.wrap(this.getBuffer(), prop_values_offset[mdIdx], 1).get(0);
    }

    public final LongBuffer getProp_values() {
        return ElementBuffer.derefPointer(8, this.getBuffer(), prop_values_offset[mdIdx], this.getCount_props()).getByteBuffer().asLongBuffer();
    }

    public final long[] getProp_values(int n, long[] lArray, int n2, int n3) {
        int n4 = this.getCount_props();
        ElementBuffer.derefPointer(8, this.getBuffer(), prop_values_offset[mdIdx], n4).get(n, lArray, n2, n3);
        return lArray;
    }

    public final int getCount_encoders() {
        return this.accessor.getIntAt(count_encoders_offset[mdIdx], this.md.intSizeInBytes());
    }

    public final boolean isEncodersNull() {
        return 0L == PointerBuffer.wrap(this.getBuffer(), encoders_offset[mdIdx], 1).get(0);
    }

    public final IntBuffer getEncoders() {
        return ElementBuffer.derefPointer(4, this.getBuffer(), encoders_offset[mdIdx], this.getCount_encoders()).getByteBuffer().asIntBuffer();
    }

    public final int[] getEncoders(int n, int[] nArray, int n2, int n3) {
        int n4 = this.getCount_encoders();
        ElementBuffer.derefPointer(4, this.getBuffer(), encoders_offset[mdIdx], n4).get(n, nArray, n2, n3);
        return nArray;
    }
}

