/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font;

import com.jogamp.common.net.Uri;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.IOUtil;
import com.jogamp.common.util.JarUtil;
import com.jogamp.common.util.SecurityUtil;
import com.jogamp.common.util.cache.TempJarCache;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.font.FontFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.security.PrivilegedAction;

public abstract class FontLoaderImpl {
    private static boolean attemptedJARLoading = false;
    private static boolean useTempJARCache = false;

    protected static boolean isOneSet(int n, int n2) {
        return 0 != (n & n2);
    }

    protected synchronized Font readFont(String string, Uri.Encoded encoded, String string2) throws IOException {
        Object object;
        if (!attemptedJARLoading) {
            attemptedJARLoading = true;
            Platform.initSingleton();
            if (TempJarCache.isInitialized(false)) {
                try {
                    object = JarUtil.getRelativeOf(FontLoaderImpl.class, null, encoded);
                    Exception exception = SecurityUtil.doPrivileged(new PrivilegedAction<Exception>(){
                        final /* synthetic */ Uri val$uri;
                        {
                            this.val$uri = uri;
                        }

                        @Override
                        public Exception run() {
                            try {
                                TempJarCache.addResources(FontLoaderImpl.class, this.val$uri);
                                useTempJARCache = true;
                                return null;
                            }
                            catch (Exception exception) {
                                return exception;
                            }
                        }
                    });
                    if (null != exception) {
                        throw exception;
                    }
                }
                catch (Exception exception) {
                    System.err.println("Caught " + exception.getMessage());
                    exception.printStackTrace();
                }
            }
        }
        try {
            object = this.readFontImpl(string2 + string);
            if (null != object) {
                return object;
            }
            throw new IOException(String.format("Problem loading font %s, stream %s%s", string, string2, string));
        }
        catch (Exception exception) {
            throw new IOException(String.format("Problem loading font %s, stream %s%s", string, string2, string), exception);
        }
    }

    private Font readFontImpl(final String string) throws IOException {
        InputStream inputStream;
        if (useTempJARCache) {
            final Exception[] exceptionArray = new Exception[]{null};
            inputStream = SecurityUtil.doPrivileged(new PrivilegedAction<InputStream>(){

                @Override
                public InputStream run() {
                    try {
                        Uri uri = TempJarCache.getResourceUri(string);
                        return null != uri ? uri.toURL().openConnection().getInputStream() : null;
                    }
                    catch (Exception exception) {
                        exceptionArray[0] = exception;
                        return null;
                    }
                }
            });
            if (null != exceptionArray[0]) {
                throw new IOException(exceptionArray[0]);
            }
        } else {
            URLConnection uRLConnection = IOUtil.getResource(string, this.getClass().getClassLoader(), null);
            InputStream inputStream2 = inputStream = null != uRLConnection ? uRLConnection.getInputStream() : null;
        }
        if (null != inputStream) {
            return FontFactory.get(inputStream, true);
        }
        return null;
    }
}

