/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl;

import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLException;
import com.jogamp.opencl.CLObjectResource;
import com.jogamp.opencl.impl.CLTLInfoAccessor;
import com.jogamp.opencl.llb.CL;
import com.jogamp.opencl.util.CLUtil;
import java.nio.Buffer;

public class CLSampler
extends CLObjectResource {
    private final CLSamplerInfoAccessor samplerInfo;
    private final CL binding;

    private CLSampler(CLContext cLContext, long l, AddressingMode addressingMode, FilteringMode filteringMode, boolean bl) {
        super(cLContext, l);
        this.binding = cLContext.getPlatform().getCLBinding();
        this.samplerInfo = new CLSamplerInfoAccessor();
    }

    static CLSampler create(CLContext cLContext, AddressingMode addressingMode, FilteringMode filteringMode, boolean bl) {
        int[] nArray = new int[1];
        CL cL = cLContext.getPlatform().getCLBinding();
        long l = cL.clCreateSampler(cLContext.ID, CLUtil.clBoolean(bl), addressingMode.MODE, filteringMode.MODE, nArray, 0);
        CLException.checkForError(nArray[0], "can not create sampler");
        return new CLSampler(cLContext, l, addressingMode, filteringMode, bl);
    }

    public FilteringMode getFilteringMode() {
        int n = (int)this.samplerInfo.getLong(4436);
        return FilteringMode.valueOf(n);
    }

    public AddressingMode getAddressingMode() {
        int n = (int)this.samplerInfo.getLong(4435);
        return AddressingMode.valueOf(n);
    }

    public boolean hasNormalizedCoords() {
        return this.samplerInfo.getLong(4434) == 1L;
    }

    @Override
    public void release() {
        super.release();
        int n = this.binding.clReleaseSampler(this.ID);
        this.context.onSamplerReleased(this);
        if (n != 0) {
            throw CLException.newException(n, "can not release " + this);
        }
    }

    private class CLSamplerInfoAccessor
    extends CLTLInfoAccessor {
        private CLSamplerInfoAccessor() {
        }

        @Override
        protected int getInfo(int n, long l, Buffer buffer, PointerBuffer pointerBuffer) {
            return CLSampler.this.binding.clGetSamplerInfo(CLSampler.this.ID, n, l, buffer, pointerBuffer);
        }
    }

    public static enum AddressingMode {
        REPEAT(4403),
        CLAMP_TO_EDGE(4401),
        CLAMP(4402),
        NONE(4400);

        public final int MODE;

        private AddressingMode(int n2) {
            this.MODE = n2;
        }

        public static AddressingMode valueOf(int n) {
            switch (n) {
                case 4403: {
                    return REPEAT;
                }
                case 4401: {
                    return CLAMP_TO_EDGE;
                }
                case 4402: {
                    return CLAMP;
                }
                case 4400: {
                    return NONE;
                }
            }
            return null;
        }
    }

    public static enum FilteringMode {
        NEAREST(4416),
        LINEAR(4417);

        public final int MODE;

        private FilteringMode(int n2) {
            this.MODE = n2;
        }

        public static FilteringMode valueOf(int n) {
            switch (n) {
                case 4416: {
                    return NEAREST;
                }
                case 4417: {
                    return LINEAR;
                }
            }
            return null;
        }
    }
}

