/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt;

import com.jogamp.common.util.ArrayHashSet;
import com.jogamp.common.util.PropertyAccess;
import com.jogamp.nativewindow.util.Dimension;
import com.jogamp.nativewindow.util.DimensionImmutable;
import com.jogamp.nativewindow.util.Rectangle;
import com.jogamp.nativewindow.util.RectangleImmutable;
import com.jogamp.newt.Display;
import com.jogamp.newt.MonitorMode;
import com.jogamp.newt.Screen;
import java.util.List;

public abstract class MonitorDevice {
    protected final Screen screen;
    protected final long nativeHandle;
    protected final int nativeId;
    protected final String name;
    protected final DimensionImmutable sizeMM;
    protected final MonitorMode originalMode;
    protected final ArrayHashSet<MonitorMode> supportedModes;
    protected final float[] pixelScale;
    protected final Rectangle viewportPU;
    protected final Rectangle viewportWU;
    protected boolean isClone;
    protected boolean isPrimary;
    protected MonitorMode currentMode;
    protected boolean modeChanged;
    public static final DimensionImmutable DEFAULT_MODE_PIXEL_SIZE;
    public static final boolean DEFAULT_MODE_PIXEL_SIZE_OVERRIDE;
    public static final int DEFAULT_MODE_REFRESH;
    public static final boolean DEFAULT_MODE_REFRESH_OVERRIDE;
    public static final int DEFAULT_MODE_BPP;
    public static final boolean DEFAULT_MODE_BPP_OVERRIDE;
    public static final DimensionImmutable DEFAULT_SCREEN_MM_SIZE;
    public static final boolean DEFAULT_SCREEN_MM_SIZE_OVERRIDE;

    public final Orientation getOrientationTo(MonitorDevice monitorDevice, int[] nArray) {
        Orientation orientation = Orientation.clone;
        if (null != monitorDevice) {
            RectangleImmutable rectangleImmutable = monitorDevice.getViewport();
            RectangleImmutable rectangleImmutable2 = this.getViewport();
            if (rectangleImmutable.getY() == rectangleImmutable2.getY() || rectangleImmutable.getY() + rectangleImmutable.getHeight() - 1 == rectangleImmutable2.getY() + rectangleImmutable2.getHeight() - 1) {
                if (rectangleImmutable2.getX() > rectangleImmutable.getX() + rectangleImmutable.getWidth() - 1) {
                    nArray[0] = rectangleImmutable2.getX() - (rectangleImmutable.getX() + rectangleImmutable.getWidth() - 1);
                    orientation = Orientation.right_of;
                } else if (rectangleImmutable2.getX() + rectangleImmutable2.getWidth() - 1 < rectangleImmutable.getX()) {
                    nArray[0] = rectangleImmutable2.getX() + rectangleImmutable2.getWidth() - 1 - rectangleImmutable.getX();
                    orientation = Orientation.left_of;
                }
            } else if (rectangleImmutable.getX() == rectangleImmutable2.getX() || rectangleImmutable.getX() + rectangleImmutable.getWidth() - 1 == rectangleImmutable2.getX() + rectangleImmutable2.getWidth() - 1) {
                if (rectangleImmutable2.getY() + rectangleImmutable.getHeight() - 1 < rectangleImmutable.getY()) {
                    nArray[1] = rectangleImmutable2.getY() + rectangleImmutable2.getHeight() - 1 - rectangleImmutable.getY();
                    orientation = Orientation.above;
                } else if (rectangleImmutable2.getY() > rectangleImmutable.getY() + rectangleImmutable.getHeight() - 1) {
                    nArray[1] = rectangleImmutable2.getY() - (rectangleImmutable.getY() + rectangleImmutable.getHeight() - 1);
                    orientation = Orientation.below;
                }
            }
        }
        return orientation;
    }

    protected MonitorDevice(Screen screen, long l, int n, String string, boolean bl, boolean bl2, DimensionImmutable dimensionImmutable, MonitorMode monitorMode, float[] fArray, Rectangle rectangle, Rectangle rectangle2, ArrayHashSet<MonitorMode> arrayHashSet) {
        this.screen = screen;
        this.nativeHandle = l;
        this.nativeId = n;
        this.name = null != string ? string : "";
        this.sizeMM = dimensionImmutable;
        this.originalMode = monitorMode;
        this.supportedModes = arrayHashSet;
        this.pixelScale = null != fArray ? new float[]{fArray[0], fArray[1]} : new float[]{1.0f, 1.0f};
        this.viewportPU = rectangle;
        this.viewportWU = rectangle2;
        this.isClone = bl;
        this.isPrimary = bl2;
        this.currentMode = monitorMode;
        this.modeChanged = false;
    }

    public final Screen getScreen() {
        return this.screen;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof MonitorDevice) {
            MonitorDevice monitorDevice = (MonitorDevice)object;
            return monitorDevice.nativeId == this.nativeId;
        }
        return false;
    }

    public final int hashCode() {
        return this.nativeId;
    }

    public final long getHandle() {
        return this.nativeHandle;
    }

    public final int getId() {
        return this.nativeId;
    }

    public final String getName() {
        return this.name;
    }

    public final boolean isClone() {
        return this.isClone;
    }

    public final boolean isPrimary() {
        return this.isPrimary;
    }

    public final DimensionImmutable getSizeMM() {
        return this.sizeMM;
    }

    public final float[] getPixelsPerMM(float[] fArray) {
        return this.getPixelsPerMM(this.getCurrentMode(), fArray);
    }

    public final float[] getPixelsPerMM(MonitorMode monitorMode, float[] fArray) {
        DimensionImmutable dimensionImmutable = this.getSizeMM();
        DimensionImmutable dimensionImmutable2 = monitorMode.getSurfaceSize().getResolution();
        fArray[0] = (float)dimensionImmutable2.getWidth() / (float)dimensionImmutable.getWidth();
        fArray[1] = (float)dimensionImmutable2.getHeight() / (float)dimensionImmutable.getHeight();
        return fArray;
    }

    public static float[] mmToInch(float[] fArray, float[] fArray2) {
        fArray[0] = fArray2[0] * 25.4f;
        fArray[1] = fArray2[1] * 25.4f;
        return fArray;
    }

    public static float[] mmToInch(float[] fArray) {
        fArray[0] = fArray[0] * 25.4f;
        fArray[1] = fArray[1] * 25.4f;
        return fArray;
    }

    public static float mmToInch(float f) {
        return f * 25.4f;
    }

    public static float[] inchToMM(float[] fArray, float[] fArray2) {
        fArray[0] = fArray2[0] / 25.4f;
        fArray[1] = fArray2[1] / 25.4f;
        return fArray;
    }

    public static float[] inchToMM(float[] fArray) {
        fArray[0] = fArray[0] / 25.4f;
        fArray[1] = fArray[1] / 25.4f;
        return fArray;
    }

    public static float inchToMM(float f) {
        return f / 25.4f;
    }

    public final MonitorMode getOriginalMode() {
        return this.originalMode;
    }

    public final List<MonitorMode> getSupportedModes() {
        return this.supportedModes.getData();
    }

    public final RectangleImmutable getViewport() {
        return this.viewportPU;
    }

    public final RectangleImmutable getViewportInWindowUnits() {
        return this.viewportWU;
    }

    public float[] getPixelScale(float[] fArray) {
        System.arraycopy(this.pixelScale, 0, fArray, 0, 2);
        return fArray;
    }

    public final boolean contains(int n, int n2) {
        return n >= this.viewportPU.getX() && n < this.viewportPU.getX() + this.viewportPU.getWidth() && n2 >= this.viewportPU.getY() && n2 < this.viewportPU.getY() + this.viewportPU.getHeight();
    }

    public static void unionOfViewports(Rectangle rectangle, Rectangle rectangle2, List<MonitorDevice> list) {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        int n4 = Integer.MIN_VALUE;
        int n5 = Integer.MAX_VALUE;
        int n6 = Integer.MAX_VALUE;
        int n7 = Integer.MIN_VALUE;
        int n8 = Integer.MIN_VALUE;
        for (int i = list.size() - 1; i >= 0; --i) {
            RectangleImmutable rectangleImmutable;
            if (null != rectangle) {
                rectangleImmutable = list.get(i).getViewport();
                n = Math.min(n, rectangleImmutable.getX());
                n3 = Math.max(n3, rectangleImmutable.getX() + rectangleImmutable.getWidth());
                n2 = Math.min(n2, rectangleImmutable.getY());
                n4 = Math.max(n4, rectangleImmutable.getY() + rectangleImmutable.getHeight());
            }
            if (null == rectangle2) continue;
            rectangleImmutable = list.get(i).getViewportInWindowUnits();
            n5 = Math.min(n5, rectangleImmutable.getX());
            n7 = Math.max(n7, rectangleImmutable.getX() + rectangleImmutable.getWidth());
            n6 = Math.min(n6, rectangleImmutable.getY());
            n8 = Math.max(n8, rectangleImmutable.getY() + rectangleImmutable.getHeight());
        }
        if (null != rectangle) {
            rectangle.set(n, n2, n3 - n, n4 - n2);
        }
        if (null != rectangle2) {
            rectangle2.set(n5, n6, n7 - n5, n8 - n6);
        }
    }

    public final boolean isOriginalMode() {
        return this.currentMode.hashCode() == this.originalMode.hashCode();
    }

    public final boolean isModeChangedByUs() {
        return this.modeChanged && !this.isOriginalMode();
    }

    public final MonitorMode getCurrentMode() {
        return this.currentMode;
    }

    public abstract MonitorMode queryCurrentMode() throws IllegalStateException;

    public abstract boolean setCurrentMode(MonitorMode var1) throws IllegalStateException;

    public String toString() {
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Monitor[Id ").append(Display.toHexString(this.nativeId)).append(" [");
        if (!this.name.isEmpty()) {
            if (bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("name ").append("'").append(this.name).append("'");
            bl = true;
        }
        if (this.nativeHandle != (long)this.nativeId) {
            if (bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("handle ").append(Display.toHexString(this.nativeHandle));
            bl = true;
        }
        if (this.isClone()) {
            if (bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("clone");
            bl = true;
        }
        if (this.isPrimary()) {
            if (bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("primary");
        }
        bl = false;
        stringBuilder.append("], ").append(this.sizeMM).append(" mm, pixelScale [").append(this.pixelScale[0]).append(", ").append(this.pixelScale[1]).append("], viewport[pixel ").append(this.viewportPU).append(", window ").append(this.viewportWU).append("], orig ").append(this.originalMode).append(", curr ").append(this.currentMode).append(", modeChanged ").append(this.modeChanged).append(", modeCount ").append(this.supportedModes.size()).append("]");
        return stringBuilder.toString();
    }

    static {
        int n = PropertyAccess.getIntProperty("newt.monitor.pxwidth", true, 0);
        int n2 = PropertyAccess.getIntProperty("newt.monitor.pxheight", true, 0);
        int n3 = PropertyAccess.getIntProperty("newt.monitor.refresh", true, 0);
        int n4 = PropertyAccess.getIntProperty("newt.monitor.bpp", true, 0);
        int n5 = PropertyAccess.getIntProperty("newt.monitor.mmwidth", true, 0);
        int n6 = PropertyAccess.getIntProperty("newt.monitor.mmheight", true, 0);
        if (n > 0 && n2 > 0) {
            DEFAULT_MODE_PIXEL_SIZE = new Dimension(n, n2);
            DEFAULT_MODE_PIXEL_SIZE_OVERRIDE = true;
        } else {
            DEFAULT_MODE_PIXEL_SIZE = new Dimension(1920, 1080);
            DEFAULT_MODE_PIXEL_SIZE_OVERRIDE = false;
        }
        if (n3 > 0) {
            DEFAULT_MODE_REFRESH = n3;
            DEFAULT_MODE_REFRESH_OVERRIDE = true;
        } else {
            DEFAULT_MODE_REFRESH = 60;
            DEFAULT_MODE_REFRESH_OVERRIDE = false;
        }
        if (n4 > 0) {
            DEFAULT_MODE_BPP = n3;
            DEFAULT_MODE_BPP_OVERRIDE = true;
        } else {
            DEFAULT_MODE_BPP = 32;
            DEFAULT_MODE_BPP_OVERRIDE = false;
        }
        if (n5 > 0 && n6 > 0) {
            DEFAULT_SCREEN_MM_SIZE = new Dimension(n5, n6);
            DEFAULT_SCREEN_MM_SIZE_OVERRIDE = true;
        } else {
            DEFAULT_SCREEN_MM_SIZE = new Dimension(521, 293);
            DEFAULT_SCREEN_MM_SIZE_OVERRIDE = false;
        }
    }

    public static enum Orientation {
        clone(0),
        right_of(1),
        left_of(-1),
        below(2),
        above(-2);

        public final int value;

        private Orientation(int n2) {
            this.value = n2;
        }
    }
}

