/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.curve;

import com.jogamp.common.os.Clock;
import com.jogamp.common.util.PerfCounterCtrl;
import com.jogamp.graph.curve.OutlineShape;
import com.jogamp.graph.geom.Triangle;
import com.jogamp.graph.geom.Vertex;
import com.jogamp.math.Vec3f;
import com.jogamp.math.Vec4f;
import com.jogamp.math.geom.AABBox;
import com.jogamp.math.geom.Frustum;
import com.jogamp.math.geom.plane.AffineTransform;
import java.io.PrintStream;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import jogamp.opengl.Debug;

public abstract class Region {
    public static final boolean DEBUG_ALL_EVENT = Debug.debugExplicit("graph.curve.AllEvent");
    public static final boolean DEBUG_INSTANCE = Debug.debugExplicit("graph.curve.Instance");
    public static final boolean DEBUG = DEBUG_ALL_EVENT || Debug.debug("graph.curve");
    public static final int NORM_RENDERING_BIT = 0;
    public static final int MSAA_RENDERING_BIT = 1;
    public static final int VBAA_RENDERING_BIT = 2;
    public static final int AA_RENDERING_MASK = 3;
    public static final int VARWEIGHT_RENDERING_BIT = 256;
    public static final int COLORCHANNEL_RENDERING_BIT = 512;
    public static final int COLORTEXTURE_RENDERING_BIT = 1024;
    public static final int MIN_AA_QUALITY = 0;
    public static final int MAX_AA_QUALITY = 1;
    public static final int DEFAULT_AA_QUALITY = 1;
    public static final int MIN_AA_SAMPLE_COUNT = 1;
    public static final int MAX_AA_SAMPLE_COUNT = 8;
    public static final int DEFAULT_AA_SAMPLE_COUNT = 4;
    public static final int DEFAULT_TWO_PASS_TEXTURE_UNIT = 0;
    protected static final int DIRTY_SHAPE = 1;
    protected static final int DIRTY_STATE = 2;
    private final int renderModes;
    private final boolean use_int32_idx;
    private final int max_indices;
    private int dirty = 3;
    private int numVertices = 0;
    protected final AABBox box = new AABBox();
    protected Frustum frustum = null;
    private final AABBox tmpBox = new AABBox();
    protected static final int GL_UINT16_MAX = 65535;
    protected static final int GL_INT32_MAX = Integer.MAX_VALUE;
    private Perf perf = null;
    private final PerfCounterCtrl perfCounterCtrl = new PerfCounterCtrl(){

        @Override
        public void enable(boolean bl) {
            if (bl) {
                if (null != Region.this.perf) {
                    Region.this.perf.clear();
                } else {
                    Region.this.perf = new Perf();
                }
            } else {
                Region.this.perf = null;
            }
        }

        @Override
        public void clear() {
            if (null != Region.this.perf) {
                Region.this.perf.clear();
            }
        }

        @Override
        public long getTotalDuration() {
            if (null != Region.this.perf) {
                return ((Region)Region.this).perf.td_total;
            }
            return 0L;
        }

        @Override
        public void print(PrintStream printStream) {
            if (null != Region.this.perf) {
                Region.this.perf.print(printStream);
            }
        }
    };

    public static final int clipAAQuality(int n) {
        return Math.min(1, Math.max(n, 0));
    }

    public static final int clipAASampleCount(int n) {
        return Math.min(8, Math.max(n, 1));
    }

    public static final boolean isRenderModeSet(int n, int n2) {
        return n2 == (n & n2);
    }

    public static final int setRenderMode(int n, int n2, boolean bl) {
        n = bl ? (n |= n2) : (n &= ~n2);
        return n;
    }

    public static boolean isVBAA(int n) {
        return 0 != (n & 2);
    }

    public static boolean isMSAA(int n) {
        return 0 != (n & 1);
    }

    public static boolean isGraphAA(int n) {
        return 0 != (n & 3);
    }

    public static boolean isTwoPass(int n) {
        return 0 != (n & 3);
    }

    public static boolean hasVariableWeight(int n) {
        return 0 != (n & 0x100);
    }

    public static boolean hasColorChannel(int n) {
        return 0 != (n & 0x200);
    }

    public static boolean hasColorTexture(int n) {
        return 0 != (n & 0x400);
    }

    public static String getRenderModeString(int n) {
        String string = Region.hasVariableWeight(n) ? "-curve" : "";
        String string2 = Region.hasColorChannel(n) ? "-cols" : "";
        String string3 = Region.hasColorTexture(n) ? "-ctex" : "";
        if (Region.isVBAA(n)) {
            return "vbaa" + string + string2 + string3;
        }
        if (Region.isMSAA(n)) {
            return "msaa" + string + string2 + string3;
        }
        return "norm" + string + string2 + string3;
    }

    public static String getRenderModeString(int n, int n2, int n3, int n4) {
        if (0 > n2) {
            return String.format((Locale)null, "%s-qu-s%02d-fsaa%d", Region.getRenderModeString(n), n3, n4);
        }
        return String.format((Locale)null, "%s-q%01d-s%02d-fsaa%d", Region.getRenderModeString(n), n2, n3, n4);
    }

    protected Region(int n, boolean bl) {
        this.renderModes = n;
        this.use_int32_idx = bl;
        this.max_indices = bl ? 0x1FFFFFFF : 65535;
    }

    public abstract void printBufferStats(PrintStream var1);

    public final boolean usesI32Idx() {
        return this.use_int32_idx;
    }

    public abstract boolean growBuffer(int var1, int var2);

    public abstract boolean setBufferCapacity(int var1, int var2);

    protected abstract void pushVertex(Vec3f var1, Vec3f var2, Vec4f var3);

    protected abstract void pushVertices(Vec3f var1, Vec3f var2, Vec3f var3, Vec3f var4, Vec3f var5, Vec3f var6, Vec4f var7);

    protected abstract void pushIndex(int var1);

    protected abstract void pushIndices(int var1, int var2, int var3);

    public final int getRenderModes() {
        return this.renderModes;
    }

    protected final void clearImpl() {
        this.dirty = 3;
        this.numVertices = 0;
        this.box.reset();
    }

    public final boolean isRenderModeSet(int n) {
        return n == (this.renderModes & n);
    }

    public final boolean isVBAA() {
        return Region.isVBAA(this.renderModes);
    }

    public final boolean isMSAA() {
        return Region.isMSAA(this.renderModes);
    }

    public final boolean hasVariableWeight() {
        return Region.hasVariableWeight(this.renderModes);
    }

    public final boolean hasColorChannel() {
        return Region.hasColorChannel(this.renderModes);
    }

    public final boolean hasColorTexture() {
        return Region.hasColorTexture(this.renderModes);
    }

    public final Frustum getFrustum() {
        return this.frustum;
    }

    public final void setFrustum(Frustum frustum) {
        this.frustum = frustum;
    }

    private void pushNewVertexImpl(Vertex vertex, AffineTransform affineTransform, Vec4f vec4f) {
        if (null != affineTransform) {
            Vec3f vec3f = affineTransform.transform(vertex.getCoord(), new Vec3f());
            this.box.resize(vec3f);
            this.pushVertex(vec3f, vertex.getTexCoord(), vec4f);
        } else {
            this.box.resize(vertex.getCoord());
            this.pushVertex(vertex.getCoord(), vertex.getTexCoord(), vec4f);
        }
        ++this.numVertices;
    }

    private void pushNewVerticesImpl(Vertex vertex, Vertex vertex2, Vertex vertex3, AffineTransform affineTransform, Vec4f vec4f) {
        if (null != affineTransform) {
            Vec3f vec3f = affineTransform.transform(vertex.getCoord(), new Vec3f());
            Vec3f vec3f2 = affineTransform.transform(vertex2.getCoord(), new Vec3f());
            Vec3f vec3f3 = affineTransform.transform(vertex3.getCoord(), new Vec3f());
            this.box.resize(vec3f);
            this.box.resize(vec3f2);
            this.box.resize(vec3f3);
            this.pushVertices(vec3f, vec3f2, vec3f3, vertex.getTexCoord(), vertex2.getTexCoord(), vertex3.getTexCoord(), vec4f);
        } else {
            this.box.resize(vertex.getCoord());
            this.box.resize(vertex2.getCoord());
            this.box.resize(vertex3.getCoord());
            this.pushVertices(vertex.getCoord(), vertex2.getCoord(), vertex3.getCoord(), vertex.getTexCoord(), vertex2.getTexCoord(), vertex3.getTexCoord(), vec4f);
        }
        this.numVertices += 3;
    }

    private void pushNewVertexIdxImpl(Vertex vertex, AffineTransform affineTransform, Vec4f vec4f) {
        this.pushIndex(this.numVertices);
        this.pushNewVertexImpl(vertex, affineTransform, vec4f);
    }

    private void pushNewVerticesIdxImpl(Vertex vertex, Vertex vertex2, Vertex vertex3, AffineTransform affineTransform, Vec4f vec4f) {
        this.pushIndices(this.numVertices, this.numVertices + 1, this.numVertices + 2);
        this.pushNewVerticesImpl(vertex, vertex2, vertex3, affineTransform, vec4f);
    }

    protected static void put3i(IntBuffer intBuffer, int n, int n2, int n3) {
        intBuffer.put(n);
        intBuffer.put(n2);
        intBuffer.put(n3);
    }

    protected static void put3s(ShortBuffer shortBuffer, short s, short s2, short s3) {
        shortBuffer.put(s);
        shortBuffer.put(s2);
        shortBuffer.put(s3);
    }

    protected static void put3f(FloatBuffer floatBuffer, Vec3f vec3f) {
        floatBuffer.put(vec3f.x());
        floatBuffer.put(vec3f.y());
        floatBuffer.put(vec3f.z());
    }

    protected static void put4f(FloatBuffer floatBuffer, float f, float f2, float f3, float f4) {
        floatBuffer.put(f);
        floatBuffer.put(f2);
        floatBuffer.put(f3);
        floatBuffer.put(f4);
    }

    protected static void put4f(FloatBuffer floatBuffer, Vec4f vec4f) {
        floatBuffer.put(vec4f.x());
        floatBuffer.put(vec4f.y());
        floatBuffer.put(vec4f.z());
        floatBuffer.put(vec4f.w());
    }

    public PerfCounterCtrl perfCounter() {
        return this.perfCounterCtrl;
    }

    public static final int[] countOutlineShape(OutlineShape outlineShape, int[] nArray) {
        if (null == outlineShape) {
            return nArray;
        }
        ArrayList<Triangle> arrayList = outlineShape.getTriangles(OutlineShape.VerticesState.QUADRATIC_NURBS);
        ArrayList<Vertex> arrayList2 = outlineShape.getVertices();
        nArray[0] = nArray[0] + (arrayList2.size() + outlineShape.getAddedVerticeCount());
        nArray[1] = nArray[1] + arrayList.size() * 3;
        return nArray;
    }

    public static final int[] countOutlineShapes(List<OutlineShape> list, int[] nArray) {
        for (int i = 0; i < list.size(); ++i) {
            Region.countOutlineShape(list.get(i), nArray);
        }
        return nArray;
    }

    public final void addOutlineShape(OutlineShape outlineShape, AffineTransform affineTransform, Vec4f vec4f) {
        if (null != this.frustum) {
            AABBox aABBox;
            AABBox aABBox2 = outlineShape.getBounds();
            if (null != affineTransform) {
                affineTransform.transform(aABBox2, this.tmpBox);
                aABBox = this.tmpBox;
            } else {
                aABBox = aABBox2;
            }
            if (this.frustum.isOutside(aABBox)) {
                return;
            }
        }
        if (null == this.perf && !DEBUG_INSTANCE) {
            this.addOutlineShape0(outlineShape, affineTransform, vec4f);
        } else {
            if (null == this.perf) {
                this.perfCounter().enable(true);
            }
            this.addOutlineShape1(outlineShape, affineTransform, vec4f);
        }
        this.markShapeDirty();
    }

    private final void addOutlineShape0(OutlineShape outlineShape, AffineTransform affineTransform, Vec4f vec4f) {
        ArrayList<Triangle> arrayList = outlineShape.getTriangles(OutlineShape.VerticesState.QUADRATIC_NURBS);
        ArrayList<Vertex> arrayList2 = outlineShape.getVertices();
        int n = arrayList2.size() + outlineShape.getAddedVerticeCount();
        int n2 = arrayList.size() * 3;
        this.growBuffer(n, n2);
        n = this.numVertices;
        if (arrayList2.size() >= 3) {
            for (n2 = 0; n2 < arrayList2.size(); ++n2) {
                this.pushNewVertexImpl(arrayList2.get(n2), affineTransform, vec4f);
            }
            n2 = arrayList.size();
            for (int i = 0; i < n2; ++i) {
                Triangle triangle = (Triangle)arrayList.get(i);
                Vertex[] vertexArray = triangle.getVertices();
                int n3 = vertexArray[0].getId();
                if (this.max_indices - n > n3) {
                    this.pushIndices(n3 + n, vertexArray[1].getId() + n, vertexArray[2].getId() + n);
                    continue;
                }
                this.pushNewVerticesIdxImpl(vertexArray[0], vertexArray[1], vertexArray[2], affineTransform, vec4f);
            }
        }
    }

    private final void addOutlineShape1(OutlineShape outlineShape, AffineTransform affineTransform, Vec4f vec4f) {
        ++this.perf.count;
        long l = Clock.currentNanos();
        ArrayList<Triangle> arrayList = outlineShape.getTriangles(OutlineShape.VerticesState.QUADRATIC_NURBS);
        ArrayList<Vertex> arrayList2 = outlineShape.getVertices();
        int n = outlineShape.getAddedVerticeCount();
        int n2 = arrayList2.size() + n;
        int n3 = arrayList.size() * 3;
        if (DEBUG_INSTANCE) {
            System.err.println("Region.addOutlineShape().0: tris: " + arrayList.size() + ", verts " + arrayList2.size() + ", transform " + affineTransform);
            System.err.println("Region.addOutlineShape().0: VerticeCount " + arrayList2.size() + " + " + n + " = " + n2);
            System.err.println("Region.addOutlineShape().0: IndexCount " + n3);
        }
        this.growBuffer(n2, n3);
        n = this.numVertices;
        n2 = 0;
        n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (arrayList2.size() >= 3) {
            for (int i = 0; i < arrayList2.size(); ++i) {
                this.pushNewVertexImpl(arrayList2.get(i), affineTransform, vec4f);
                ++n2;
            }
            long l2 = Clock.currentNanos();
            this.perf.td_vertices += l2 - l;
            int n6 = arrayList.size();
            for (int i = 0; i < n6; ++i) {
                long l3;
                Triangle triangle = (Triangle)arrayList.get(i);
                long l4 = Clock.currentNanos();
                Vertex[] vertexArray = triangle.getVertices();
                int n7 = vertexArray[0].getId();
                this.perf.td_tri_misc += Clock.currentNanos() - l4;
                if (this.max_indices - n > n7) {
                    l3 = Clock.currentNanos();
                    this.pushIndices(n7 + n, vertexArray[1].getId() + n, vertexArray[2].getId() + n);
                    this.perf.td_tri_push_idx += Clock.currentNanos() - l3;
                    n3 += 3;
                } else {
                    l3 = Clock.currentNanos();
                    this.pushNewVerticesIdxImpl(vertexArray[0], vertexArray[1], vertexArray[2], affineTransform, vec4f);
                    this.perf.td_tri_push_vertidx += Clock.currentNanos() - l3;
                    n4 += 3;
                }
                ++n5;
            }
            long l5 = Clock.currentNanos();
            this.perf.td_tri_total += l5 - l2;
            this.perf.td_total += l5 - l;
        }
        if (DEBUG_INSTANCE) {
            System.err.println("Region.addOutlineShape().X: idx[ui32 " + this.usesI32Idx() + ", offset " + n + "], tris: " + n5 + ", verts [idx " + n4 + ", add " + n4 + " = " + (n2 + n4) + "]");
            System.err.println("Region.addOutlineShape().X: verts: idx[v-new " + n2 + ", t-new " + n4 + " = " + (n2 + n4) + "]");
            System.err.println("Region.addOutlineShape().X: verts: idx t-moved " + n3 + ", numVertices " + this.numVertices);
            System.err.println("Region.addOutlineShape().X: verts: v-dups 0, t-dups 0, t-known 0");
            System.err.println("Region.addOutlineShape().X: box " + this.box);
            this.printBufferStats(System.err);
        }
    }

    public final void addOutlineShapes(List<OutlineShape> list, AffineTransform affineTransform, Vec4f vec4f) {
        for (int i = 0; i < list.size(); ++i) {
            this.addOutlineShape(list.get(i), affineTransform, vec4f);
        }
    }

    public final AABBox getBounds() {
        return this.box;
    }

    public final void markShapeDirty() {
        this.dirty |= 1;
    }

    public final boolean isShapeDirty() {
        return 0 != (this.dirty & 1);
    }

    public final void markStateDirty() {
        this.dirty |= 2;
    }

    public final boolean isStateDirty() {
        return 0 != (this.dirty & 2);
    }

    protected final void clearDirtyBits(int n) {
        this.dirty &= ~n;
    }

    protected final int getDirtyBits() {
        return this.dirty;
    }

    public String toString() {
        return "Region[0x" + Integer.toHexString(this.hashCode()) + ", " + Region.getRenderModeString(this.renderModes) + ", dirty " + this.dirty + ", vertices " + this.numVertices + ", box " + this.box + "]";
    }

    static class Perf {
        long td_vertices = 0L;
        long td_tri_push_idx = 0L;
        long td_tri_push_vertidx = 0L;
        long td_tri_misc = 0L;
        long td_tri_total = 0L;
        long td_total = 0L;
        long count = 0L;

        Perf() {
        }

        public void print(PrintStream printStream) {
            long l = this.td_tri_total - this.td_tri_push_vertidx - this.td_tri_push_idx - this.td_tri_misc;
            long l2 = this.td_total - this.td_tri_total - this.td_vertices;
            printStream.printf("Region.add(): count %,3d, total %,5d [ms], per-add %,4.2f [ns]%n", this.count, TimeUnit.NANOSECONDS.toMillis(this.td_total), (double)this.td_total / (double)this.count);
            printStream.printf("                total self %,5d [ms], per-add %,4.2f [ns]%n", TimeUnit.NANOSECONDS.toMillis(l2), (double)l2 / (double)this.count);
            printStream.printf("                  vertices %,5d [ms], per-add %,4.2f [ns]%n", TimeUnit.NANOSECONDS.toMillis(this.td_vertices), (double)this.td_vertices / (double)this.count);
            printStream.printf("           triangles total %,5d [ms], per-add %,4.2f [ns]%n", TimeUnit.NANOSECONDS.toMillis(this.td_tri_total), (double)this.td_tri_total / (double)this.count);
            printStream.printf("            triangles self %,5d [ms], per-add %,4.2f [ns]%n", TimeUnit.NANOSECONDS.toMillis(l), (double)l / (double)this.count);
            printStream.printf("                  tri misc %,5d [ms], per-add %,4.2f [ns]%n", TimeUnit.NANOSECONDS.toMillis(this.td_tri_misc), (double)this.td_tri_misc / (double)this.count);
            printStream.printf("                 tri p-idx %,5d [ms], per-add %,4.2f [ns]%n", TimeUnit.NANOSECONDS.toMillis(this.td_tri_push_idx), (double)this.td_tri_push_idx / (double)this.count);
            printStream.printf("             tri p-vertidx %,5d [ms], per-add %,4.2f [ns]%n", TimeUnit.NANOSECONDS.toMillis(this.td_tri_push_vertidx), (double)this.td_tri_push_vertidx / (double)this.count);
        }

        public void clear() {
            this.td_vertices = 0L;
            this.td_tri_push_idx = 0L;
            this.td_tri_push_vertidx = 0L;
            this.td_tri_misc = 0L;
            this.td_tri_total = 0L;
            this.td_total = 0L;
            this.count = 0L;
        }
    }
}

