/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.demos.graph.ui.util;

import com.jogamp.graph.ui.Scene;
import com.jogamp.graph.ui.Shape;
import com.jogamp.graph.ui.shapes.Button;
import com.jogamp.graph.ui.shapes.Label;
import com.jogamp.math.geom.AABBox;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.opengl.GLAutoDrawable;

public class Tooltips {

    public static class ZoomLabelOnClickListener
    extends Shape.MouseGestureAdapter {
        private final Scene scene;
        private final int renderModes;
        private final float sceneHeightScale;
        private Button buttonLabel = null;

        public ZoomLabelOnClickListener(Scene scene, int n, float f) {
            this.scene = scene;
            this.renderModes = n;
            this.sceneHeightScale = f;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            AABBox aABBox = this.scene.getBounds();
            float f = this.scene.getZEpsilon(16);
            Shape.EventInfo eventInfo = (Shape.EventInfo)mouseEvent.getAttachment();
            if (!(eventInfo.shape instanceof Label)) {
                return;
            }
            Label label = (Label)eventInfo.shape;
            AABBox aABBox2 = label.getBounds();
            float f2 = this.sceneHeightScale * aABBox.getHeight() / aABBox2.getHeight();
            this.buttonLabel = (Button)new Button(this.renderModes, label.getFont(), label.getText(), aABBox2.getWidth() + 3.0f, aABBox2.getHeight(), f).setPerp().scale(f2, f2, 1.0f).move(0.0f, 0.0f, 10.0f * f).setColor(0.97f, 0.97f, 0.97f, 0.92f).setBorder(0.05f).setBorderColor(0.0f, 0.0f, 0.0f, 1.0f).setInteractive(false);
            this.buttonLabel.setLabelColor(0.0f, 0.0f, 0.0f, 1.0f);
            this.buttonLabel.setSpacing(0.2f, 0.2f);
            Button button = this.buttonLabel;
            this.scene.invoke(false, arg_0 -> this.lambda$mousePressed$0((Shape)button, arg_0));
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (null != this.buttonLabel) {
                Button button = this.buttonLabel;
                this.buttonLabel = null;
                this.scene.invoke(false, arg_0 -> this.lambda$mouseReleased$1((Shape)button, arg_0));
            }
        }

        private /* synthetic */ boolean lambda$mouseReleased$1(Shape shape, GLAutoDrawable gLAutoDrawable) {
            this.scene.removeShape(gLAutoDrawable.getGL().getGL2ES2(), shape);
            return true;
        }

        private /* synthetic */ boolean lambda$mousePressed$0(Shape shape, GLAutoDrawable gLAutoDrawable) {
            shape.validate(gLAutoDrawable.getGL().getGL2ES2());
            shape.move(-shape.getScaledWidth() / 2.0f, -shape.getScaledHeight() / 2.0f, 0.0f);
            this.scene.addShape(shape);
            return true;
        }
    }
}

