/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.demos.graph.ui;

import com.jogamp.common.util.InterruptSource;
import com.jogamp.graph.curve.OutlineShape;
import com.jogamp.graph.curve.Region;
import com.jogamp.graph.curve.opengl.GLRegion;
import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.graph.curve.opengl.TextRegionUtil;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.font.FontFactory;
import com.jogamp.graph.ui.GraphShape;
import com.jogamp.graph.ui.Shape;
import com.jogamp.graph.ui.shapes.CrossHair;
import com.jogamp.math.FloatUtil;
import com.jogamp.math.Recti;
import com.jogamp.math.Vec3f;
import com.jogamp.math.Vec4f;
import com.jogamp.math.geom.AABBox;
import com.jogamp.math.geom.plane.AffineTransform;
import com.jogamp.math.util.PMVMatrix4f;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.KeyAdapter;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.FPSCounter;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLAnimatorControl;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLPipelineFactory;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.GLRunnable;
import com.jogamp.opengl.demos.graph.MSAATool;
import com.jogamp.opengl.demos.graph.ui.testshapes.Glyph03FreeMonoRegular_M;
import com.jogamp.opengl.demos.util.CommandlineOptions;
import com.jogamp.opengl.demos.util.MiscUtils;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.GLReadBufferUtil;
import java.io.File;
import java.io.IOException;

public class UITypeDemo01
implements GLEventListener {
    static final boolean DEBUG = false;
    static final boolean TRACE = false;
    static CommandlineOptions options = new CommandlineOptions(1280, 720, 2);
    private final Vec4f fg_color = new Vec4f(0.0f, 0.0f, 0.0f, 1.0f);
    private final Font font;
    private final String text;
    private final int glyph_id;
    private final GLReadBufferUtil screenshot;
    private final int renderModes;
    private final RegionRenderer rRenderer;
    private final boolean debug;
    private final boolean trace;
    private final CrossHair crossHair;
    private final GraphShape testObj;
    private KeyAction keyAction;
    private MouseAction mouseAction;
    private volatile GLAutoDrawable autoDrawable = null;
    private final float[] position = new float[]{0.0f, 0.0f, 0.0f};
    private static final float xTran = 0.0f;
    private static final float yTran = 0.0f;
    private static final float zTran = -0.2f;
    private static final float zNear = 0.1f;
    private static final float zFar = 7000.0f;
    boolean ignoreInput = false;
    protected final AffineTransform tempT1 = new AffineTransform();
    protected final AffineTransform tempT2 = new AffineTransform();
    float lastWidth = 0.0f;
    float lastHeight = 0.0f;
    private boolean once = true;
    int screenshot_num = 0;

    public static void main(String[] stringArray) throws IOException {
        String string = "Hello Origin.";
        Font font = null;
        int n = 0;
        int[] nArray = new int[]{0};
        nArray[0] = 0;
        while (nArray[0] < stringArray.length) {
            if (!options.parse(stringArray, nArray)) {
                if (stringArray[nArray[0]].equals("-font")) {
                    nArray[0] = nArray[0] + 1;
                    font = FontFactory.get((File)new File(stringArray[nArray[0]]));
                } else if (stringArray[nArray[0]].equals("-text")) {
                    nArray[0] = nArray[0] + 1;
                    string = stringArray[nArray[0]];
                } else if (stringArray[nArray[0]].equals("-glyph")) {
                    nArray[0] = nArray[0] + 1;
                    n = MiscUtils.atoi(stringArray[nArray[0]], 0);
                }
            }
            nArray[0] = nArray[0] + 1;
        }
        System.err.println(options);
        if (null == font) {
            font = FontFactory.get((int)0).get(1, 2);
        }
        System.err.println("Font: " + font.getFullFamilyName());
        System.err.println("Text: " + string);
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setAlphaBits(4);
        System.out.println("Requested: " + gLCapabilities);
        final GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)gLCapabilities);
        gLWindow.setSize(UITypeDemo01.options.surface_width, UITypeDemo01.options.surface_height);
        gLWindow.setTitle(UITypeDemo01.class.getSimpleName() + ": " + gLWindow.getSurfaceWidth() + " x " + gLWindow.getSurfaceHeight());
        UITypeDemo01 uITypeDemo01 = new UITypeDemo01(font, n, string, UITypeDemo01.options.renderModes, false, false);
        uITypeDemo01.attachInputListenerTo(gLWindow);
        gLWindow.addGLEventListener((GLEventListener)uITypeDemo01);
        gLWindow.setVisible(true);
        final Animator animator = new Animator(0);
        animator.add((GLAutoDrawable)gLWindow);
        gLWindow.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                short s = keyEvent.getKeySymbol();
                if (s == 100 || s == 27 || s == 81) {
                    new InterruptSource.Thread(() -> gLWindow.destroy()).start();
                }
            }
        });
        gLWindow.addWindowListener((WindowListener)new WindowAdapter(){

            public void windowDestroyed(WindowEvent windowEvent) {
                animator.stop();
            }
        });
        animator.start();
    }

    public UITypeDemo01(Font font, int n, String string, int n2, boolean bl, boolean bl2) {
        this.font = font;
        this.text = string;
        this.glyph_id = n;
        this.renderModes = n2;
        this.rRenderer = RegionRenderer.create((RegionRenderer.GLCallback)RegionRenderer.defaultBlendEnable, (RegionRenderer.GLCallback)RegionRenderer.defaultBlendDisable);
        this.rRenderer.setAAQuality(UITypeDemo01.options.graphAAQuality);
        this.rRenderer.setSampleCount(UITypeDemo01.options.graphAASamples);
        this.debug = bl;
        this.trace = bl2;
        this.screenshot = new GLReadBufferUtil(false, false);
        this.crossHair = new CrossHair(n2, 0.05f, 0.05f, 0.001f);
        this.crossHair.setColor(0.0f, 0.0f, 1.0f, 1.0f);
        this.crossHair.setVisible(true);
        Glyph03FreeMonoRegular_M glyph03FreeMonoRegular_M = new Glyph03FreeMonoRegular_M(n2);
        glyph03FreeMonoRegular_M.scale(0.15312886f, 0.15312886f, 1.0f);
        this.testObj = glyph03FreeMonoRegular_M;
        this.testObj.setColor(0.0f, 0.0f, 0.0f, 1.0f);
        this.testObj.setVisible(true);
    }

    public final RegionRenderer getRegionRenderer() {
        return this.rRenderer;
    }

    public final float[] getPosition() {
        return this.position;
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        this.autoDrawable = gLAutoDrawable;
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        if (this.debug) {
            gL2ES2 = gL2ES2.getContext().setGL(GLPipelineFactory.create((String)"com.jogamp.opengl.Debug", null, (GL)gL2ES2, null)).getGL2ES2();
        }
        if (this.trace) {
            gL2ES2 = gL2ES2.getContext().setGL(GLPipelineFactory.create((String)"com.jogamp.opengl.Trace", null, (GL)gL2ES2, (Object[])new Object[]{System.err})).getGL2ES2();
        }
        gL2ES2.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.getRegionRenderer().init(gL2ES2);
        gL2ES2.setSwapInterval(1);
        gL2ES2.glEnable(2929);
        MSAATool.dump(gLAutoDrawable);
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        gL2ES2.glViewport(n, n2, n3, n4);
        this.rRenderer.reshapePerspective(0.7853982f, n3, n4, 0.1f, 7000.0f);
        this.lastWidth = n3;
        this.lastHeight = n4;
        if (gLAutoDrawable instanceof Window) {
            ((Window)gLAutoDrawable).setTitle(UITypeDemo01.class.getSimpleName() + ": " + gLAutoDrawable.getSurfaceWidth() + " x " + gLAutoDrawable.getSurfaceHeight());
        }
    }

    private void drawShape(GL2ES2 gL2ES2, PMVMatrix4f pMVMatrix4f, RegionRenderer regionRenderer, Shape shape) {
        pMVMatrix4f.pushMv();
        shape.applyMatToMv(pMVMatrix4f);
        shape.draw(gL2ES2, regionRenderer);
        pMVMatrix4f.popMv();
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        Font.Glyph glyph;
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        gL2ES2.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
        gL2ES2.glClear(16640);
        RegionRenderer regionRenderer = this.getRegionRenderer();
        PMVMatrix4f pMVMatrix4f = regionRenderer.getMatrix();
        pMVMatrix4f.loadMvIdentity();
        pMVMatrix4f.translateMv(0.0f, 0.0f, -0.2f);
        regionRenderer.enable(gL2ES2, true);
        pMVMatrix4f.pushMv();
        pMVMatrix4f.scaleMv(0.8f, 0.8f, 1.0f);
        this.drawShape(gL2ES2, pMVMatrix4f, regionRenderer, (Shape)this.testObj);
        pMVMatrix4f.popMv();
        this.drawShape(gL2ES2, pMVMatrix4f, regionRenderer, (Shape)this.crossHair);
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = FloatUtil.getOrthoWinZ((float)0.2f, (float)0.1f, (float)7000.0f);
        Vec3f vec3f = new Vec3f();
        Vec3f vec3f2 = new Vec3f();
        if (pMVMatrix4f.mapWinToObj(f, f2, f3, regionRenderer.getViewport(), vec3f) && this.once) {
            System.err.printf("winToObjCoord: win [%f, %f, %f] -> obj [%s]%n", Float.valueOf(f), Float.valueOf(f2), Float.valueOf(f3), vec3f);
        }
        if (pMVMatrix4f.mapWinToObj(f = (float)gLAutoDrawable.getSurfaceWidth(), f2 = (float)gLAutoDrawable.getSurfaceHeight(), f3, regionRenderer.getViewport(), vec3f2) && this.once) {
            System.err.printf("winToObjCoord: win [%f, %f, %f] -> obj [%s]%n", Float.valueOf(f), Float.valueOf(f2), Float.valueOf(f3), vec3f2);
        }
        float f4 = vec3f2.x() - vec3f.x();
        float f5 = vec3f2.y() - vec3f.y();
        pMVMatrix4f.pushMv();
        if (0 < this.glyph_id) {
            glyph = this.font.getGlyph(this.glyph_id);
            if (this.once) {
                System.err.println("glyph_id " + this.glyph_id + ": " + glyph);
            }
        } else {
            glyph = null;
        }
        if (null != glyph && glyph.getID() != 0) {
            GLRegion gLRegion;
            float f6;
            AABBox aABBox = glyph.getBounds();
            f3 = f4 / aABBox.getWidth();
            float f7 = f3 < (f6 = f5 / aABBox.getHeight()) ? f3 / 2.0f : f6 / 2.0f;
            pMVMatrix4f.scaleMv(f7, f7, 1.0f);
            pMVMatrix4f.translateMv(-aABBox.getWidth(), 0.0f, 0.0f);
            if (null != glyph.getShape()) {
                gLRegion = GLRegion.create((GLProfile)gL2ES2.getGLProfile(), (int)this.renderModes, null, (OutlineShape)glyph.getShape());
                gLRegion.addOutlineShape(glyph.getShape(), null, this.fg_color);
                gLRegion.draw(gL2ES2, regionRenderer);
                gLRegion.destroy(gL2ES2);
            }
            if (this.once) {
                gLRegion = this.font.getGlyphShapeBounds(null, (CharSequence)this.text);
                System.err.println("XXX: full_width: " + f4 + " / " + aABBox.getWidth() + " -> " + f3);
                System.err.println("XXX: full_height: " + f5 + " / " + aABBox.getHeight() + " -> " + f6);
                System.err.println("XXX: txt_scale: " + f7);
                System.err.println("XXX: txt_box_em " + aABBox);
                System.err.println("XXX: txt_box_e2 " + gLRegion);
            }
        } else if (0 == this.glyph_id) {
            float f8;
            AABBox aABBox = this.font.getGlyphBounds((CharSequence)this.text, this.tempT1, this.tempT2);
            f3 = f4 / aABBox.getWidth();
            float f9 = f3 < (f8 = f5 / aABBox.getHeight()) ? f3 / 2.0f : f8 / 2.0f;
            pMVMatrix4f.scaleMv(f9, f9, 1.0f);
            pMVMatrix4f.translateMv(-aABBox.getWidth(), 0.0f, 0.0f);
            AABBox aABBox2 = TextRegionUtil.drawString3D((GL2ES2)gL2ES2, (int)this.renderModes, (RegionRenderer)regionRenderer, (Font)this.font, (CharSequence)this.text, (Vec4f)this.fg_color, (AffineTransform)this.tempT1, (AffineTransform)this.tempT2);
            if (this.once) {
                AABBox aABBox3 = this.font.getGlyphShapeBounds(null, (CharSequence)this.text);
                System.err.println("XXX: full_width: " + f4 + " / " + aABBox.getWidth() + " -> " + f3);
                System.err.println("XXX: full_height: " + f5 + " / " + aABBox.getHeight() + " -> " + f8);
                System.err.println("XXX: txt_scale: " + f9);
                System.err.println("XXX: txt_box_em " + aABBox);
                System.err.println("XXX: txt_box_e2 " + aABBox3);
                System.err.println("XXX: txt_box_rg " + aABBox2);
            }
        }
        pMVMatrix4f.popMv();
        if (this.once) {
            try {
                this.printScreen(gLAutoDrawable);
            }
            catch (GLException | IOException throwable) {
                throwable.printStackTrace();
            }
        }
        this.once = false;
        regionRenderer.enable(gL2ES2, false);
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        this.crossHair.destroy(gL2ES2, this.getRegionRenderer());
        this.testObj.destroy(gL2ES2, this.getRegionRenderer());
        this.autoDrawable = null;
        this.screenshot.dispose((GL)gL2ES2);
        this.rRenderer.destroy(gL2ES2);
    }

    public void attachInputListenerTo(GLWindow gLWindow) {
        if (null == this.keyAction) {
            this.keyAction = new KeyAction();
            gLWindow.addKeyListener((KeyListener)this.keyAction);
        }
        if (null == this.mouseAction) {
            this.mouseAction = new MouseAction();
            gLWindow.addMouseListener((MouseListener)this.mouseAction);
        }
    }

    public void detachFrom(GLWindow gLWindow) {
        if (null == this.keyAction) {
            return;
        }
        if (null == this.mouseAction) {
            return;
        }
        gLWindow.removeGLEventListener((GLEventListener)this);
        gLWindow.removeKeyListener((KeyListener)this.keyAction);
        gLWindow.removeMouseListener((MouseListener)this.mouseAction);
    }

    public void printScreen(GLAutoDrawable gLAutoDrawable) throws GLException, IOException {
        String string = "demo-" + Region.getRenderModeString((int)this.renderModes);
        String string2 = "snap" + this.screenshot_num;
        String string3 = String.format("-%03dx%03d-Z%04d-T%04d-%s", gLAutoDrawable.getSurfaceWidth(), gLAutoDrawable.getSurfaceHeight(), (int)Math.abs(-0.2f), 0, string2);
        String string4 = "./" + string + string3 + ".png";
        if (this.screenshot.readPixels(gLAutoDrawable.getGL(), false)) {
            this.screenshot.write(new File(string4));
        }
        ++this.screenshot_num;
    }

    public void setIgnoreInput(boolean bl) {
        this.ignoreInput = bl;
    }

    public boolean getIgnoreInput() {
        return this.ignoreInput;
    }

    public class KeyAction
    implements KeyListener {
        public void keyPressed(KeyEvent keyEvent) {
            if (UITypeDemo01.this.ignoreInput) {
                return;
            }
            if (keyEvent.getKeyCode() == 49) {
                UITypeDemo01.this.crossHair.move(0.0f, 0.0f, 0.02f);
            } else if (keyEvent.getKeyCode() == 50) {
                UITypeDemo01.this.crossHair.move(0.0f, 0.0f, -0.02f);
            } else if (keyEvent.getKeyCode() == 150) {
                UITypeDemo01.this.crossHair.move(0.0f, UITypeDemo01.this.crossHair.getHeight() / 10.0f, 0.0f);
            } else if (keyEvent.getKeyCode() == 152) {
                UITypeDemo01.this.crossHair.move(0.0f, -UITypeDemo01.this.crossHair.getHeight() / 10.0f, 0.0f);
            } else if (keyEvent.getKeyCode() == 149) {
                UITypeDemo01.this.crossHair.move(-UITypeDemo01.this.crossHair.getWidth() / 10.0f, 0.0f, 0.0f);
            } else if (keyEvent.getKeyCode() == 151) {
                UITypeDemo01.this.crossHair.move(UITypeDemo01.this.crossHair.getWidth() / 10.0f, 0.0f, 0.0f);
            } else if (keyEvent.getKeyCode() != 48 && keyEvent.getKeyCode() != 57) {
                if (keyEvent.getKeyCode() == 86) {
                    if (null != UITypeDemo01.this.autoDrawable) {
                        UITypeDemo01.this.autoDrawable.invoke(false, new GLRunnable(){

                            public boolean run(GLAutoDrawable gLAutoDrawable) {
                                int n;
                                GL gL = gLAutoDrawable.getGL();
                                int n2 = gL.getSwapInterval();
                                switch (n2) {
                                    case 0: {
                                        n = 1;
                                        break;
                                    }
                                    case 1: {
                                        n = -1;
                                        break;
                                    }
                                    case -1: {
                                        n = 0;
                                        break;
                                    }
                                    default: {
                                        n = 1;
                                    }
                                }
                                gL.setSwapInterval(n);
                                GLAnimatorControl gLAnimatorControl = gLAutoDrawable.getAnimator();
                                if (null != gLAnimatorControl) {
                                    gLAnimatorControl.resetFPSCounter();
                                }
                                if (gLAutoDrawable instanceof FPSCounter) {
                                    ((FPSCounter)gLAutoDrawable).resetFPSCounter();
                                }
                                System.err.println("Swap Interval: " + n2 + " -> " + n + " -> " + gL.getSwapInterval());
                                return true;
                            }
                        });
                    }
                } else if (keyEvent.getKeyCode() == 83 && null != UITypeDemo01.this.autoDrawable) {
                    UITypeDemo01.this.autoDrawable.invoke(false, new GLRunnable(){

                        public boolean run(GLAutoDrawable gLAutoDrawable) {
                            try {
                                UITypeDemo01.this.printScreen(gLAutoDrawable);
                            }
                            catch (GLException gLException) {
                                gLException.printStackTrace();
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                            }
                            return true;
                        }
                    });
                }
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }
    }

    public class MouseAction
    implements MouseListener {
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(final MouseEvent mouseEvent) {
            UITypeDemo01.this.autoDrawable.invoke(false, new GLRunnable(){

                public boolean run(GLAutoDrawable gLAutoDrawable) {
                    Object object;
                    System.err.println("\n\nMouse: " + mouseEvent);
                    RegionRenderer regionRenderer = UITypeDemo01.this.getRegionRenderer();
                    PMVMatrix4f pMVMatrix4f = regionRenderer.getMatrix();
                    pMVMatrix4f.loadMvIdentity();
                    pMVMatrix4f.translateMv(0.0f, 0.0f, -0.2f);
                    Recti recti = regionRenderer.getViewport(new Recti());
                    int n = mouseEvent.getX();
                    int n2 = recti.height() - mouseEvent.getY() - 1;
                    pMVMatrix4f.pushMv();
                    UITypeDemo01.this.crossHair.applyMatToMv(pMVMatrix4f);
                    Vec3f vec3f = UITypeDemo01.this.crossHair.getBounds().getCenter();
                    System.err.println("\n\nCrossHair: " + UITypeDemo01.this.crossHair);
                    int[] nArray = UITypeDemo01.this.crossHair.shapeToWinCoord(pMVMatrix4f, recti, vec3f, new int[2]);
                    System.err.println("CrossHair: Obj: Obj " + vec3f + " -> Win " + nArray[0] + "/" + nArray[1]);
                    Vec3f vec3f2 = UITypeDemo01.this.crossHair.winToShapeCoord(pMVMatrix4f, recti, nArray[0], nArray[1], new Vec3f());
                    System.err.println("CrossHair: Obj: Win " + nArray[0] + "/" + nArray[1] + " -> Obj " + vec3f2);
                    Vec3f vec3f3 = UITypeDemo01.this.crossHair.winToShapeCoord(pMVMatrix4f, recti, n, n2, new Vec3f());
                    if (null != vec3f3) {
                        object = vec3f3.minus(vec3f);
                        if (!FloatUtil.isZero((float)object.x()) || !FloatUtil.isZero((float)object.y())) {
                            System.err.println("CrossHair: Move.1: Win " + n + "/" + n2 + " -> Obj " + vec3f3 + " -> diff " + object);
                            UITypeDemo01.this.crossHair.move(object.x(), object.y(), 0.0f);
                        } else {
                            System.err.println("CrossHair: Move.0: Win " + n + "/" + n2 + " -> Obj " + vec3f3 + " -> diff " + object);
                        }
                    }
                    object = UITypeDemo01.this.crossHair.getSurfaceSize(pMVMatrix4f, recti, new int[2]);
                    System.err.println("CrossHair: Size: Pixel " + (int)object[0] + " x " + (int)object[1]);
                    pMVMatrix4f.popMv();
                    return true;
                }
            });
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseWheelMoved(MouseEvent mouseEvent) {
        }
    }
}

