/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.demos.graph.ui;

import com.jogamp.common.util.InterruptSource;
import com.jogamp.graph.curve.Region;
import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.graph.ui.Scene;
import com.jogamp.graph.ui.Shape;
import com.jogamp.graph.ui.shapes.Rectangle;
import com.jogamp.math.Vec3f;
import com.jogamp.math.geom.Cube;
import com.jogamp.math.geom.Frustum;
import com.jogamp.math.geom.plane.AffineTransform;
import com.jogamp.math.util.PMVMatrix4f;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.KeyAdapter;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MouseAdapter;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLPipelineFactory;
import com.jogamp.opengl.GLRunnable;
import com.jogamp.opengl.demos.graph.MSAATool;
import com.jogamp.opengl.demos.util.CommandlineOptions;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.GLReadBufferUtil;
import java.io.File;
import java.io.IOException;

public class UIShapeClippingDemo00
implements GLEventListener {
    static final boolean DEBUG = false;
    static final boolean TRACE = false;
    static CommandlineOptions options = new CommandlineOptions(1280, 720, 2);
    static final float szw = 0.26666668f;
    static final float szh = 0.13333334f;
    static Rectangle clipRect;
    private final GLReadBufferUtil screenshot;
    private final int renderModes;
    private final RegionRenderer rRenderer;
    private final boolean debug;
    private final boolean trace;
    private Shape shape;
    private KeyAction keyAction;
    private volatile GLAutoDrawable autoDrawable = null;
    private final float[] position = new float[]{0.0f, 0.0f, 0.0f};
    private static final float xTran = 0.0f;
    private static final float yTran = 0.0f;
    private static final float zTran = -0.2f;
    private static final float zNear = 0.1f;
    private static final float zFar = 7000.0f;
    boolean ignoreInput = false;
    protected final AffineTransform tempT1 = new AffineTransform();
    protected final AffineTransform tempT2 = new AffineTransform();
    int screenshot_num = 0;

    public static void main(String[] stringArray) throws IOException {
        int[] nArray = new int[]{0};
        nArray[0] = 0;
        while (nArray[0] < stringArray.length) {
            if (options.parse(stringArray, nArray)) {
                // empty if block
            }
            nArray[0] = nArray[0] + 1;
        }
        System.err.println(options);
        GLCapabilities gLCapabilities = options.getGLCaps();
        System.out.println("Requested: " + gLCapabilities);
        final GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)gLCapabilities);
        gLWindow.setSize(UIShapeClippingDemo00.options.surface_width, UIShapeClippingDemo00.options.surface_height);
        gLWindow.setTitle(UIShapeClippingDemo00.class.getSimpleName() + ": " + gLWindow.getSurfaceWidth() + " x " + gLWindow.getSurfaceHeight());
        clipRect = new Rectangle(UIShapeClippingDemo00.options.renderModes, 0.26666668f, 0.13333334f, 5.0E-4f);
        clipRect.move(-0.13333334f, -0.06666667f, Scene.DEFAULT_Z16_EPSILON).setColor(0.0f, 0.0f, 0.0f, 1.0f);
        UIShapeClippingDemo00 uIShapeClippingDemo00 = new UIShapeClippingDemo00(UIShapeClippingDemo00.options.renderModes, false, false);
        uIShapeClippingDemo00.attachInputListenerTo(gLWindow);
        gLWindow.addGLEventListener((GLEventListener)uIShapeClippingDemo00);
        gLWindow.setVisible(true);
        System.out.println("Chosen: " + gLWindow.getChosenGLCapabilities());
        final Animator animator = new Animator(0);
        animator.setUpdateFPSFrames(300, null);
        animator.add((GLAutoDrawable)gLWindow);
        gLWindow.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                short s = keyEvent.getKeySymbol();
                float f = clipRect.getX();
                float f2 = clipRect.getY();
                float f3 = clipRect.getZ();
                float f4 = clipRect.getWidth();
                float f5 = clipRect.getHeight();
                if (s == 149) {
                    if (keyEvent.isShiftDown()) {
                        float f6 = f4 * 1.01f - f4;
                        clipRect.move(-f6, 0.0f, 0.0f);
                    } else if (keyEvent.isControlDown()) {
                        float f7 = f4 * 1.01f - f4;
                        clipRect.setPosition(f - f7, f2, f3);
                        clipRect.setDimension(f4 * 1.01f, f5, clipRect.getLineWidth());
                    } else {
                        clipRect.setDimension(f4 * 0.99f, f5, clipRect.getLineWidth());
                    }
                } else if (s == 151) {
                    if (keyEvent.isShiftDown()) {
                        float f8 = f4 * 1.01f - f4;
                        clipRect.move(f8, 0.0f, 0.0f);
                    } else if (keyEvent.isControlDown()) {
                        float f9 = f4 - f4 * 0.99f;
                        clipRect.setPosition(f + f9, f2, f3);
                        clipRect.setDimension(f4 * 0.99f, f5, clipRect.getLineWidth());
                    } else {
                        clipRect.setDimension(f4 * 1.01f, f5, clipRect.getLineWidth());
                    }
                } else if (s == 150) {
                    if (keyEvent.isShiftDown()) {
                        float f10 = f5 * 1.01f - f5;
                        clipRect.move(0.0f, f10, 0.0f);
                    } else if (keyEvent.isControlDown()) {
                        float f11 = f5 - f5 * 0.99f;
                        clipRect.setPosition(f, f2 + f11, f3);
                        clipRect.setDimension(f4, f5 * 0.99f, clipRect.getLineWidth());
                    } else {
                        clipRect.setDimension(f4, f5 * 1.01f, clipRect.getLineWidth());
                    }
                } else if (s == 152) {
                    if (keyEvent.isShiftDown()) {
                        float f12 = f5 * 1.01f - f5;
                        clipRect.move(0.0f, -f12, 0.0f);
                    } else if (keyEvent.isControlDown()) {
                        float f13 = f5 * 1.01f - f5;
                        clipRect.setPosition(f, f2 - f13, f3);
                        clipRect.setDimension(f4, f5 * 1.01f, clipRect.getLineWidth());
                    } else {
                        clipRect.setDimension(f4, f5 * 0.99f, clipRect.getLineWidth());
                    }
                } else if (s == 100 || s == 27 || s == 81) {
                    new InterruptSource.Thread(() -> gLWindow.destroy()).start();
                }
            }
        });
        gLWindow.addWindowListener((WindowListener)new WindowAdapter(){

            public void windowDestroyed(WindowEvent windowEvent) {
                animator.stop();
            }
        });
        animator.start();
    }

    public UIShapeClippingDemo00(int n, boolean bl, boolean bl2) {
        this.renderModes = n;
        this.rRenderer = RegionRenderer.create((RegionRenderer.GLCallback)RegionRenderer.defaultBlendEnable, (RegionRenderer.GLCallback)RegionRenderer.defaultBlendDisable);
        this.rRenderer.setAAQuality(UIShapeClippingDemo00.options.graphAAQuality);
        this.rRenderer.setSampleCount(UIShapeClippingDemo00.options.graphAASamples);
        this.debug = bl;
        this.trace = bl2;
        this.screenshot = new GLReadBufferUtil(false, false);
        this.shape = new Rectangle(n, 0.24000001f, 0.120000005f, 0.0f);
        this.shape.move(0.013333335f, 0.0066666673f, -Scene.DEFAULT_Z16_EPSILON);
    }

    public final RegionRenderer getRegionRenderer() {
        return this.rRenderer;
    }

    public final float[] getPosition() {
        return this.position;
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        this.autoDrawable = gLAutoDrawable;
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        if (this.debug) {
            gL2ES2 = gL2ES2.getContext().setGL(GLPipelineFactory.create((String)"com.jogamp.opengl.Debug", null, (GL)gL2ES2, null)).getGL2ES2();
        }
        if (this.trace) {
            gL2ES2 = gL2ES2.getContext().setGL(GLPipelineFactory.create((String)"com.jogamp.opengl.Trace", null, (GL)gL2ES2, (Object[])new Object[]{System.err})).getGL2ES2();
        }
        gL2ES2.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.getRegionRenderer().init(gL2ES2);
        gL2ES2.setSwapInterval(1);
        gL2ES2.glEnable(2929);
        MSAATool.dump(gLAutoDrawable);
        if (gLAutoDrawable instanceof Window) {
            Window window = (Window)gLAutoDrawable;
            window.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseWheelMoved(MouseEvent mouseEvent) {
                    Vec3f vec3f = new Vec3f(mouseEvent.getRotation()).scale((float)Math.PI / 180);
                    float f = vec3f.x();
                    vec3f.setX(vec3f.y());
                    vec3f.setY(f);
                    clipRect.setRotation(clipRect.getRotation().rotateByEuler(vec3f.scale(2.0f)));
                }
            });
        }
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        this.rRenderer.reshapePerspective(0.7853982f, n3, n4, 0.1f, 7000.0f);
        PMVMatrix4f pMVMatrix4f = this.rRenderer.getMatrix();
        pMVMatrix4f.loadMvIdentity();
        pMVMatrix4f.translateMv(0.0f, 0.0f, -0.2f);
        if (gLAutoDrawable instanceof Window) {
            ((Window)gLAutoDrawable).setTitle(UIShapeClippingDemo00.class.getSimpleName() + ": " + gLAutoDrawable.getSurfaceWidth() + " x " + gLAutoDrawable.getSurfaceHeight());
        }
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        gL2ES2.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
        gL2ES2.glClear(16640);
        RegionRenderer regionRenderer = this.getRegionRenderer();
        regionRenderer.enable(gL2ES2, true);
        PMVMatrix4f pMVMatrix4f = regionRenderer.getMatrix();
        pMVMatrix4f.pushMv();
        clipRect.applyMatToMv(pMVMatrix4f);
        Frustum frustum = new Cube(clipRect.getBounds()).transform(pMVMatrix4f.getMv()).updateFrustumPlanes(new Frustum());
        regionRenderer.setClipFrustum(frustum);
        if (null != this.shape && this.shape.isVisible()) {
            pMVMatrix4f.pushMv();
            this.shape.applyMatToMv(pMVMatrix4f);
            this.shape.draw(gL2ES2, regionRenderer);
            pMVMatrix4f.popMv();
        }
        regionRenderer.setClipFrustum(null);
        clipRect.draw(gL2ES2, regionRenderer);
        pMVMatrix4f.popMv();
        regionRenderer.enable(gL2ES2, false);
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        if (null != this.shape) {
            this.shape.destroy(gL2ES2, this.getRegionRenderer());
            this.shape = null;
        }
        if (null != clipRect) {
            clipRect.destroy(gL2ES2, this.getRegionRenderer());
        }
        this.autoDrawable = null;
        this.screenshot.dispose((GL)gL2ES2);
        this.rRenderer.destroy(gL2ES2);
    }

    public void attachInputListenerTo(GLWindow gLWindow) {
        if (null == this.keyAction) {
            this.keyAction = new KeyAction();
            gLWindow.addKeyListener((KeyListener)this.keyAction);
        }
    }

    public void detachFrom(GLWindow gLWindow) {
        if (null == this.keyAction) {
            return;
        }
        gLWindow.removeGLEventListener((GLEventListener)this);
        gLWindow.removeKeyListener((KeyListener)this.keyAction);
    }

    public void printScreen(GLAutoDrawable gLAutoDrawable, String string, String string2, String string3, boolean bl) throws GLException, IOException {
        String string4 = String.format("-%03dx%03d-Z%04d-T%04d-%s", gLAutoDrawable.getSurfaceWidth(), gLAutoDrawable.getSurfaceHeight(), (int)Math.abs(-0.2f), 0, string3);
        String string5 = string + string2 + string4 + ".png";
        if (this.screenshot.readPixels(gLAutoDrawable.getGL(), false)) {
            this.screenshot.write(new File(string5));
        }
    }

    public void setIgnoreInput(boolean bl) {
        this.ignoreInput = bl;
    }

    public boolean getIgnoreInput() {
        return this.ignoreInput;
    }

    public class KeyAction
    implements KeyListener {
        public void keyPressed(KeyEvent keyEvent) {
            if (UIShapeClippingDemo00.this.ignoreInput) {
                return;
            }
            if (keyEvent.getKeyCode() == 83 && null != UIShapeClippingDemo00.this.autoDrawable) {
                UIShapeClippingDemo00.this.autoDrawable.invoke(false, new GLRunnable(){

                    public boolean run(GLAutoDrawable gLAutoDrawable) {
                        try {
                            String string = Region.getRenderModeString((int)UIShapeClippingDemo00.this.renderModes);
                            UIShapeClippingDemo00.this.printScreen(gLAutoDrawable, "./", "demo-" + string, "snap" + UIShapeClippingDemo00.this.screenshot_num, false);
                            ++UIShapeClippingDemo00.this.screenshot_num;
                        }
                        catch (GLException gLException) {
                            gLException.printStackTrace();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                        return true;
                    }
                });
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }
    }
}

