/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.demos.graph.ui;

import com.jogamp.common.os.Clock;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.font.FontFactory;
import com.jogamp.graph.ui.Container;
import com.jogamp.graph.ui.Group;
import com.jogamp.graph.ui.Scene;
import com.jogamp.graph.ui.Shape;
import com.jogamp.graph.ui.layout.Alignment;
import com.jogamp.graph.ui.layout.Gap;
import com.jogamp.graph.ui.layout.GridLayout;
import com.jogamp.graph.ui.shapes.Button;
import com.jogamp.math.Recti;
import com.jogamp.math.geom.AABBox;
import com.jogamp.math.util.PMVMatrix4f;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.demos.util.CommandlineOptions;
import com.jogamp.opengl.util.Animator;
import java.io.IOException;
import jogamp.graph.ui.TreeTool;

public class UISceneDemo11 {
    static CommandlineOptions options = new CommandlineOptions(1280, 720, 2);

    public static void main(String[] stringArray) throws IOException {
        long l;
        Object object;
        if (0 != stringArray.length) {
            object = new int[]{0};
            object[0] = (GLCapabilities)false;
            while (object[0] < stringArray.length) {
                if (options.parse(stringArray, (int[])object)) {
                    // empty if block
                }
                Object object2 = object;
                object2[0] = object2[0] + true;
            }
        }
        System.err.println(options);
        object = options.getGLCaps();
        System.out.println("Requested: " + object);
        Font font = FontFactory.get((int)0).get(1, 2);
        System.err.println("Font: " + font.getFullFamilyName());
        Group group = new Group((Group.Layout)new GridLayout(2, 1.0f, 0.5f, Alignment.Fill, new Gap(0.1f)));
        group.addShape(new Button(UISceneDemo11.options.renderModes, font, (CharSequence)"r1 c1", 1.0f, 0.5f).setPerp().setDragAndResizable(false));
        group.addShape(new Button(UISceneDemo11.options.renderModes, font, (CharSequence)"r1 c2", 1.0f, 0.5f).setPerp().setDragAndResizable(false));
        group.addShape(new Button(UISceneDemo11.options.renderModes, font, (CharSequence)"r2 c1", 1.0f, 0.5f).setPerp().setDragAndResizable(false));
        group.addShape(new Button(UISceneDemo11.options.renderModes, font, (CharSequence)"r2 c2", 1.0f, 0.5f).setPerp().setDragAndResizable(false));
        group.setInteractive(true);
        group.scale(0.125f, 0.125f, 1.0f);
        group.validate(object.getGLProfile());
        System.err.println("Group-A0 " + group);
        System.err.println("Group-A0 Layout " + group.getLayout());
        TreeTool.forAll((Container)group, shape -> {
            System.err.println("Shape... " + shape);
            return false;
        });
        Scene scene = new Scene(UISceneDemo11.options.graphAASamples);
        scene.setPMVMatrixSetup((Scene.PMVMatrixSetup)new MyPMVMatrixSetup());
        scene.setClearParams(new float[]{1.0f, 1.0f, 1.0f, 1.0f}, 16640);
        scene.addShape((Shape)group);
        scene.setPMvCullingEnabled(true);
        final Animator animator = new Animator(0);
        final GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)object);
        gLWindow.setSize(UISceneDemo11.options.surface_width, UISceneDemo11.options.surface_height);
        gLWindow.setTitle(UISceneDemo11.class.getSimpleName() + ": " + gLWindow.getSurfaceWidth() + " x " + gLWindow.getSurfaceHeight());
        gLWindow.setVisible(true);
        gLWindow.addGLEventListener((GLEventListener)scene);
        gLWindow.addWindowListener((WindowListener)new WindowAdapter(){

            public void windowResized(WindowEvent windowEvent) {
                gLWindow.setTitle(UISceneDemo11.class.getSimpleName() + ": " + gLWindow.getSurfaceWidth() + " x " + gLWindow.getSurfaceHeight());
            }

            public void windowDestroyNotify(WindowEvent windowEvent) {
                animator.stop();
            }
        });
        scene.attachInputListenerTo(gLWindow);
        animator.setUpdateFPSFrames(60, null);
        animator.add((GLAutoDrawable)gLWindow);
        animator.start();
        scene.waitUntilDisplayed();
        AABBox aABBox = scene.getBounds();
        System.err.println("SceneBox " + aABBox);
        System.err.println("Group-A0 " + group);
        TreeTool.forAll((Container)group, shape -> {
            System.err.println("Shape... " + shape);
            return false;
        });
        group.moveTo(0.0f, aABBox.getMinY(), 0.0f);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Group group2 = group;
        float f = aABBox.getMinX();
        float f2 = aABBox.getMaxX() - group2.getScaledWidth();
        int[] nArray = group2.getSurfaceSize(scene, new PMVMatrix4f(), new int[2]);
        float[] fArray = group2.getPixelPerShapeUnit(nArray, new float[2]);
        float f3 = gLWindow.getPixelsPerMM(new float[2])[0];
        float f4 = scene.getWidth() - nArray[0];
        float f5 = f4 / f3 / 1000.0f;
        float f6 = 50.0f * f3;
        float f7 = f6 / fArray[0];
        float f8 = f5 / 0.05f;
        System.err.println();
        System.err.printf("Shape: %d x %d [pixel], %.4f px/shape_unit%n", nArray[0], nArray[1], Float.valueOf(fArray[0]));
        System.err.printf("Shape: %s%n", group2);
        System.err.println();
        System.err.printf("Distance: %.0f pixel @ %.3f px/mm, %.3f mm%n", Float.valueOf(f4), Float.valueOf(f3), Float.valueOf(f5 * 1000.0f));
        System.err.printf("Velocity: %.3f mm/s, %.3f px/s, %.6f obj/s, expected travel-duration %.3f s%n", Float.valueOf(50.0f), Float.valueOf(f6), Float.valueOf(f7), Float.valueOf(f8));
        long l2 = l = Clock.currentNanos() / 1000L;
        group2.moveTo(f, aABBox.getMinY(), 0.0f);
        while (group2.getPosition().x() < f2 && gLWindow.isNativeValid()) {
            long l3 = Clock.currentNanos() / 1000L;
            float f9 = (float)(l3 - l2) / 1000000.0f;
            l2 = l3;
            float f10 = f7 * f9;
            gLWindow.invoke(true, arg_0 -> UISceneDemo11.lambda$main$2((Shape)group2, f10, arg_0));
        }
        group2.moveTo(f2, aABBox.getMinY(), 0.0f);
        float f11 = (float)(Clock.currentNanos() / 1000L - l) / 1000000.0f;
        System.err.printf("Actual travel-duration %.3f s, delay %.3f s%n", Float.valueOf(f11), Float.valueOf(f11 - f8));
        System.err.println("Group-A0 bounds " + group);
        TreeTool.forAll((Container)group, shape -> {
            System.err.println("Shape... " + shape);
            return false;
        });
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!UISceneDemo11.options.stayOpen) {
            gLWindow.destroy();
        }
    }

    private static /* synthetic */ boolean lambda$main$2(Shape shape, float f, GLAutoDrawable gLAutoDrawable) {
        shape.move(f, 0.0f, 0.0f);
        return true;
    }

    static class MyPMVMatrixSetup
    extends Scene.DefaultPMVMatrixSetup {
        MyPMVMatrixSetup() {
        }

        public void set(PMVMatrix4f pMVMatrix4f, Recti recti) {
            super.set(pMVMatrix4f, recti);
            AABBox aABBox = new AABBox();
            this.setPlaneBox(aABBox, pMVMatrix4f, recti);
            float f = aABBox.getWidth();
            float f2 = aABBox.getHeight();
            float f3 = f > f2 ? f : f2;
            pMVMatrix4f.scaleP(f3, f3, 1.0f);
        }
    }
}

