/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.demos.graph.ui;

import com.jogamp.common.util.InterruptSource;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.font.FontFactory;
import com.jogamp.graph.ui.Scene;
import com.jogamp.graph.ui.Shape;
import com.jogamp.graph.ui.shapes.GLButton;
import com.jogamp.math.Recti;
import com.jogamp.math.Vec3f;
import com.jogamp.math.geom.AABBox;
import com.jogamp.math.util.PMVMatrix4f;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.KeyAdapter;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.demos.es2.GearsES2;
import com.jogamp.opengl.demos.util.CommandlineOptions;
import com.jogamp.opengl.util.Animator;
import java.io.File;
import java.io.IOException;

public class UISceneDemo10 {
    static final boolean DEBUG = false;
    static final boolean TRACE = false;
    static CommandlineOptions options = new CommandlineOptions(1280, 720, 2);
    private static final String defaultMediaPath = "http://archive.org/download/BigBuckBunny_328/BigBuckBunny_512kb.mp4";
    private static String filmPath = "http://archive.org/download/BigBuckBunny_328/BigBuckBunny_512kb.mp4";

    public static void main(String[] stringArray) throws IOException {
        Object object;
        Font font = null;
        if (0 != stringArray.length) {
            object = new int[]{0};
            object[0] = (GLCapabilities)false;
            while (object[0] < stringArray.length) {
                if (!options.parse(stringArray, (int[])object)) {
                    if (stringArray[object[0]].equals("-font")) {
                        Object object2 = object;
                        object2[0] = object2[0] + true;
                        font = FontFactory.get((File)new File(stringArray[object[0]]));
                    } else if (stringArray[object[0]].equals("-film")) {
                        Object object3 = object;
                        object3[0] = object3[0] + true;
                        filmPath = stringArray[object[0]];
                    }
                }
                Object object4 = object;
                object4[0] = object4[0] + true;
            }
        }
        System.err.println(options);
        object = options.getGLCaps();
        System.out.println("Requested: " + object);
        final GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)object);
        if (null == font) {
            font = FontFactory.get((int)0).get(1, 2);
        }
        System.err.println("Font: " + font.getFullFamilyName());
        final Shape shape = UISceneDemo10.makeShape((Window)gLWindow, font, UISceneDemo10.options.renderModes);
        System.err.println("m0 shape bounds " + shape.getBounds(object.getGLProfile()));
        System.err.println("m0 " + shape);
        final Scene scene = new Scene(UISceneDemo10.options.graphAASamples);
        scene.setPMVMatrixSetup((Scene.PMVMatrixSetup)new MyPMVMatrixSetup());
        scene.setClearParams(new float[]{1.0f, 1.0f, 1.0f, 1.0f}, 16640);
        shape.onMove((shape2, vec3f, vec3f2, mouseEvent) -> {
            Vec3f vec3f3 = shape.getPosition();
            System.err.println("Shape moved: " + vec3f + " -> " + vec3f3);
        });
        shape.addMouseListener((Shape.MouseGestureListener)new Shape.MouseGestureAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                Recti recti = scene.getViewport(new Recti());
                int n = mouseEvent.getX();
                int n2 = recti.height() - mouseEvent.getY() - 1;
                UISceneDemo10.testProject(scene, shape, n, n2);
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                Recti recti = scene.getViewport(new Recti());
                int n = mouseEvent.getX();
                int n2 = recti.height() - mouseEvent.getY() - 1;
                UISceneDemo10.testProject(scene, shape, n, n2);
            }
        });
        scene.addShape(shape);
        gLWindow.setSize(UISceneDemo10.options.surface_width, UISceneDemo10.options.surface_height);
        gLWindow.setTitle(UISceneDemo10.class.getSimpleName() + ": " + gLWindow.getSurfaceWidth() + " x " + gLWindow.getSurfaceHeight());
        gLWindow.setVisible(true);
        gLWindow.addGLEventListener((GLEventListener)scene);
        scene.attachInputListenerTo(gLWindow);
        final Animator animator = new Animator(0);
        animator.setUpdateFPSFrames(300, null);
        animator.add((GLAutoDrawable)gLWindow);
        gLWindow.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                short s = keyEvent.getKeySymbol();
                if (s == 100 || s == 27 || s == 81) {
                    new InterruptSource.Thread(() -> gLWindow.destroy()).start();
                }
            }
        });
        gLWindow.addWindowListener((WindowListener)new WindowAdapter(){

            public void windowResized(WindowEvent windowEvent) {
                gLWindow.setTitle(UISceneDemo10.class.getSimpleName() + ": " + gLWindow.getSurfaceWidth() + " x " + gLWindow.getSurfaceHeight());
            }

            public void windowDestroyed(WindowEvent windowEvent) {
                animator.stop();
            }
        });
        animator.start();
        scene.waitUntilDisplayed();
        System.err.println("m1.1 Scene " + scene.getBounds());
        System.err.println("m1.1 " + shape);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.err.println("You may test moving the Shape by dragging the shape with 1-pointer.");
        System.err.println("You may test resizing the Shape by dragging the shape on 1/5th of the bottom-left or bottom-right corner with 1-pointer.");
        System.err.println("Press F4 or 'window close' to exit ..");
    }

    static void testProject(Scene scene, Shape shape, int n, int n2) {
        PMVMatrix4f pMVMatrix4f = new PMVMatrix4f();
        Vec3f vec3f = shape.winToShapeCoord(scene.getPMVMatrixSetup(), scene.getViewport(), n, n2, pMVMatrix4f, new Vec3f());
        System.err.printf("MM1: winToObjCoord: obj %s%n", vec3f);
        int[] nArray = shape.shapeToWinCoord(scene.getPMVMatrixSetup(), scene.getViewport(), vec3f, pMVMatrix4f, new int[2]);
        int n3 = nArray[0] - n;
        int n4 = nArray[1] - n2;
        System.err.printf("MM2: objToWinCoord: winCoords %d / %d, diff %d x %d%n", nArray[0], nArray[1], n3, n4);
    }

    static Shape makeShape(Window window, Font font, int n) {
        GearsES2 gearsES2 = new GearsES2(0);
        gearsES2.setVerbose(false);
        gearsES2.setClearColor(new float[]{0.9f, 0.9f, 0.9f, 1.0f});
        window.addKeyListener(gearsES2.getKeyListener());
        GearsES2 gearsES22 = gearsES2;
        gearsES2 = new GLButton(n, 0.25f, 0.1f, 1, (GLEventListener)gearsES22, false);
        gearsES2.setToggleable(true);
        gearsES2.setToggle(true);
        gearsES2.setAnimate(true);
        gearsES2.addMouseListener((Shape.MouseGestureListener)new Shape.MouseGestureAdapter((GLButton)gearsES2){
            final /* synthetic */ GLButton val$b;
            {
                this.val$b = gLButton;
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                this.val$b.setAnimate(this.val$b.isToggleOn());
            }
        });
        return gearsES2;
    }

    static class MyPMVMatrixSetup
    extends Scene.DefaultPMVMatrixSetup {
        MyPMVMatrixSetup() {
        }

        public void set(PMVMatrix4f pMVMatrix4f, Recti recti) {
            super.set(pMVMatrix4f, recti);
            AABBox aABBox = new AABBox();
            this.setPlaneBox(aABBox, pMVMatrix4f, recti);
            float f = aABBox.getWidth();
            float f2 = aABBox.getHeight();
            float f3 = f > f2 ? f : f2;
            pMVMatrix4f.scaleP(f3, f3, 1.0f);
        }
    }
}

