/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.demos.graph.ui;

import com.jogamp.common.net.Uri;
import com.jogamp.common.os.Clock;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.IOUtil;
import com.jogamp.common.util.InterruptSource;
import com.jogamp.common.util.VersionUtil;
import com.jogamp.graph.curve.Region;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.font.FontFactory;
import com.jogamp.graph.ui.AnimGroup;
import com.jogamp.graph.ui.Container;
import com.jogamp.graph.ui.Group;
import com.jogamp.graph.ui.Scene;
import com.jogamp.graph.ui.Shape;
import com.jogamp.graph.ui.layout.Alignment;
import com.jogamp.graph.ui.layout.Gap;
import com.jogamp.graph.ui.layout.GridLayout;
import com.jogamp.graph.ui.shapes.Button;
import com.jogamp.graph.ui.shapes.Label;
import com.jogamp.graph.ui.shapes.Rectangle;
import com.jogamp.math.FloatUtil;
import com.jogamp.math.Quaternion;
import com.jogamp.math.Vec2f;
import com.jogamp.math.Vec3f;
import com.jogamp.math.Vec4f;
import com.jogamp.math.geom.AABBox;
import com.jogamp.nativewindow.CapabilitiesChooser;
import com.jogamp.newt.Display;
import com.jogamp.newt.MonitorDevice;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.KeyAdapter;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MouseAdapter;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLAnimatorControl;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLPipelineFactory;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.JoglVersion;
import com.jogamp.opengl.demos.graph.FontSetDemos;
import com.jogamp.opengl.demos.graph.MSAATool;
import com.jogamp.opengl.demos.util.CommandlineOptions;
import com.jogamp.opengl.demos.util.MiscUtils;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.av.GLMediaPlayer;
import com.jogamp.opengl.util.av.GLMediaPlayerFactory;
import com.jogamp.opengl.util.caps.NonFSAAGLCapsChooser;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Random;
import jogamp.graph.ui.TreeTool;

public class UISceneDemo03
implements GLEventListener {
    static final boolean DEBUG = false;
    static final String[] originalTexts = new String[]{" JOGL, Java\u2122 Binding for the OpenGL\u00ae API ", " GraphUI, Resolution Independent Curves ", " JogAmp, Java\u2122 libraries for 3D & Media ", " Linux, Android, Windows, MacOS; iOS, embedded, etc on demand"};
    public static CommandlineOptions options = new CommandlineOptions(1280, 720, 2);
    boolean showAnimBox = true;
    float frame_velocity = 0.005f;
    float velocity = 0.03f;
    float ang_velo = this.velocity * 60.0f;
    int autoSpeed = -1;
    Uri audioUri = null;
    GLMediaPlayer mPlayer = null;
    final int[] manualScreenShotCount = new int[]{0};
    private boolean debug = false;
    private boolean trace = false;
    private final Font fontButtons;
    private final Font fontSymbols;
    private final Font font;
    private final Font fontStatus;
    private float dpiV = 96.0f;
    private float pixPerMM;
    private float monitorRefresh = 60.0f;
    private final Scene scene;
    private final AABBox sceneBox;
    private float top_ypos = 0.0f;
    private final AnimGroup animGroup;
    private final AABBox animBox;
    private final AnimGroup.Set[] dynAnimSet = new AnimGroup.Set[]{null, null, null};
    private boolean firstReshape = true;
    private boolean z_only = true;
    private int txt_idx = 0;
    private int m_state = -1;
    private long t0_us = 0L;
    private long t1_pause_us = 0L;

    public static void main(String[] stringArray) throws IOException {
        Object object;
        UISceneDemo03 uISceneDemo03 = new UISceneDemo03(0);
        if (0 != stringArray.length) {
            object = new int[]{0};
            object[0] = 0;
            while (object[0] < stringArray.length) {
                if (!options.parse(stringArray, (int[])object)) {
                    if (stringArray[object[0]].equals("-v")) {
                        object[0] = object[0] + 1;
                        uISceneDemo03.setVelocity((float)MiscUtils.atoi(stringArray[object[0]], (int)uISceneDemo03.velocity * 1000) / 1000.0f);
                    } else if (stringArray[object[0]].equals("-aspeed")) {
                        uISceneDemo03.setVelocity(0.08f);
                        uISceneDemo03.autoSpeed = -1;
                    } else if (stringArray[object[0]].equals("-rspeed")) {
                        object[0] = object[0] + 1;
                        uISceneDemo03.ang_velo = MiscUtils.atof(stringArray[object[0]], uISceneDemo03.ang_velo);
                    } else if (stringArray[object[0]].equals("-no_anim_box")) {
                        uISceneDemo03.showAnimBox = false;
                    } else if (stringArray[object[0]].equals("-audio")) {
                        object[0] = object[0] + 1;
                        try {
                            uISceneDemo03.audioUri = Uri.cast((String)stringArray[object[0]]);
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            System.err.println(uRISyntaxException);
                            uISceneDemo03.audioUri = null;
                        }
                    }
                }
                object[0] = object[0] + 1;
            }
        }
        System.err.println(JoglVersion.getInstance().toString());
        System.err.println(options);
        object = NewtFactory.createDisplay(null);
        Screen screen = NewtFactory.createScreen((Display)object, (int)0);
        System.err.println(VersionUtil.getPlatformInfo());
        GLCapabilities gLCapabilities = options.getGLCaps();
        System.out.println("Requested: " + gLCapabilities);
        GLWindow gLWindow = GLWindow.create((Screen)screen, (GLCapabilitiesImmutable)gLCapabilities);
        if (0 == UISceneDemo03.options.sceneMSAASamples) {
            gLWindow.setCapabilitiesChooser((CapabilitiesChooser)new NonFSAAGLCapsChooser(false));
        }
        gLWindow.setSize(UISceneDemo03.options.surface_width, UISceneDemo03.options.surface_height);
        gLWindow.setTitle(UISceneDemo03.class.getSimpleName() + ": " + gLWindow.getSurfaceWidth() + " x " + gLWindow.getSurfaceHeight());
        gLWindow.addGLEventListener((GLEventListener)uISceneDemo03);
        final Animator animator = new Animator(0);
        animator.setUpdateFPSFrames(300, null);
        animator.add((GLAutoDrawable)gLWindow);
        animator.setExclusiveContext(UISceneDemo03.options.exclusiveContext);
        gLWindow.addWindowListener((WindowListener)new WindowAdapter(){

            public void windowDestroyed(WindowEvent windowEvent) {
                animator.stop();
            }
        });
        if (UISceneDemo03.options.wait_to_start) {
            System.err.println("Press enter to continue");
            MiscUtils.waitForKey("Start");
        }
        gLWindow.setVisible(true);
        System.out.println("Chosen: " + gLWindow.getChosenGLCapabilities());
        animator.start();
    }

    public UISceneDemo03(int n) {
        this(null, n, false, false);
    }

    private UISceneDemo03(String string, int n, boolean bl, boolean bl2) {
        this.setVelocity(0.08f);
        this.autoSpeed = -1;
        this.debug = bl;
        this.trace = bl2;
        UISceneDemo03.options.renderModes = n;
        try {
            this.fontButtons = FontFactory.get((int)0).getDefault();
            this.fontSymbols = FontFactory.get((int)10).getDefault();
            this.font = FontFactory.get((InputStream)IOUtil.getResource((String)"fonts/freefont/FreeSerif.ttf", (ClassLoader)FontSetDemos.class.getClassLoader(), FontSetDemos.class).getInputStream(), (boolean)true);
            System.err.println("Font FreeSerif: " + this.font.getFullFamilyName());
            this.fontStatus = FontFactory.get((InputStream)IOUtil.getResource((String)"fonts/freefont/FreeMono.ttf", (ClassLoader)FontSetDemos.class.getClassLoader(), FontSetDemos.class).getInputStream(), (boolean)true);
            System.err.println("Font Status: " + this.fontStatus.getFullFamilyName());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.scene = new Scene(UISceneDemo03.options.graphAASamples);
        this.sceneBox = new AABBox();
        this.scene.setClearParams(new float[]{1.0f, 1.0f, 1.0f, 1.0f}, 16640);
        this.scene.getRenderer().setHintBits(2);
        this.animGroup = new AnimGroup(null);
        this.animBox = new AABBox();
        this.scene.addShape((Shape)this.animGroup);
        this.scene.setPMvCullingEnabled(true);
        this.animGroup.setPMvCullingEnabled(true);
    }

    void setVelocity(float f) {
        this.velocity = f;
        this.ang_velo = this.velocity * 60.0f;
        this.autoSpeed = 0;
    }

    public static void rotateShape(Shape shape, float f, int n) {
        float f2;
        Quaternion quaternion = shape.getRotation().copy();
        Vec3f vec3f = quaternion.toEuler(new Vec3f());
        Vec3f vec3f2 = vec3f.copy();
        float f3 = FloatUtil.adegToRad((float)5.0f);
        float f4 = f >= 0.0f ? 1.0f : -1.0f;
        switch (n) {
            case 0: {
                f2 = vec3f.x();
                break;
            }
            case 1: {
                f2 = vec3f.y();
                break;
            }
            case 2: {
                f2 = vec3f.z();
                break;
            }
            default: {
                return;
            }
        }
        float f5 = Math.abs(f2);
        if (1.5707964f - f3 <= f5 && f5 <= 1.5707964f + f3 || 4.712389f - f3 <= f5 && f5 <= 4.712389f + f3) {
            f = 2.0f * f3 * f4;
        }
        switch (n) {
            case 0: {
                vec3f.add(f, 0.0f, 0.0f);
                break;
            }
            case 1: {
                vec3f.add(0.0f, f, 0.0f);
                break;
            }
            case 2: {
                vec3f.add(0.0f, 0.0f, f);
            }
        }
        System.err.println("Rot: angleDelta " + f + " (eps " + f3 + "): " + vec3f2 + " -> " + vec3f);
        shape.setRotation(quaternion.setFromEuler(vec3f));
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        Object object = gLAutoDrawable.getUpstreamWidget();
        if (object instanceof Window) {
            Window window = (Window)object;
            MonitorDevice monitorDevice = window.getMainMonitor();
            float[] fArray = MonitorDevice.mmToInch((float[])monitorDevice.getPixelsPerMM(new float[2]));
            float[] fArray2 = window.getPixelsPerMM(new float[2]);
            this.pixPerMM = fArray2[1];
            float[] fArray3 = MonitorDevice.mmToInch((float[])new float[2], (float[])fArray2);
            this.dpiV = fArray3[1];
            this.monitorRefresh = monitorDevice.getCurrentMode().getRefreshRate();
            System.err.println("Monitor detected: " + monitorDevice);
            System.err.println("Monitor dpi: " + fArray[0] + " x " + fArray[1]);
            System.err.println("Surface scale: native " + Arrays.toString(window.getMaximumSurfaceScale(new float[2])) + ", current " + Arrays.toString(window.getCurrentSurfaceScale(new float[2])));
            System.err.println("Surface dpi " + fArray3[0] + " x " + fArray3[1] + ", refresh " + this.monitorRefresh + " Hz");
        } else {
            this.pixPerMM = MonitorDevice.inchToMM((float)this.dpiV);
            this.monitorRefresh = 60.0f;
            System.err.println("Using default DPI of " + this.dpiV + ", refresh " + this.monitorRefresh + " Hz");
        }
        int n = options.fixDefaultAARenderModeWithDPIThreshold(this.dpiV);
        System.err.println("AUTO RenderMode: dpi " + this.dpiV + ", threshold " + UISceneDemo03.options.noAADPIThreshold + ", mode " + Region.getRenderModeString((int)n) + " -> " + Region.getRenderModeString((int)UISceneDemo03.options.renderModes));
        if (gLAutoDrawable instanceof GLWindow) {
            System.err.println("FontView01: init (1.1)");
            GLWindow gLWindow = (GLWindow)gLAutoDrawable;
            this.scene.attachInputListenerTo(gLWindow);
        } else {
            System.err.println("FontView01: init (1.0)");
        }
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        if (this.debug) {
            gL2ES2 = gL2ES2.getContext().setGL(GLPipelineFactory.create((String)"com.jogamp.opengl.Debug", null, (GL)gL2ES2, null)).getGL2ES2();
        }
        if (this.trace) {
            gL2ES2 = gL2ES2.getContext().setGL(GLPipelineFactory.create((String)"com.jogamp.opengl.Trace", null, (GL)gL2ES2, (Object[])new Object[]{System.err})).getGL2ES2();
        }
        System.err.println(JoglVersion.getGLInfo((GL)gL2ES2, null, (boolean)false).toString());
        System.err.println("VSync Swap Interval: " + gL2ES2.getSwapInterval());
        System.err.println("Chosen: " + gLAutoDrawable.getChosenGLCapabilities());
        MSAATool.dump(gLAutoDrawable);
        gL2ES2.setSwapInterval(1);
        gL2ES2.glEnable(2929);
        this.scene.setAAQuality(UISceneDemo03.options.graphAAQuality);
        this.scene.init(gLAutoDrawable);
        if (null != this.audioUri) {
            this.mPlayer = GLMediaPlayerFactory.createDefault();
            this.mPlayer.addEventListener((GLMediaPlayer.GLMediaEventListener)new MyGLMediaEventListener());
            this.mPlayer.playStream(this.audioUri, -2, -1, -2, 3);
        } else {
            this.mPlayer = null;
        }
        this.firstReshape = true;
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
        this.animGroup.destroy(gLAutoDrawable.getGL().getGL2ES2(), this.scene.getRenderer());
        this.scene.dispose(gLAutoDrawable);
        if (null != this.mPlayer) {
            this.mPlayer.destroy(gLAutoDrawable.getGL());
            this.mPlayer = null;
        }
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        this.scene.reshape(gLAutoDrawable, n, n2, n3, n4);
        if (!this.firstReshape) {
            return;
        }
        this.sceneBox.set(this.scene.getBounds());
        float f = this.sceneBox.getWidth() * 0.0025f;
        Rectangle rectangle = new Rectangle(UISceneDemo03.options.renderModes, this.sceneBox, f);
        if (this.showAnimBox) {
            rectangle.setColor(0.45f, 0.45f, 0.45f, 0.9f);
        } else {
            rectangle.setColor(0.0f, 0.0f, 0.0f, 0.0f);
        }
        rectangle.setInteractive(false);
        this.animGroup.addShape((Shape)rectangle);
        this.animGroup.setRotationPivot(0.0f, 0.0f, 0.0f);
        if (this.showAnimBox) {
            this.animGroup.scale(0.85f, 0.85f, 1.0f);
            this.animGroup.move(-this.sceneBox.getWidth() / 2.0f * 0.075f, 0.0f, 0.0f);
            this.animGroup.setRotation(this.animGroup.getRotation().rotateByAngleY(0.1325f));
        } else {
            this.animGroup.scale(1.0f, 1.0f, 1.0f);
        }
        GLProfile gLProfile = gLAutoDrawable.getChosenGLCapabilities().getGLProfile();
        this.animGroup.validate(gLProfile);
        this.animGroup.setInteractive(false);
        this.animGroup.setToggleable(true);
        this.animGroup.setResizable(false);
        this.animGroup.setToggle(false);
        System.err.println("SceneBox " + this.sceneBox);
        System.err.println("Frustum " + this.scene.getMatrix().getFrustum());
        System.err.println("AnimGroup.0: " + this.animGroup);
        AABBox aABBox = this.fontStatus.getGlyphBounds((CharSequence)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA");
        float f2 = this.sceneBox.getWidth() / aABBox.getWidth();
        System.err.println("StatusLabelScale: " + f2 + " = " + this.sceneBox.getWidth() + " / " + aABBox.getWidth() + ", " + aABBox);
        Label label = new Label(UISceneDemo03.options.renderModes, this.fontStatus, (CharSequence)"Nothing there yet");
        label.setScale(f2, f2, 1.0f);
        label.setColor(0.1f, 0.1f, 0.1f, 1.0f);
        label.moveTo(this.sceneBox.getMinX(), this.sceneBox.getMinY() + f2 * (this.fontStatus.getMetrics().getLineGap() - this.fontStatus.getMetrics().getDescent()), 0.0f);
        this.scene.addShape((Shape)label);
        if (gLAutoDrawable instanceof GLWindow) {
            System.err.println("UISceneDemo20: init (1.1)");
            aABBox = (GLWindow)gLAutoDrawable;
            this.sub01SetupWindowListener((GLWindow)aABBox, this.scene, this.animGroup, label, this.dpiV);
        }
        this.sub02AddUItoScene(this.scene, this.animGroup, 2, gLAutoDrawable);
        this.animBox.set(this.animGroup.getBounds());
        System.err.println("AnimBox " + this.animBox);
        System.err.println("AnimGroup.1 " + this.animGroup);
        this.top_ypos = 0.0f;
        AABBox aABBox2 = this.font.getGlyphBounds((CharSequence)"Welcome to G\u00f6thel Software ***  Jausoft  ***  https://jausoft.com *** We do software ...  Check out Gamp. XXXXXXXXXXXXXXXXXXXXXXXXXXX");
        float f3 = this.animBox.getWidth() / aABBox2.getWidth();
        System.err.println("FontScale2: " + f3 + " = " + this.animBox.getWidth() + " / " + aABBox2.getWidth());
        aABBox2 = new AABBox(this.animBox).resizeWidth(-f, -f);
        this.top_ypos = aABBox2.getMaxY();
        this.top_ypos -= f3 * 1.5f;
        this.animGroup.addGlyphSetHorizScroll01(this.pixPerMM, gLProfile, this.scene.getMatrix(), this.scene.getViewport(), UISceneDemo03.options.renderModes, this.font, (CharSequence)"Welcome to G\u00f6thel Software ***  Jausoft  ***  https://jausoft.com *** We do software ...  Check out Gamp.", f3, new Vec4f(0.1f, 0.1f, 0.1f, 0.9f), 0.05f, aABBox2, this.top_ypos);
        String string = VersionUtil.getPlatformInfo().replace(Platform.getNewline(), "; ").replace("-----------------------------------------------------------------------------------------------------", "  ***  ").replaceAll("\\s+", " ");
        this.top_ypos -= f3 * 1.2f;
        this.animGroup.addGlyphSetHorizScroll01(this.pixPerMM, gLProfile, this.scene.getMatrix(), this.scene.getViewport(), UISceneDemo03.options.renderModes, this.font, (CharSequence)string, f3, new Vec4f(0.1f, 0.1f, 0.1f, 0.9f), 0.03f, aABBox2, this.top_ypos);
        this.firstReshape = false;
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        boolean bl;
        boolean bl2 = bl = null != this.dynAnimSet[0] && this.dynAnimSet[0].isAnimationActive();
        if (0 == this.m_state && !bl && !this.animGroup.getTickPaused()) {
            if (null != this.dynAnimSet[0]) {
                long l = Clock.currentNanos() / 1000L;
                float f = (float)(l - this.t0_us) / 1000000.0f;
                String string = originalTexts[this.txt_idx];
                System.err.printf("Text travel-duration %.3f s, %d chars%n", Float.valueOf(f), string.length());
                this.m_state = 1;
                this.t1_pause_us = l + 1500000L;
            }
        } else if (1 == this.m_state && this.t1_pause_us <= Clock.currentNanos() / 1000L) {
            this.animGroup.removeAnimSets(gLAutoDrawable.getGL().getGL2ES2(), this.scene.getRenderer(), Arrays.asList(this.dynAnimSet));
            if (this.autoSpeed > 0) {
                if (this.velocity < 0.06f) {
                    this.setVelocity(this.velocity + 0.009f);
                } else {
                    this.setVelocity(this.velocity - 0.009f);
                    this.autoSpeed = -1;
                }
            } else if (this.autoSpeed < 0) {
                if (this.velocity > 0.011f) {
                    this.setVelocity(this.velocity - 0.009f);
                } else {
                    this.setVelocity(this.velocity + 0.009f);
                    this.autoSpeed = 1;
                }
            }
            this.txt_idx = (this.txt_idx + 1) % originalTexts.length;
            this.z_only = !this.z_only;
            this.m_state = -1;
            System.err.println("Next animation loop ...");
        } else if (-1 == this.m_state) {
            this.createAnimSets(gLAutoDrawable.getGL());
            this.t0_us = Clock.currentNanos();
            this.m_state = 0;
        }
        this.scene.display(gLAutoDrawable);
    }

    private void createAnimSets(GL gL) {
        GLProfile gLProfile = gL.getGLProfile();
        String string = originalTexts[this.txt_idx];
        AABBox aABBox = this.font.getGlyphBounds((CharSequence)string);
        float f = this.animBox.getWidth() / aABBox.getWidth();
        System.err.println("FontScale: " + f + " = " + this.animBox.getWidth() + " / " + aABBox.getWidth());
        this.dynAnimSet[0] = this.animGroup.addGlyphSetRandom01(this.pixPerMM, gLProfile, this.scene.getMatrix(), this.scene.getViewport(), UISceneDemo03.options.renderModes, this.font, (CharSequence)string, f, new Vec4f(0.1f, 0.1f, 0.1f, 1.0f), 0.0f, this.velocity, 0.15707964f, this.ang_velo, this.animBox, this.z_only, new Random(), (AnimGroup.LerpFunc)new AnimGroup.TargetLerp(Vec3f.UNIT_Y));
        aABBox = gL.getContext();
        String string2 = "JogAmp Version " + JoglVersion.getInstance().getImplementationVersion() + ", GL " + aABBox.getGLVersionNumber().getVersionString() + ", GLSL " + aABBox.getGLSLVersionNumber().getVersionString() + " by " + gL.glGetString(7936);
        AABBox aABBox2 = this.font.getGlyphBounds((CharSequence)string2);
        float f2 = this.animBox.getWidth() / aABBox2.getWidth() * 0.6f;
        this.dynAnimSet[1] = this.animGroup.addGlyphSet(this.pixPerMM, gLProfile, this.scene.getMatrix(), this.scene.getViewport(), UISceneDemo03.options.renderModes, this.font, 'X', (CharSequence)string2, f2, this.velocity, this.velocity / 10.0f, 0.0f, (float)Math.PI * 2, (AnimGroup.LerpFunc)new AnimGroup.SineLerp(this.z_only ? Vec3f.UNIT_Z : Vec3f.UNIT_Y, 1.618f, 1.618f), (set, n, shapeData) -> {
            shapeData.shape.setColor(0.1f, 0.1f, 0.1f, 0.9f);
            shapeData.targetPos.add(this.animBox.getMinX() + set.refShape.getScaledWidth() * 1.0f, this.animBox.getMinY() + set.refShape.getScaledHeight() * 2.0f, 0.0f);
            shapeData.startPos.set(shapeData.targetPos.x() + this.animBox.getWidth(), shapeData.targetPos.y(), shapeData.targetPos.z());
            shapeData.shape.moveTo(shapeData.startPos);
        });
        float f3 = f / 2.0f;
        string2 = new Rectangle(UISceneDemo03.options.renderModes, f3, f3 * 1.1f, this.sceneBox.getWidth() * 0.0025f);
        this.dynAnimSet[2] = this.animGroup.addAnimSet(this.pixPerMM, gLProfile, this.scene.getMatrix(), this.scene.getViewport(), this.velocity, this.velocity / 10.0f, 0.0f, (float)Math.PI * 2, (AnimGroup.LerpFunc)new AnimGroup.TargetLerp(Vec3f.UNIT_Z), (Shape)string2);
        AnimGroup.ShapeSetup shapeSetup = (set, n, shapeData) -> {
            shapeData.targetPos.add(this.animBox.getMinX() + set.refShape.getScaledWidth() * 1.0f, this.top_ypos - set.refShape.getScaledHeight() * 1.5f, 0.0f);
            shapeData.startPos.set(shapeData.targetPos.x() + this.animBox.getWidth(), shapeData.targetPos.y(), shapeData.targetPos.z());
            shapeData.shape.moveTo(shapeData.startPos);
        };
        string2.setColor(1.0f, 0.0f, 0.0f, 0.9f);
        string2.setRotation(string2.getRotation().rotateByAngleZ(0.7853982f));
        this.dynAnimSet[2].addShape(this.animGroup, (Shape)string2, shapeSetup);
        aABBox2 = new Rectangle(UISceneDemo03.options.renderModes, f3, f3 * 1.1f, this.sceneBox.getWidth() * 0.0025f).validate(gLProfile);
        aABBox2.setColor(0.0f, 1.0f, 0.0f, 0.9f);
        aABBox2.move(string2.getScaledWidth() * 1.5f * 1.0f, 0.0f, 0.0f);
        this.dynAnimSet[2].addShape(this.animGroup, (Shape)aABBox2, shapeSetup);
        aABBox2 = new Rectangle(UISceneDemo03.options.renderModes, f3, f3 * 1.1f, this.sceneBox.getWidth() * 0.0025f).validate(gLProfile);
        aABBox2.setColor(0.0f, 0.0f, 1.0f, 0.9f);
        aABBox2.move(string2.getScaledWidth() * 1.5f * 2.0f, 0.0f, 0.0f);
        aABBox2.getRotation().rotateByAngleZ(0.7853982f);
        this.dynAnimSet[2].addShape(this.animGroup, (Shape)aABBox2, shapeSetup);
    }

    void sub01SetupWindowListener(final GLWindow gLWindow, final Scene scene, final AnimGroup animGroup, final Label label, final float f) {
        gLWindow.addWindowListener((WindowListener)new WindowAdapter(){

            public void windowResized(WindowEvent windowEvent) {
                gLWindow.setTitle(UISceneDemo03.class.getSimpleName() + ": " + gLWindow.getSurfaceWidth() + " x " + gLWindow.getSurfaceHeight());
            }

            public void windowDestroyNotify(WindowEvent windowEvent) {
                GLAnimatorControl gLAnimatorControl = gLWindow.getAnimator();
                if (null != gLAnimatorControl) {
                    gLAnimatorControl.stop();
                }
            }
        });
        gLWindow.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                short s = keyEvent.getKeySymbol();
                if (s == 43 || s == 139) {
                    if (keyEvent.isShiftDown()) {
                        UISceneDemo03.this.setVelocity(UISceneDemo03.this.velocity + 0.01f);
                    } else {
                        UISceneDemo03.this.setVelocity(UISceneDemo03.this.velocity + 0.001f);
                    }
                } else if (s == 45 || s == 140) {
                    if (keyEvent.isShiftDown()) {
                        UISceneDemo03.this.setVelocity(UISceneDemo03.this.velocity - 0.01f);
                    } else {
                        UISceneDemo03.this.setVelocity(UISceneDemo03.this.velocity - 0.001f);
                    }
                } else if (s == 100 || s == 27 || s == 81) {
                    MiscUtils.destroyWindow((GLAutoDrawable)gLWindow);
                } else if (s == 32) {
                    animGroup.setTickPaused(!animGroup.getTickPaused());
                } else if (s == 13) {
                    animGroup.stopAnimation();
                }
            }
        });
        gLWindow.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseWheelMoved(MouseEvent mouseEvent) {
                int n = 1;
                if (mouseEvent.isControlDown()) {
                    n = 0;
                } else if (mouseEvent.isAltDown()) {
                    n = 2;
                }
                float f = mouseEvent.getRotation()[1] < 0.0f ? FloatUtil.adegToRad((float)-1.0f) : FloatUtil.adegToRad((float)1.0f);
                UISceneDemo03.rotateShape((Shape)animGroup, f, n);
            }
        });
        gLWindow.addGLEventListener(new GLEventListener(){
            float dir = 1.0f;

            public void init(GLAutoDrawable gLAutoDrawable) {
                System.err.println(JoglVersion.getGLInfo((GL)gLAutoDrawable.getGL(), null));
            }

            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }

            public void display(GLAutoDrawable gLAutoDrawable) {
                Object object;
                if (animGroup.isToggleOn()) {
                    object = animGroup.getRotation();
                    Vec3f vec3f = object.toEuler(new Vec3f());
                    if (1.5707964f <= vec3f.y()) {
                        this.dir = -1.0f;
                    } else if (vec3f.y() <= -1.5707964f) {
                        this.dir = 1.0f;
                    }
                    object.rotateByAngleY(UISceneDemo03.this.frame_velocity * this.dir);
                    animGroup.setRotation(object);
                }
                object = String.format("%s, v %.1f mm/s, r %.3f rad/s", scene.getStatusText(gLAutoDrawable, UISceneDemo03.options.renderModes, f), Float.valueOf(UISceneDemo03.this.velocity * 1000.0f), Float.valueOf(UISceneDemo03.this.ang_velo));
                label.setText((CharSequence)object);
            }

            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            }
        });
    }

    void sub02AddUItoScene(final Scene scene, final AnimGroup animGroup, final int n, final GLAutoDrawable gLAutoDrawable) {
        Group group = new Group();
        float f = this.sceneBox.getWidth() * 0.09f;
        float f2 = f / 3.0f;
        float f3 = scene.getZEpsilon(16);
        Vec2f vec2f = new Vec2f(0.0f, 1.0f);
        Vec2f vec2f2 = new Vec2f(0.0f, 0.2f);
        group.setLayout((Group.Layout)new GridLayout(f, f2, Alignment.Fill, new Gap(f2 * 0.5f, f * 0.1f), 8));
        Button button = new Button(UISceneDemo03.options.renderModes, this.fontSymbols, (CharSequence)this.fontSymbols.getUTF16String("play_arrow"), (CharSequence)this.fontSymbols.getUTF16String("pause"), f, f2, f3);
        button.setSpacing(vec2f2, vec2f);
        button.onToggle(shape -> {
            System.err.println("Play/Pause " + shape);
            animGroup.setTickPaused(shape.isToggleOn());
            if (shape.isToggleOn()) {
                animGroup.setTickPaused(false);
                if (null != this.mPlayer) {
                    this.mPlayer.resume();
                }
            } else {
                animGroup.setTickPaused(true);
                if (null != this.mPlayer) {
                    this.mPlayer.pause(false);
                }
            }
        });
        button.setToggle(true);
        group.addShape((Shape)button);
        button = new Button(UISceneDemo03.options.renderModes, this.fontSymbols, (CharSequence)this.fontSymbols.getUTF16String("fast_forward"), f, f2, f3);
        button.setSpacing(vec2f2, vec2f);
        button.addMouseListener((Shape.MouseGestureListener)new Shape.MouseGestureAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                AnimGroup.Set set = animGroup.getAnimSet(n);
                if (null != set) {
                    set.setAnimationActive(false);
                }
            }
        });
        group.addShape((Shape)button);
        button = new Button(UISceneDemo03.options.renderModes, this.fontSymbols, (CharSequence)this.fontSymbols.getUTF16String("rotate_right"), (CharSequence)this.fontSymbols.getUTF16String("stop_circle"), f, f2, f3);
        button.setSpacing(vec2f2, vec2f);
        button.setToggleable(true);
        button.onToggle(shape -> animGroup.toggle());
        group.addShape((Shape)button);
        button = new Button(UISceneDemo03.options.renderModes, this.fontButtons, (CharSequence)" < Rot > ", f, f2, f3);
        button.addMouseListener((Shape.MouseGestureListener)new Shape.MouseGestureAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                Shape.EventInfo eventInfo = (Shape.EventInfo)mouseEvent.getAttachment();
                int n = 1;
                if (mouseEvent.isControlDown()) {
                    n = 0;
                } else if (mouseEvent.isAltDown()) {
                    n = 2;
                }
                if (eventInfo.objPos.x() < eventInfo.shape.getBounds().getCenter().x()) {
                    UISceneDemo03.rotateShape((Shape)animGroup, FloatUtil.adegToRad((float)1.0f), n);
                } else {
                    UISceneDemo03.rotateShape((Shape)animGroup, FloatUtil.adegToRad((float)-1.0f), n);
                }
            }
        });
        group.addShape((Shape)button);
        button = new Button(UISceneDemo03.options.renderModes, this.fontButtons, (CharSequence)" < Velo > ", f, f2, f3);
        button.addMouseListener((Shape.MouseGestureListener)new Shape.MouseGestureAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                float f;
                Shape.EventInfo eventInfo = (Shape.EventInfo)mouseEvent.getAttachment();
                float f2 = f = mouseEvent.isShiftDown() ? 1.0f : 10.0f;
                if (eventInfo.objPos.x() < eventInfo.shape.getBounds().getCenter().x()) {
                    UISceneDemo03.this.setVelocity(UISceneDemo03.this.velocity - f / 1000.0f);
                } else {
                    UISceneDemo03.this.setVelocity(UISceneDemo03.this.velocity + f / 1000.0f);
                }
                AnimGroup.Set set = animGroup.getAnimSet(n);
                if (null != set) {
                    set.setAnimationActive(false);
                }
            }
        });
        group.addShape((Shape)button);
        button = new Button(UISceneDemo03.options.renderModes, this.fontButtons, (CharSequence)"increment", (CharSequence)"realtime", f, f2, f3);
        button.onToggle(shape -> {
            animGroup.setFixedPeriod(shape.isToggleOn() ? 0.0f : 1.0f / this.monitorRefresh);
            System.err.println("Realtime/Incr " + shape + ", period " + animGroup.getFixedPeriod());
        });
        button.setToggle(true);
        group.addShape((Shape)button);
        button = new Button(UISceneDemo03.options.renderModes, this.fontSymbols, (CharSequence)this.fontSymbols.getUTF16String("camera"), f, f2, f3);
        button.setSpacing(vec2f2, vec2f);
        button.addMouseListener((Shape.MouseGestureListener)new Shape.MouseGestureAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                scene.screenshot(false, scene.nextScreenshotFile(null, UISceneDemo03.class.getSimpleName(), UISceneDemo03.options.renderModes, gLAutoDrawable.getChosenGLCapabilities(), null));
                UISceneDemo03.this.manualScreenShotCount[0] = UISceneDemo03.this.manualScreenShotCount[0] + 1;
            }
        });
        group.addShape((Shape)button);
        button = new Button(UISceneDemo03.options.renderModes, this.fontSymbols, (CharSequence)this.fontSymbols.getUTF16String("power_settings_new"), f, f2, f3);
        button.setSpacing(vec2f2, vec2f);
        button.setColor(0.7f, 0.3f, 0.3f, 1.0f);
        button.addMouseListener((Shape.MouseGestureListener)new Shape.MouseGestureAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                MiscUtils.destroyWindow(gLAutoDrawable);
            }
        });
        group.addShape((Shape)button);
        TreeTool.forAll((Container)group, shape -> {
            shape.setDragAndResizable(false);
            return false;
        });
        group.validate(gLAutoDrawable.getChosenGLCapabilities().getGLProfile());
        group.moveTo(this.sceneBox.getWidth() / 2.0f - group.getScaledWidth() * 1.02f, this.sceneBox.getHeight() / 2.0f - group.getScaledHeight() * 1.02f, 0.0f);
        scene.addShape((Shape)group);
    }

    class MyGLMediaEventListener
    implements GLMediaPlayer.GLMediaEventListener {
        MyGLMediaEventListener() {
        }

        public void attributesChanged(final GLMediaPlayer gLMediaPlayer, GLMediaPlayer.EventMask eventMask, long l) {
            System.err.println("MediaPlayer.1 AttributesChanges: " + eventMask + ", when " + l);
            System.err.println("MediaPlayer.1 State: " + gLMediaPlayer);
            if (eventMask.isSet(GLMediaPlayer.EventMask.Bit.Init)) {
                new InterruptSource.Thread(){

                    public void run() {
                        try {
                            gLMediaPlayer.initGL(null);
                            if (GLMediaPlayer.State.Paused == gLMediaPlayer.getState()) {
                                gLMediaPlayer.resume();
                            }
                            System.out.println("MediaPlayer.1 " + gLMediaPlayer);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            gLMediaPlayer.destroy(null);
                            UISceneDemo03.this.mPlayer = null;
                            return;
                        }
                    }
                }.start();
            }
            boolean bl = false;
            GLMediaPlayer.StreamException streamException = null;
            if (eventMask.isSet(GLMediaPlayer.EventMask.Bit.EOS)) {
                streamException = gLMediaPlayer.getStreamException();
                if (null != streamException) {
                    System.err.println("MovieSimple State: Exception");
                    bl = true;
                } else {
                    new InterruptSource.Thread(){

                        public void run() {
                            gLMediaPlayer.setPlaySpeed(1.0f);
                            gLMediaPlayer.seek(0);
                            gLMediaPlayer.resume();
                        }
                    }.start();
                }
            }
            if (eventMask.isSet(GLMediaPlayer.EventMask.Bit.Error)) {
                streamException = gLMediaPlayer.getStreamException();
                bl = true;
            }
            if (bl) {
                if (null != streamException) {
                    System.err.println("MovieSimple State: Exception");
                    streamException.printStackTrace();
                }
                gLMediaPlayer.destroy(null);
                UISceneDemo03.this.mPlayer = null;
            }
        }
    }
}

