/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.demos.graph.ui;

import com.jogamp.common.os.Clock;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.font.FontFactory;
import com.jogamp.graph.ui.Scene;
import com.jogamp.graph.ui.Shape;
import com.jogamp.graph.ui.shapes.BaseButton;
import com.jogamp.graph.ui.shapes.Button;
import com.jogamp.math.FloatUtil;
import com.jogamp.math.Quaternion;
import com.jogamp.math.geom.AABBox;
import com.jogamp.math.util.PMVMatrix4f;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.demos.util.CommandlineOptions;
import com.jogamp.opengl.util.Animator;
import java.io.IOException;

public class UISceneDemo01b {
    static CommandlineOptions options = new CommandlineOptions(1280, 720, 2);

    public static void main(String[] stringArray) throws IOException {
        long l;
        options.parse(stringArray);
        System.err.println(options);
        GLCapabilities gLCapabilities = options.getGLCaps();
        System.out.println("Requested: " + gLCapabilities);
        Font font = FontFactory.get((int)0).get(1, 2);
        System.err.println("Font: " + font.getFullFamilyName());
        BaseButton baseButton = new Button(UISceneDemo01b.options.renderModes, font, (CharSequence)"L", 0.125f, 0.05f).setPerp();
        Quaternion quaternion = baseButton.getRotation().copy();
        quaternion.rotateByAngleX((float)Math.PI);
        quaternion.rotateByAngleY((float)Math.PI);
        baseButton.setRotation(quaternion);
        System.err.println("Shape bounds " + baseButton.getBounds(gLCapabilities.getGLProfile()));
        System.err.println("Shape " + baseButton);
        quaternion = new Scene(UISceneDemo01b.options.graphAASamples);
        quaternion.setClearParams(new float[]{1.0f, 1.0f, 1.0f, 1.0f}, 16640);
        quaternion.addShape((Shape)baseButton);
        quaternion.setAAQuality(UISceneDemo01b.options.graphAAQuality);
        final Animator animator = new Animator(0);
        final GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)gLCapabilities);
        gLWindow.setSize(UISceneDemo01b.options.surface_width, UISceneDemo01b.options.surface_height);
        gLWindow.setTitle(UISceneDemo01b.class.getSimpleName() + ": " + gLWindow.getSurfaceWidth() + " x " + gLWindow.getSurfaceHeight());
        gLWindow.setVisible(true);
        gLWindow.addGLEventListener((GLEventListener)quaternion);
        gLWindow.addWindowListener((WindowListener)new WindowAdapter(){

            public void windowResized(WindowEvent windowEvent) {
                gLWindow.setTitle(UISceneDemo01b.class.getSimpleName() + ": " + gLWindow.getSurfaceWidth() + " x " + gLWindow.getSurfaceHeight());
            }

            public void windowDestroyNotify(WindowEvent windowEvent) {
                animator.stop();
            }
        });
        quaternion.attachInputListenerTo(gLWindow);
        animator.setUpdateFPSFrames(60, null);
        animator.add((GLAutoDrawable)gLWindow);
        animator.start();
        quaternion.waitUntilDisplayed();
        AABBox aABBox = quaternion.getBounds();
        System.err.println("SceneBox " + aABBox);
        System.err.println("Shape " + baseButton);
        baseButton.scale(aABBox.getWidth(), aABBox.getWidth(), 1.0f);
        System.err.println("Shape " + baseButton);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        float f = aABBox.getMinX();
        float f2 = aABBox.getMaxX() - baseButton.getScaledWidth();
        int[] nArray = baseButton.getSurfaceSize((Scene)quaternion, new PMVMatrix4f(), new int[2]);
        float[] fArray = baseButton.getPixelPerShapeUnit(nArray, new float[2]);
        float f3 = gLWindow.getPixelsPerMM(new float[2])[0];
        float f4 = quaternion.getWidth() - nArray[0];
        float f5 = f4 / f3 / 1000.0f;
        float f6 = 50.0f * f3;
        float f7 = f6 / fArray[0];
        float f8 = f5 / 0.05f;
        System.err.println();
        System.err.printf("Shape: %d x %d [pixel], %.4f px/shape_unit%n", nArray[0], nArray[1], Float.valueOf(fArray[0]));
        System.err.printf("Shape: %s%n", baseButton);
        System.err.println();
        System.err.printf("Distance: %.0f pixel @ %.3f px/mm, %.3f mm%n", Float.valueOf(f4), Float.valueOf(f3), Float.valueOf(f5 * 1000.0f));
        System.err.printf("Velocity: %.3f mm/s, %.3f px/s, %.6f obj/s, expected travel-duration %.3f s%n", Float.valueOf(50.0f), Float.valueOf(f6), Float.valueOf(f7), Float.valueOf(f8));
        baseButton.addMouseListener((Shape.MouseGestureListener)new Shape.MouseGestureAdapter((Shape)baseButton){
            final /* synthetic */ Shape val$shape;
            {
                this.val$shape = shape;
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                Shape.EventInfo eventInfo = (Shape.EventInfo)mouseEvent.getAttachment();
                System.err.println("MouseOver " + eventInfo);
                System.err.println();
            }

            public void mouseWheelMoved(MouseEvent mouseEvent) {
                if (!mouseEvent.isShiftDown()) {
                    float f;
                    float f2 = f = mouseEvent.getRotation()[1] < 0.0f ? FloatUtil.adegToRad((float)-10.0f) : FloatUtil.adegToRad((float)10.0f);
                    if (mouseEvent.isAltDown()) {
                        this.val$shape.getRotation().rotateByAngleZ(f);
                    } else if (mouseEvent.isControlDown()) {
                        this.val$shape.getRotation().rotateByAngleX(f);
                    } else {
                        this.val$shape.getRotation().rotateByAngleY(f);
                    }
                    System.err.println("Shape " + this.val$shape);
                    PMVMatrix4f pMVMatrix4f = new PMVMatrix4f();
                    this.val$shape.applyMatToMv(pMVMatrix4f);
                    System.err.println("Shape " + pMVMatrix4f);
                }
            }
        });
        long l2 = l = Clock.currentNanos() / 1000L;
        baseButton.moveTo(f, 0.0f, 0.0f);
        System.err.println("Shape Move: " + f + " -> " + f2);
        System.err.println("Shape Start Pos: " + baseButton);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        while (baseButton.getPosition().x() < f2 && gLWindow.isNativeValid()) {
            long l3 = Clock.currentNanos() / 1000L;
            float f9 = (float)(l3 - l2) / 1000000.0f;
            l2 = l3;
            float f10 = f7 * f9;
            gLWindow.invoke(true, arg_0 -> UISceneDemo01b.lambda$main$0((Shape)baseButton, f10, arg_0));
        }
        float f11 = (float)(Clock.currentNanos() / 1000L - l) / 1000000.0f;
        System.err.printf("Actual travel-duration %.3f s, delay %.3f s%n", Float.valueOf(f11), Float.valueOf(f11 - f8));
        System.err.println("Shape End Pos: " + baseButton);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!UISceneDemo01b.options.stayOpen) {
            gLWindow.destroy();
        }
    }

    private static /* synthetic */ boolean lambda$main$0(Shape shape, float f, GLAutoDrawable gLAutoDrawable) {
        shape.move(f, 0.0f, 0.0f);
        System.err.println("Moved: " + shape);
        return true;
    }
}

