/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.demos.graph.ui;

import com.jogamp.common.net.Uri;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.font.FontFactory;
import com.jogamp.graph.font.FontScale;
import com.jogamp.graph.ui.Container;
import com.jogamp.graph.ui.Group;
import com.jogamp.graph.ui.Scene;
import com.jogamp.graph.ui.Shape;
import com.jogamp.graph.ui.layout.Alignment;
import com.jogamp.graph.ui.layout.BoxLayout;
import com.jogamp.graph.ui.layout.Gap;
import com.jogamp.graph.ui.layout.GridLayout;
import com.jogamp.graph.ui.layout.Margin;
import com.jogamp.graph.ui.layout.Padding;
import com.jogamp.graph.ui.shapes.Button;
import com.jogamp.graph.ui.shapes.Label;
import com.jogamp.graph.ui.shapes.MediaButton;
import com.jogamp.graph.ui.shapes.Rectangle;
import com.jogamp.graph.ui.widgets.MediaPlayer;
import com.jogamp.graph.ui.widgets.RangeSlider;
import com.jogamp.graph.ui.widgets.RangedGroup;
import com.jogamp.math.Vec2f;
import com.jogamp.math.Vec2i;
import com.jogamp.math.Vec3f;
import com.jogamp.math.util.PMVMatrix4f;
import com.jogamp.newt.event.KeyAdapter;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventAdapter;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.demos.util.CommandlineOptions;
import com.jogamp.opengl.demos.util.MiscUtils;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.av.GLMediaPlayer;
import com.jogamp.opengl.util.av.GLMediaPlayerFactory;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jogamp.graph.ui.TreeTool;

public class UIMediaGrid01 {
    private static final float MediaGridWidth = 1.0f;
    static CommandlineOptions options = new CommandlineOptions(1280, 720, 0, 0, 0, 8);
    private static final boolean VERBOSE_UI = false;
    private static final List<String> MEDIA_SUFFIXES = Arrays.asList("mp4", "mkv", "m2v", "avi");
    private static int aid = -1;
    private static int sid = -2;
    private static String alang = null;
    private static String slang = null;
    private static int start_pos = 0;
    private static float videoAspectRatio = 1.7777778f;
    private static boolean letterBox = true;
    private static boolean enableStills = true;
    private static int texCount = 3;
    private static boolean printNativeInfoOnce = true;

    public static void main(String[] stringArray) throws IOException {
        Uri uri;
        Animator animator;
        File file3;
        Object object;
        float f = 50.0f;
        int n = 10000;
        int n2 = -1;
        String string = null;
        String string2 = null;
        if (0 != stringArray.length) {
            object = new int[]{0};
            object[0] = 0;
            while (object[0] < stringArray.length) {
                if (!options.parse(stringArray, (int[])object)) {
                    if (stringArray[object[0]].equals("-dir")) {
                        object[0] = object[0] + 1;
                        string2 = stringArray[object[0]];
                    } else if (stringArray[object[0]].equals("-max")) {
                        object[0] = object[0] + 1;
                        n = MiscUtils.atoi(stringArray[object[0]], n);
                    } else if (stringArray[object[0]].equals("-aid")) {
                        object[0] = object[0] + 1;
                        aid = MiscUtils.atoi(stringArray[object[0]], aid);
                    } else if (stringArray[object[0]].equals("-sid")) {
                        object[0] = object[0] + 1;
                        sid = MiscUtils.atoi(stringArray[object[0]], sid);
                    } else if (stringArray[object[0]].equals("-alang")) {
                        object[0] = object[0] + 1;
                        alang = stringArray[object[0]];
                    } else if (stringArray[object[0]].equals("-slang")) {
                        object[0] = object[0] + 1;
                        slang = stringArray[object[0]];
                    } else if (stringArray[object[0]].equals("-start")) {
                        object[0] = object[0] + 1;
                        start_pos = MiscUtils.atoi(stringArray[object[0]], start_pos);
                    } else if (stringArray[object[0]].equals("-ratio")) {
                        object[0] = object[0] + 1;
                        videoAspectRatio = MiscUtils.atof(stringArray[object[0]], videoAspectRatio);
                    } else if (stringArray[object[0]].equals("-zoom")) {
                        letterBox = false;
                    } else if (stringArray[object[0]].equals("-mmPerCell")) {
                        Object object2 = object;
                        object2[0] = object2[0] + 1;
                        f = MiscUtils.atof(stringArray[object[0]], f);
                    } else if (stringArray[object[0]].equals("-col")) {
                        Object object3 = object;
                        object3[0] = object3[0] + true;
                        n2 = MiscUtils.atoi(stringArray[object[0]], n2);
                    } else if (stringArray[object[0]].equals("-fallbackFont")) {
                        Object object4 = object;
                        object4[0] = object4[0] + true;
                        string = stringArray[object[0]];
                    } else if (stringArray[object[0]].equals("-texCount")) {
                        Object object5 = object;
                        object5[0] = object5[0] + true;
                        texCount = MiscUtils.atoi(stringArray[object[0]], texCount);
                    } else if (stringArray[object[0]].equals("-noStills")) {
                        enableStills = false;
                    }
                }
                object[0] = object[0] + 1;
            }
        }
        if (null != string) {
            FontFactory.setFallbackFont((Font)FontFactory.get((File)new File(string)));
        }
        System.err.println(options);
        System.err.println("mediaDir " + string2);
        System.err.println("maxMediaFiles " + n);
        System.err.println("aid " + aid + ", alang " + alang + "; sid " + sid + ", slang " + slang);
        System.err.println("texCount " + texCount);
        System.err.println("boxRatio " + videoAspectRatio);
        System.err.println("letterBox " + letterBox);
        System.err.println("columns " + n2);
        System.err.println("FallbackFont " + FontFactory.getFallbackFont());
        object = new ArrayList();
        if (null != string2 && string2.length() > 0) {
            file3 = new File(string2);
            animator = file3.listFiles(file -> {
                if (!file.canRead() || !file.isFile()) {
                    System.err.println("Not a file or not readable: " + file);
                    return false;
                }
                String string = file.getName();
                int n = string.lastIndexOf(".");
                if (0 >= n || n == string.length() - 1) {
                    System.err.println("Not having a suffixe: " + file);
                    return false;
                }
                String string2 = string.substring(n + 1);
                if (!MEDIA_SUFFIXES.contains(string2)) {
                    System.err.println("Not having a media suffix: " + file + ", suffix '" + string2 + "'");
                    return false;
                }
                return true;
            });
            Arrays.sort(animator, (file, file2) -> file.getAbsolutePath().compareTo(file2.getAbsolutePath()));
            for (File file4 : animator) {
                try {
                    uri = Uri.valueOf((File)file4);
                    if (object.size() < n) {
                        object.add(uri);
                        System.err.println("Adding media file: " + uri);
                        continue;
                    }
                    System.err.println("Dropping media file: " + uri);
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
        }
        if (0 == object.size()) {
            System.err.println("No media files, exit.");
            return;
        }
        System.err.println("Media Files Count " + object.size());
        file3 = options.getGLCaps();
        System.out.println("Requested: " + file3);
        animator = new Animator(0);
        animator.setUpdateFPSFrames(60, null);
        Animator animator2 = GLWindow.create((GLCapabilitiesImmutable)file3);
        animator2.invoke(false, gLAutoDrawable -> {
            gLAutoDrawable.getGL().setSwapInterval(UIMediaGrid01.options.swapInterval);
            return true;
        });
        animator2.setSize(UIMediaGrid01.options.surface_width, UIMediaGrid01.options.surface_height);
        animator2.setVisible(true);
        System.out.println("Chosen: " + animator2.getChosenGLCapabilities());
        animator2.setTitle(UIMediaGrid01.class.getSimpleName() + ": " + animator2.getSurfaceWidth() + " x " + animator2.getSurfaceHeight());
        animator2.addWindowListener((WindowListener)new WindowAdapter((GLWindow)animator2, animator){
            final /* synthetic */ GLWindow val$window;
            final /* synthetic */ Animator val$animator;
            {
                this.val$window = gLWindow;
                this.val$animator = animator;
            }

            public void windowResized(WindowEvent windowEvent) {
                this.val$window.setTitle(UIMediaGrid01.class.getSimpleName() + ": " + this.val$window.getSurfaceWidth() + " x " + this.val$window.getSurfaceHeight());
            }

            public void windowDestroyNotify(WindowEvent windowEvent) {
                this.val$animator.stop();
            }
        });
        animator.add((GLAutoDrawable)animator2);
        final Scene scene = new Scene(UIMediaGrid01.options.graphAASamples);
        scene.setClearParams(new float[]{1.0f, 1.0f, 1.0f, 1.0f}, 16640);
        scene.setPMvCullingEnabled(true);
        scene.attachInputListenerTo((GLWindow)animator2);
        animator2.addGLEventListener((GLEventListener)scene);
        float f2 = (float)animator2.getSurfaceWidth() / (float)animator2.getSurfaceHeight();
        float[] fArray = animator2.getPixelsPerMM(new float[2]);
        Object object6 = FontScale.ppmmToPPI((float[])new float[]{fArray[0], fArray[1]});
        System.err.println("DPI " + object6[0] + " x " + object6[1] + ", " + fArray[0] + " x " + fArray[1] + " pixel/mm");
        final float f3 = object6[1];
        Object object7 = animator2.getCurrentSurfaceScale(new float[2]);
        System.err.println("HiDPI PixelScale: " + object7[0] + "x" + object7[1] + " (has)");
        float f4 = f / videoAspectRatio;
        int n3 = (int)((float)animator2.getSurfaceHeight() / fArray[1] / f4);
        if (0 >= n2) {
            n2 = (int)((float)animator2.getSurfaceWidth() * 1.0f / fArray[0] / f);
        }
        if (object.size() < n2 * n3) {
            n3 = n2 = (int)Math.floor(Math.sqrt(object.size()));
        }
        int n4 = n3;
        uri = new Vec2i(n2, n4);
        float f5 = videoAspectRatio;
        object6 = new Vec2f((float)uri.x() * f5, (float)n4 * 1.0f);
        System.err.println("GridDim " + uri);
        System.err.println("GridSize " + object6);
        System.err.println("CellSize " + f5 + " x " + 1.0f + ", vAspectRatio " + videoAspectRatio);
        System.err.println("Window " + animator2.getSurfaceWidth() + " x " + animator2.getSurfaceHeight() + ", wAspectRatio " + f2);
        Group group = new Group((Group.Layout)new GridLayout(uri.x(), f5 * 0.9f, 0.9f, Alignment.FillCenter, new Gap(0.1f, f5 * 0.1f)));
        group.setInteractive(false).setDragAndResizable(false).setToggleable(false).setName("MediaGrid");
        UIMediaGrid01.addMedia(scene, file3.getGLProfile(), group, (List<Uri>)object, videoAspectRatio);
        group.setRelayoutOnDirtyShapes(false);
        object7 = new RangedGroup(UIMediaGrid01.options.renderModes, group, (Vec2f)object6, null, new RangedGroup.SliderParam(new Vec2f(f5 / 20.0f, object6.y()), 0.033333335f, true));
        object7.setPaddding(new Padding(0.0625f));
        object7.getVertSlider().setColor(0.3f, 0.3f, 0.3f, 0.7f).setName("MediaView");
        group = new Group((Group.Layout)new GridLayout(1, 0.0f, 0.0f, Alignment.None));
        group.setName("MainGrid");
        group.addShape((Shape)object7);
        Font font = FontFactory.getDefaultFont();
        final Label label = new Label(UIMediaGrid01.options.renderModes, font, (CharSequence)"Not yet");
        label.setColor(0.1f, 0.1f, 0.1f, 1.0f);
        Group group2 = new Group((Group.Layout)new BoxLayout(object6.x(), 0.1f, new Alignment(Alignment.Bit.Fill.value | Alignment.Bit.CenterVert.value), new Margin(0.0f, 0.005f)));
        group2.addShape((Shape)label);
        scene.addGLEventListener((GLEventListener)new GLEventAdapter(){

            public void display(GLAutoDrawable gLAutoDrawable) {
                label.setText((CharSequence)scene.getStatusText(gLAutoDrawable, UIMediaGrid01.options.renderModes, f3));
            }
        });
        group.addShape((Shape)group2);
        scene.addShape((Shape)group);
        animator2.addKeyListener((KeyListener)new KeyAdapter((GLWindow)animator2){
            final /* synthetic */ GLWindow val$window;
            {
                this.val$window = gLWindow;
            }

            public void keyReleased(KeyEvent keyEvent) {
                short s = keyEvent.getKeySymbol();
                if (s == 83) {
                    UIMediaGrid01.printScreenOnGLThread(scene, this.val$window.getChosenGLCapabilities());
                } else if (s == 100 || s == 27 || s == 81) {
                    MiscUtils.destroyWindow((GLAutoDrawable)this.val$window);
                } else if (s == 68) {
                    PMVMatrix4f pMVMatrix4f2 = new PMVMatrix4f();
                    scene.setupMatrix(pMVMatrix4f2);
                    int[] nArray = new int[]{0};
                    TreeTool.forAllRendered((Container)scene, (boolean)false, (PMVMatrix4f)pMVMatrix4f2, (shape, pMVMatrix4f) -> {
                        nArray[0] = nArray[0] + 1;
                        System.err.printf("%03d: shape %s/%s, %s%n", nArray[0], shape.getClass().getSimpleName(), shape.getName(), shape);
                        return false;
                    });
                }
            }
        });
        animator.start();
        scene.waitUntilDisplayed();
        font = scene.getBounds();
        label = group.getBounds();
        float f6 = font.getWidth() / label.getWidth();
        float f7 = font.getHeight() / label.getHeight();
        float f8 = Math.min(f6, f7);
        System.err.println("SceneBox " + font);
        System.err.println("MainGridBox " + label);
        System.err.println("scale sx " + f6 + ", sy " + f7 + ", sxy " + f8);
        group.scale(f8, f8, 1.0f).moveTo(font.getLow()).move(0.0f, font.getHeight() - label.getHeight() * f8, 0.0f);
        UIMediaGrid01.printScreenOnGLThread(scene, animator2.getChosenGLCapabilities());
    }

    static void printScreenOnGLThread(Scene scene, GLCapabilitiesImmutable gLCapabilitiesImmutable) {
        scene.screenshot(true, scene.nextScreenshotFile(null, UIMediaGrid01.class.getSimpleName(), UIMediaGrid01.options.renderModes, gLCapabilitiesImmutable, "media"));
    }

    static void addMedia(Scene scene, GLProfile gLProfile, Group group, List<Uri> list, float f) {
        for (Uri uri : list) {
            GLMediaPlayer gLMediaPlayer = GLMediaPlayerFactory.createDefault();
            if (printNativeInfoOnce) {
                gLMediaPlayer.printNativeInfo(System.err);
                printNativeInfoOnce = false;
            }
            gLMediaPlayer.setTextureMinMagFilter(new int[]{9729, 9729});
            gLMediaPlayer.setTextureUnit(1);
            ArrayList<Button> arrayList = new ArrayList<Button>();
            Font font = FontFactory.getSymbolsFont();
            if (null == font) {
                group.addShape((Shape)new Rectangle(UIMediaGrid01.options.renderModes, f, 1.0f, 0.1f));
                return;
            }
            Button button = new Button(UIMediaGrid01.options.renderModes, font, (CharSequence)font.getUTF16String("reset_tv"), 1.0f, 1.0f, scene.getZEpsilon(16));
            button.setName("reset");
            button.setSpacing(MediaPlayer.SymSpacing, MediaPlayer.FixedSymSize).setPerp().setColor(MediaPlayer.CtrlCellCol);
            button.onClicked((shape2, vec3f, mouseEvent) -> TreeTool.forAll((Container)scene, shape -> {
                System.err.println("- " + shape.getName());
                if (shape instanceof MediaButton) {
                    MediaButton mediaButton = (MediaButton)shape;
                    GLMediaPlayer gLMediaPlayer = mediaButton.getGLMediaPlayer();
                    gLMediaPlayer.seek(0);
                    gLMediaPlayer.setPlaySpeed(1.0f);
                    gLMediaPlayer.setAudioVolume(0.0f);
                }
                if (shape.getName().equals("muteLabel")) {
                    shape.setVisible(true);
                }
                if (shape.getName().equals("MediaGrid")) {
                    shape.markShapeDirty();
                    System.err.println("Reset: " + shape);
                }
                return false;
            }));
            arrayList.add(button);
            font = new MediaPlayer(UIMediaGrid01.options.renderModes, scene, gLMediaPlayer, uri, f, letterBox, 1.0f, enableStills, arrayList);
            group.addShape((Shape)font);
            gLMediaPlayer.playStream(uri, -1, alang, aid, slang, sid, texCount);
            if (start_pos <= 0) continue;
            gLMediaPlayer.seek(start_pos * 1000);
        }
    }

    private static /* synthetic */ void lambda$main$3(RangeSlider rangeSlider, float f, float f2, float f3, float f4, Vec3f vec3f, MouseEvent mouseEvent) {
        Vec2f vec2f = rangeSlider.getMinMax();
        float f5 = f2 / 1.0f;
        System.err.println("VertSlider: row " + f5 + ", val[" + f + " -> " + f2 + "], pct[" + 100.0f * f3 + "% -> " + 100.0f * f4 + "%], minmax " + vec2f);
    }
}

