/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.demos.graph;

import com.jogamp.graph.curve.Region;
import com.jogamp.graph.curve.opengl.GLRegion;
import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.graph.curve.opengl.RenderState;
import com.jogamp.graph.font.FontScale;
import com.jogamp.math.FloatUtil;
import com.jogamp.math.Recti;
import com.jogamp.math.Vec3f;
import com.jogamp.math.geom.AABBox;
import com.jogamp.math.util.PMVMatrix4f;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.FPSCounter;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLAnimatorControl;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLPipelineFactory;
import com.jogamp.opengl.GLRunnable;
import com.jogamp.opengl.demos.graph.MSAATool;
import com.jogamp.opengl.util.GLReadBufferUtil;
import java.io.File;
import java.io.IOException;

public abstract class GPURendererListenerBase01
implements GLEventListener {
    private final RegionRenderer renderer;
    private final int renderModes;
    private final boolean debug;
    private final boolean trace;
    protected GLRegion region;
    private final GLReadBufferUtil screenshot;
    private KeyAction keyAction;
    private volatile GLAutoDrawable autoDrawable = null;
    private final float[] position = new float[]{0.0f, 0.0f, 0.0f};
    protected final float zNear = 0.1f;
    protected final float zFar = 7000.0f;
    protected final AABBox nearPlane1Box;
    private float xTran = -10.0f;
    private float yTran = 10.0f;
    private float ang = 0.0f;
    private float zTran = -70.0f;
    protected volatile float weight = 1.0f;
    boolean ignoreInput = false;
    private int screenshot_num = 0;

    public GPURendererListenerBase01(RegionRenderer regionRenderer, int n, boolean bl, boolean bl2) {
        this.renderer = regionRenderer;
        this.renderModes = n;
        this.debug = bl;
        this.trace = bl2;
        this.screenshot = new GLReadBufferUtil(false, false);
        this.nearPlane1Box = new AABBox();
    }

    public final RegionRenderer getRenderer() {
        return this.renderer;
    }

    public final int getRenderModes() {
        return this.renderModes;
    }

    public final float getZTran() {
        return this.zTran;
    }

    public final float getXTran() {
        return this.xTran;
    }

    public final float getYTran() {
        return this.yTran;
    }

    public final float getAngleDeg() {
        return this.ang;
    }

    public final float getAngleRad() {
        return FloatUtil.adegToRad((float)this.ang);
    }

    public final float[] getPosition() {
        return this.position;
    }

    public void setMatrix(float f, float f2, float f3, float f4) {
        this.xTran = f;
        this.yTran = f2;
        this.zTran = f3;
        this.ang = f4;
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        Window window;
        Object object = gLAutoDrawable.getUpstreamWidget();
        if (object instanceof Window) {
            window = (Window)object;
            float[] fArray = window.getPixelsPerMM(new float[2]);
            float[] fArray2 = FontScale.ppmmToPPI((float[])new float[]{fArray[0], fArray[1]});
            System.err.println("DPI " + fArray2[0] + " x " + fArray2[1] + ", " + fArray[0] + " x " + fArray[1] + " pixel/mm");
            float[] fArray3 = window.getCurrentSurfaceScale(new float[2]);
            System.err.println("HiDPI PixelScale: " + fArray3[0] + "x" + fArray3[1] + " (has)");
        }
        this.autoDrawable = gLAutoDrawable;
        window = gLAutoDrawable.getGL().getGL2ES2();
        if (this.debug) {
            window = window.getContext().setGL(GLPipelineFactory.create((String)"com.jogamp.opengl.Debug", null, (GL)window, null)).getGL2ES2();
        }
        if (this.trace) {
            window = window.getContext().setGL(GLPipelineFactory.create((String)"com.jogamp.opengl.Trace", null, (GL)window, (Object[])new Object[]{System.err})).getGL2ES2();
        }
        System.err.println("*** " + window.getContext().getGLVersion());
        System.err.println("*** GLDebugMessage " + window.getContext().isGLDebugMessageEnabled());
        MSAATool.dump(gLAutoDrawable);
        window.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.getRenderer().init((GL2ES2)window);
    }

    public static void mapWin2ObjectCoords(PMVMatrix4f pMVMatrix4f, Recti recti, float f, float f2, float f3, float f4, float f5, float[] fArray, Vec3f vec3f) {
        fArray[0] = (1.0f / f - 1.0f / f5) / (1.0f / f - 1.0f / f2);
        pMVMatrix4f.mapWinToObj(f3, f4, fArray[0], recti, vec3f);
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        PMVMatrix4f pMVMatrix4f = this.renderer.getMatrix();
        this.renderer.reshapePerspective(0.7853982f, n3, n4, 0.1f, 7000.0f);
        pMVMatrix4f.loadMvIdentity();
        System.err.printf("Reshape: zNear %f,  zFar %f%n", Float.valueOf(0.1f), Float.valueOf(7000.0f));
        System.err.printf("Reshape: Frustum: %s%n", pMVMatrix4f.getFrustum());
        Vec3f vec3f = new Vec3f();
        Vec3f vec3f2 = new Vec3f();
        float[] fArray = new float[1];
        Recti recti = new Recti(0, 0, n3, n4);
        GPURendererListenerBase01.mapWin2ObjectCoords(pMVMatrix4f, recti, 0.1f, 7000.0f, 0.0f, 0.0f, 1.0f, fArray, vec3f);
        System.err.printf("Reshape: mapped.00: [%f, %f, %f], winZ %f -> [%s]%n", Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(fArray[0]), vec3f);
        GPURendererListenerBase01.mapWin2ObjectCoords(pMVMatrix4f, recti, 0.1f, 7000.0f, n3, n4, 1.0f, fArray, vec3f2);
        System.err.printf("Reshape: mapped.11: [%f, %f, %f], winZ %f -> [%s]%n", Float.valueOf(n3), Float.valueOf(n4), Float.valueOf(1.0f), Float.valueOf(fArray[0]), vec3f2);
        this.nearPlane1Box.setSize(vec3f, vec3f2);
        System.err.printf("Reshape: dist1Box: %s%n", this.nearPlane1Box);
        this.dumpMatrix();
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
        this.autoDrawable = null;
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        if (null != this.region) {
            this.region.destroy(gL2ES2);
        }
        this.screenshot.dispose((GL)gL2ES2);
        this.renderer.destroy(gL2ES2);
    }

    public void zoom(int n) {
        this.zTran += (float)n;
        this.dumpMatrix();
    }

    public void move(float f, float f2) {
        this.xTran += f;
        this.yTran += f2;
        this.dumpMatrix();
    }

    public void rotate(float f) {
        this.ang += f;
        this.ang %= 360.0f;
        this.dumpMatrix();
    }

    public void editGlobalWeight(float f) {
        if (!RenderState.isWeightValid((float)(this.weight + f))) {
            return;
        }
        this.weight += f;
        System.err.println("Global Weight: " + this.weight);
    }

    void dumpMatrix() {
        System.err.println("Matrix: " + this.xTran + " / " + this.yTran + " / " + this.zTran + " @ " + this.ang);
    }

    public void attachInputListenerTo(GLWindow gLWindow) {
        if (null == this.keyAction) {
            this.keyAction = new KeyAction();
            gLWindow.addKeyListener((KeyListener)this.keyAction);
        }
    }

    public void detachInputListenerFrom(GLWindow gLWindow) {
        if (null == this.keyAction) {
            return;
        }
        gLWindow.removeKeyListener((KeyListener)this.keyAction);
    }

    public void printScreen(GLAutoDrawable gLAutoDrawable, String string, String string2, String string3, boolean bl) throws GLException, IOException {
        String string4 = String.format("_s%02d-%s-Z%04d-snap%02d-%03dx%03d", this.getRenderer().getSampleCount(), string3, (int)Math.abs(this.zTran), this.screenshot_num++, gLAutoDrawable.getSurfaceWidth(), gLAutoDrawable.getSurfaceHeight());
        String string5 = string + string2 + string4 + ".png";
        if (this.screenshot.readPixels(gLAutoDrawable.getGL(), false)) {
            this.screenshot.write(new File(string5));
        }
    }

    public void printScreenOnGLThread(GLAutoDrawable gLAutoDrawable, final String string, final String string2, final String string3, final boolean bl) {
        gLAutoDrawable.invoke(false, new GLRunnable(){

            public boolean run(GLAutoDrawable gLAutoDrawable) {
                try {
                    GPURendererListenerBase01.this.printScreen(gLAutoDrawable, string, string2, string3, bl);
                }
                catch (GLException gLException) {
                    gLException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return true;
            }
        });
    }

    public void setIgnoreInput(boolean bl) {
        this.ignoreInput = bl;
    }

    public boolean getIgnoreInput() {
        return this.ignoreInput;
    }

    public class KeyAction
    implements KeyListener {
        public void keyPressed(KeyEvent keyEvent) {
            if (GPURendererListenerBase01.this.ignoreInput) {
                return;
            }
            if (keyEvent.getKeyCode() == 49) {
                GPURendererListenerBase01.this.zoom(10);
            } else if (keyEvent.getKeyCode() == 50) {
                GPURendererListenerBase01.this.zoom(-10);
            } else if (keyEvent.getKeyCode() == 150) {
                GPURendererListenerBase01.this.move(0.0f, -1.0f);
            } else if (keyEvent.getKeyCode() == 152) {
                GPURendererListenerBase01.this.move(0.0f, 1.0f);
            } else if (keyEvent.getKeyCode() == 149) {
                GPURendererListenerBase01.this.move(-1.0f, 0.0f);
            } else if (keyEvent.getKeyCode() == 151) {
                GPURendererListenerBase01.this.move(1.0f, 0.0f);
            } else if (keyEvent.getKeyCode() == 54) {
                GPURendererListenerBase01.this.getRenderer().setSampleCount(GPURendererListenerBase01.this.getRenderer().getSampleCount() - 1);
                System.err.println("Sample Count: " + GPURendererListenerBase01.this.getRenderer().getSampleCount());
            } else if (keyEvent.getKeyCode() == 55) {
                GPURendererListenerBase01.this.getRenderer().setSampleCount(GPURendererListenerBase01.this.getRenderer().getSampleCount() + 1);
                System.err.println("Sample Count: " + GPURendererListenerBase01.this.getRenderer().getSampleCount());
            } else if (keyEvent.getKeyCode() == 48) {
                GPURendererListenerBase01.this.rotate(1.0f);
            } else if (keyEvent.getKeyCode() == 57) {
                GPURendererListenerBase01.this.rotate(-1.0f);
            } else if (keyEvent.getKeyCode() == 81) {
                GPURendererListenerBase01.this.editGlobalWeight(-0.1f);
            } else if (keyEvent.getKeyCode() == 87) {
                GPURendererListenerBase01.this.editGlobalWeight(0.1f);
            } else if (keyEvent.getKeyCode() == 86) {
                if (null != GPURendererListenerBase01.this.autoDrawable) {
                    GPURendererListenerBase01.this.autoDrawable.invoke(false, new GLRunnable(){

                        public boolean run(GLAutoDrawable gLAutoDrawable) {
                            int n;
                            GL gL = gLAutoDrawable.getGL();
                            int n2 = gL.getSwapInterval();
                            switch (n2) {
                                case 0: {
                                    n = -1;
                                    break;
                                }
                                case -1: {
                                    n = 1;
                                    break;
                                }
                                case 1: {
                                    n = 0;
                                    break;
                                }
                                default: {
                                    n = 1;
                                }
                            }
                            gL.setSwapInterval(n);
                            GLAnimatorControl gLAnimatorControl = gLAutoDrawable.getAnimator();
                            if (null != gLAnimatorControl) {
                                gLAnimatorControl.resetFPSCounter();
                            }
                            if (gLAutoDrawable instanceof FPSCounter) {
                                ((FPSCounter)gLAutoDrawable).resetFPSCounter();
                            }
                            System.err.println("Swap Interval: " + n2 + " -> " + n + " -> " + gL.getSwapInterval());
                            return true;
                        }
                    });
                }
            } else if (keyEvent.getKeyCode() == 83 && null != GPURendererListenerBase01.this.autoDrawable) {
                String string = Region.getRenderModeString((int)GPURendererListenerBase01.this.renderModes);
                String string2 = string + (Region.hasVariableWeight((int)GPURendererListenerBase01.this.renderModes) ? "-vc" : "-uc");
                GPURendererListenerBase01.this.printScreenOnGLThread(GPURendererListenerBase01.this.autoDrawable, "./", "demo-" + string2, "", false);
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }
    }
}

