/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.demos.gl4es31;

import com.jogamp.common.util.VersionUtil;
import com.jogamp.math.util.SyncBuffer;
import com.jogamp.nativewindow.CapabilitiesChooser;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GL3;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLUniformData;
import com.jogamp.opengl.demos.util.CommandlineOptions;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.GLBuffers;
import com.jogamp.opengl.util.PMVMatrix;
import com.jogamp.opengl.util.caps.NonFSAAGLCapsChooser;
import com.jogamp.opengl.util.glsl.ShaderCode;
import com.jogamp.opengl.util.glsl.ShaderProgram;
import com.jogamp.opengl.util.glsl.ShaderState;
import com.jogamp.opengl.util.glsl.ShaderUtil;

public class ComputeShader01GL4ES31
implements GLEventListener {
    private ShaderState stComp;
    private ShaderState stGfx;
    private PMVMatrix pmvMatrix;
    private GLUniformData pmvMatrixUniform;
    private GLUniformData uRadius;
    private boolean usesPMVMatrix;
    private int iVBO;
    private int iLocVertex = -1;
    private int iLocColor = -1;
    private static final int FloatByteSize = GLBuffers.sizeOfGLType((int)5126);
    private static final int CompPerElem = 3;
    private static final int BytesPerElem = 3 * FloatByteSize;
    private static final int ByteStride = 6 * FloatByteSize;
    private static final String shaderBasename = "compute01_xxx";
    private static final int GROUP_SIZE_HEIGHT = 8;
    private static final int GROUP_SIZE_WIDTH = 8;
    private static final int NUM_VERTS_H = 16;
    private static final int NUM_VERTS_V = 16;
    float radius_dir = -1.0f;

    public void init(GLAutoDrawable gLAutoDrawable) {
        GL gL = gLAutoDrawable.getGL();
        System.err.println("GL_VENDOR: " + gL.glGetString(7936));
        System.err.println("GL_RENDERER: " + gL.glGetString(7937));
        System.err.println("GL_VERSION: " + gL.glGetString(7938));
        System.err.println("GL GLSL: " + gL.hasGLSL() + ", has-compiler-func: " + gL.isFunctionAvailable("glCompileShader") + ", version " + (gL.hasGLSL() ? gL.glGetString(35724) : "none"));
        System.err.println("GL Profile: " + gL.getGLProfile());
        System.err.println("GL Renderer Quirks:" + gL.getContext().getRendererQuirks().toString());
        System.err.println("GL:" + gL + ", " + gL.getContext().getGLVersion());
        if (!ShaderUtil.isComputeShaderSupported((GL)gL)) {
            throw new RuntimeException("GL object not >= 4.3 or ES >= 3.1, i.e. no compute shader support.: " + gL);
        }
        gL = gLAutoDrawable.getGL().getGL3();
        Object object = new int[1];
        gL.glGenBuffers(1, object, 0);
        this.iVBO = object[0];
        if (0 == this.iVBO) {
            throw new GLException("Couldn't create VBO");
        }
        gL.glBindBuffer(34962, this.iVBO);
        gL.glBufferData(34962, (long)(256 * ByteStride), null, 35044);
        gL.glBindBuffer(34962, 0);
        System.err.println("iVBO: " + this.iVBO + ": " + 16 + "x" + 16);
        object = ShaderCode.create((GL2ES2)gL, (int)37305, this.getClass(), (String)"shader", (String)"shader/bin", (String)shaderBasename, (boolean)true);
        object.defaultShaderCustomization((GL2ES2)gL, true, true);
        ShaderProgram shaderProgram = new ShaderProgram();
        shaderProgram.add((GL2ES2)gL, (ShaderCode)object, System.err);
        if (!shaderProgram.link((GL2ES2)gL, System.err)) {
            throw new GLException("Couldn't link program: " + shaderProgram);
        }
        this.stComp = new ShaderState();
        this.stComp.attachShaderProgram((GL2ES2)gL, shaderProgram, true);
        this.uRadius = new GLUniformData("radius", 1.0f);
        this.stComp.ownUniform(this.uRadius);
        if (!this.stComp.uniform((GL2ES2)gL, this.uRadius)) {
            throw new GLException("Error setting radius in shader: " + this.uRadius);
        }
        System.err.println("uRadius: " + this.uRadius);
        this.stComp.useProgram((GL2ES2)gL, false);
        this.usesPMVMatrix = true;
        object = ShaderCode.create((GL2ES2)gL, (int)35633, this.getClass(), (String)"shader", (String)"shader/bin", (String)shaderBasename, (boolean)true);
        shaderProgram = ShaderCode.create((GL2ES2)gL, (int)35632, this.getClass(), (String)"shader", (String)"shader/bin", (String)shaderBasename, (boolean)true);
        object.defaultShaderCustomization((GL2ES2)gL, true, true);
        shaderProgram.defaultShaderCustomization((GL2ES2)gL, true, true);
        ShaderProgram shaderProgram2 = new ShaderProgram();
        shaderProgram2.add((GL2ES2)gL, (ShaderCode)object, System.err);
        shaderProgram2.add((GL2ES2)gL, (ShaderCode)shaderProgram, System.err);
        if (!shaderProgram2.link((GL2ES2)gL, System.err)) {
            throw new GLException("Couldn't link program: " + shaderProgram2);
        }
        this.stGfx = new ShaderState();
        this.stGfx.attachShaderProgram((GL2ES2)gL, shaderProgram2, true);
        this.pmvMatrix = new PMVMatrix();
        this.pmvMatrix.glMatrixMode(5889);
        this.pmvMatrix.glLoadIdentity();
        this.pmvMatrix.glMatrixMode(5888);
        this.pmvMatrix.glLoadIdentity();
        if (this.usesPMVMatrix) {
            this.pmvMatrixUniform = new GLUniformData("gcu_PMVMatrix", 4, 4, (SyncBuffer)this.pmvMatrix.getSyncPMv());
            this.stGfx.ownUniform(this.pmvMatrixUniform);
            if (!this.stGfx.uniform((GL2ES2)gL, this.pmvMatrixUniform)) {
                throw new GLException("Error setting PMVMatrix in shader: " + this.stGfx);
            }
        }
        this.iLocVertex = gL.glGetAttribLocation(shaderProgram2.program(), "gca_Vertex");
        if (this.iLocVertex < 0) {
            throw new GLException("Couldn't find gca_Vertex: " + shaderProgram2);
        }
        this.iLocColor = gL.glGetAttribLocation(shaderProgram2.program(), "gca_Color");
        if (this.iLocColor < 0) {
            throw new GLException("Couldn't find gca_Color: " + shaderProgram2);
        }
        System.err.println("iLocVertex: " + this.iLocVertex);
        System.err.println("iLocColor: " + this.iLocColor);
        gL.glBindBuffer(34962, this.iVBO);
        gL.glEnableVertexAttribArray(this.iLocVertex);
        gL.glEnableVertexAttribArray(this.iLocColor);
        gL.glVertexAttribPointer(this.iLocVertex, 3, 5126, false, ByteStride, 0L);
        gL.glVertexAttribPointer(this.iLocColor, 3, 5126, false, ByteStride, (long)BytesPerElem);
        gL.glBindBuffer(34962, 0);
        this.stGfx.useProgram((GL2ES2)gL, false);
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
        GL3 gL3 = gLAutoDrawable.getGL().getGL3();
        if (null != this.stComp) {
            this.stComp.destroy((GL2ES2)gL3);
            this.stComp = null;
        }
        if (null != this.stGfx) {
            this.pmvMatrixUniform = null;
            this.pmvMatrix = null;
            this.stGfx.destroy((GL2ES2)gL3);
            this.stGfx = null;
        }
        if (this.iVBO != 0) {
            int[] nArray = new int[]{this.iVBO};
            gL3.glDeleteBuffers(1, nArray, 0);
            this.iVBO = 0;
        }
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        GL3 gL3 = gLAutoDrawable.getGL().getGL3();
        gL3.setSwapInterval(1);
        if (null != this.stGfx) {
            this.pmvMatrix.glMatrixMode(5889);
            this.pmvMatrix.glLoadIdentity();
            this.pmvMatrix.glOrthof(-1.0f, 1.0f, -1.0f, 1.0f, 0.0f, 10.0f);
            this.pmvMatrix.glMatrixMode(5888);
            this.pmvMatrix.glLoadIdentity();
            this.stGfx.useProgram((GL2ES2)gL3, true);
            if (this.usesPMVMatrix) {
                this.stGfx.uniform((GL2ES2)gL3, this.pmvMatrixUniform);
            }
            this.stGfx.useProgram((GL2ES2)gL3, false);
        }
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        GL3 gL3 = gLAutoDrawable.getGL().getGL3();
        gL3.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        gL3.glClear(16640);
        if (null != this.stComp) {
            this.stComp.useProgram((GL2ES2)gL3, true);
            float f = this.uRadius.floatValue();
            if (f > 1.0f) {
                this.radius_dir = -1.0f;
            } else if (f < 0.01f) {
                this.radius_dir = 1.0f;
            }
            this.uRadius.setData(f += this.radius_dir * 0.004f);
            this.stComp.uniform((GL2ES2)gL3, this.uRadius);
            gL3.glBindBufferBase(37074, 0, this.iVBO);
            gL3.glDispatchCompute(2, 2, 1);
            gL3.glBindBufferBase(37074, 0, 0);
            this.stComp.useProgram((GL2ES2)gL3, false);
        }
        if (null != this.stGfx) {
            this.stGfx.useProgram((GL2ES2)gL3, true);
            gL3.glMemoryBarrier(1);
            gL3.glBindBuffer(34962, this.iVBO);
            gL3.glEnableVertexAttribArray(this.iLocVertex);
            gL3.glEnableVertexAttribArray(this.iLocColor);
            gL3.glDrawArrays(3, 0, 256);
            gL3.glBindBuffer(34962, 0);
            this.stGfx.useProgram((GL2ES2)gL3, false);
        }
    }

    public static void main(String[] stringArray) {
        CommandlineOptions commandlineOptions = new CommandlineOptions(1280, 720, 0);
        System.err.println(commandlineOptions);
        System.err.println(VersionUtil.getPlatformInfo());
        GLCapabilities gLCapabilities = commandlineOptions.getGLCaps();
        System.out.println("Requested: " + gLCapabilities);
        GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)gLCapabilities);
        if (0 == commandlineOptions.sceneMSAASamples) {
            gLWindow.setCapabilitiesChooser((CapabilitiesChooser)new NonFSAAGLCapsChooser(false));
        }
        gLWindow.setSize(commandlineOptions.surface_width, commandlineOptions.surface_height);
        gLWindow.setTitle(ComputeShader01GL4ES31.class.getSimpleName());
        gLWindow.addGLEventListener((GLEventListener)new ComputeShader01GL4ES31());
        final Animator animator = new Animator(0);
        animator.setUpdateFPSFrames(300, System.err);
        animator.add((GLAutoDrawable)gLWindow);
        gLWindow.addWindowListener((WindowListener)new WindowAdapter(){

            public void windowDestroyed(WindowEvent windowEvent) {
                animator.stop();
            }
        });
        gLWindow.setVisible(true);
        animator.start();
    }
}

