/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.demos.es2;

import com.jogamp.common.util.VersionUtil;
import com.jogamp.math.util.SyncBuffer;
import com.jogamp.nativewindow.CapabilitiesChooser;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLArrayData;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLUniformData;
import com.jogamp.opengl.JoglVersion;
import com.jogamp.opengl.demos.util.CommandlineOptions;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.GLArrayDataServer;
import com.jogamp.opengl.util.PMVMatrix;
import com.jogamp.opengl.util.caps.NonFSAAGLCapsChooser;
import com.jogamp.opengl.util.glsl.ShaderCode;
import com.jogamp.opengl.util.glsl.ShaderProgram;
import com.jogamp.opengl.util.glsl.ShaderState;

public class RedSquareES2
implements GLEventListener {
    private ShaderState st;
    private PMVMatrix pmvMatrix;
    private GLUniformData pmvMatrixUniform;
    private GLArrayDataServer vertices;
    private GLArrayDataServer colors;
    private long t0;
    private int swapInterval = 0;
    private float aspect = 1.0f;
    private boolean doRotate = true;
    private boolean verbose = true;
    private boolean clearBuffers = true;

    public RedSquareES2(int n) {
        this.swapInterval = n;
    }

    public RedSquareES2() {
        this.swapInterval = 1;
    }

    public void setAspect(float f) {
        this.aspect = f;
    }

    public void setDoRotation(boolean bl) {
        this.doRotate = bl;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void setClearBuffers(boolean bl) {
        this.clearBuffers = bl;
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        if (this.verbose) {
            System.err.println(Thread.currentThread() + " RedSquareES2.init");
        }
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        if (this.verbose) {
            System.err.println("RedSquareES2 init on " + Thread.currentThread());
            System.err.println("Chosen GLCapabilities: " + gLAutoDrawable.getChosenGLCapabilities());
            System.err.println("INIT GL IS: " + gL2ES2.getClass().getName());
            System.err.println(JoglVersion.getGLStrings((GL)gL2ES2, null, (boolean)false).toString());
        }
        if (!gL2ES2.hasGLSL()) {
            System.err.println("No GLSL available, no rendering.");
            return;
        }
        this.st = new ShaderState();
        this.st.setVerbose(true);
        ShaderCode shaderCode = ShaderCode.create((GL2ES2)gL2ES2, (int)35633, this.getClass(), (String)"shader", (String)"shader/bin", (String)"RedSquareShader", (boolean)true);
        ShaderCode shaderCode2 = ShaderCode.create((GL2ES2)gL2ES2, (int)35632, this.getClass(), (String)"shader", (String)"shader/bin", (String)"RedSquareShader", (boolean)true);
        shaderCode.defaultShaderCustomization(gL2ES2, true, true);
        shaderCode2.defaultShaderCustomization(gL2ES2, true, true);
        ShaderProgram shaderProgram = new ShaderProgram();
        shaderProgram.add(gL2ES2, shaderCode, System.err);
        shaderProgram.add(gL2ES2, shaderCode2, System.err);
        this.st.attachShaderProgram(gL2ES2, shaderProgram, true);
        this.pmvMatrix = new PMVMatrix();
        this.pmvMatrix.glMatrixMode(5889);
        this.pmvMatrix.glLoadIdentity();
        this.pmvMatrix.glMatrixMode(5888);
        this.pmvMatrix.glLoadIdentity();
        this.pmvMatrixUniform = new GLUniformData("mgl_PMVMatrix", 4, 4, (SyncBuffer)this.pmvMatrix.getSyncPMv());
        this.st.ownUniform(this.pmvMatrixUniform);
        this.st.uniform(gL2ES2, this.pmvMatrixUniform);
        this.vertices = GLArrayDataServer.createGLSL((String)"mgl_Vertex", (int)3, (int)5126, (boolean)false, (int)4, (int)35044);
        this.vertices.putf(-2.0f);
        this.vertices.putf(2.0f);
        this.vertices.putf(0.0f);
        this.vertices.putf(2.0f);
        this.vertices.putf(2.0f);
        this.vertices.putf(0.0f);
        this.vertices.putf(-2.0f);
        this.vertices.putf(-2.0f);
        this.vertices.putf(0.0f);
        this.vertices.putf(2.0f);
        this.vertices.putf(-2.0f);
        this.vertices.putf(0.0f);
        this.vertices.seal((GL)gL2ES2, true);
        this.st.ownAttribute((GLArrayData)this.vertices, true);
        this.vertices.enableBuffer((GL)gL2ES2, false);
        this.colors = GLArrayDataServer.createGLSL((String)"mgl_Color", (int)4, (int)5126, (boolean)false, (int)4, (int)35044);
        this.colors.putf(1.0f);
        this.colors.putf(0.0f);
        this.colors.putf(0.0f);
        this.colors.putf(1.0f);
        this.colors.putf(0.0f);
        this.colors.putf(0.0f);
        this.colors.putf(1.0f);
        this.colors.putf(1.0f);
        this.colors.putf(1.0f);
        this.colors.putf(0.0f);
        this.colors.putf(0.0f);
        this.colors.putf(1.0f);
        this.colors.putf(1.0f);
        this.colors.putf(0.0f);
        this.colors.putf(0.0f);
        this.colors.putf(1.0f);
        this.colors.seal((GL)gL2ES2, true);
        this.st.ownAttribute((GLArrayData)this.colors, true);
        this.colors.enableBuffer((GL)gL2ES2, false);
        gL2ES2.glEnable(2929);
        this.st.useProgram(gL2ES2, false);
        this.t0 = System.currentTimeMillis();
        if (this.verbose) {
            System.err.println(Thread.currentThread() + " RedSquareES2.init FIN");
        }
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        long l = System.currentTimeMillis();
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        if (this.clearBuffers) {
            gL2ES2.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            gL2ES2.glClear(16640);
        }
        if (!gL2ES2.hasGLSL()) {
            return;
        }
        this.st.useProgram(gL2ES2, true);
        this.pmvMatrix.glMatrixMode(5888);
        this.pmvMatrix.glLoadIdentity();
        this.pmvMatrix.glTranslatef(0.0f, 0.0f, -10.0f);
        if (this.doRotate) {
            float f = (float)(l - this.t0) * 360.0f / 4000.0f;
            this.pmvMatrix.glRotatef(f, 0.0f, 0.0f, 1.0f);
            this.pmvMatrix.glRotatef(f, 0.0f, 1.0f, 0.0f);
        }
        this.st.uniform(gL2ES2, this.pmvMatrixUniform);
        this.vertices.enableBuffer((GL)gL2ES2, true);
        this.colors.enableBuffer((GL)gL2ES2, true);
        gL2ES2.glDrawArrays(5, 0, 4);
        this.vertices.enableBuffer((GL)gL2ES2, false);
        this.colors.enableBuffer((GL)gL2ES2, false);
        this.st.useProgram(gL2ES2, false);
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        if (this.verbose) {
            System.err.println(Thread.currentThread() + " RedSquareES2.reshape " + n + "/" + n2 + " " + n3 + "x" + n4 + ", swapInterval " + this.swapInterval + ", drawable 0x" + Long.toHexString(gL2ES2.getContext().getGLDrawable().getHandle()));
        }
        gL2ES2.setSwapInterval(this.swapInterval);
        if (!gL2ES2.hasGLSL()) {
            return;
        }
        this.st.useProgram(gL2ES2, true);
        this.pmvMatrix.glMatrixMode(5889);
        this.pmvMatrix.glLoadIdentity();
        float f = (float)n3 / (float)n4 / this.aspect;
        float f2 = (float)Math.tan(0.3926991f) * 1.0f;
        float f3 = -1.0f * f2;
        float f4 = f * f3;
        float f5 = f * f2;
        this.pmvMatrix.glFrustumf(f4, f5, f3, f2, 1.0f, 100.0f);
        this.st.uniform(gL2ES2, this.pmvMatrixUniform);
        this.st.useProgram(gL2ES2, false);
        System.err.println(Thread.currentThread() + " RedSquareES2.reshape FIN");
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
        GL2ES2 gL2ES2;
        if (this.verbose) {
            System.err.println(Thread.currentThread() + " RedSquareES2.dispose");
        }
        if (!(gL2ES2 = gLAutoDrawable.getGL().getGL2ES2()).hasGLSL()) {
            return;
        }
        this.st.destroy(gL2ES2);
        this.st = null;
        this.pmvMatrix = null;
        if (this.verbose) {
            System.err.println(Thread.currentThread() + " RedSquareES2.dispose FIN");
        }
    }

    public static void main(String[] stringArray) {
        CommandlineOptions commandlineOptions = new CommandlineOptions(1280, 720, 0);
        System.err.println(commandlineOptions);
        System.err.println(VersionUtil.getPlatformInfo());
        GLCapabilities gLCapabilities = commandlineOptions.getGLCaps();
        System.out.println("Requested: " + gLCapabilities);
        GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)gLCapabilities);
        if (0 == commandlineOptions.sceneMSAASamples) {
            gLWindow.setCapabilitiesChooser((CapabilitiesChooser)new NonFSAAGLCapsChooser(false));
        }
        gLWindow.setSize(commandlineOptions.surface_width, commandlineOptions.surface_height);
        gLWindow.setTitle(RedSquareES2.class.getSimpleName());
        gLWindow.addGLEventListener((GLEventListener)new RedSquareES2(1));
        final Animator animator = new Animator(0);
        animator.setUpdateFPSFrames(300, null);
        animator.add((GLAutoDrawable)gLWindow);
        gLWindow.addWindowListener((WindowListener)new WindowAdapter(){

            public void windowDestroyed(WindowEvent windowEvent) {
                animator.stop();
            }
        });
        gLWindow.setVisible(true);
        animator.start();
    }
}

