/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.demos.es2;

import com.jogamp.common.util.VersionUtil;
import com.jogamp.math.Recti;
import com.jogamp.math.util.SyncBuffer;
import com.jogamp.nativewindow.CapabilitiesChooser;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLArrayData;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLUniformData;
import com.jogamp.opengl.demos.es2.GearsES2;
import com.jogamp.opengl.demos.util.CommandlineOptions;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.GLArrayDataServer;
import com.jogamp.opengl.util.PMVMatrix;
import com.jogamp.opengl.util.caps.NonFSAAGLCapsChooser;
import com.jogamp.opengl.util.glsl.ShaderCode;
import com.jogamp.opengl.util.glsl.ShaderProgram;
import com.jogamp.opengl.util.glsl.ShaderState;
import java.nio.FloatBuffer;

public class GearsFBO01
implements GLEventListener {
    private final GLEventListener demo;
    private final int swapInterval;
    private final ShaderState st;
    private final PMVMatrix pmvMatrix;
    private ShaderProgram sp0;
    private GLUniformData pmvMatrixUniform;
    private GLArrayDataServer interleavedVBO;
    private final GLUniformData texUnit0;
    private GLUniformData texType;
    Recti viewport = new Recti();
    private int fboID;
    private int fboWidth;
    private int fboHeight;
    private int colorTexID;
    private int depthTexID;
    private int depthRenderID;
    private final boolean useDepthTexture = true;
    private final int colorAttachmentPoint = 0;
    private static final float[] s_quadVertices = new float[]{-1.0f, -1.0f, 0.0f, 1.0f, -1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f};
    private static final float[] s_quadColors = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    private static final float[] s_quadTexCoords = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};

    public GearsFBO01(int n) {
        this.demo = new GearsES2(0);
        this.swapInterval = n;
        this.st = new ShaderState();
        this.pmvMatrix = new PMVMatrix();
        this.texUnit0 = new GLUniformData("mgl_Texture0", 0);
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        System.err.println("Init: Chosen Caps: " + gLAutoDrawable.getChosenGLCapabilities());
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        this.demo.init(gLAutoDrawable);
        ShaderCode shaderCode = ShaderCode.create((GL2ES2)gL2ES2, (int)35633, GearsFBO01.class, (String)"shader", (String)"shader/bin", (String)"texture01_xxx", (boolean)true);
        ShaderCode shaderCode2 = ShaderCode.create((GL2ES2)gL2ES2, (int)35632, GearsFBO01.class, (String)"shader", (String)"shader/bin", (String)"texture01_customtex", (boolean)true);
        shaderCode.defaultShaderCustomization(gL2ES2, true, true);
        shaderCode2.defaultShaderCustomization(gL2ES2, true, true);
        this.sp0 = new ShaderProgram();
        this.sp0.add(gL2ES2, shaderCode, System.err);
        this.sp0.add(gL2ES2, shaderCode2, System.err);
        this.st.attachShaderProgram(gL2ES2, this.sp0, true);
        this.pmvMatrixUniform = new GLUniformData("mgl_PMVMatrix", 4, 4, (SyncBuffer)this.pmvMatrix.getSyncPMv());
        this.st.ownUniform(this.pmvMatrixUniform);
        this.st.uniform(gL2ES2, this.pmvMatrixUniform);
        this.interleavedVBO = GLArrayDataServer.createGLSLInterleaved((int)9, (int)5126, (boolean)false, (int)12, (int)35044);
        this.interleavedVBO.addGLSLSubArray("mgl_Vertex", 3, 34962);
        this.interleavedVBO.addGLSLSubArray("mgl_Color", 4, 34962);
        this.interleavedVBO.addGLSLSubArray("mgl_MultiTexCoord", 2, 34962);
        FloatBuffer floatBuffer = (FloatBuffer)this.interleavedVBO.getBuffer();
        for (int i = 0; i < 4; ++i) {
            floatBuffer.put(s_quadVertices, i * 3, 3);
            floatBuffer.put(s_quadColors, i * 4, 4);
            floatBuffer.put(s_quadTexCoords, i * 2, 2);
        }
        this.interleavedVBO.seal((GL)gL2ES2, true);
        this.interleavedVBO.enableBuffer((GL)gL2ES2, false);
        this.st.ownAttribute((GLArrayData)this.interleavedVBO, true);
        this.texType = new GLUniformData("mgl_TexType", 1);
        this.st.ownUniform(this.texType);
        this.st.uniform(gL2ES2, this.texType);
        this.st.ownUniform(this.texUnit0);
        this.st.uniform(gL2ES2, this.texUnit0);
        this.st.useProgram(gL2ES2, false);
        this.viewport.set(0, 0, gLAutoDrawable.getSurfaceWidth(), gLAutoDrawable.getSurfaceHeight());
        this.initFBO(gL2ES2, this.viewport.width() / 2, this.viewport.height());
        gL2ES2.glEnable(2929);
    }

    private void initTexParam(GL2ES2 gL2ES2) {
        gL2ES2.glTexParameteri(3553, 10240, 9728);
        gL2ES2.glTexParameteri(3553, 10241, 9728);
        gL2ES2.glTexParameteri(3553, 10242, 33071);
        gL2ES2.glTexParameteri(3553, 10243, 33071);
    }

    private void initFBO(GL2ES2 gL2ES2, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int[] nArray = new int[]{0};
        this.colorTexID = 0;
        this.depthTexID = 0;
        this.depthRenderID = 0;
        this.fboWidth = 0;
        this.fboHeight = 0;
        gL2ES2.glGenTextures(1, nArray, 0);
        this.colorTexID = nArray[0];
        if (0 == this.colorTexID) {
            throw new GLException("XXX");
        }
        gL2ES2.glGenTextures(1, nArray, 0);
        this.depthTexID = nArray[0];
        if (0 == this.depthTexID) {
            throw new GLException("XXX");
        }
        gL2ES2.glGenFramebuffers(1, nArray, 0);
        this.fboID = nArray[0];
        if (0 == this.fboID) {
            throw new GLException("XXX");
        }
        gL2ES2.glBindFramebuffer(36160, this.fboID);
        if (gL2ES2.isGLES3()) {
            n5 = 32856;
            n4 = 6408;
            n3 = 5121;
        } else if (gL2ES2.isGLES()) {
            n5 = 6408;
            n4 = 6408;
            n3 = 5121;
        } else {
            n5 = 32856;
            n4 = 32993;
            n3 = 33639;
        }
        gL2ES2.glBindTexture(3553, this.colorTexID);
        gL2ES2.glTexImage2D(3553, 0, n5, n, n2, 0, n4, n3, null);
        this.initTexParam(gL2ES2);
        gL2ES2.glFramebufferTexture2D(36160, 36064, 3553, this.colorTexID, 0);
        gL2ES2.glBindTexture(3553, this.depthTexID);
        gL2ES2.glTexImage2D(3553, 0, 33191, n, n2, 0, 6402, 5126, null);
        this.initTexParam(gL2ES2);
        gL2ES2.glFramebufferTexture2D(36160, 36096, 3553, this.depthTexID, 0);
        gL2ES2.glBindFramebuffer(36160, 0);
        n5 = gL2ES2.glCheckFramebufferStatus(36160);
        if (36053 != n5) {
            throw new GLException("FBO not complete, but 0x" + Integer.toHexString(n5));
        }
        this.fboWidth = n;
        this.fboHeight = n2;
    }

    private void disposeFBO(GL gL) {
        gL.glBindFramebuffer(36160, this.fboID);
        gL.glFramebufferTexture2D(36160, 36064, 3553, 0, 0);
        gL.glFramebufferTexture2D(36160, 36096, 3553, 0, 0);
        gL.glBindTexture(3553, 0);
        int[] nArray = new int[]{this.colorTexID};
        gL.glDeleteTextures(1, nArray, 0);
        nArray = new int[]{this.depthTexID};
        gL.glDeleteTextures(1, nArray, 0);
        this.colorTexID = 0;
        this.depthTexID = 0;
        this.depthRenderID = 0;
        this.fboWidth = 0;
        this.fboHeight = 0;
        gL.glBindFramebuffer(36160, 0);
        nArray = new int[]{this.fboID};
        gL.glDeleteFramebuffers(1, nArray, 0);
        this.fboID = 0;
    }

    private void resetFBOs(GL2ES2 gL2ES2, int n, int n2) {
        if (this.fboWidth != n || this.fboHeight != n2) {
            this.disposeFBO((GL)gL2ES2);
            this.initFBO(gL2ES2, n, n2);
        }
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        this.demo.dispose(gLAutoDrawable);
        this.disposeFBO((GL)gL2ES2);
        this.st.destroy(gL2ES2);
        this.sp0 = null;
        this.pmvMatrixUniform = null;
        this.interleavedVBO = null;
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        gL2ES2.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        gL2ES2.glClear(16640);
        gL2ES2.glViewport(this.viewport.x(), this.viewport.y(), this.fboWidth, this.fboHeight);
        gL2ES2.glBindFramebuffer(36160, this.fboID);
        this.demo.display(gLAutoDrawable);
        gL2ES2.glBindFramebuffer(36160, 0);
        this.st.useProgram(gL2ES2, true);
        this.texType.setData(0);
        this.st.uniform(gL2ES2, this.texType);
        gL2ES2.glActiveTexture(33984 + this.texUnit0.intValue());
        gL2ES2.glBindTexture(3553, this.colorTexID);
        if (!gL2ES2.isGLcore()) {
            gL2ES2.glEnable(3553);
        }
        this.interleavedVBO.enableBuffer((GL)gL2ES2, true);
        gL2ES2.glDrawArrays(5, 0, 4);
        this.interleavedVBO.enableBuffer((GL)gL2ES2, false);
        gL2ES2.glBindTexture(3553, 0);
        gL2ES2.glViewport(this.viewport.x(), this.viewport.y(), this.viewport.width(), this.viewport.height());
        gL2ES2.glViewport(this.viewport.x() + this.fboWidth, this.viewport.y(), this.fboWidth, this.fboHeight);
        this.texType.setData(1);
        this.st.uniform(gL2ES2, this.texType);
        gL2ES2.glActiveTexture(33984 + this.texUnit0.intValue());
        gL2ES2.glBindTexture(3553, this.depthTexID);
        if (!gL2ES2.isGLcore()) {
            gL2ES2.glEnable(3553);
        }
        this.interleavedVBO.enableBuffer((GL)gL2ES2, true);
        gL2ES2.glDrawArrays(5, 0, 4);
        this.interleavedVBO.enableBuffer((GL)gL2ES2, false);
        gL2ES2.glBindTexture(3553, 0);
        gL2ES2.glViewport(this.viewport.x(), this.viewport.y(), this.viewport.width(), this.viewport.height());
        this.st.useProgram(gL2ES2, false);
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        this.viewport.set(n, n2, n3, n4);
        System.err.println("**** Reshape.Reset: " + n3 + "x" + n4);
        this.resetFBOs(gL2ES2, n3 / 2, n4);
        gL2ES2.glViewport(this.viewport.x(), this.viewport.y(), this.fboWidth, this.fboHeight);
        gL2ES2.glBindFramebuffer(36160, this.fboID);
        this.demo.reshape(gLAutoDrawable, n, n2, this.fboWidth, this.fboHeight);
        gL2ES2.glBindFramebuffer(36160, 0);
        gL2ES2.glViewport(this.viewport.x(), this.viewport.y(), this.viewport.width(), this.viewport.height());
        gL2ES2.setSwapInterval(this.swapInterval);
        this.pmvMatrix.glMatrixMode(5889);
        this.pmvMatrix.glLoadIdentity();
        this.pmvMatrix.glOrthof(-1.0f, 1.0f, -1.0f, 1.0f, 0.0f, 10.0f);
        this.pmvMatrix.glMatrixMode(5888);
        this.pmvMatrix.glLoadIdentity();
        this.st.useProgram(gL2ES2, true);
        this.st.uniform(gL2ES2, this.pmvMatrixUniform);
        this.st.useProgram(gL2ES2, false);
    }

    public static void main(String[] stringArray) {
        CommandlineOptions commandlineOptions = new CommandlineOptions(1280, 720, 0);
        System.err.println(commandlineOptions);
        System.err.println(VersionUtil.getPlatformInfo());
        GLCapabilities gLCapabilities = commandlineOptions.getGLCaps();
        System.out.println("Requested: " + gLCapabilities);
        GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)gLCapabilities);
        if (0 == commandlineOptions.sceneMSAASamples) {
            gLWindow.setCapabilitiesChooser((CapabilitiesChooser)new NonFSAAGLCapsChooser(false));
        }
        gLWindow.setSize(commandlineOptions.surface_width, commandlineOptions.surface_height);
        gLWindow.setTitle(GearsFBO01.class.getSimpleName());
        gLWindow.addGLEventListener((GLEventListener)new GearsFBO01(1));
        final Animator animator = new Animator(0);
        animator.setUpdateFPSFrames(300, null);
        animator.add((GLAutoDrawable)gLWindow);
        gLWindow.addWindowListener((WindowListener)new WindowAdapter(){

            public void windowDestroyed(WindowEvent windowEvent) {
                animator.stop();
            }
        });
        gLWindow.setVisible(true);
        animator.start();
    }
}

