/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.demos.es2;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.util.VersionUtil;
import com.jogamp.math.Matrix4f;
import com.jogamp.math.Quaternion;
import com.jogamp.math.Vec3f;
import com.jogamp.math.util.PMVMatrix4f;
import com.jogamp.math.util.SyncBuffer;
import com.jogamp.nativewindow.CapabilitiesChooser;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.GestureHandler;
import com.jogamp.newt.event.KeyAdapter;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.event.PinchToZoomGesture;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLUniformData;
import com.jogamp.opengl.JoglVersion;
import com.jogamp.opengl.demos.GearsObject;
import com.jogamp.opengl.demos.es2.GearsObjectES2;
import com.jogamp.opengl.demos.util.CommandlineOptions;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.PMVMatrix;
import com.jogamp.opengl.util.caps.NonFSAAGLCapsChooser;
import com.jogamp.opengl.util.glsl.ShaderCode;
import com.jogamp.opengl.util.glsl.ShaderProgram;
import com.jogamp.opengl.util.glsl.ShaderState;
import com.jogamp.opengl.util.stereo.EyeParameter;
import com.jogamp.opengl.util.stereo.StereoGLEventListener;
import com.jogamp.opengl.util.stereo.ViewerPose;
import java.nio.FloatBuffer;

public class GearsES2
implements StereoGLEventListener {
    private final FloatBuffer lightPos = Buffers.newDirectFloatBuffer((float[])new float[]{5.0f, 5.0f, 10.0f});
    private ShaderState st = null;
    private PMVMatrix pmvMatrix = null;
    private GLUniformData pmvMatrixUniform = null;
    private GLUniformData colorU = null;
    private volatile float view_rotx = 20.0f;
    private volatile float view_roty = 30.0f;
    private final float view_rotz = 0.0f;
    private float panX = 0.0f;
    private float panY = 0.0f;
    private float panZ = 0.0f;
    private float scalexyz = 1.0f;
    private volatile GearsObjectES2 gear1 = null;
    private volatile GearsObjectES2 gear2 = null;
    private volatile GearsObjectES2 gear3 = null;
    private boolean useMappedBuffers = false;
    private boolean validateBuffers = false;
    private float angle = 0.0f;
    private int swapInterval = 0;
    public MouseListener gearsMouse = new GearsMouseAdapter();
    public KeyListener gearsKeys = new GearsKeyAdapter();
    private boolean doRotate = true;
    private float[] clearColor = null;
    private boolean clearBuffers = true;
    private boolean clearStencilBuffer = false;
    private boolean verbose = true;
    private volatile boolean isInit = false;
    private PinchToZoomGesture pinchToZoomGesture = null;
    private static final int TIME_OUT = 2000;
    private static final int POLL_DIVIDER = 20;
    private static final int TIME_SLICE = 100;
    private final GestureHandler.GestureListener pinchToZoomListener = new GestureHandler.GestureListener(){

        public void gestureDetected(GestureHandler.GestureEvent gestureEvent) {
            PinchToZoomGesture.ZoomEvent zoomEvent = (PinchToZoomGesture.ZoomEvent)gestureEvent;
            float f = zoomEvent.getZoom();
            GearsES2.this.panZ = f * 30.0f - 30.0f;
        }
    };
    private float zNear = 5.0f;
    private float zFar = 10000.0f;
    private float zViewDist = 40.0f;
    private final Matrix4f mat4Tmp1 = new Matrix4f();
    private final Matrix4f mat4Tmp2 = new Matrix4f();
    private final Vec3f vec3Tmp1 = new Vec3f();
    private final Vec3f vec3Tmp2 = new Vec3f();
    private final Vec3f vec3Tmp3 = new Vec3f();
    private static final float scalePos = 20.0f;

    public GearsES2(int n) {
        this.swapInterval = n;
    }

    public GearsES2() {
        this.swapInterval = 1;
    }

    public void setDoRotation(boolean bl) {
        this.doRotate = bl;
    }

    public void setClearBuffers(boolean bl) {
        this.clearBuffers = bl;
    }

    public void setClearStencilBuffer(boolean bl) {
        this.clearStencilBuffer = bl;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void setClearColor(float[] fArray) {
        this.clearColor = fArray;
    }

    public void setGearsColor(int n, float f, float f2, float f3, float f4) {
        switch (n) {
            case -1: {
                this.gear1.setColor(f, f2, f3, f4);
                this.gear2.setColor(f, f2, f3, f4);
                this.gear3.setColor(f, f2, f3, f4);
                return;
            }
            case 0: {
                this.gear1.setColor(f, f2, f3, f4);
                return;
            }
            case 1: {
                this.gear2.setColor(f, f2, f3, f4);
                return;
            }
            case 2: {
                this.gear3.setColor(f, f2, f3, f4);
                return;
            }
        }
    }

    public void resetGearsColor() {
        this.gear1.setColor(GearsObject.red.get(0), GearsObject.red.get(1), GearsObject.red.get(2), GearsObject.red.get(3));
        this.gear2.setColor(GearsObject.green.get(0), GearsObject.green.get(1), GearsObject.green.get(2), GearsObject.green.get(3));
        this.gear3.setColor(GearsObject.blue.get(0), GearsObject.blue.get(1), GearsObject.blue.get(2), GearsObject.blue.get(3));
    }

    public float getScale() {
        return this.scalexyz;
    }

    public void setScale(float f) {
        this.scalexyz = f;
    }

    public float getRotX() {
        return this.view_rotx;
    }

    public float getRotY() {
        return this.view_roty;
    }

    public void setRotX(float f) {
        this.view_rotx = f;
    }

    public void setRotY(float f) {
        this.view_roty = f;
    }

    public void addPanning(float f, float f2, float f3) {
        this.panX += f;
        this.panY += f2;
        this.panZ += f3;
    }

    public GearsObjectES2 getGear1() {
        return this.gear1;
    }

    public GearsObjectES2 getGear2() {
        return this.gear2;
    }

    public GearsObjectES2 getGear3() {
        return this.gear3;
    }

    public void setUseMappedBuffers(boolean bl) {
        this.useMappedBuffers = bl;
    }

    public void setValidateBuffers(boolean bl) {
        this.validateBuffers = bl;
    }

    public PMVMatrix4f getPMVMatrix() {
        return this.pmvMatrix;
    }

    public boolean waitForInit(boolean bl) throws InterruptedException {
        int n;
        for (n = 0; n < 20 && bl != this.isInit; ++n) {
            Thread.sleep(100L);
        }
        return n < 20;
    }

    private final String sid() {
        return "0x" + Integer.toHexString(this.hashCode());
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        Object object;
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        if (this.verbose) {
            System.err.println(Thread.currentThread() + " GearsES2.init.0 " + this.sid() + ", " + this);
            System.err.println("GearsES2 init " + this.sid() + " on " + Thread.currentThread());
            System.err.println("Chosen GLCapabilities: " + gLAutoDrawable.getChosenGLCapabilities());
            System.err.println("INIT GL IS: " + gL2ES2.getClass().getName());
            System.err.println(JoglVersion.getGLStrings((GL)gL2ES2, null, (boolean)false).toString());
        }
        if (!gL2ES2.hasGLSL()) {
            System.err.println("No GLSL available, no rendering.");
            return;
        }
        this.st = new ShaderState();
        ShaderCode shaderCode = ShaderCode.create((GL2ES2)gL2ES2, (int)35633, this.getClass(), (String)"shader", (String)"shader/bin", (String)"gears", (boolean)true);
        ShaderCode shaderCode2 = ShaderCode.create((GL2ES2)gL2ES2, (int)35632, this.getClass(), (String)"shader", (String)"shader/bin", (String)"gears", (boolean)true);
        shaderCode.defaultShaderCustomization(gL2ES2, true, true);
        shaderCode2.defaultShaderCustomization(gL2ES2, true, true);
        ShaderProgram shaderProgram = new ShaderProgram();
        shaderProgram.add(gL2ES2, shaderCode, System.err);
        shaderProgram.add(gL2ES2, shaderCode2, System.err);
        this.st.attachShaderProgram(gL2ES2, shaderProgram, true);
        this.pmvMatrix = new PMVMatrix(6);
        this.st.attachObject("pmvMatrix", (Object)this.pmvMatrix);
        this.pmvMatrixUniform = new GLUniformData("pmvMatrix", 4, 4, (SyncBuffer)this.pmvMatrix.getSyncPMvMviMvit());
        this.st.ownUniform(this.pmvMatrixUniform);
        this.st.uniform(gL2ES2, this.pmvMatrixUniform);
        GLUniformData gLUniformData = new GLUniformData("lightPos", 3, this.lightPos);
        this.st.ownUniform(gLUniformData);
        this.st.uniform(gL2ES2, gLUniformData);
        this.colorU = new GLUniformData("color", 4, Buffers.newDirectFloatBuffer((int)4));
        this.st.ownUniform(this.colorU);
        this.st.uniform(gL2ES2, this.colorU);
        this.gear1 = new GearsObjectES2((GL)gL2ES2, this.useMappedBuffers, this.st, GearsObject.red, 1.0f, 4.0f, 1.0f, 20, 0.7f, this.pmvMatrix, this.pmvMatrixUniform, this.colorU, this.validateBuffers);
        if (this.verbose) {
            System.err.println("gear1 " + this.sid() + " created: " + this.gear1);
        }
        this.gear2 = new GearsObjectES2((GL)gL2ES2, this.useMappedBuffers, this.st, GearsObject.green, 0.5f, 2.0f, 2.0f, 10, 0.7f, this.pmvMatrix, this.pmvMatrixUniform, this.colorU, this.validateBuffers);
        if (this.verbose) {
            System.err.println("gear2 " + this.sid() + " created: " + this.gear2);
        }
        this.gear3 = new GearsObjectES2((GL)gL2ES2, this.useMappedBuffers, this.st, GearsObject.blue, 1.3f, 2.0f, 0.5f, 10, 0.7f, this.pmvMatrix, this.pmvMatrixUniform, this.colorU, this.validateBuffers);
        if (this.verbose) {
            System.err.println("gear3 " + this.sid() + " created: " + this.gear2);
        }
        if ((object = gLAutoDrawable.getUpstreamWidget()) instanceof Window) {
            Window window = (Window)object;
            window.addMouseListener(this.gearsMouse);
            window.addKeyListener(this.gearsKeys);
            window.addGestureListener(this.pinchToZoomListener);
            this.pinchToZoomGesture = new PinchToZoomGesture(gLAutoDrawable.getNativeSurface(), false);
            window.addGestureHandler((GestureHandler)this.pinchToZoomGesture);
        }
        this.st.useProgram(gL2ES2, false);
        gL2ES2.glFinish();
        this.isInit = true;
        if (this.verbose) {
            System.err.println(Thread.currentThread() + " GearsES2.init.X " + this.sid() + " FIN " + this);
        }
    }

    public final boolean isInit() {
        return this.isInit;
    }

    public void setZ(float f, float f2, float f3) {
        this.zNear = f;
        this.zFar = f2;
        this.zViewDist = f3;
    }

    public float getZNear() {
        return this.zNear;
    }

    public float getZFar() {
        return this.zFar;
    }

    public float getZViewDist() {
        return this.zViewDist;
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        float f;
        float f2;
        float f3;
        float f4;
        if (!this.isInit) {
            return;
        }
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        boolean bl = gL2ES2.getContext().getGLDrawable().getChosenGLCapabilities().getSampleBuffers();
        if (this.verbose) {
            System.err.println(Thread.currentThread() + " GearsES2.reshape " + this.sid() + " " + n + "/" + n2 + " " + n3 + "x" + n4 + ", swapInterval " + this.swapInterval + ", drawable 0x" + Long.toHexString(gL2ES2.getContext().getGLDrawable().getHandle()) + ", msaa " + bl);
        }
        gL2ES2.setSwapInterval(this.swapInterval);
        if (!gL2ES2.hasGLSL()) {
            return;
        }
        if (n4 > n3) {
            float f5 = (float)n4 / (float)n3;
            f4 = -1.0f;
            f3 = 1.0f;
            f2 = -f5;
            f = f5;
        } else {
            float f6 = (float)n3 / (float)n4;
            f4 = -f6;
            f3 = f6;
            f2 = -1.0f;
            f = 1.0f;
        }
        this.pmvMatrix.glMatrixMode(5889);
        this.pmvMatrix.glLoadIdentity();
        this.pmvMatrix.glFrustumf(f4, f3, f2, f, this.zNear, this.zFar);
        this.pmvMatrix.glMatrixMode(5888);
        this.pmvMatrix.glLoadIdentity();
        this.pmvMatrix.glTranslatef(0.0f, 0.0f, -this.zViewDist);
        this.st.useProgram(gL2ES2, true);
        this.st.uniform(gL2ES2, this.pmvMatrixUniform);
        this.st.useProgram(gL2ES2, false);
    }

    public void reshapeForEye(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4, EyeParameter eyeParameter, ViewerPose viewerPose) {
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        Matrix4f matrix4f = new Matrix4f();
        this.pmvMatrix.glMatrixMode(5889);
        matrix4f.setToPerspective(eyeParameter.fovhv, this.zNear, this.zFar);
        this.pmvMatrix.glLoadMatrixf(matrix4f);
        this.pmvMatrix.glMatrixMode(5888);
        Quaternion quaternion = new Quaternion();
        Vec3f vec3f = this.vec3Tmp1.set(viewerPose.position);
        vec3f.scale(20.0f);
        vec3f.add(eyeParameter.positionOffset);
        quaternion.mult(viewerPose.orientation);
        Vec3f vec3f2 = quaternion.rotateVector(Vec3f.UNIT_Y, this.vec3Tmp2);
        Vec3f vec3f3 = quaternion.rotateVector(Vec3f.UNIT_Z_NEG, this.vec3Tmp3);
        Vec3f vec3f4 = vec3f3.add(vec3f);
        Matrix4f matrix4f2 = this.mat4Tmp2.setToLookAt(vec3f, vec3f4, vec3f2, this.mat4Tmp1);
        matrix4f.mul(this.mat4Tmp1.setToTranslation(eyeParameter.distNoseToPupilX, eyeParameter.distMiddleToPupilY, eyeParameter.eyeReliefZ), matrix4f2);
        matrix4f.translate(0.0f, 0.0f, -this.zViewDist, this.mat4Tmp1);
        this.pmvMatrix.glLoadMatrixf(matrix4f);
        this.st.useProgram(gL2ES2, true);
        this.st.uniform(gL2ES2, this.pmvMatrixUniform);
        this.st.useProgram(gL2ES2, false);
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
        Window window;
        Object object;
        if (!this.isInit) {
            return;
        }
        this.isInit = false;
        if (this.verbose) {
            System.err.println(Thread.currentThread() + " GearsES2.dispose " + this.sid());
        }
        if ((object = gLAutoDrawable.getUpstreamWidget()) instanceof Window) {
            window = (Window)object;
            window.removeMouseListener(this.gearsMouse);
            window.removeKeyListener(this.gearsKeys);
            window.removeGestureHandler((GestureHandler)this.pinchToZoomGesture);
            this.pinchToZoomGesture = null;
            window.removeGestureListener(this.pinchToZoomListener);
        }
        if (!(window = gLAutoDrawable.getGL().getGL2ES2()).hasGLSL()) {
            return;
        }
        this.st.useProgram((GL2ES2)window, false);
        this.gear1.destroy((GL)window);
        this.gear1 = null;
        this.gear2.destroy((GL)window);
        this.gear2 = null;
        this.gear3.destroy((GL)window);
        this.gear3 = null;
        this.pmvMatrix = null;
        this.colorU = null;
        this.st.destroy((GL2ES2)window);
        this.st = null;
        if (this.verbose) {
            System.err.println(Thread.currentThread() + " GearsES2.dispose " + this.sid() + " FIN");
        }
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        this.display(gLAutoDrawable, 0);
    }

    public void display(GLAutoDrawable gLAutoDrawable, int n) {
        boolean bl;
        if (!this.isInit) {
            return;
        }
        boolean bl2 = 0 != (1 & n);
        boolean bl3 = bl = 0 != (2 & n);
        if (this.doRotate && !bl2) {
            this.angle += 0.5f;
        }
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        if (this.clearBuffers && !bl) {
            if (null != this.clearColor) {
                gL2ES2.glClearColor(this.clearColor[0], this.clearColor[1], this.clearColor[2], this.clearColor[3]);
            } else {
                gL2ES2.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            }
            if (this.clearStencilBuffer) {
                gL2ES2.glClear(17664);
            } else {
                gL2ES2.glClear(16640);
            }
        }
        if (!gL2ES2.hasGLSL()) {
            return;
        }
        this.setGLStatesImpl(gL2ES2, true);
        this.st.useProgram(gL2ES2, true);
        this.pmvMatrix.glPushMatrix();
        this.pmvMatrix.glTranslatef(this.panX, this.panY, this.panZ);
        this.pmvMatrix.glScalef(this.scalexyz, this.scalexyz, this.scalexyz);
        this.pmvMatrix.glRotatef(this.view_rotx, 1.0f, 0.0f, 0.0f);
        this.pmvMatrix.glRotatef(this.view_roty, 0.0f, 1.0f, 0.0f);
        this.pmvMatrix.glRotatef(0.0f, 0.0f, 0.0f, 1.0f);
        this.gear1.draw((GL)gL2ES2, -3.0f, -2.0f, 1.0f * this.angle - 0.0f);
        this.gear2.draw((GL)gL2ES2, 3.1f, -2.0f, -2.0f * this.angle - 9.0f);
        this.gear3.draw((GL)gL2ES2, -3.1f, 4.2f, -2.0f * this.angle - 25.0f);
        this.pmvMatrix.glPopMatrix();
        this.st.useProgram(gL2ES2, false);
        this.setGLStatesImpl(gL2ES2, false);
    }

    private void setGLStatesImpl(GL2ES2 gL2ES2, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = !gL2ES2.getContext().getGLDrawable().isGLOriented();
        if (bl) {
            gL2ES2.glEnable(2929);
            if (bl2) {
                gL2ES2.glEnable(2884);
            }
        } else {
            gL2ES2.glDisable(2929);
            if (bl2) {
                gL2ES2.glDisable(2884);
            }
        }
    }

    public String toString() {
        return "GearsES2[obj " + this.sid() + " isInit " + this.isInit + ", 1 " + this.gear1 + ", 2 " + this.gear2 + ", 3 " + this.gear3 + "]";
    }

    public KeyListener getKeyListener() {
        return this.gearsKeys;
    }

    public MouseListener getMouseListener() {
        return this.gearsMouse;
    }

    public static void main(String[] stringArray) {
        CommandlineOptions commandlineOptions = new CommandlineOptions(1280, 720, 0);
        System.err.println(commandlineOptions);
        System.err.println(VersionUtil.getPlatformInfo());
        GLCapabilities gLCapabilities = commandlineOptions.getGLCaps();
        System.out.println("Requested: " + gLCapabilities);
        GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)gLCapabilities);
        if (0 == commandlineOptions.sceneMSAASamples) {
            gLWindow.setCapabilitiesChooser((CapabilitiesChooser)new NonFSAAGLCapsChooser(false));
        }
        gLWindow.setSize(commandlineOptions.surface_width, commandlineOptions.surface_height);
        gLWindow.setTitle(GearsES2.class.getSimpleName());
        gLWindow.addGLEventListener((GLEventListener)new GearsES2(1));
        final Animator animator = new Animator(0);
        animator.setUpdateFPSFrames(300, null);
        animator.add((GLAutoDrawable)gLWindow);
        gLWindow.addWindowListener((WindowListener)new WindowAdapter(){

            public void windowDestroyed(WindowEvent windowEvent) {
                animator.stop();
            }
        });
        gLWindow.setVisible(true);
        animator.start();
    }

    class GearsMouseAdapter
    implements MouseListener {
        private int prevMouseX;
        private int prevMouseY;

        GearsMouseAdapter() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseWheelMoved(MouseEvent mouseEvent) {
            float[] fArray = mouseEvent.getRotation();
            if (mouseEvent.isControlDown()) {
                float f = mouseEvent.isShiftDown() ? fArray[0] : fArray[1] * 0.5f;
                GearsES2.this.panZ += f;
                System.err.println("panZ.2: incr " + f + ", dblZoom " + mouseEvent.isShiftDown() + " -> " + GearsES2.this.panZ);
            } else {
                GearsES2.this.panX -= fArray[0];
                GearsES2.this.panY += fArray[1];
                System.err.println("panXY.2: incr (" + fArray[0] + ", " + fArray[1] + ") -> (" + GearsES2.this.panX + ", " + GearsES2.this.panY + ")");
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getPointerCount() == 1) {
                this.prevMouseX = mouseEvent.getX();
                this.prevMouseY = mouseEvent.getY();
            } else if (mouseEvent.getPointerCount() == 4) {
                Object object = mouseEvent.getSource();
                if (mouseEvent.getPressure(0, true) > 0.7f && object instanceof Window) {
                    ((Window)object).setKeyboardVisible(true);
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (mouseEvent.isConfined()) {
                this.navigate(mouseEvent);
            } else {
                this.prevMouseX = mouseEvent.getX();
                this.prevMouseY = mouseEvent.getY();
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.navigate(mouseEvent);
        }

        private void navigate(MouseEvent mouseEvent) {
            int n;
            int n2;
            int n3 = mouseEvent.getX();
            int n4 = mouseEvent.getY();
            Object object = mouseEvent.getSource();
            Window window = null;
            if (object instanceof Window) {
                window = (Window)object;
                n2 = window.getSurfaceWidth();
                n = window.getSurfaceHeight();
            } else if (object instanceof GLAutoDrawable) {
                GLAutoDrawable gLAutoDrawable = (GLAutoDrawable)object;
                n2 = gLAutoDrawable.getSurfaceWidth();
                n = gLAutoDrawable.getSurfaceHeight();
            } else {
                throw new RuntimeException("Event source neither Window nor Component: " + object);
            }
            float f = 360.0f * ((float)(n3 - this.prevMouseX) / (float)n2);
            float f2 = 360.0f * ((float)(this.prevMouseY - n4) / (float)n);
            GearsES2.this.view_rotx += f2;
            GearsES2.this.view_roty += f;
            this.prevMouseX = n3;
            this.prevMouseY = n4;
        }
    }

    class GearsKeyAdapter
    extends KeyAdapter {
        GearsKeyAdapter() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            short s = keyEvent.getKeyCode();
            if (149 == s) {
                GearsES2.this.view_roty -= 1.0f;
            } else if (151 == s) {
                GearsES2.this.view_roty += 1.0f;
            } else if (150 == s) {
                GearsES2.this.view_rotx -= 1.0f;
            } else if (152 == s) {
                GearsES2.this.view_rotx += 1.0f;
            }
        }
    }
}

