/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.demos.av;

import com.jogamp.common.av.PTS;
import com.jogamp.common.net.Uri;
import com.jogamp.common.os.Clock;
import com.jogamp.common.util.InterruptSource;
import com.jogamp.graph.curve.Region;
import com.jogamp.graph.curve.opengl.GLRegion;
import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.font.FontScale;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.KeyAdapter;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MouseAdapter;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLAnimatorControl;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.GLRunnable;
import com.jogamp.opengl.JoglVersion;
import com.jogamp.opengl.demos.es2.TextureSequenceES2;
import com.jogamp.opengl.demos.graph.TextRendererGLELBase;
import com.jogamp.opengl.demos.util.MiscUtils;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.GLReadBufferUtil;
import com.jogamp.opengl.util.av.GLMediaPlayer;
import com.jogamp.opengl.util.av.GLMediaPlayerFactory;
import com.jogamp.opengl.util.texture.TextureSequence;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;

public class MovieSimple
implements GLEventListener {
    public static final int EFFECT_NORMAL = 0;
    public static final int EFFECT_GRADIENT_BOTTOM2TOP = 2;
    public static final int EFFECT_TRANSPARENT = 8;
    public static final String WINDOW_KEY = "window";
    public static final String PLAYER = "player";
    private static boolean waitForKey = false;
    private int surfWidth;
    private int surfHeight;
    private int prevMouseX;
    private boolean orthoProjection = true;
    private float zoom0;
    private float zoom1;
    private float zoom;
    private int effects = 0;
    private float alpha = 1.0f;
    private int swapInterval = 1;
    private boolean swapIntervalSet = true;
    private TextureSequenceES2 screen = null;
    private GLMediaPlayer mPlayer;
    private final boolean mPlayerShared;
    private boolean useOriginalScale;
    private volatile boolean resetGLState = false;
    private volatile GLAutoDrawable autoDrawable = null;
    public static final Uri defURI;
    private InfoTextRendererGLELBase textRendererGLEL = null;
    private boolean displayOSD = true;
    private final GLReadBufferUtil screenshot;
    private int screenshot_num = 0;
    private final MouseListener mouseAction = new MouseAdapter(){

        public void mouseClicked(MouseEvent mouseEvent) {
            if (null != MovieSimple.this.autoDrawable && mouseEvent.getClickCount() == 3) {
                MiscUtils.destroyWindow(MovieSimple.this.autoDrawable);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getY() <= MovieSimple.this.surfHeight / 2 && null != MovieSimple.this.mPlayer && 1 == mouseEvent.getClickCount()) {
                if (GLMediaPlayer.State.Playing == MovieSimple.this.mPlayer.getState()) {
                    MovieSimple.this.mPlayer.pause(false);
                } else {
                    MovieSimple.this.mPlayer.resume();
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.getY() <= MovieSimple.this.surfHeight / 2) {
                MovieSimple.this.zoom = MovieSimple.this.zoom0;
                if (null != MovieSimple.this.screen) {
                    MovieSimple.this.screen.setZoom(MovieSimple.this.zoom);
                    MovieSimple.this.screen.setZRotation(-1.0f);
                }
                System.err.println("zoom: " + MovieSimple.this.zoom);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            MovieSimple.this.prevMouseX = mouseEvent.getX();
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (n2 > MovieSimple.this.surfHeight / 2) {
                float f = (float)(n - MovieSimple.this.prevMouseX) / (float)MovieSimple.this.surfWidth;
                int n3 = MovieSimple.this.mPlayer.getPTS().getCurrent();
                MovieSimple.this.mPlayer.seek(n3 + (int)((float)MovieSimple.this.mPlayer.getDuration() * f));
            } else {
                MovieSimple.this.mPlayer.resume();
                MovieSimple.this.zoom = MovieSimple.this.zoom1;
                if (null != MovieSimple.this.screen) {
                    MovieSimple.this.screen.setZoom(MovieSimple.this.zoom);
                    MovieSimple.this.screen.setZRotation(1.0f);
                }
            }
            MovieSimple.this.prevMouseX = n;
        }

        public void mouseWheelMoved(MouseEvent mouseEvent) {
            if (!mouseEvent.isShiftDown()) {
                MovieSimple.this.zoom += mouseEvent.getRotation()[1] / 10.0f;
                if (null != MovieSimple.this.screen) {
                    MovieSimple.this.screen.setZoom(MovieSimple.this.zoom);
                }
                System.err.println("zoom: " + MovieSimple.this.zoom);
            }
        }
    };
    private final KeyListener keyAction = new KeyAdapter(){

        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.isAutoRepeat()) {
                return;
            }
            System.err.println("MC " + keyEvent);
            int n = MovieSimple.this.mPlayer.getPTS().getCurrent();
            int n2 = 0;
            switch (keyEvent.getKeySymbol()) {
                case 86: {
                    switch (MovieSimple.this.swapInterval) {
                        case 0: {
                            MovieSimple.this.swapInterval = -1;
                            break;
                        }
                        case -1: {
                            MovieSimple.this.swapInterval = 1;
                            break;
                        }
                        case 1: {
                            MovieSimple.this.swapInterval = 0;
                            break;
                        }
                        default: {
                            MovieSimple.this.swapInterval = 1;
                        }
                    }
                    MovieSimple.this.swapIntervalSet = true;
                    break;
                }
                case 79: {
                    MovieSimple.this.displayOSD = !MovieSimple.this.displayOSD;
                    break;
                }
                case 151: {
                    n2 = n + 1000;
                    break;
                }
                case 150: {
                    n2 = n + 10000;
                    break;
                }
                case 16: {
                    n2 = n + 30000;
                    break;
                }
                case 149: {
                    n2 = n - 1000;
                    break;
                }
                case 152: {
                    n2 = n - 10000;
                    break;
                }
                case 11: {
                    n2 = n - 30000;
                    break;
                }
                case 2: 
                case 8: {
                    System.err.println("Seek: " + n + " -> 0");
                    MovieSimple.this.mPlayer.seek(0);
                    break;
                }
                case 32: {
                    if (GLMediaPlayer.State.Paused == MovieSimple.this.mPlayer.getState()) {
                        MovieSimple.this.mPlayer.resume();
                        break;
                    }
                    if (GLMediaPlayer.State.Uninitialized == MovieSimple.this.mPlayer.getState()) {
                        MovieSimple.this.playStream(MovieSimple.this.mPlayer.getUri(), -1, -1, 3);
                        break;
                    }
                    if (keyEvent.isShiftDown()) {
                        MovieSimple.this.mPlayer.stop();
                        break;
                    }
                    MovieSimple.this.mPlayer.pause(false);
                    break;
                }
                case 141: {
                    MovieSimple.this.mPlayer.setPlaySpeed(1.0f);
                    break;
                }
                case 140: {
                    float f = MovieSimple.this.mPlayer.getPlaySpeed();
                    f = keyEvent.isShiftDown() ? (f /= 2.0f) : (f -= 0.1f);
                    MovieSimple.this.mPlayer.setPlaySpeed(f);
                    break;
                }
                case 139: {
                    float f = MovieSimple.this.mPlayer.getPlaySpeed();
                    f = keyEvent.isShiftDown() ? (f *= 2.0f) : (f += 0.1f);
                    MovieSimple.this.mPlayer.setPlaySpeed(f);
                    break;
                }
                case 77: {
                    float f = MovieSimple.this.mPlayer.getAudioVolume();
                    f = f > 0.5f ? 0.0f : 1.0f;
                    MovieSimple.this.mPlayer.setAudioVolume(f);
                    break;
                }
                case 83: {
                    if (null == MovieSimple.this.autoDrawable) break;
                    MovieSimple.this.printScreenOnGLThread(MovieSimple.this.autoDrawable);
                    break;
                }
                case 27: 
                case 81: 
                case 100: {
                    if (null == MovieSimple.this.autoDrawable) break;
                    MiscUtils.destroyWindow(MovieSimple.this.autoDrawable);
                }
            }
            if (0 != n2) {
                System.err.println("Seek: " + n + " -> " + n2);
                MovieSimple.this.mPlayer.seek(n2);
            }
        }
    };
    long lastPerfPos = 0L;
    public static final MyGLMediaEventListener myGLMediaEventListener;
    static boolean loopEOS;
    static boolean origSize;

    public void printScreen(GLAutoDrawable gLAutoDrawable) throws GLException, IOException {
        String string = String.format("MovieSimple-snap%02d-%03dx%03d.png", this.screenshot_num++, gLAutoDrawable.getSurfaceWidth(), gLAutoDrawable.getSurfaceHeight());
        if (this.screenshot.readPixels(gLAutoDrawable.getGL(), false)) {
            this.screenshot.write(new File(string.toString()));
        }
    }

    public void printScreenOnGLThread(GLAutoDrawable gLAutoDrawable) {
        gLAutoDrawable.invoke(false, new GLRunnable(){

            public boolean run(GLAutoDrawable gLAutoDrawable) {
                try {
                    MovieSimple.this.printScreen(gLAutoDrawable);
                }
                catch (GLException gLException) {
                    gLException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return true;
            }
        });
    }

    public MovieSimple() {
        this(null);
        this.mPlayer.addEventListener(new GLMediaPlayer.GLMediaEventListener(){

            public void attributesChanged(GLMediaPlayer gLMediaPlayer, GLMediaPlayer.EventMask eventMask, long l) {
                System.err.println("MovieSimple.0 AttributesChanges: " + eventMask + ", when " + l);
                System.err.println("MovieSimple.0 State: " + gLMediaPlayer);
                if (eventMask.isSet(GLMediaPlayer.EventMask.Bit.EOS)) {
                    new InterruptSource.Thread(){

                        public void run() {
                            MovieSimple.this.mPlayer.seek(0);
                            MovieSimple.this.mPlayer.resume();
                        }
                    }.start();
                }
            }
        });
        this.playStream(defURI, -1, -1, 3);
    }

    public MovieSimple(GLMediaPlayer gLMediaPlayer) throws IllegalStateException {
        this.screenshot = new GLReadBufferUtil(false, false);
        this.mPlayer = gLMediaPlayer;
        this.mPlayerShared = null != this.mPlayer;
        this.useOriginalScale = false;
        if (!this.mPlayerShared) {
            this.mPlayer = GLMediaPlayerFactory.createDefault();
            this.mPlayer.attachObject(PLAYER, (Object)this);
        }
        System.out.println("pC.1a shared " + this.mPlayerShared + ", " + this.mPlayer);
    }

    public void playStream(Uri uri, int n, int n2, int n3) {
        this.mPlayer.playStream(uri, n, n2, -2, n3);
        System.out.println("pC.1b " + this.mPlayer);
    }

    public void setSwapInterval(int n) {
        this.swapInterval = n;
    }

    public void setUseOriginalScale(boolean bl) {
        this.useOriginalScale = bl;
    }

    public GLMediaPlayer getGLMediaPlayer() {
        return this.mPlayer;
    }

    public void setOrthoProjection(boolean bl) {
        this.orthoProjection = bl;
    }

    public boolean getOrthoProjection() {
        return this.orthoProjection;
    }

    public void setEffects(int n) {
        this.effects = n;
    }

    public void setTransparency(float f) {
        this.alpha = f;
    }

    public void resetGLState() {
        this.resetGLState = true;
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        if (null == this.mPlayer) {
            throw new InternalError("mPlayer null");
        }
        this.resetGLState = false;
        this.zoom0 = this.orthoProjection ? 0.0f : -2.5f;
        this.zoom1 = this.orthoProjection ? 0.0f : -5.0f;
        this.zoom = this.zoom0;
        this.autoDrawable = gLAutoDrawable;
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        System.err.println(JoglVersion.getGLInfo((GL)gL2ES2, null));
        System.err.println("Alpha: " + this.alpha + ", opaque " + gLAutoDrawable.getChosenGLCapabilities().isBackgroundOpaque() + ", " + gLAutoDrawable.getClass().getName() + ", " + gLAutoDrawable);
        this.screen = new TextureSequenceES2((TextureSequence)this.mPlayer, this.mPlayerShared, this.orthoProjection, this.zoom);
        this.screen.setEffects(this.effects);
        this.screen.setTransparency(this.alpha);
        this.screen.setUseOriginalScale(this.useOriginalScale);
        if (waitForKey) {
            MiscUtils.waitForKey("Init>");
        }
        try {
            this.mPlayer.initGL((GL)gL2ES2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (null != this.mPlayer) {
                this.mPlayer.destroy((GL)gL2ES2);
                this.mPlayer = null;
            }
            throw new GLException((Throwable)exception);
        }
        this.screen.init(gLAutoDrawable);
        Object object = gLAutoDrawable.getUpstreamWidget();
        if (object instanceof Window) {
            Window window = (Window)object;
            window.addMouseListener(this.mouseAction);
            window.addKeyListener(this.keyAction);
            this.surfWidth = window.getSurfaceWidth();
            this.surfHeight = window.getSurfaceHeight();
        }
        int n = gLAutoDrawable.getChosenGLCapabilities().getSampleBuffers() ? 0 : 2;
        this.textRendererGLEL = new InfoTextRendererGLELBase(gL2ES2.getGLProfile(), n);
        gLAutoDrawable.addGLEventListener((GLEventListener)this.textRendererGLEL);
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        if (null == this.mPlayer) {
            return;
        }
        this.screen.reshape(gLAutoDrawable, n, n2, n3, n4);
        this.surfWidth = n3;
        this.surfHeight = n4;
        System.out.println("pR " + this.mPlayer);
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
        this.autoDrawable = null;
        this.screenshot.dispose(gLAutoDrawable.getGL());
        this.disposeImpl(gLAutoDrawable, true);
    }

    private void disposeImpl(GLAutoDrawable gLAutoDrawable, boolean bl) {
        Window window;
        if (null == this.mPlayer) {
            return;
        }
        Object object = gLAutoDrawable.getUpstreamWidget();
        if (object instanceof Window) {
            window = (Window)object;
            window.removeMouseListener(this.mouseAction);
            window.removeKeyListener(this.keyAction);
        }
        System.out.println("pD.1 " + this.mPlayer + ", disposePlayer " + bl);
        window = gLAutoDrawable.getGL().getGL2ES2();
        if (null != this.textRendererGLEL) {
            gLAutoDrawable.disposeGLEventListener((GLEventListener)this.textRendererGLEL, true);
            this.textRendererGLEL = null;
        }
        if (bl) {
            if (!this.mPlayerShared) {
                this.mPlayer.destroy((GL)window);
            }
            System.out.println("pD.X " + this.mPlayer);
            this.mPlayer = null;
        }
        this.screen.dispose(gLAutoDrawable);
        this.screen = null;
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        long l;
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        if (this.swapIntervalSet) {
            int n = this.swapInterval;
            gL2ES2.setSwapInterval(n);
            if (null != gLAutoDrawable.getAnimator()) {
                gLAutoDrawable.getAnimator().resetFPSCounter();
            }
            this.swapInterval = gL2ES2.getSwapInterval();
            System.err.println("Swap Interval: " + n + " -> " + this.swapInterval);
            this.swapIntervalSet = false;
        }
        if (null == this.mPlayer) {
            return;
        }
        if (this.resetGLState) {
            this.resetGLState = false;
            System.err.println("XXX resetGLState");
            this.disposeImpl(gLAutoDrawable, false);
            this.init(gLAutoDrawable);
            this.reshape(gLAutoDrawable, 0, 0, gLAutoDrawable.getSurfaceWidth(), gLAutoDrawable.getSurfaceHeight());
        }
        if ((l = System.currentTimeMillis()) - this.lastPerfPos > 2000L) {
            this.lastPerfPos = l;
        }
        this.screen.display(gLAutoDrawable);
    }

    public static void main(String[] stringArray) throws IOException, URISyntaxException {
        int n;
        int n2 = 1;
        float f = 1.0f;
        int n3 = 800;
        int n4 = 600;
        int n5 = 3;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        int n6 = -1;
        int n7 = -1;
        float f2 = 1.0f;
        int n8 = 0;
        for (n = 0; n < stringArray.length; ++n) {
            if (!stringArray[n].equals("-url")) continue;
            ++n;
            ++n8;
        }
        int n9 = Math.max(1, n8);
        String[] stringArray2 = new String[n9];
        n = 0;
        int n10 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-vid")) {
                n6 = MiscUtils.atoi(stringArray[++i], n6);
                continue;
            }
            if (stringArray[i].equals("-aid")) {
                n7 = MiscUtils.atoi(stringArray[++i], n7);
                continue;
            }
            if (stringArray[i].equals("-width")) {
                n3 = MiscUtils.atoi(stringArray[++i], n3);
                continue;
            }
            if (stringArray[i].equals("-height")) {
                n4 = MiscUtils.atoi(stringArray[++i], n4);
                continue;
            }
            if (stringArray[i].equals("-osize")) {
                n = 1;
                continue;
            }
            if (stringArray[i].equals("-textureCount")) {
                n5 = MiscUtils.atoi(stringArray[++i], n5);
                continue;
            }
            if (stringArray[i].equals("-es2")) {
                bl3 = true;
                continue;
            }
            if (stringArray[i].equals("-es3")) {
                bl4 = true;
                continue;
            }
            if (stringArray[i].equals("-gl3")) {
                bl5 = true;
                continue;
            }
            if (stringArray[i].equals("-gldef")) {
                bl6 = true;
                continue;
            }
            if (stringArray[i].equals("-vsync")) {
                n2 = MiscUtils.atoi(stringArray[++i], n2);
                continue;
            }
            if (stringArray[i].equals("-speed")) {
                f = MiscUtils.atof(stringArray[++i], f);
                continue;
            }
            if (stringArray[i].equals("-mute")) {
                f2 = 0.0f;
                continue;
            }
            if (stringArray[i].equals("-projection")) {
                bl = false;
                continue;
            }
            if (stringArray[i].equals("-orig_scale")) {
                bl2 = true;
                continue;
            }
            if (stringArray[i].equals("-loop")) {
                loopEOS = true;
                continue;
            }
            if (stringArray[i].equals("-url")) {
                stringArray2[n10++] = stringArray[++i];
                continue;
            }
            if (!stringArray[i].equals("-wait")) continue;
            waitForKey = true;
        }
        origSize = n;
        Uri uri = null;
        if (null != stringArray2[0]) {
            uri = Uri.tryUriOrFile((String)stringArray2[0]);
        }
        if (null == uri) {
            uri = defURI;
        }
        System.err.println("url_s " + stringArray2[0]);
        System.err.println("stream0 " + uri);
        System.err.println("vid " + n6 + ", aid " + n7);
        System.err.println("textureCount " + n5);
        System.err.println("forceES2   " + bl3);
        System.err.println("forceES3   " + bl4);
        System.err.println("forceGL3   " + bl5);
        System.err.println("forceGLDef " + bl6);
        System.err.println("swapInterval " + n2);
        System.err.println("playSpeed " + f);
        System.err.println("audioVolume " + f2);
        GLProfile gLProfile = bl6 ? GLProfile.getDefault() : (bl5 ? GLProfile.get((String)"GL3") : (bl4 ? GLProfile.get((String)"GLES3") : (bl3 ? GLProfile.get((String)"GLES2") : GLProfile.getGL2ES2())));
        System.err.println("GLProfile: " + gLProfile);
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        MovieSimple[] movieSimpleArray = new MovieSimple[n9];
        GLWindow[] gLWindowArray = new GLWindow[n9];
        for (int i = 0; i < n9; ++i) {
            final Animator animator = new Animator(0);
            animator.start();
            gLWindowArray[i] = GLWindow.create((GLCapabilitiesImmutable)gLCapabilities);
            gLWindowArray[i].addWindowListener((WindowListener)new WindowAdapter(){

                public void windowDestroyed(WindowEvent windowEvent) {
                    animator.stop();
                }
            });
            movieSimpleArray[i] = new MovieSimple(null);
            movieSimpleArray[i].setSwapInterval(n2);
            movieSimpleArray[i].setUseOriginalScale(bl2);
            movieSimpleArray[i].setOrthoProjection(bl);
            movieSimpleArray[i].mPlayer.setPlaySpeed(f);
            movieSimpleArray[i].mPlayer.setAudioVolume(f2);
            movieSimpleArray[i].mPlayer.attachObject(WINDOW_KEY, (Object)gLWindowArray[i]);
            movieSimpleArray[i].mPlayer.addEventListener((GLMediaPlayer.GLMediaEventListener)myGLMediaEventListener);
            animator.add((GLAutoDrawable)gLWindowArray[i]);
            gLWindowArray[i].addGLEventListener((GLEventListener)movieSimpleArray[i]);
            gLWindowArray[i].setTitle("Player " + i);
            gLWindowArray[i].setSize(n3, n4);
            gLWindowArray[i].setVisible(true);
            Uri uri2 = null;
            if (0 == i) {
                uri2 = uri;
            } else {
                if (null != stringArray2[i]) {
                    uri2 = Uri.tryUriOrFile((String)stringArray2[i]);
                }
                if (null == uri2) {
                    uri2 = defURI;
                }
            }
            System.err.println("Win #" + i + ": stream " + uri2);
            movieSimpleArray[i].playStream(uri2, n6, n7, n5);
        }
    }

    static {
        Uri uri = null;
        try {
            uri = Uri.cast((String)"http://archive.org/download/BigBuckBunny_328/BigBuckBunny_512kb.mp4");
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        defURI = uri;
        myGLMediaEventListener = new MyGLMediaEventListener();
        loopEOS = false;
    }

    private final class InfoTextRendererGLELBase
    extends TextRendererGLELBase {
        private final Font font;
        private final float fontSize = 10.0f;
        private final GLRegion regionFPS;
        String text1_old;

        InfoTextRendererGLELBase(GLProfile gLProfile, int n) {
            super(n, 4);
            this.font = InfoTextRendererGLELBase.getFont(0, 0, 0);
            this.fontSize = 10.0f;
            this.text1_old = null;
            this.setRendererCallbacks(RegionRenderer.defaultBlendEnable, RegionRenderer.defaultBlendDisable);
            this.regionFPS = GLRegion.create((GLProfile)gLProfile, (int)this.renderModes, null, (int)0, (int)0);
            System.err.println("RegionFPS " + Region.getRenderModeString((int)this.renderModes) + ", sampleCount " + 4 + ", class " + this.regionFPS.getClass().getName());
            this.staticRGBAColor[0] = 0.9f;
            this.staticRGBAColor[1] = 0.9f;
            this.staticRGBAColor[2] = 0.9f;
            this.staticRGBAColor[3] = 1.0f;
        }

        @Override
        public void init(GLAutoDrawable gLAutoDrawable) {
            super.init(gLAutoDrawable);
        }

        @Override
        public void dispose(GLAutoDrawable gLAutoDrawable) {
            if (null != this.regionFPS) {
                this.regionFPS.destroy(gLAutoDrawable.getGL().getGL2ES2());
            }
            super.dispose(gLAutoDrawable);
        }

        @Override
        public void display(GLAutoDrawable gLAutoDrawable) {
            GLAnimatorControl gLAnimatorControl = gLAutoDrawable.getAnimator();
            float f = null != gLAnimatorControl ? gLAnimatorControl.getLastFPS() : 0.0f;
            float f2 = null != gLAnimatorControl ? gLAnimatorControl.getTotalFPS() : 0.0f;
            long l = Clock.currentMillis();
            PTS pTS = MovieSimple.this.mPlayer.getPTS();
            float f3 = (float)pTS.get(l) / 1000.0f;
            float f4 = (float)l / 1000.0f;
            int n = gLAutoDrawable.getSurfaceHeight();
            float f5 = (float)MovieSimple.this.mPlayer.getWidth() / (float)MovieSimple.this.mPlayer.getHeight();
            String string = null != this.regionFPS ? "3.1" : "3.0";
            String string2 = String.format("%0" + string + "f/%0" + string + "f/%0" + string + "f s, %s (%01.2fx, vol %01.2f), a %01.2f, fps %02.1f -> %02.1f / %02.1f, swap %d", Float.valueOf(f4), Float.valueOf(f3), Float.valueOf((float)MovieSimple.this.mPlayer.getDuration() / 1000.0f), MovieSimple.this.mPlayer.getState().toString().toLowerCase(), Float.valueOf(MovieSimple.this.mPlayer.getPlaySpeed()), Float.valueOf(MovieSimple.this.mPlayer.getAudioVolume()), Float.valueOf(f5), Float.valueOf(MovieSimple.this.mPlayer.getFramerate()), Float.valueOf(f), Float.valueOf(f2), gLAutoDrawable.getGL().getSwapInterval());
            String string3 = String.format("audio: id %d, kbps %d, codec %s", MovieSimple.this.mPlayer.getAID(), MovieSimple.this.mPlayer.getAudioBitrate() / 1000, MovieSimple.this.mPlayer.getAudioCodec());
            String string4 = String.format("video: id %d, kbps %d, codec %s", MovieSimple.this.mPlayer.getVID(), MovieSimple.this.mPlayer.getVideoBitrate() / 1000, MovieSimple.this.mPlayer.getVideoCodec());
            String string5 = ((MovieSimple)MovieSimple.this).mPlayer.getUri().path.decode();
            if (MovieSimple.this.displayOSD && null != this.renderer) {
                float f6 = FontScale.toPixels((float)10.0f, (float)this.dpiH);
                GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
                if (!string2.equals(this.text1_old)) {
                    this.renderString(gLAutoDrawable, this.font, f6, (CharSequence)string2, 1, 1, 0.0f, 0.0f, -1.0f, this.regionFPS.clear(gL2ES2));
                    this.text1_old = string2;
                } else {
                    this.renderRegion(gLAutoDrawable, this.font, f6, 1, 1, 0.0f, 0.0f, -1.0f, this.regionFPS);
                }
                this.renderString(gLAutoDrawable, this.font, f6, (CharSequence)string3, 1, -4, 0.0f, (float)n, -1.0f, true);
                this.renderString(gLAutoDrawable, this.font, f6, (CharSequence)string4, 1, -3, 0.0f, (float)n, -1.0f, true);
                this.renderString(gLAutoDrawable, this.font, f6, (CharSequence)string5, 1, -2, 0.0f, (float)n, -1.0f, true);
            }
        }
    }

    static class MyGLMediaEventListener
    implements GLMediaPlayer.GLMediaEventListener {
        MyGLMediaEventListener() {
        }

        void destroyWindow(Window window) {
            new InterruptSource.Thread(() -> window.destroy()).start();
        }

        public void attributesChanged(final GLMediaPlayer gLMediaPlayer, GLMediaPlayer.EventMask eventMask, long l) {
            System.err.println("MovieSimple.1 AttributesChanges: " + eventMask + ", when " + l);
            System.err.println("MovieSimple.1 State: " + gLMediaPlayer);
            GLWindow gLWindow = (GLWindow)gLMediaPlayer.getAttachedObject(MovieSimple.WINDOW_KEY);
            MovieSimple movieSimple = (MovieSimple)gLMediaPlayer.getAttachedObject(MovieSimple.PLAYER);
            if (eventMask.isSet(GLMediaPlayer.EventMask.Bit.Size) && origSize) {
                gLWindow.setSurfaceSize(gLMediaPlayer.getWidth(), gLMediaPlayer.getHeight());
            }
            if (eventMask.isSet(GLMediaPlayer.EventMask.Bit.Init)) {
                GLAnimatorControl gLAnimatorControl = gLWindow.getAnimator();
                gLAnimatorControl.setUpdateFPSFrames(60, null);
                gLAnimatorControl.resetFPSCounter();
                movieSimple.resetGLState();
            } else if (eventMask.isSet(GLMediaPlayer.EventMask.Bit.Play)) {
                gLWindow.getAnimator().resetFPSCounter();
            }
            boolean bl = false;
            GLMediaPlayer.StreamException streamException = null;
            if (eventMask.isSet(GLMediaPlayer.EventMask.Bit.EOS)) {
                streamException = movieSimple.mPlayer.getStreamException();
                if (null != streamException) {
                    System.err.println("MovieSimple State: Exception");
                    bl = true;
                } else if (loopEOS) {
                    new InterruptSource.Thread(){

                        public void run() {
                            gLMediaPlayer.setPlaySpeed(1.0f);
                            gLMediaPlayer.seek(0);
                            gLMediaPlayer.resume();
                        }
                    }.start();
                } else {
                    bl = true;
                }
            }
            if (eventMask.isSet(GLMediaPlayer.EventMask.Bit.Error)) {
                streamException = movieSimple.mPlayer.getStreamException();
                if (null != streamException) {
                    System.err.println("MovieSimple State: Exception");
                }
                bl = true;
            }
            if (bl) {
                if (null != streamException) {
                    streamException.printStackTrace();
                }
                this.destroyWindow((Window)gLWindow);
            }
        }
    }
}

