/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.demos.av;

import com.jogamp.common.net.Uri;
import com.jogamp.common.util.InterruptSource;
import com.jogamp.graph.curve.Region;
import com.jogamp.graph.curve.opengl.GLRegion;
import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.font.FontScale;
import com.jogamp.math.util.PMVMatrix4f;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.KeyAdapter;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLAnimatorControl;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.GLRunnable;
import com.jogamp.opengl.JoglVersion;
import com.jogamp.opengl.demos.es2.TextureSequenceCubeES2;
import com.jogamp.opengl.demos.graph.TextRendererGLELBase;
import com.jogamp.opengl.demos.util.MiscUtils;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.GLReadBufferUtil;
import com.jogamp.opengl.util.av.GLMediaPlayer;
import com.jogamp.opengl.util.av.GLMediaPlayerFactory;
import com.jogamp.opengl.util.texture.TextureSequence;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;

public class MovieCube
implements GLEventListener {
    public static final float zoom_def = -2.77f;
    private static boolean waitForKey = false;
    private final float zoom0;
    private final float rotx;
    private final float roty;
    private TextureSequenceCubeES2 cube = null;
    private GLMediaPlayer mPlayer = null;
    private int swapInterval = 1;
    private boolean swapIntervalSet = true;
    private long lastPerfPos = 0L;
    private volatile boolean resetGLState = false;
    private volatile GLAutoDrawable autoDrawable = null;
    public static final Uri defURI;
    private InfoTextRendererGLELBase textRendererGLEL = null;
    final boolean showText;
    private boolean displayOSD = true;
    private final GLReadBufferUtil screenshot;
    private int screenshot_num = 0;
    private final KeyListener keyAction = new KeyAdapter(){

        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.isAutoRepeat()) {
                return;
            }
            System.err.println("MC " + keyEvent);
            int n = MovieCube.this.mPlayer.getPTS().getCurrent();
            int n2 = 0;
            switch (keyEvent.getKeySymbol()) {
                case 86: {
                    switch (MovieCube.this.swapInterval) {
                        case 0: {
                            MovieCube.this.swapInterval = -1;
                            break;
                        }
                        case -1: {
                            MovieCube.this.swapInterval = 1;
                            break;
                        }
                        case 1: {
                            MovieCube.this.swapInterval = 0;
                            break;
                        }
                        default: {
                            MovieCube.this.swapInterval = 1;
                        }
                    }
                    MovieCube.this.swapIntervalSet = true;
                    break;
                }
                case 79: {
                    MovieCube.this.displayOSD = !MovieCube.this.displayOSD;
                    break;
                }
                case 151: {
                    n2 = n + 1000;
                    break;
                }
                case 150: {
                    n2 = n + 10000;
                    break;
                }
                case 16: {
                    n2 = n + 30000;
                    break;
                }
                case 149: {
                    n2 = n - 1000;
                    break;
                }
                case 152: {
                    n2 = n - 10000;
                    break;
                }
                case 11: {
                    n2 = n - 30000;
                    break;
                }
                case 2: 
                case 8: {
                    MovieCube.this.mPlayer.seek(0);
                    break;
                }
                case 32: {
                    if (GLMediaPlayer.State.Paused == MovieCube.this.mPlayer.getState()) {
                        MovieCube.this.mPlayer.resume();
                        break;
                    }
                    if (GLMediaPlayer.State.Uninitialized == MovieCube.this.mPlayer.getState()) {
                        MovieCube.this.playStream(MovieCube.this.mPlayer.getUri(), -1, -1, 3);
                        break;
                    }
                    if (keyEvent.isShiftDown()) {
                        MovieCube.this.mPlayer.stop();
                        break;
                    }
                    MovieCube.this.mPlayer.pause(false);
                    break;
                }
                case 141: {
                    MovieCube.this.mPlayer.setPlaySpeed(1.0f);
                    break;
                }
                case 140: {
                    float f = MovieCube.this.mPlayer.getPlaySpeed();
                    f = keyEvent.isShiftDown() ? (f /= 2.0f) : (f -= 0.1f);
                    MovieCube.this.mPlayer.setPlaySpeed(f);
                    break;
                }
                case 139: {
                    float f = MovieCube.this.mPlayer.getPlaySpeed();
                    f = keyEvent.isShiftDown() ? (f *= 2.0f) : (f += 0.1f);
                    MovieCube.this.mPlayer.setPlaySpeed(f);
                    break;
                }
                case 77: {
                    float f = MovieCube.this.mPlayer.getAudioVolume();
                    f = f > 0.5f ? 0.0f : 1.0f;
                    MovieCube.this.mPlayer.setAudioVolume(f);
                    break;
                }
                case 83: {
                    if (null == MovieCube.this.autoDrawable) break;
                    MovieCube.this.printScreenOnGLThread(MovieCube.this.autoDrawable);
                    break;
                }
                case 27: 
                case 81: 
                case 100: {
                    if (null == MovieCube.this.autoDrawable) break;
                    MiscUtils.destroyWindow(MovieCube.this.autoDrawable);
                }
            }
            if (0 != n2) {
                MovieCube.this.mPlayer.seek(n2);
            }
        }
    };

    public MovieCube() throws IOException, URISyntaxException {
        this(-2.77f, 0.0f, 0.0f, true);
        this.mPlayer.addEventListener(new GLMediaPlayer.GLMediaEventListener(){

            public void attributesChanged(GLMediaPlayer gLMediaPlayer, GLMediaPlayer.EventMask eventMask, long l) {
                System.err.println("MovieCube.0 AttributesChanges: " + eventMask + ", when " + l);
                System.err.println("MovieCube.0 State: " + gLMediaPlayer);
                if (eventMask.isSet(GLMediaPlayer.EventMask.Bit.Size)) {
                    MovieCube.this.resetGLState();
                }
                if (eventMask.isSet(GLMediaPlayer.EventMask.Bit.EOS)) {
                    new InterruptSource.Thread(){

                        public void run() {
                            MovieCube.this.mPlayer.seek(0);
                            MovieCube.this.mPlayer.resume();
                        }
                    }.start();
                }
            }
        });
        this.playStream(defURI, -1, -1, 3);
    }

    public MovieCube(float f, float f2, float f3, boolean bl) throws IOException {
        this.zoom0 = f;
        this.rotx = f2;
        this.roty = f3;
        this.showText = bl;
        this.screenshot = new GLReadBufferUtil(false, false);
        this.mPlayer = GLMediaPlayerFactory.createDefault();
    }

    public void playStream(Uri uri, int n, int n2, int n3) {
        this.mPlayer.playStream(uri, n, n2, -2, n3);
        System.out.println("pC.1b " + this.mPlayer);
    }

    public void setSwapInterval(int n) {
        this.swapInterval = n;
    }

    public GLMediaPlayer getGLMediaPlayer() {
        return this.mPlayer;
    }

    public void resetGLState() {
        this.resetGLState = true;
    }

    public void printScreen(GLAutoDrawable gLAutoDrawable) throws GLException, IOException {
        String string = String.format("MovieCube-snap%02d-%03dx%03d.png", this.screenshot_num++, gLAutoDrawable.getSurfaceWidth(), gLAutoDrawable.getSurfaceHeight());
        if (this.screenshot.readPixels(gLAutoDrawable.getGL(), false)) {
            this.screenshot.write(new File(string.toString()));
        }
    }

    public void printScreenOnGLThread(GLAutoDrawable gLAutoDrawable) {
        gLAutoDrawable.invoke(false, new GLRunnable(){

            public boolean run(GLAutoDrawable gLAutoDrawable) {
                try {
                    MovieCube.this.printScreen(gLAutoDrawable);
                }
                catch (GLException gLException) {
                    gLException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return true;
            }
        });
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        boolean bl;
        if (null == this.mPlayer) {
            throw new InternalError("mPlayer null");
        }
        this.resetGLState = false;
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        System.err.println(JoglVersion.getGLInfo((GL)gL2ES2, null));
        this.cube = new TextureSequenceCubeES2((TextureSequence)this.mPlayer, false, this.zoom0, this.rotx, this.roty);
        if (waitForKey) {
            MiscUtils.waitForKey("Init>");
        }
        try {
            this.mPlayer.initGL((GL)gL2ES2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (null != this.mPlayer) {
                this.mPlayer.destroy((GL)gL2ES2);
                this.mPlayer = null;
            }
            throw new GLException((Throwable)exception);
        }
        this.cube.init(gLAutoDrawable);
        this.mPlayer.resume();
        System.out.println("play.0 " + this.mPlayer);
        Object object = gLAutoDrawable.getUpstreamWidget();
        if (object instanceof Window) {
            Window window = (Window)object;
            window.addKeyListener(this.keyAction);
            bl = true;
        } else {
            bl = false;
        }
        System.err.println("MC.init: kl-added " + bl + ", " + gLAutoDrawable.getClass().getName());
        if (this.showText) {
            int n = gLAutoDrawable.getChosenGLCapabilities().getSampleBuffers() ? 0 : 2;
            this.textRendererGLEL = new InfoTextRendererGLELBase(gL2ES2.getGLProfile(), n);
            gLAutoDrawable.addGLEventListener((GLEventListener)this.textRendererGLEL);
        }
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        if (null == this.mPlayer) {
            return;
        }
        this.cube.reshape(gLAutoDrawable, n, n2, n3, n4);
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
        System.err.println(Thread.currentThread() + " MovieCube.dispose ... ");
        this.disposeImpl(gLAutoDrawable, true);
    }

    private void disposeImpl(GLAutoDrawable gLAutoDrawable, boolean bl) {
        Window window;
        if (null == this.mPlayer) {
            return;
        }
        Object object = gLAutoDrawable.getUpstreamWidget();
        if (object instanceof Window) {
            window = (Window)object;
            window.removeKeyListener(this.keyAction);
        }
        window = gLAutoDrawable.getGL().getGL2ES2();
        if (null != this.textRendererGLEL) {
            gLAutoDrawable.disposeGLEventListener((GLEventListener)this.textRendererGLEL, true);
            this.textRendererGLEL = null;
        }
        if (bl) {
            this.mPlayer.destroy((GL)window);
            this.mPlayer = null;
        }
        this.cube.dispose(gLAutoDrawable);
        this.cube = null;
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        long l;
        if (this.swapIntervalSet) {
            GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
            int n = this.swapInterval;
            gL2ES2.setSwapInterval(n);
            gLAutoDrawable.getAnimator().resetFPSCounter();
            this.swapInterval = gL2ES2.getSwapInterval();
            System.err.println("Swap Interval: " + n + " -> " + this.swapInterval);
            this.swapIntervalSet = false;
        }
        if (null == this.mPlayer) {
            return;
        }
        if (this.resetGLState) {
            this.resetGLState = false;
            System.err.println("XXX resetGLState");
            this.disposeImpl(gLAutoDrawable, false);
            this.init(gLAutoDrawable);
            this.reshape(gLAutoDrawable, 0, 0, gLAutoDrawable.getSurfaceWidth(), gLAutoDrawable.getSurfaceHeight());
        }
        if ((l = System.currentTimeMillis()) - this.lastPerfPos > 2000L) {
            this.lastPerfPos = l;
        }
        this.cube.display(gLAutoDrawable);
    }

    public static void main(String[] stringArray) throws IOException, InterruptedException, URISyntaxException {
        int n = 1;
        int n2 = 800;
        int n3 = 600;
        int n4 = 3;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n5 = -1;
        int n6 = -1;
        String string = null;
        Object var13_12 = null;
        boolean bl5 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-vid")) {
                n5 = MiscUtils.atoi(stringArray[++i], n5);
                continue;
            }
            if (stringArray[i].equals("-aid")) {
                n6 = MiscUtils.atoi(stringArray[++i], n6);
                continue;
            }
            if (stringArray[i].equals("-width")) {
                n2 = MiscUtils.atoi(stringArray[++i], n2);
                continue;
            }
            if (stringArray[i].equals("-height")) {
                n3 = MiscUtils.atoi(stringArray[++i], n3);
                continue;
            }
            if (stringArray[i].equals("-osize")) {
                bl5 = true;
                continue;
            }
            if (stringArray[i].equals("-textureCount")) {
                n4 = MiscUtils.atoi(stringArray[++i], n4);
                continue;
            }
            if (stringArray[i].equals("-url")) {
                string = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-es2")) {
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-es3")) {
                bl2 = true;
                continue;
            }
            if (stringArray[i].equals("-gl3")) {
                bl3 = true;
                continue;
            }
            if (stringArray[i].equals("-gldef")) {
                bl4 = true;
                continue;
            }
            if (stringArray[i].equals("-vsync")) {
                n = MiscUtils.atoi(stringArray[++i], n);
                continue;
            }
            if (!stringArray[i].equals("-wait")) continue;
            waitForKey = true;
        }
        final boolean bl6 = bl5;
        Uri uri = null;
        if (null != string) {
            uri = Uri.tryUriOrFile(string);
        }
        if (null == uri) {
            uri = defURI;
        }
        System.err.println("url_s " + string);
        System.err.println("stream " + uri);
        System.err.println("vid " + n5 + ", aid " + n6);
        System.err.println("textureCount " + n4);
        System.err.println("forceES2   " + bl);
        System.err.println("forceES3   " + bl2);
        System.err.println("forceGL3   " + bl3);
        System.err.println("forceGLDef " + bl4);
        System.err.println("swapInterval " + n);
        final MovieCube movieCube = new MovieCube(-2.77f, 0.0f, 0.0f, true);
        movieCube.setSwapInterval(n);
        GLProfile gLProfile = bl4 ? GLProfile.getDefault() : (bl3 ? GLProfile.get((String)"GL3") : (bl2 ? GLProfile.get((String)"GLES3") : (bl ? GLProfile.get((String)"GLES2") : GLProfile.getGL2ES2())));
        System.err.println("GLProfile: " + gLProfile);
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        final GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)gLCapabilities);
        final Animator animator = new Animator((GLAutoDrawable)gLWindow);
        gLWindow.addWindowListener((WindowListener)new WindowAdapter(){

            public void windowDestroyed(WindowEvent windowEvent) {
                animator.stop();
            }
        });
        gLWindow.addGLEventListener((GLEventListener)movieCube);
        gLWindow.setSize(n2, n3);
        gLWindow.setVisible(true);
        System.err.println("Chosen: " + gLWindow.getChosenGLCapabilities());
        animator.start();
        movieCube.mPlayer.addEventListener(new GLMediaPlayer.GLMediaEventListener(){

            public void attributesChanged(GLMediaPlayer gLMediaPlayer, GLMediaPlayer.EventMask eventMask, long l) {
                System.err.println("MovieCube.1 AttributesChanges: events_mask " + eventMask + ", when " + l);
                System.err.println("MovieCube.1 State: " + gLMediaPlayer);
                if (eventMask.isSet(GLMediaPlayer.EventMask.Bit.Size) && bl6) {
                    gLWindow.setSurfaceSize(gLMediaPlayer.getWidth(), gLMediaPlayer.getHeight());
                }
                if (eventMask.isSet(GLMediaPlayer.EventMask.Bit.Init)) {
                    animator.setUpdateFPSFrames(60, null);
                    animator.resetFPSCounter();
                    movieCube.resetGLState();
                } else if (eventMask.isSet(GLMediaPlayer.EventMask.Bit.Play)) {
                    animator.resetFPSCounter();
                }
                if (eventMask.isSet(GLMediaPlayer.EventMask.Bit.EOS)) {
                    new InterruptSource.Thread(){

                        public void run() {
                            movieCube.mPlayer.seek(0);
                            movieCube.mPlayer.resume();
                        }
                    }.start();
                }
                if (eventMask.isSet(GLMediaPlayer.EventMask.Bit.Error)) {
                    GLMediaPlayer.StreamException streamException = movieCube.mPlayer.getStreamException();
                    if (null != streamException) {
                        streamException.printStackTrace();
                    }
                    new InterruptSource.Thread(() -> gLWindow.destroy()).start();
                }
            }
        });
        movieCube.playStream(uri, n5, n6, n4);
    }

    static {
        Uri uri = null;
        try {
            uri = Uri.cast((String)"http://archive.org/download/BigBuckBunny_328/BigBuckBunny_512kb.mp4");
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        defURI = uri;
    }

    private final class InfoTextRendererGLELBase
    extends TextRendererGLELBase {
        private static final float z_diff = 0.001f;
        private final Font font;
        private final float fontSize1 = 12.0f;
        private final float fontSize2 = 10.0f;
        private final GLRegion regionFPS;
        private float pixelSize1;
        private float pixelSize2;
        private float underlineSize;
        String text1_old;

        InfoTextRendererGLELBase(GLProfile gLProfile, int n) {
            super(n, 4);
            this.font = InfoTextRendererGLELBase.getFont(0, 0, 0);
            this.fontSize1 = 12.0f;
            this.fontSize2 = 10.0f;
            this.text1_old = null;
            this.setRendererCallbacks(RegionRenderer.defaultBlendEnable, RegionRenderer.defaultBlendDisable);
            this.regionFPS = GLRegion.create((GLProfile)gLProfile, (int)this.renderModes, null, (int)0, (int)0);
            System.err.println("RegionFPS " + Region.getRenderModeString((int)this.renderModes) + ", sampleCount " + 4 + ", class " + this.regionFPS.getClass().getName());
            this.staticRGBAColor[0] = 0.1f;
            this.staticRGBAColor[1] = 0.1f;
            this.staticRGBAColor[2] = 0.1f;
            this.staticRGBAColor[3] = 1.0f;
        }

        @Override
        public void init(GLAutoDrawable gLAutoDrawable) {
            this.setSharedPMVMatrix((PMVMatrix4f)((MovieCube)MovieCube.this).cube.pmvMatrix);
            super.init(gLAutoDrawable);
            MovieCube.this.autoDrawable = gLAutoDrawable;
            this.pixelSize1 = FontScale.toPixels((float)12.0f, (float)this.dpiH);
            this.pixelSize2 = FontScale.toPixels((float)10.0f, (float)this.dpiH);
            this.pixelScale = 1.0f / (this.pixelSize1 * 20.0f);
            Font.Metrics metrics = this.font.getMetrics();
            float f = this.pixelSize1 * metrics.getLineGap();
            float f2 = this.pixelSize1 * metrics.getDescent();
            this.underlineSize = f - f2;
            System.err.println("XXX: dpiH " + this.dpiH + ", fontSize " + 12.0f + ", pixelSize " + this.pixelSize1 + ", pixelScale " + this.pixelScale + ", fLG " + f + ", fDesc " + f2 + ", underlineSize " + this.underlineSize);
        }

        @Override
        public void dispose(GLAutoDrawable gLAutoDrawable) {
            MovieCube.this.autoDrawable = null;
            MovieCube.this.screenshot.dispose(gLAutoDrawable.getGL());
            if (null != this.regionFPS) {
                this.regionFPS.destroy(gLAutoDrawable.getGL().getGL2ES2());
            }
            super.dispose(gLAutoDrawable);
        }

        @Override
        public void display(GLAutoDrawable gLAutoDrawable) {
            GLAnimatorControl gLAnimatorControl = gLAutoDrawable.getAnimator();
            float f = null != gLAnimatorControl ? gLAnimatorControl.getLastFPS() : 0.0f;
            float f2 = null != gLAnimatorControl ? gLAnimatorControl.getTotalFPS() : 0.0f;
            float f3 = (float)MovieCube.this.mPlayer.getPTS().getCurrent() / 1000.0f;
            float f4 = (float)MovieCube.this.mPlayer.getWidth() / (float)MovieCube.this.mPlayer.getHeight();
            float f5 = 1.0f / f4;
            float f6 = 1.0f - f5;
            float f7 = f6 - this.pixelScale * this.underlineSize;
            float f8 = 2.0f - f6;
            GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
            String string = null != this.regionFPS ? "3.1" : "3.0";
            String string2 = String.format("%0" + string + "f/%0" + string + "f s, %s (%01.2fx, vol %01.2f), a %01.2f, fps %02.1f -> %02.1f / %02.1f, swap %d", Float.valueOf(f3), Float.valueOf((float)MovieCube.this.mPlayer.getDuration() / 1000.0f), MovieCube.this.mPlayer.getState().toString().toLowerCase(), Float.valueOf(MovieCube.this.mPlayer.getPlaySpeed()), Float.valueOf(MovieCube.this.mPlayer.getAudioVolume()), Float.valueOf(f4), Float.valueOf(MovieCube.this.mPlayer.getFramerate()), Float.valueOf(f), Float.valueOf(f2), gLAutoDrawable.getGL().getSwapInterval());
            String string3 = String.format("audio: id %d, kbps %d, codec %s", MovieCube.this.mPlayer.getAID(), MovieCube.this.mPlayer.getAudioBitrate() / 1000, MovieCube.this.mPlayer.getAudioCodec());
            String string4 = String.format("video: id %d, kbps %d, codec %s", MovieCube.this.mPlayer.getVID(), MovieCube.this.mPlayer.getVideoBitrate() / 1000, MovieCube.this.mPlayer.getVideoCodec());
            String string5 = ((MovieCube)MovieCube.this).mPlayer.getUri().path.decode();
            if (MovieCube.this.displayOSD && null != this.renderer) {
                gL2ES2.glClearColor(1.0f, 1.0f, 1.0f, 0.0f);
                if (!string2.equals(this.text1_old)) {
                    this.renderString(gLAutoDrawable, this.font, this.pixelSize1, (CharSequence)string2, 1, -1, -0.999f, f7, 1.001f, this.regionFPS.clear(gL2ES2));
                    this.text1_old = string2;
                } else {
                    this.renderRegion(gLAutoDrawable, this.font, this.pixelSize1, 1, -1, -0.999f, f7, 1.001f, this.regionFPS);
                }
                this.renderString(gLAutoDrawable, this.font, this.pixelSize2, (CharSequence)string3, 1, 0, -0.999f, f8, 1.001f, true);
                this.renderString(gLAutoDrawable, this.font, this.pixelSize2, (CharSequence)string4, 1, 1, -0.999f, f8, 1.001f, true);
                this.renderString(gLAutoDrawable, this.font, this.pixelSize2, (CharSequence)string5, 1, 2, -0.999f, f8, 1.001f, true);
            }
        }
    }
}

