/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.demos;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.util.GLArrayDataServer;
import java.nio.FloatBuffer;

public abstract class GearsObject {
    public static final FloatBuffer red = Buffers.newDirectFloatBuffer((float[])new float[]{0.8f, 0.1f, 0.0f, 0.7f});
    public static final FloatBuffer green = Buffers.newDirectFloatBuffer((float[])new float[]{0.0f, 0.8f, 0.2f, 0.7f});
    public static final FloatBuffer blue = Buffers.newDirectFloatBuffer((float[])new float[]{0.2f, 0.2f, 1.0f, 0.7f});
    public static final float M_PI = (float)Math.PI;
    public final FloatBuffer gearColor;
    public GLArrayDataServer frontFace;
    public GLArrayDataServer frontSide;
    public GLArrayDataServer backFace;
    public GLArrayDataServer backSide;
    public GLArrayDataServer outwardFace;
    public GLArrayDataServer insideRadiusCyl;
    protected boolean validateBuffers = false;

    public abstract GLArrayDataServer createInterleaved(boolean var1, int var2, int var3, boolean var4, int var5, int var6);

    public abstract void addInterleavedVertexAndNormalArrays(GLArrayDataServer var1, int var2);

    public abstract void draw(GL var1, float var2, float var3, float var4);

    public void setColor(float f, float f2, float f3, float f4) {
        this.gearColor.put(0, f).put(1, f2).put(2, f3).put(3, f4);
    }

    private void init(GL gL, GLArrayDataServer gLArrayDataServer) {
        gLArrayDataServer.enableBuffer(gL, true);
        gLArrayDataServer.enableBuffer(gL, false);
    }

    public void destroy(GL gL) {
        if (null != this.frontFace) {
            this.frontFace.destroy(gL);
        }
        if (null != this.frontSide) {
            this.frontSide.destroy(gL);
        }
        if (null != this.backFace) {
            this.backFace.destroy(gL);
        }
        if (null != this.backSide) {
            this.backSide.destroy(gL);
        }
        if (null != this.outwardFace) {
            this.outwardFace.destroy(gL);
        }
        if (null != this.insideRadiusCyl) {
            this.insideRadiusCyl.destroy(gL);
        }
        this.frontFace = null;
        this.frontSide = null;
        this.backFace = null;
        this.backSide = null;
        this.outwardFace = null;
        this.insideRadiusCyl = null;
    }

    public GearsObject(GL gL, boolean bl, FloatBuffer floatBuffer, float f, float f2, float f3, int n, float f4, boolean bl2) {
        float f5;
        float f6;
        float f7;
        float f8 = f3 * 0.5f;
        float[] fArray = new float[5];
        float[] fArray2 = new float[5];
        float[] fArray3 = new float[3];
        this.validateBuffers = bl2;
        this.gearColor = Buffers.newDirectFloatBuffer((int)4);
        this.gearColor.put(floatBuffer).rewind();
        floatBuffer.rewind();
        float f9 = f;
        float f10 = f2 - f4 / 2.0f;
        float f11 = f2 + f4 / 2.0f;
        float f12 = (float)Math.PI * 2 / (float)n / 4.0f;
        fArray[4] = 0.0f;
        fArray2[4] = 1.0f;
        this.frontFace = this.createInterleaved(bl, 6, 5126, false, 4 * n + 2, 35044);
        this.addInterleavedVertexAndNormalArrays(this.frontFace, 3);
        this.backFace = this.createInterleaved(bl, 6, 5126, false, 4 * n + 2, 35044);
        this.addInterleavedVertexAndNormalArrays(this.backFace, 3);
        this.frontSide = this.createInterleaved(bl, 6, 5126, false, 6 * n, 35044);
        this.addInterleavedVertexAndNormalArrays(this.frontSide, 3);
        this.backSide = this.createInterleaved(bl, 6, 5126, false, 6 * n, 35044);
        this.addInterleavedVertexAndNormalArrays(this.backSide, 3);
        this.outwardFace = this.createInterleaved(bl, 6, 5126, false, 16 * n + 2, 35044);
        this.addInterleavedVertexAndNormalArrays(this.outwardFace, 3);
        this.insideRadiusCyl = this.createInterleaved(bl, 6, 5126, false, 2 * n + 2, 35044);
        this.addInterleavedVertexAndNormalArrays(this.insideRadiusCyl, 3);
        if (bl) {
            this.frontFace.mapStorage(gL, 35001);
            this.backFace.mapStorage(gL, 35001);
            this.frontSide.mapStorage(gL, 35001);
            this.backSide.mapStorage(gL, 35001);
            this.outwardFace.mapStorage(gL, 35001);
            this.insideRadiusCyl.mapStorage(gL, 35001);
        }
        for (int i = 0; i < n; ++i) {
            float f13 = (float)i * 2.0f * (float)Math.PI / (float)n;
            GearsObject.sincos(f13 + f12 * 0.0f, fArray, 0, fArray2, 0);
            GearsObject.sincos(f13 + f12 * 1.0f, fArray, 1, fArray2, 1);
            GearsObject.sincos(f13 + f12 * 2.0f, fArray, 2, fArray2, 2);
            GearsObject.sincos(f13 + f12 * 3.0f, fArray, 3, fArray2, 3);
            fArray3[0] = 0.0f;
            fArray3[1] = 0.0f;
            fArray3[2] = 1.0f;
            GearsObject.vert(this.frontFace, f9 * fArray2[0], f9 * fArray[0], f8, fArray3);
            GearsObject.vert(this.frontFace, f10 * fArray2[0], f10 * fArray[0], f8, fArray3);
            GearsObject.vert(this.frontFace, f9 * fArray2[0], f9 * fArray[0], f8, fArray3);
            GearsObject.vert(this.frontFace, f10 * fArray2[3], f10 * fArray[3], f8, fArray3);
            GearsObject.vert(this.frontSide, f10 * fArray2[0], f10 * fArray[0], f8, fArray3);
            GearsObject.vert(this.frontSide, f11 * fArray2[1], f11 * fArray[1], f8, fArray3);
            GearsObject.vert(this.frontSide, f11 * fArray2[2], f11 * fArray[2], f8, fArray3);
            GearsObject.vert(this.frontSide, f10 * fArray2[0], f10 * fArray[0], f8, fArray3);
            GearsObject.vert(this.frontSide, f11 * fArray2[2], f11 * fArray[2], f8, fArray3);
            GearsObject.vert(this.frontSide, f10 * fArray2[3], f10 * fArray[3], f8, fArray3);
            fArray3[0] = 0.0f;
            fArray3[1] = 0.0f;
            fArray3[2] = -1.0f;
            GearsObject.vert(this.backFace, f10 * fArray2[0], f10 * fArray[0], -f8, fArray3);
            GearsObject.vert(this.backFace, f9 * fArray2[0], f9 * fArray[0], -f8, fArray3);
            GearsObject.vert(this.backFace, f10 * fArray2[3], f10 * fArray[3], -f8, fArray3);
            GearsObject.vert(this.backFace, f9 * fArray2[0], f9 * fArray[0], -f8, fArray3);
            GearsObject.vert(this.backSide, f10 * fArray2[3], f10 * fArray[3], -f8, fArray3);
            GearsObject.vert(this.backSide, f11 * fArray2[2], f11 * fArray[2], -f8, fArray3);
            GearsObject.vert(this.backSide, f11 * fArray2[1], f11 * fArray[1], -f8, fArray3);
            GearsObject.vert(this.backSide, f10 * fArray2[3], f10 * fArray[3], -f8, fArray3);
            GearsObject.vert(this.backSide, f11 * fArray2[1], f11 * fArray[1], -f8, fArray3);
            GearsObject.vert(this.backSide, f10 * fArray2[0], f10 * fArray[0], -f8, fArray3);
            f7 = f11 * fArray2[1] - f10 * fArray2[0];
            f6 = f11 * fArray[1] - f10 * fArray[0];
            f5 = (float)Math.sqrt(f7 * f7 + f6 * f6);
            fArray3[0] = f6 /= f5;
            fArray3[1] = -(f7 /= f5);
            fArray3[2] = 0.0f;
            GearsObject.vert(this.outwardFace, f10 * fArray2[0], f10 * fArray[0], f8, fArray3);
            GearsObject.vert(this.outwardFace, f10 * fArray2[0], f10 * fArray[0], -f8, fArray3);
            GearsObject.vert(this.outwardFace, f11 * fArray2[1], f11 * fArray[1], f8, fArray3);
            GearsObject.vert(this.outwardFace, f11 * fArray2[1], f11 * fArray[1], -f8, fArray3);
            fArray3[0] = fArray2[0];
            fArray3[1] = fArray[0];
            GearsObject.vert(this.outwardFace, f11 * fArray2[1], f11 * fArray[1], f8, fArray3);
            GearsObject.vert(this.outwardFace, f11 * fArray2[1], f11 * fArray[1], -f8, fArray3);
            GearsObject.vert(this.outwardFace, f11 * fArray2[2], f11 * fArray[2], f8, fArray3);
            GearsObject.vert(this.outwardFace, f11 * fArray2[2], f11 * fArray[2], -f8, fArray3);
            fArray3[0] = f10 * fArray[3] - f11 * fArray[2];
            fArray3[1] = (f10 * fArray2[3] - f11 * fArray2[2]) * -1.0f;
            GearsObject.vert(this.outwardFace, f11 * fArray2[2], f11 * fArray[2], f8, fArray3);
            GearsObject.vert(this.outwardFace, f11 * fArray2[2], f11 * fArray[2], -f8, fArray3);
            GearsObject.vert(this.outwardFace, f10 * fArray2[3], f10 * fArray[3], f8, fArray3);
            GearsObject.vert(this.outwardFace, f10 * fArray2[3], f10 * fArray[3], -f8, fArray3);
            fArray3[0] = fArray2[0];
            fArray3[1] = fArray[0];
            GearsObject.vert(this.outwardFace, f10 * fArray2[3], f10 * fArray[3], f8, fArray3);
            GearsObject.vert(this.outwardFace, f10 * fArray2[3], f10 * fArray[3], -f8, fArray3);
            GearsObject.vert(this.outwardFace, f10 * fArray2[0], f10 * fArray[0], f8, fArray3);
            GearsObject.vert(this.outwardFace, f10 * fArray2[0], f10 * fArray[0], -f8, fArray3);
            fArray3[0] = fArray2[0] * -1.0f;
            fArray3[1] = fArray[0] * -1.0f;
            fArray3[2] = 0.0f;
            GearsObject.vert(this.insideRadiusCyl, f9 * fArray2[0], f9 * fArray[0], -f8, fArray3);
            GearsObject.vert(this.insideRadiusCyl, f9 * fArray2[0], f9 * fArray[0], f8, fArray3);
        }
        fArray3[0] = 0.0f;
        fArray3[1] = 0.0f;
        fArray3[2] = 1.0f;
        GearsObject.vert(this.frontFace, f9 * fArray2[4], f9 * fArray[4], f8, fArray3);
        GearsObject.vert(this.frontFace, f10 * fArray2[4], f10 * fArray[4], f8, fArray3);
        this.frontFace.seal(true);
        fArray3[2] = -1.0f;
        GearsObject.vert(this.backFace, f10 * fArray2[4], f10 * fArray[4], -f8, fArray3);
        GearsObject.vert(this.backFace, f9 * fArray2[4], f9 * fArray[4], -f8, fArray3);
        this.backFace.seal(true);
        this.backSide.seal(true);
        this.frontSide.seal(true);
        GearsObject.sincos(f12 * 1.0f, fArray, 1, fArray2, 1);
        f7 = f11 * fArray2[1] - f10 * fArray2[4];
        f6 = f11 * fArray[1] - f10 * fArray[4];
        f5 = (float)Math.sqrt(f7 * f7 + f6 * f6);
        fArray3[0] = f6 /= f5;
        fArray3[1] = -(f7 /= f5);
        fArray3[2] = 0.0f;
        GearsObject.vert(this.outwardFace, f10 * fArray2[4], f10 * fArray[4], f8, fArray3);
        GearsObject.vert(this.outwardFace, f10 * fArray2[4], f10 * fArray[4], -f8, fArray3);
        this.outwardFace.seal(true);
        fArray3[0] = fArray2[4] * -1.0f;
        fArray3[1] = fArray[4] * -1.0f;
        fArray3[2] = 0.0f;
        GearsObject.vert(this.insideRadiusCyl, f9 * fArray2[4], f9 * fArray[4], -f8, fArray3);
        GearsObject.vert(this.insideRadiusCyl, f9 * fArray2[4], f9 * fArray[4], f8, fArray3);
        this.insideRadiusCyl.seal(true);
        if (bl) {
            this.frontFace.unmapStorage(gL);
            this.backFace.unmapStorage(gL);
            this.frontSide.unmapStorage(gL);
            this.backSide.unmapStorage(gL);
            this.outwardFace.unmapStorage(gL);
            this.insideRadiusCyl.unmapStorage(gL);
        } else {
            this.init(gL, this.frontFace);
            this.init(gL, this.frontSide);
            this.init(gL, this.backFace);
            this.init(gL, this.backSide);
            this.init(gL, this.outwardFace);
            this.init(gL, this.insideRadiusCyl);
        }
    }

    public String toString() {
        int n = null != this.frontFace ? this.frontFace.getVBOName() : 0;
        int n2 = null != this.frontSide ? this.frontSide.getVBOName() : 0;
        int n3 = null != this.backFace ? this.backFace.getVBOName() : 0;
        int n4 = null != this.backSide ? this.backSide.getVBOName() : 0;
        return "GearsObj[0x" + Integer.toHexString(this.hashCode()) + ", vbo ff " + n + ", fs " + n2 + ", bf " + n3 + ", bs " + n4 + "]";
    }

    static void vert(GLArrayDataServer gLArrayDataServer, float f, float f2, float f3, float[] fArray) {
        gLArrayDataServer.putf(f);
        gLArrayDataServer.putf(f2);
        gLArrayDataServer.putf(f3);
        gLArrayDataServer.putf(fArray[0]);
        gLArrayDataServer.putf(fArray[1]);
        gLArrayDataServer.putf(fArray[2]);
    }

    static void sincos(float f, float[] fArray, int n, float[] fArray2, int n2) {
        fArray[n] = (float)Math.sin(f);
        fArray2[n2] = (float)Math.cos(f);
    }
}

