/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.util;

import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.newt.Display;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.test.junit.util.NewtTestUtil;
import com.jogamp.opengl.util.caps.NonFSAAGLCapsChooser;
import org.junit.Assert;

public class NEWTGLContext {
    public static WindowContext createWindow(GLCapabilities gLCapabilities, int n, int n2, boolean bl) throws InterruptedException {
        Display display = NewtFactory.createDisplay(null);
        Assert.assertNotNull(display);
        Screen screen = NewtFactory.createScreen(display, 0);
        Assert.assertNotNull(screen);
        Window window = NewtFactory.createWindow(screen, (CapabilitiesImmutable)gLCapabilities);
        Assert.assertNotNull(window);
        window.setSize(n, n2);
        if (!gLCapabilities.getSampleBuffers()) {
            window.setCapabilitiesChooser(new NonFSAAGLCapsChooser(true));
        }
        window.setVisible(true);
        Assert.assertTrue(NewtTestUtil.waitForVisible(window, true, null));
        Assert.assertTrue(NewtTestUtil.waitForRealized(window, true, null));
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory(gLCapabilities.getGLProfile());
        GLDrawable gLDrawable = gLDrawableFactory.createGLDrawable(window);
        Assert.assertNotNull(gLDrawable);
        gLDrawable.setRealized(true);
        Assert.assertTrue(gLDrawable.isRealized());
        GLContext gLContext = gLDrawable.createContext(null);
        Assert.assertNotNull(gLContext);
        gLContext.enableGLDebugMessage(bl);
        int n3 = gLContext.makeCurrent();
        Assert.assertTrue(2 == n3 || 1 == n3);
        return new WindowContext(window, gLDrawable, gLContext);
    }

    public static void destroyWindow(WindowContext windowContext) {
        GLDrawable gLDrawable = windowContext.context.getGLDrawable();
        Assert.assertNotNull(windowContext.context);
        windowContext.context.destroy();
        Assert.assertNotNull(gLDrawable);
        gLDrawable.setRealized(false);
        Assert.assertNotNull(windowContext.window);
        windowContext.window.destroy();
    }

    public static class WindowContext {
        public final Window window;
        public final GLDrawable drawable;
        public final GLContext context;

        public WindowContext(Window window, GLDrawable gLDrawable, GLContext gLContext) {
            this.window = window;
            this.drawable = gLDrawable;
            this.context = gLContext;
        }
    }
}

