/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.newt.parenting;

import com.jogamp.newt.Window;
import com.jogamp.newt.awt.NewtCanvasAWT;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.NEWTEvent;
import com.jogamp.newt.event.NEWTEventFiFo;
import com.jogamp.newt.event.TraceKeyAdapter;
import com.jogamp.newt.event.TraceWindowAdapter;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.newt.parenting.KeyAction;
import com.jogamp.opengl.test.junit.newt.parenting.WindowAction;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Frame;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestParenting02AWT
extends UITestCase {
    static int width;
    static int height;
    static long durationPerTest;
    static long waitReparent;
    static boolean verbose;

    @BeforeClass
    public static void initClass() {
        width = 640;
        height = 480;
    }

    @Test
    public void test01NewtChildOnAWTParentLayouted() throws InterruptedException, InvocationTargetException {
        this.runNewtChildOnAWTParent(true, false);
    }

    @Test
    public void test02NewtChildOnAWTParentLayoutedDef() throws InterruptedException, InvocationTargetException {
        this.runNewtChildOnAWTParent(true, true);
    }

    @Test
    public void test03NewtChildOnAWTParentDirect() throws InterruptedException, InvocationTargetException {
        this.runNewtChildOnAWTParent(false, false);
    }

    @Test
    public void test04NewtChildOnAWTParentDirectDef() throws InterruptedException, InvocationTargetException {
        this.runNewtChildOnAWTParent(false, true);
    }

    public void runNewtChildOnAWTParent(final boolean bl, boolean bl2) throws InterruptedException, InvocationTargetException {
        NEWTEventFiFo nEWTEventFiFo = new NEWTEventFiFo();
        GLWindow gLWindow = GLWindow.create(new GLCapabilities(null));
        Assert.assertNotNull(gLWindow);
        gLWindow.setTitle("NEWT - CHILD");
        gLWindow.addKeyListener(new TraceKeyAdapter(new KeyAction(nEWTEventFiFo)));
        gLWindow.addWindowListener(new TraceWindowAdapter(new WindowAction(nEWTEventFiFo)));
        GearsES2 gearsES2 = new GearsES2();
        TestParenting02AWT.setDemoFields(gearsES2, gLWindow, false);
        gLWindow.addGLEventListener(gearsES2);
        final NewtCanvasAWT newtCanvasAWT = new NewtCanvasAWT(gLWindow);
        Assert.assertNotNull(newtCanvasAWT);
        Assert.assertEquals(false, gLWindow.isVisible());
        Assert.assertEquals(false, gLWindow.isNativeValid());
        Assert.assertNull(gLWindow.getParent());
        final Frame frame = new Frame("AWT Parent Frame");
        Assert.assertNotNull(frame);
        if (bl) {
            frame.setLayout(new BorderLayout());
            frame.add((Component)new Button("North"), "North");
            frame.add((Component)new Button("South"), "South");
            frame.add((Component)new Button("East"), "East");
            frame.add((Component)new Button("West"), "West");
            if (!bl2) {
                frame.add((Component)newtCanvasAWT, "Center");
            }
        } else if (!bl2) {
            frame.add(newtCanvasAWT);
        }
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setBounds(100, 100, width, height);
                frame.setVisible(true);
            }
        });
        if (bl2) {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    if (bl) {
                        frame.add((Component)newtCanvasAWT, "Center");
                    } else {
                        frame.add(newtCanvasAWT);
                    }
                    frame.validate();
                }
            });
        }
        do {
            Thread.yield();
            gLWindow.display();
        } while (!gLWindow.isNativeValid());
        boolean bl3 = gLWindow.getChosenCapabilities().isOnscreen();
        Assert.assertEquals(true, gLWindow.isNativeValid());
        Assert.assertNotNull(gLWindow.getParent());
        if (verbose) {
            System.out.println("+++++++++++++++++++ 1st ADDED");
        }
        Thread.sleep(waitReparent);
        if (bl) {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.remove(newtCanvasAWT);
                    frame.validate();
                }
            });
            Assert.assertEquals(false, gLWindow.isVisible());
            if (bl3) {
                Assert.assertEquals(true, gLWindow.isNativeValid());
            }
            Assert.assertNull(gLWindow.getParent());
            if (verbose) {
                System.out.println("+++++++++++++++++++ REMOVED!");
            }
            Thread.sleep(waitReparent);
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.add((Component)newtCanvasAWT, "Center");
                    frame.validate();
                }
            });
            gLWindow.display();
            Assert.assertEquals(true, gLWindow.isVisible());
            Assert.assertEquals(true, gLWindow.isNativeValid());
            Assert.assertNotNull(gLWindow.getParent());
            if (verbose) {
                System.out.println("+++++++++++++++++++ 2nd ADDED");
            }
            Thread.sleep(waitReparent);
        }
        long l = durationPerTest;
        boolean bl4 = false;
        while (l > 0L && !bl4) {
            NEWTEvent nEWTEvent;
            gLWindow.display();
            Thread.sleep(20L);
            l -= 20L;
            while (null != (nEWTEvent = nEWTEventFiFo.get())) {
                Window window = (Window)nEWTEvent.getSource();
                if (!(nEWTEvent instanceof KeyEvent)) continue;
                KeyEvent keyEvent = (KeyEvent)nEWTEvent;
                switch (keyEvent.getKeyChar()) {
                    case 'q': {
                        bl4 = true;
                        break;
                    }
                    case 'f': {
                        window.setFullscreen(!window.isFullscreen());
                    }
                }
            }
        }
        if (verbose) {
            System.out.println("+++++++++++++++++++ END");
        }
        Thread.sleep(waitReparent);
        gLWindow.destroy();
        if (bl) {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.remove(newtCanvasAWT);
                    frame.validate();
                }
            });
        }
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.dispose();
            }
        });
    }

    public static void setDemoFields(GLEventListener gLEventListener, GLWindow gLWindow, boolean bl) {
        Assert.assertNotNull(gLEventListener);
        Assert.assertNotNull(gLWindow);
        Window window = gLWindow.getDelegatedWindow();
        if (bl) {
            MiscUtils.setFieldIfExists(gLEventListener, "glDebug", true);
            MiscUtils.setFieldIfExists(gLEventListener, "glTrace", true);
        }
        if (!MiscUtils.setFieldIfExists(gLEventListener, "window", window)) {
            MiscUtils.setFieldIfExists(gLEventListener, "glWindow", gLWindow);
        }
    }

    static int atoi(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public static void main(String[] stringArray) throws IOException {
        verbose = true;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                durationPerTest = TestParenting02AWT.atoi(stringArray[++i]);
                continue;
            }
            if (!stringArray[i].equals("-wait")) continue;
            waitReparent = TestParenting02AWT.atoi(stringArray[++i]);
        }
        String string = TestParenting02AWT.class.getName();
        JUnitCore.main(string);
    }

    static {
        durationPerTest = 500L;
        waitReparent = 300L;
        verbose = false;
    }
}

