/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.newt.event;

import com.jogamp.newt.awt.NewtCanvasAWT;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.test.junit.jogl.demos.es2.RedSquareES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.NEWTKeyAdapter;
import com.jogamp.opengl.test.junit.util.NEWTKeyUtil;
import com.jogamp.opengl.test.junit.util.NewtTestUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Robot;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import jogamp.nativewindow.jawt.JAWTUtil;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestNewtKeyCodesAWT
extends UITestCase {
    static int width;
    static int height;
    static long durationPerTest;
    static long awtWaitTimeout;
    static GLCapabilities glCaps;
    static NEWTKeyUtil.CodeSeg[] codeSegments;

    @BeforeClass
    public static void initClass() {
        width = 640;
        height = 480;
        glCaps = new GLCapabilities(null);
    }

    @AfterClass
    public static void release() {
    }

    @Before
    public void initTest() {
    }

    @After
    public void releaseTest() {
    }

    @Test(timeout=180000L)
    public void test01NEWT() throws AWTException, InterruptedException, InvocationTargetException {
        GLWindow gLWindow = GLWindow.create(glCaps);
        gLWindow.setSize(width, height);
        gLWindow.setVisible(true);
        this.testImpl(gLWindow);
        gLWindow.destroy();
    }

    private void testNewtCanvasAWT_Impl(boolean bl) throws AWTException, InterruptedException, InvocationTargetException {
        GLWindow gLWindow = GLWindow.create(glCaps);
        NewtCanvasAWT newtCanvasAWT = new NewtCanvasAWT(gLWindow);
        if (!bl) {
            newtCanvasAWT.setShallUseOffscreenLayer(true);
        }
        final JFrame jFrame = new JFrame("Swing AWT Parent Frame: " + gLWindow.getTitle());
        jFrame.getContentPane().add((Component)newtCanvasAWT, "Center");
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                jFrame.setSize(width, height);
                jFrame.setVisible(true);
            }
        });
        Assert.assertEquals(true, AWTRobotUtil.waitForVisible(jFrame, true, null));
        this.testImpl(gLWindow);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    jFrame.setVisible(false);
                    jFrame.dispose();
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException(throwable);
        }
        gLWindow.destroy();
    }

    @Test(timeout=180000L)
    public void test02NewtCanvasAWT_Onscreen() throws AWTException, InterruptedException, InvocationTargetException {
        if (JAWTUtil.isOffscreenLayerRequired()) {
            System.err.println("Platform doesn't support onscreen rendering.");
            return;
        }
        this.testNewtCanvasAWT_Impl(true);
    }

    @Test(timeout=180000L)
    public void test03NewtCanvasAWT_Offsccreen() throws AWTException, InterruptedException, InvocationTargetException {
        if (!JAWTUtil.isOffscreenLayerSupported()) {
            System.err.println("Platform doesn't support offscreen rendering.");
            return;
        }
        this.testNewtCanvasAWT_Impl(false);
    }

    static void testKeyCodes(Robot robot, Object object, NEWTKeyAdapter nEWTKeyAdapter) throws InterruptedException, InvocationTargetException {
        ArrayList<List<EventObject>> arrayList = new ArrayList<List<EventObject>>();
        nEWTKeyAdapter.setVerbose(true);
        int[] nArray = AWTRobotUtil.getCenterLocation(object, false);
        for (int i = 0; i < codeSegments.length; ++i) {
            int n;
            nEWTKeyAdapter.reset();
            NEWTKeyUtil.CodeSeg codeSeg = codeSegments[i];
            int n2 = 0;
            for (n = codeSeg.min; n <= codeSeg.max; n = (short)(n + 1)) {
                AWTRobotUtil.waitForIdle(robot);
                try {
                    AWTRobotUtil.newtKeyPress(0, robot, true, (short)n, 10);
                }
                catch (Exception exception) {
                    System.err.println("Exception @ AWT Robot.PRESS " + MiscUtils.toHexString((short)n) + " - " + exception.getMessage());
                    break;
                }
                ++n2;
                try {
                    AWTRobotUtil.newtKeyPress(0, robot, false, (short)n, 100);
                }
                catch (Exception exception) {
                    System.err.println("Exception @ AWT Robot.RELEASE " + MiscUtils.toHexString((short)n) + " - " + exception.getMessage());
                    break;
                }
                ++n2;
            }
            AWTRobotUtil.waitForIdle(robot);
            for (n = 0; n < 20 && nEWTKeyAdapter.getQueueSize() < n2; ++n) {
                robot.delay(100);
                int n3 = 0 == n % 2 ? 1 : -1;
                AWTRobotUtil.awtRobotMouseMove(robot, nArray[0] + n3, nArray[1]);
            }
            AWTRobotUtil.awtRobotMouseMove(robot, nArray[0], nArray[1]);
            arrayList.add(nEWTKeyAdapter.copyQueue());
        }
        Assert.assertEquals("KeyCode impl. incomplete", true, NEWTKeyUtil.validateKeyCodes(codeSegments, arrayList, true));
    }

    void testImpl(GLWindow gLWindow) throws AWTException, InterruptedException, InvocationTargetException {
        Robot robot = new Robot();
        robot.setAutoWaitForIdle(true);
        RedSquareES2 redSquareES2 = new RedSquareES2();
        gLWindow.addGLEventListener(redSquareES2);
        NEWTKeyAdapter nEWTKeyAdapter = new NEWTKeyAdapter("GLWindow1");
        nEWTKeyAdapter.setVerbose(false);
        gLWindow.addKeyListener(nEWTKeyAdapter);
        Assert.assertEquals(true, NewtTestUtil.waitForRealized(gLWindow, true, null));
        Animator animator = new Animator(gLWindow);
        animator.start();
        Thread.sleep(durationPerTest);
        AWTRobotUtil.assertRequestFocusAndWait(null, gLWindow, gLWindow, null, null);
        AWTRobotUtil.requestFocus(robot, gLWindow, false);
        nEWTKeyAdapter.reset();
        TestNewtKeyCodesAWT.testKeyCodes(robot, gLWindow, nEWTKeyAdapter);
        gLWindow.removeKeyListener(nEWTKeyAdapter);
        animator.stop();
    }

    static int atoi(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            durationPerTest = TestNewtKeyCodesAWT.atoi(stringArray[++i]);
        }
        System.out.println("durationPerTest: " + durationPerTest);
        String string = TestNewtKeyCodesAWT.class.getName();
        JUnitCore.main(string);
    }

    static {
        durationPerTest = 100L;
        awtWaitTimeout = 1000L;
        codeSegments = new NEWTKeyUtil.CodeSeg[]{new NEWTKeyUtil.CodeSeg(8, 8, "bs"), new NEWTKeyUtil.CodeSeg(13, 13, "cr"), new NEWTKeyUtil.CodeSeg(11, 11, "pg_down"), new NEWTKeyUtil.CodeSeg(15, 18, "shift, pg_up, ctrl, alt"), new NEWTKeyUtil.CodeSeg(27, 27, "esc"), new NEWTKeyUtil.CodeSeg(32, 32, "space"), new NEWTKeyUtil.CodeSeg(39, 39, "quote"), new NEWTKeyUtil.CodeSeg(44, 47, ", - . /"), new NEWTKeyUtil.CodeSeg(48, 57, "0 - 9"), new NEWTKeyUtil.CodeSeg(59, 59, ";"), new NEWTKeyUtil.CodeSeg(61, 61, "="), new NEWTKeyUtil.CodeSeg(65, 90, "a - z"), new NEWTKeyUtil.CodeSeg(91, 93, "[ \\ ]"), new NEWTKeyUtil.CodeSeg(96, 96, "`"), new NEWTKeyUtil.CodeSeg(97, 104, "f1..f8"), new NEWTKeyUtil.CodeSeg(147, 147, "del"), new NEWTKeyUtil.CodeSeg(149, 152, "cursor arrows")};
    }
}

