/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.newt;

import com.jogamp.common.util.IOUtil;
import com.jogamp.junit.util.SingletonJunitCase;
import com.jogamp.nativewindow.NativeWindowFactory;
import com.jogamp.newt.Display;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.NewtTestUtil;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.AnimatorBase;
import java.io.IOException;
import java.util.Properties;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestWindowAndPointerIconNEWT
extends SingletonJunitCase {
    static long duration = 1000L;

    static void setPointerIcons() {
        Properties properties = System.getProperties();
        properties.put("jnlp.newt.window.icons", "red-16x16.png red-32x32.png");
    }

    @AfterClass
    public static void unsetPointerIcons() {
        Properties properties = System.getProperties();
        properties.remove("jnlp.newt.window.icons");
    }

    @Test
    public void test() throws InterruptedException {
        long l;
        GLWindow gLWindow = GLWindow.create(new GLCapabilities(null));
        Assert.assertNotNull(gLWindow);
        gLWindow.setSize(800, 600);
        GearsES2 gearsES2 = new GearsES2(1);
        gLWindow.addGLEventListener(gearsES2);
        QuitAdapter quitAdapter = new QuitAdapter();
        gLWindow.addKeyListener(quitAdapter);
        gLWindow.addWindowListener(quitAdapter);
        Object object = gLWindow.getScreen().getDisplay();
        ((Display)object).createNative();
        Display.PointerIcon pointerIcon = null;
        IOUtil.ClassResources classResources = new IOUtil.ClassResources(new String[]{"arrow-red-alpha-64x64.png"}, gLWindow.getClass().getClassLoader(), null);
        try {
            pointerIcon = ((Display)object).createPointerIcon(classResources, 0, 0);
            System.err.printf("Create PointerIcon #%02d: %s%n", 0, pointerIcon.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Display.PointerIcon pointerIcon2 = pointerIcon;
        gLWindow.setPointerIcon(pointerIcon2);
        System.err.println("Set PointerIcon: " + gLWindow.getPointerIcon());
        object = new Animator(0);
        ((AnimatorBase)object).add(gLWindow);
        ((Animator)object).start();
        gLWindow.setVisible(true);
        gLWindow.warpPointer(3 * gLWindow.getSurfaceWidth() / 4, 3 * gLWindow.getSurfaceHeight() / 4);
        long l2 = l = System.currentTimeMillis();
        while (!quitAdapter.shouldQuit() && l2 - l < duration) {
            Thread.sleep(100L);
            l2 = System.currentTimeMillis();
        }
        ((Animator)object).stop();
        gLWindow.destroy();
        if (NativeWindowFactory.isAWTAvailable()) {
            Assert.assertEquals(true, NewtTestUtil.waitForRealized(gLWindow, false, null));
        }
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            duration = MiscUtils.atol(stringArray[++i], duration);
        }
        JUnitCore.main(TestWindowAndPointerIconNEWT.class.getName());
    }

    static {
        TestWindowAndPointerIconNEWT.setPointerIcons();
    }
}

