/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.newt;

import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.newt.Screen;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.io.IOException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGLWindows00NEWT
extends UITestCase {
    static GLProfile glp;
    static int width;
    static int height;
    static boolean manual;
    static int loopVisibleToggle;
    static long durationPerTest;

    @BeforeClass
    public static void initClass() {
        width = 640;
        height = 480;
        glp = GLProfile.getDefault();
    }

    static GLWindow createWindow(Screen screen, GLCapabilitiesImmutable gLCapabilitiesImmutable, boolean bl) throws InterruptedException {
        GLWindow gLWindow;
        Assert.assertNotNull(gLCapabilitiesImmutable);
        if (null != screen) {
            gLWindow = GLWindow.create(screen, gLCapabilitiesImmutable);
            Assert.assertNotNull(gLWindow);
        } else {
            gLWindow = GLWindow.create(gLCapabilitiesImmutable);
            Assert.assertNotNull(gLWindow);
        }
        gLWindow.setUpdateFPSFrames(1, null);
        GearsES2 gearsES2 = new GearsES2();
        gLWindow.addGLEventListener(gearsES2);
        gLWindow.setUndecorated(bl);
        gLWindow.setSize(512, 512);
        System.err.println("XXX VISIBLE.0 -> TRUE");
        gLWindow.setVisible(true);
        Assert.assertEquals(true, gLWindow.isVisible());
        Assert.assertEquals(true, gLWindow.isNativeValid());
        return gLWindow;
    }

    static void destroyWindow(GLWindow gLWindow) {
        if (null != gLWindow) {
            gLWindow.destroy();
            Assert.assertEquals(false, gLWindow.isNativeValid());
            Assert.assertEquals(false, gLWindow.isVisible());
        }
    }

    @Test
    public void test01WindowCreateSimple() throws InterruptedException {
        if (manual) {
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        Assert.assertNotNull(gLCapabilities);
        GLWindow gLWindow = TestGLWindows00NEWT.createWindow(null, gLCapabilities, false);
        Assert.assertEquals(true, gLWindow.isNativeValid());
        Assert.assertEquals(true, gLWindow.isVisible());
        AbstractGraphicsDevice abstractGraphicsDevice = gLWindow.getScreen().getDisplay().getGraphicsDevice();
        System.err.println("GLProfiles window1: " + abstractGraphicsDevice.getConnection() + ": " + GLProfile.glAvailabilityToString(abstractGraphicsDevice));
        int n = 0;
        while ((long)(n * 100) < durationPerTest) {
            Thread.sleep(100L);
            ++n;
        }
        TestGLWindows00NEWT.destroyWindow(gLWindow);
    }

    @Test
    public void test02WindowCreateUndecor() throws InterruptedException {
        if (manual) {
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        Assert.assertNotNull(gLCapabilities);
        GLWindow gLWindow = TestGLWindows00NEWT.createWindow(null, gLCapabilities, true);
        Assert.assertEquals(true, gLWindow.isNativeValid());
        Assert.assertEquals(true, gLWindow.isVisible());
        AbstractGraphicsDevice abstractGraphicsDevice = gLWindow.getScreen().getDisplay().getGraphicsDevice();
        System.err.println("GLProfiles window1: " + abstractGraphicsDevice.getConnection() + ": " + GLProfile.glAvailabilityToString(abstractGraphicsDevice));
        int n = 0;
        while ((long)(n * 100) < durationPerTest) {
            Thread.sleep(100L);
            ++n;
        }
        TestGLWindows00NEWT.destroyWindow(gLWindow);
    }

    @Test
    public void test11WindowSimpleToggleVisibility() throws InterruptedException {
        this.test1xWindowToggleVisibility(false, loopVisibleToggle);
    }

    @Test
    public void test12WindowUndecorToggleVisibility() throws InterruptedException {
        if (manual) {
            return;
        }
        this.test1xWindowToggleVisibility(true, loopVisibleToggle);
    }

    private void test1xWindowToggleVisibility(boolean bl, int n) throws InterruptedException {
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        Assert.assertNotNull(gLCapabilities);
        GLWindow gLWindow = TestGLWindows00NEWT.createWindow(null, gLCapabilities, bl);
        Assert.assertEquals(true, gLWindow.isNativeValid());
        Assert.assertEquals(true, gLWindow.isVisible());
        gLWindow.display();
        Assert.assertEquals(true, gLWindow.isNativeValid());
        Assert.assertEquals(true, gLWindow.isVisible());
        int n2 = 0;
        while ((long)(n2 * 100) < durationPerTest) {
            Thread.sleep(100L);
            ++n2;
        }
        for (n2 = 1; n2 <= n; ++n2) {
            System.err.println("XXX VISIBLE." + n2 + " -> FALSE");
            gLWindow.setVisible(false);
            Assert.assertEquals(true, gLWindow.isNativeValid());
            Assert.assertEquals(false, gLWindow.isVisible());
            int n3 = 0;
            while ((long)(n3 * 100) < durationPerTest) {
                Thread.sleep(100L);
                ++n3;
            }
            gLWindow.display();
            Assert.assertEquals(true, gLWindow.isNativeValid());
            Assert.assertEquals(false, gLWindow.isVisible());
            System.err.println("XXX VISIBLE." + n2 + " -> TRUE");
            gLWindow.setVisible(true);
            Assert.assertEquals(true, gLWindow.isNativeValid());
            Assert.assertEquals(true, gLWindow.isVisible());
            n3 = 0;
            while ((long)(n3 * 100) < durationPerTest) {
                Thread.sleep(100L);
                ++n3;
            }
            gLWindow.display();
            Assert.assertEquals(true, gLWindow.isNativeValid());
            Assert.assertEquals(true, gLWindow.isVisible());
        }
        TestGLWindows00NEWT.destroyWindow(gLWindow);
    }

    static int atoi(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                durationPerTest = TestGLWindows00NEWT.atoi(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-loopvt")) {
                loopVisibleToggle = TestGLWindows00NEWT.atoi(stringArray[++i]);
                continue;
            }
            if (!stringArray[i].equals("-manual")) continue;
            manual = true;
        }
        System.out.println("durationPerTest: " + durationPerTest);
        String string = TestGLWindows00NEWT.class.getName();
        JUnitCore.main(string);
    }

    static {
        manual = false;
        loopVisibleToggle = 10;
        durationPerTest = 100L;
    }
}

