/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.newt;

import com.jogamp.nativewindow.NativeWindow;
import com.jogamp.nativewindow.util.Point;
import com.jogamp.newt.Window;
import com.jogamp.newt.awt.NewtCanvasAWT;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.NewtTestUtil;
import com.jogamp.opengl.test.junit.util.TestUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestCloseNewtAWT
extends UITestCase {
    GLWindow newtWindow = null;
    NewtCanvasAWT newtCanvas = null;
    JFrame frame = null;

    @Test
    public void testCloseNewtAWT() throws InterruptedException, InvocationTargetException {
        this.newtWindow = GLWindow.create(new GLCapabilities(GLProfile.getDefault()));
        this.newtCanvas = new MyCanvas((Window)this.newtWindow);
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                TestCloseNewtAWT.this.frame = new JFrame("NEWT Close Test");
                TestCloseNewtAWT.this.frame.setDefaultCloseOperation(2);
                TestCloseNewtAWT.this.frame.getContentPane().add(TestCloseNewtAWT.this.newtCanvas);
                TestCloseNewtAWT.this.frame.pack();
                TestCloseNewtAWT.this.frame.setSize(800, 600);
                TestCloseNewtAWT.this.frame.setVisible(true);
            }
        });
        Assert.assertEquals(true, AWTRobotUtil.waitForVisible(this.frame, true, null));
        GLWindow gLWindow = this.newtWindow;
        Assert.assertEquals(true, NewtTestUtil.waitForRealized(gLWindow, true, null));
        TestUtil.WindowClosingListener windowClosingListener = AWTRobotUtil.addClosingListener(this.frame);
        Assert.assertEquals(true, AWTRobotUtil.closeWindow(this.frame, true, windowClosingListener, null));
    }

    public static void main(String[] stringArray) {
        String string = TestCloseNewtAWT.class.getName();
        JUnitCore.main(string);
    }

    class MyCanvas
    extends NewtCanvasAWT {
        public MyCanvas(Window window) {
            super(window);
        }

        @Override
        public void addNotify() {
            System.err.println("MyCanvas START add: " + Thread.currentThread() + ", holds AWTTreeLock: " + Thread.holdsLock(this.getTreeLock()));
            super.addNotify();
            System.err.println("MyCanvas END add: " + Thread.currentThread() + ", holds AWTTreeLock: " + Thread.holdsLock(this.getTreeLock()));
        }

        @Override
        public void removeNotify() {
            System.err.println("MyCanvas START remove: " + Thread.currentThread() + ", holds AWTTreeLock: " + Thread.holdsLock(this.getTreeLock()));
            TestCloseNewtAWT.this.newtWindow.runOnEDTIfAvail(true, new Runnable(){

                @Override
                public void run() {
                    System.err.println("MyCanvas On NEWT-EDT From AWT-EDT: " + Thread.currentThread() + ", holds AWTTreeLock: " + Thread.holdsLock(MyCanvas.this.getTreeLock()));
                    NativeWindow nativeWindow = MyCanvas.this.getNativeWindow();
                    if (null != nativeWindow) {
                        Point point = nativeWindow.getLocationOnScreen(null);
                        System.err.println("MyCanvas On NEWT-EDT: position: " + point);
                    } else {
                        System.err.println("MyCanvas On NEWT-EDT: position n/a, null NativeWindow");
                    }
                }
            });
            System.err.println("MyCanvas passed critical: " + Thread.currentThread() + ", holds AWTTreeLock: " + Thread.holdsLock(this.getTreeLock()));
            super.removeNotify();
            System.err.println("MyCanvas END remove: " + Thread.currentThread() + ", holds AWTTreeLock: " + Thread.holdsLock(this.getTreeLock()));
        }
    }
}

