/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.newt;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.util.InterruptSource;
import com.jogamp.common.util.SourcedInterruptedException;
import com.jogamp.common.util.VersionUtil;
import com.jogamp.junit.util.SingletonJunitCase;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.newt.util.EDTUtil;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.util.Animator;
import java.io.IOException;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestBug1211IRQ00NEWT
extends SingletonJunitCase {
    static long durationTest00 = 1000L;
    static long durationTest01 = 1000L;
    static int width = 800;
    static int height = 600;
    volatile boolean interrupt1 = false;
    volatile boolean interrupt2 = false;
    volatile boolean interruptInit0 = false;

    static GLWindow createWindow(GLCapabilitiesImmutable gLCapabilitiesImmutable) {
        Assert.assertNotNull(gLCapabilitiesImmutable);
        GLWindow gLWindow = GLWindow.create(gLCapabilitiesImmutable);
        Assert.assertNotNull(gLWindow);
        gLWindow.setSize(width, height);
        gLWindow.setUpdateFPSFrames(1, null);
        GearsES2 gearsES2 = new GearsES2();
        gearsES2.setVerbose(false);
        gLWindow.addGLEventListener(gearsES2);
        return gLWindow;
    }

    static void destroyWindow(GLWindow gLWindow) throws InterruptedException {
        if (null != gLWindow) {
            gLWindow.destroy();
            Assert.assertEquals(false, gLWindow.isNativeValid());
        }
    }

    public void initTest() {
        this.interrupt1 = false;
        this.interrupt2 = false;
    }

    public void subTest00() {
        MyThread myThread = (MyThread)Thread.currentThread();
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.getDefault());
        Assert.assertNotNull(gLCapabilities);
        GLWindow gLWindow = TestBug1211IRQ00NEWT.createWindow(gLCapabilities);
        EDTUtil eDTUtil = gLWindow.getScreen().getDisplay().getEDTUtil();
        Animator animator = new Animator(gLWindow);
        try {
            gLWindow.setVisible(true);
            Assert.assertEquals(true, gLWindow.isVisible());
            Assert.assertEquals(true, gLWindow.isNativeValid());
            animator.start();
            boolean bl = true;
            int n = 0;
            while (bl && (long)(n * 100) < durationTest00) {
                int n2;
                int n3;
                Thread.sleep(100L);
                int n4 = gLWindow.getWidth();
                int n5 = gLWindow.getHeight();
                if (0 == n % 2) {
                    n3 = n4 + 100;
                    n2 = n5 + 100;
                } else {
                    n3 = n4 - 100;
                    n2 = n5 - 100;
                }
                System.err.println("test00.resize[" + n + "]: " + n4 + "x" + n5 + " -> " + n3 + "x" + n2);
                gLWindow.setSize(n3, n2);
                bl = 0 == myThread.getInterruptCounter(false) && !myThread.isInterrupted() && eDTUtil.isRunning() && animator.isAnimating();
                myThread.testInterrupted(false);
                ++n;
            }
        }
        catch (InterruptedException interruptedException) {
            ExceptionUtils.dumpThrowable("InterruptedException-1", interruptedException);
            this.interrupt1 = true;
        }
        try {
            animator.stop();
            TestBug1211IRQ00NEWT.destroyWindow(gLWindow);
            myThread.testInterrupted(false);
        }
        catch (InterruptedException interruptedException) {
            ExceptionUtils.dumpThrowable("InterruptedException-2", interruptedException);
            this.interrupt2 = true;
        }
        Assert.assertEquals("interruptCounter not zero", 0L, myThread.getInterruptCounter(false));
        Assert.assertFalse("interrupt() occured!", myThread.isInterrupted());
        Assert.assertFalse("Interrupt-1 occured!", this.interrupt1);
        Assert.assertFalse("Interrupt-2 occured!", this.interrupt2);
    }

    public void subTest01() {
        MyThread myThread = (MyThread)Thread.currentThread();
        GLWindow gLWindow = null;
        try {
            int n = 0;
            while ((long)(n * 100) < durationTest01) {
                GLWindow gLWindow2;
                GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.getDefault());
                Assert.assertNotNull(gLCapabilities);
                gLWindow = gLWindow2 = TestBug1211IRQ00NEWT.createWindow(gLCapabilities);
                gLWindow2.setVisible(true);
                Assert.assertEquals(true, gLWindow2.isVisible());
                Assert.assertEquals(true, gLWindow2.isNativeValid());
                System.err.println("test01.create[" + n + "]: " + gLWindow2.getStateMaskString() + ", " + gLWindow2.getWidth() + "x" + gLWindow2.getHeight());
                Animator animator = new Animator(gLWindow2);
                animator.start();
                Thread.sleep(100L);
                animator.stop();
                TestBug1211IRQ00NEWT.destroyWindow(gLWindow2);
                myThread.testInterrupted(false);
                ++n;
            }
        }
        catch (InterruptedException interruptedException) {
            ExceptionUtils.dumpThrowable("InterruptedException-1", interruptedException);
            this.interrupt1 = true;
        }
        try {
            TestBug1211IRQ00NEWT.destroyWindow(gLWindow);
            myThread.testInterrupted(false);
        }
        catch (InterruptedException interruptedException) {
            ExceptionUtils.dumpThrowable("InterruptedException-2", interruptedException);
            this.interrupt2 = true;
        }
        Assert.assertEquals("interruptCounter not zero", 0L, myThread.getInterruptCounter(false));
        Assert.assertFalse("interrupt() occured!", myThread.isInterrupted());
        Assert.assertFalse("Interrupt-1 occured!", this.interrupt1);
        Assert.assertFalse("Interrupt-2 occured!", this.interrupt2);
    }

    @Test
    public void testAll() {
        this.interruptInit0 = false;
        MyThread myThread = new MyThread(new Runnable(){

            @Override
            public void run() {
                MyThread myThread = (MyThread)Thread.currentThread();
                TestBug1211IRQ00NEWT testBug1211IRQ00NEWT = null;
                try {
                    System.err.println(VersionUtil.getPlatformInfo());
                    GLProfile.initSingleton();
                    testBug1211IRQ00NEWT = new TestBug1211IRQ00NEWT();
                    myThread.testInterrupted(false);
                }
                catch (InterruptedException interruptedException) {
                    ExceptionUtils.dumpThrowable("InterruptedException-Init0", interruptedException);
                    TestBug1211IRQ00NEWT.this.interruptInit0 = true;
                    testBug1211IRQ00NEWT = null;
                }
                myThread.clearInterruptSource();
                if (null != testBug1211IRQ00NEWT) {
                    testBug1211IRQ00NEWT.initTest();
                    testBug1211IRQ00NEWT.subTest00();
                    testBug1211IRQ00NEWT.initTest();
                    testBug1211IRQ00NEWT.subTest01();
                }
            }
        }, "MyMainThread");
        myThread.start();
        boolean bl = false;
        try {
            MyThread.testInterrupted1();
            while (!myThread.myThreadStarted) {
                Thread.yield();
                MyThread.testInterrupted1();
            }
            while (!myThread.myThreadStopped) {
                Thread.yield();
                MyThread.testInterrupted1();
            }
            MyThread.testInterrupted1();
        }
        catch (InterruptedException interruptedException) {
            ExceptionUtils.dumpThrowable("InterruptedException-All", interruptedException);
            bl = true;
        }
        Assert.assertFalse("Thread Interrupt-All occured!", bl);
        Assert.assertFalse("Interrupt-Init0 occured!", this.interruptInit0);
    }

    static int atoi(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public static void main(String[] stringArray) throws IOException {
        SingletonJunitCase.enableSingletonLock(false);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time00")) {
                durationTest00 = TestBug1211IRQ00NEWT.atoi(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-time01")) {
                durationTest01 = TestBug1211IRQ00NEWT.atoi(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-width")) {
                width = TestBug1211IRQ00NEWT.atoi(stringArray[++i]);
                continue;
            }
            if (!stringArray[i].equals("-height")) continue;
            height = TestBug1211IRQ00NEWT.atoi(stringArray[++i]);
        }
        System.out.println("durationTest00: " + durationTest00);
        System.out.println("durationTest01: " + durationTest01);
        System.out.println("defaultSize   : " + width + "x" + height);
        String string = TestBug1211IRQ00NEWT.class.getName();
        JUnitCore.main(string);
    }

    static class MyThread
    extends InterruptSource.Thread
    implements Thread.UncaughtExceptionHandler {
        volatile boolean myThreadStarted = false;
        volatile boolean myThreadStopped = false;

        public MyThread(Runnable runnable, String string) {
            super(null, runnable, string);
            this.setUncaughtExceptionHandler(this);
        }

        public static void testInterrupted1() throws InterruptedException {
            if (Thread.interrupted()) {
                throw SourcedInterruptedException.wrap(new InterruptedException(Thread.currentThread().getName() + ".testInterrupted -> TRUE (silent interruption)"));
            }
        }

        public synchronized void testInterrupted(boolean bl) throws InterruptedException {
            if (this.isInterrupted()) {
                boolean bl2;
                if (this == Thread.currentThread()) {
                    Thread.interrupted();
                    bl2 = true;
                } else {
                    bl2 = false;
                }
                int n = this.getInterruptCounter(false);
                Throwable throwable = this.getInterruptSource(true);
                SourcedInterruptedException sourcedInterruptedException = new SourcedInterruptedException(this.getName() + ".testInterrupted -> TRUE (current " + bl2 + ", counter " + n + ")", null, throwable);
                if (!bl) {
                    throw sourcedInterruptedException;
                }
                ExceptionUtils.dumpThrowable("Ignored", sourcedInterruptedException);
            }
        }

        @Override
        public void run() {
            this.myThreadStarted = true;
            try {
                super.run();
            }
            finally {
                this.myThreadStopped = true;
            }
        }

        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            System.err.println("UncaughtException on Thread " + thread.getName() + ": " + throwable.getMessage());
            ExceptionUtils.dumpThrowable("UncaughtException", throwable);
        }
    }
}

