/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.math;

import com.jogamp.common.os.Platform;
import com.jogamp.junit.util.JunitTracer;
import com.jogamp.math.FloatUtil;
import com.jogamp.math.Matrix4f;
import com.jogamp.opengl.test.junit.math.Matrix4fb;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestMatrix4f02MulNOUI
extends JunitTracer {
    final float[] m1_0 = new float[]{1.0f, 3.0f, 4.0f, 0.0f, 6.0f, 7.0f, 8.0f, 5.0f, 98.0f, 7.0f, 6.0f, 9.0f, 54.0f, 3.0f, 2.0f, 5.0f};
    final Matrix4f m1 = new Matrix4f(this.m1_0);
    final Matrix4fb n1 = new Matrix4fb(this.m1_0);
    final float[] m2_0 = new float[]{1.0f, 6.0f, 98.0f, 54.0f, 3.0f, 7.0f, 7.0f, 3.0f, 4.0f, 8.0f, 6.0f, 2.0f, 0.0f, 5.0f, 9.0f, 5.0f};
    final Matrix4f m2 = new Matrix4f(this.m2_0);
    final Matrix4fb n2 = new Matrix4fb(this.m2_0);
    final float[] m2xm1_0 = new float[]{26.0f, 59.0f, 143.0f, 71.0f, 59.0f, 174.0f, 730.0f, 386.0f, 143.0f, 730.0f, 9770.0f, 5370.0f, 71.0f, 386.0f, 5370.0f, 2954.0f};
    final Matrix4f m2xm1 = new Matrix4f(this.m2xm1_0);
    final Matrix4fb n2xn1 = new Matrix4fb(this.m2xm1_0);
    final float[] m1xm2_0 = new float[]{12557.0f, 893.0f, 748.0f, 1182.0f, 893.0f, 116.0f, 116.0f, 113.0f, 748.0f, 116.0f, 120.0f, 104.0f, 1182.0f, 113.0f, 104.0f, 131.0f};
    final Matrix4f m1xm2 = new Matrix4f(this.m1xm2_0);
    final Matrix4fb n1xn2 = new Matrix4fb(this.m1xm2_0);

    @Test
    public void test01_mul() {
        float[] fArray = new float[16];
        FloatUtil.multMatrix(this.m1_0, 0, this.m2_0, 0, fArray, 0);
        Assert.assertArrayEquals(this.m1xm2_0, fArray, 0.0f);
        Assert.assertEquals(this.m1xm2, new Matrix4f(this.m1).mul(this.m2));
        Assert.assertEquals(this.m1xm2, new Matrix4f().mul(this.m1, this.m2));
        Assert.assertEquals(this.n1xn2, new Matrix4fb(this.n1).mul(this.n2));
        Assert.assertEquals(this.n1xn2, new Matrix4fb().mul(this.n1, this.n2));
        fArray = new float[16];
        FloatUtil.multMatrix(this.m2_0, 0, this.m1_0, 0, fArray, 0);
        Assert.assertArrayEquals(this.m2xm1_0, fArray, 0.0f);
        Assert.assertEquals(this.m2xm1, new Matrix4f(this.m2).mul(this.m1));
        Assert.assertEquals(this.m2xm1, new Matrix4f().mul(this.m2, this.m1));
        Assert.assertEquals(this.n2xn1, new Matrix4fb(this.n2).mul(this.n1));
        Assert.assertEquals(this.n2xn1, new Matrix4fb().mul(this.n2, this.n1));
    }

    @Test
    public void test05Perf01() {
        int n;
        int n2;
        float[] fArray = new float[16];
        Matrix4f matrix4f = new Matrix4f();
        Matrix4fb matrix4fb = new Matrix4fb();
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        for (int i = 0; i < 1000; ++i) {
            FloatUtil.multMatrix(this.m1_0, 0, this.m2_0, 0, fArray, 0);
            FloatUtil.multMatrix(this.m2_0, 0, this.m1_0, 0, fArray, 0);
        }
        long l7 = Platform.currentTimeMillis();
        for (n2 = 0; n2 < 25000000; ++n2) {
            FloatUtil.multMatrix(this.m1_0, 0, this.m2_0, 0, fArray, 0);
            FloatUtil.multMatrix(this.m2_0, 0, this.m1_0, 0, fArray, 0);
        }
        l = Platform.currentTimeMillis() - l7;
        for (n2 = 0; n2 < 1000; ++n2) {
            FloatUtil.multMatrix(this.m1_0, this.m2_0, fArray);
            FloatUtil.multMatrix(this.m2_0, this.m1_0, fArray);
        }
        l7 = Platform.currentTimeMillis();
        for (n2 = 0; n2 < 25000000; ++n2) {
            FloatUtil.multMatrix(this.m1_0, this.m2_0, fArray);
            FloatUtil.multMatrix(this.m2_0, this.m1_0, fArray);
        }
        l2 = Platform.currentTimeMillis() - l7;
        double d = 1.0;
        for (n = 0; n < 1000; ++n) {
            matrix4f.mul(this.m1, this.m2);
            d += (double)matrix4f.determinant();
            matrix4f.mul(this.m2, this.m1);
            d += (double)matrix4f.determinant();
        }
        l7 = Platform.currentTimeMillis();
        for (n = 0; n < 25000000; ++n) {
            matrix4f.mul(this.m1, this.m2);
            d += (double)matrix4f.determinant();
            matrix4f.mul(this.m2, this.m1);
            d += (double)matrix4f.determinant();
        }
        l3 = Platform.currentTimeMillis() - l7;
        for (n = 0; n < 1000; ++n) {
            matrix4f.load(this.m1);
            matrix4f.mul(this.m2);
            d += (double)matrix4f.determinant();
            matrix4f.load(this.m2);
            matrix4f.mul(this.m1);
            d += (double)matrix4f.determinant();
        }
        l7 = Platform.currentTimeMillis();
        for (n = 0; n < 25000000; ++n) {
            matrix4f.load(this.m1);
            matrix4f.mul(this.m2);
            d += (double)matrix4f.determinant();
            matrix4f.load(this.m2);
            matrix4f.mul(this.m1);
            d += (double)matrix4f.determinant();
        }
        l4 = Platform.currentTimeMillis() - l7;
        for (n = 0; n < 1000; ++n) {
            matrix4fb.mul(this.n1, this.n2);
            d += (double)matrix4fb.determinant();
            matrix4fb.mul(this.n2, this.n1);
            d += (double)matrix4fb.determinant();
        }
        l7 = Platform.currentTimeMillis();
        for (n = 0; n < 25000000; ++n) {
            matrix4fb.mul(this.n1, this.n2);
            d += (double)matrix4fb.determinant();
            matrix4fb.mul(this.n2, this.n1);
            d += (double)matrix4fb.determinant();
        }
        l5 = Platform.currentTimeMillis() - l7;
        Assert.assertTrue(d > 0.0);
        for (n = 0; n < 1000; ++n) {
            matrix4fb.load(this.n1);
            matrix4fb.mul(this.n2);
            d += (double)matrix4fb.determinant();
            matrix4fb.load(this.n2);
            matrix4fb.mul(this.n1);
            d += (double)matrix4fb.determinant();
        }
        l7 = Platform.currentTimeMillis();
        for (n = 0; n < 25000000; ++n) {
            matrix4fb.load(this.n1);
            matrix4fb.mul(this.n2);
            d += (double)matrix4fb.determinant();
            matrix4fb.load(this.n2);
            matrix4fb.mul(this.n1);
            d += (double)matrix4fb.determinant();
        }
        l6 = Platform.currentTimeMillis() - l7;
        Assert.assertTrue(d > 0.0);
        System.err.printf("Checkmark %f%n", d);
        System.err.printf("Summary loops %6d: I1  %6d ms total, %f us/mul%n", 25000000, l, (double)l * 1000.0 / 2.5E7);
        System.err.printf("Summary loops %6d: I2  %6d ms total, %f us/mul, I2  / I1 %f%%%n", 25000000, l2, (double)l2 * 1000.0 / 2.0 / 2.5E7, (double)l2 / (double)l * 100.0);
        System.err.printf("Summary loops %6d: I4a %6d ms total, %f us/mul, I4a / I2 %f%%, I4a / I4b %f%%%n", 25000000, l3, (double)l3 * 1000.0 / 2.0 / 2.5E7, (double)l3 / (double)l2 * 100.0, (double)l3 / (double)l4 * 100.0);
        System.err.printf("Summary loops %6d: I4b %6d ms total, %f us/mul, I4b / I2 %f%%, I4b / I4a %f%%%n", 25000000, l4, (double)l4 * 1000.0 / 2.0 / 2.5E7, (double)l4 / (double)l2 * 100.0, (double)l4 / (double)l3 * 100.0);
        System.err.printf("Summary loops %6d: I5a %6d ms total, %f us/mul, I5a / I2 %f%%, I5a / I5b %f%%%n", 25000000, l5, (double)l5 * 1000.0 / 2.0 / 2.5E7, (double)l5 / (double)l2 * 100.0, (double)l5 / (double)l6 * 100.0);
        System.err.printf("Summary loops %6d: I5b %6d ms total, %f us/mul, I5b / I2 %f%%, I5b / I5a %f%%%n", 25000000, l6, (double)l6 * 1000.0 / 2.0 / 2.5E7, (double)l6 / (double)l2 * 100.0, (double)l6 / (double)l5 * 100.0);
    }

    public static void main(String[] stringArray) {
        JUnitCore.main(TestMatrix4f02MulNOUI.class.getName());
    }
}

