/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.math;

import com.jogamp.junit.util.JunitTracer;
import com.jogamp.math.FloatUtil;
import com.jogamp.math.Matrix4f;
import com.jogamp.math.Vec3f;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestMatrix4f01NOUI
extends JunitTracer {
    final float[] mI_0 = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    final Matrix4f mI = new Matrix4f(this.mI_0);
    final float[] m1_0 = new float[]{1.0f, 3.0f, 4.0f, 0.0f, 6.0f, 7.0f, 8.0f, 5.0f, 98.0f, 7.0f, 6.0f, 9.0f, 54.0f, 3.0f, 2.0f, 5.0f};
    final Matrix4f m1 = new Matrix4f(this.m1_0);
    final float[] m1T_0 = new float[]{1.0f, 6.0f, 98.0f, 54.0f, 3.0f, 7.0f, 7.0f, 3.0f, 4.0f, 8.0f, 6.0f, 2.0f, 0.0f, 5.0f, 9.0f, 5.0f};
    final Matrix4f m1T = new Matrix4f(this.m1T_0);
    final float[] m2_0 = new float[]{1.0f, 6.0f, 98.0f, 54.0f, 3.0f, 7.0f, 7.0f, 3.0f, 4.0f, 8.0f, 6.0f, 2.0f, 0.0f, 5.0f, 9.0f, 5.0f};
    final Matrix4f m2 = new Matrix4f(this.m2_0);
    final float[] m2xm1_0 = new float[]{26.0f, 59.0f, 143.0f, 71.0f, 59.0f, 174.0f, 730.0f, 386.0f, 143.0f, 730.0f, 9770.0f, 5370.0f, 71.0f, 386.0f, 5370.0f, 2954.0f};
    final Matrix4f m2xm1 = new Matrix4f(this.m2xm1_0);
    final float[] m1xm2_0 = new float[]{12557.0f, 893.0f, 748.0f, 1182.0f, 893.0f, 116.0f, 116.0f, 113.0f, 748.0f, 116.0f, 120.0f, 104.0f, 1182.0f, 113.0f, 104.0f, 131.0f};
    final Matrix4f m1xm2 = new Matrix4f(this.m1xm2_0);

    @Test
    public void test00_load_get() {
        Object object = new Matrix4f();
        Assert.assertEquals(this.mI, object);
        object = new float[16];
        this.m1.get((float[])object);
        Assert.assertArrayEquals(this.m1_0, (float[])object, 1.1920929E-7f);
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.load((float[])object);
        Assert.assertEquals(this.m1, matrix4f);
    }

    @Test
    public void test01_mul() {
        float[] fArray = new float[16];
        FloatUtil.multMatrix(this.m1_0, 0, this.m2_0, 0, fArray, 0);
        Assert.assertArrayEquals(this.m1xm2_0, fArray, 0.0f);
        Assert.assertEquals(this.m1xm2, new Matrix4f(this.m1).mul(this.m2));
        Assert.assertEquals(this.m1xm2, new Matrix4f().mul(this.m1, this.m2));
        fArray = new float[16];
        FloatUtil.multMatrix(this.m2_0, 0, this.m1_0, 0, fArray, 0);
        Assert.assertArrayEquals(this.m2xm1_0, fArray, 0.0f);
        Assert.assertEquals(this.m2xm1, new Matrix4f(this.m2).mul(this.m1));
        Assert.assertEquals(this.m2xm1, new Matrix4f().mul(this.m2, this.m1));
    }

    @Test
    public void test02_transpose() {
        Assert.assertEquals(this.m1T, new Matrix4f(this.m1).transpose());
        Assert.assertEquals(this.m1T, new Matrix4f().transpose(this.m1));
    }

    @Test
    public void test80LookAtNegZIsNoOp() throws Exception {
        Matrix4f matrix4f = new Matrix4f();
        Matrix4f matrix4f2 = new Matrix4f();
        matrix4f2.setToLookAt(new Vec3f(0.0f, 0.0f, 0.0f), new Vec3f(0.0f, 0.0f, -1.0f), new Vec3f(0.0f, 1.0f, 0.0f), matrix4f);
        Matrix4f matrix4f3 = new Matrix4f(new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f});
        Assert.assertEquals(matrix4f3, matrix4f2);
    }

    @Test
    public void test81LookAtPosY() throws Exception {
        Matrix4f matrix4f = new Matrix4f();
        Matrix4f matrix4f2 = new Matrix4f();
        matrix4f2.setToLookAt(new Vec3f(0.0f, 0.0f, 0.0f), new Vec3f(0.0f, 1.0f, 0.0f), new Vec3f(0.0f, 0.0f, 1.0f), matrix4f);
        Matrix4f matrix4f3 = new Matrix4f(new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f});
        Assert.assertEquals(matrix4f3, matrix4f2);
    }

    public static void main(String[] stringArray) {
        JUnitCore.main(TestMatrix4f01NOUI.class.getName());
    }
}

