/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.math;

import com.jogamp.math.FloatUtil;
import com.jogamp.math.FovHVHalves;
import com.jogamp.math.Quaternion;
import com.jogamp.math.Ray;
import com.jogamp.math.Vec3f;
import com.jogamp.math.Vec4f;
import com.jogamp.math.VectorUtil;
import com.jogamp.math.geom.Frustum;
import java.nio.FloatBuffer;

public class Matrix4fb {
    private final float[] m = new float[16];
    final Stack stack = new Stack(0, 256);

    public Matrix4fb() {
        this.loadIdentity();
    }

    public Matrix4fb(Matrix4fb matrix4fb) {
        this.load(matrix4fb);
    }

    public Matrix4fb(float[] fArray) {
        this.load(fArray);
    }

    public Matrix4fb(float[] fArray, int n) {
        this.load(fArray, n);
    }

    public final Matrix4fb loadIdentity() {
        this.m[15] = 1.0f;
        this.m[10] = 1.0f;
        this.m[5] = 1.0f;
        this.m[0] = 1.0f;
        this.m[11] = 0.0f;
        this.m[7] = 0.0f;
        this.m[3] = 0.0f;
        this.m[14] = 0.0f;
        this.m[6] = 0.0f;
        this.m[2] = 0.0f;
        this.m[13] = 0.0f;
        this.m[9] = 0.0f;
        this.m[1] = 0.0f;
        this.m[12] = 0.0f;
        this.m[8] = 0.0f;
        this.m[4] = 0.0f;
        return this;
    }

    public Matrix4fb load(Matrix4fb matrix4fb) {
        System.arraycopy(matrix4fb.m, 0, this.m, 0, 16);
        return this;
    }

    public Matrix4fb load(float[] fArray) {
        System.arraycopy(fArray, 0, this.m, 0, 16);
        return this;
    }

    public Matrix4fb load(float[] fArray, int n) {
        System.arraycopy(fArray, n, this.m, 0, 16);
        return this;
    }

    public Matrix4fb load(FloatBuffer floatBuffer) {
        floatBuffer.get(this.m, 0, 16);
        return this;
    }

    public float get(int n) {
        return this.m[n];
    }

    public Vec4f getColumn(int n, Vec4f vec4f) {
        vec4f.set(this.get(0 + n * 4), this.get(1 + n * 4), this.get(2 + n * 4), this.get(3 + n * 4));
        return vec4f;
    }

    public Vec3f getColumn(int n, Vec3f vec3f) {
        vec3f.set(this.get(0 + n * 4), this.get(1 + n * 4), this.get(2 + n * 4));
        return vec3f;
    }

    public Vec4f getRow(int n, Vec4f vec4f) {
        vec4f.set(this.get(n + 0), this.get(n + 4), this.get(n + 8), this.get(n + 12));
        return vec4f;
    }

    public Vec3f getRow(int n, Vec3f vec3f) {
        vec3f.set(this.get(n + 0), this.get(n + 4), this.get(n + 8));
        return vec3f;
    }

    public float[] get(float[] fArray, int n) {
        System.arraycopy(this.m, 0, fArray, n, 16);
        return fArray;
    }

    public float[] get(float[] fArray) {
        System.arraycopy(this.m, 0, fArray, 0, 16);
        return fArray;
    }

    public FloatBuffer get(FloatBuffer floatBuffer) {
        floatBuffer.put(this.m, 0, 16);
        return floatBuffer;
    }

    public float determinant() {
        float f = 0.0f;
        f += this.m[0] * (this.m[5] * (this.m[10] * this.m[15] - this.m[14] * this.m[11]) - this.m[9] * (this.m[6] * this.m[15] - this.m[14] * this.m[7]) + this.m[13] * (this.m[6] * this.m[11] - this.m[10] * this.m[7]));
        f -= this.m[4] * (this.m[1] * (this.m[10] * this.m[15] - this.m[14] * this.m[11]) - this.m[9] * (this.m[2] * this.m[15] - this.m[14] * this.m[3]) + this.m[13] * (this.m[2] * this.m[11] - this.m[10] * this.m[3]));
        f += this.m[8] * (this.m[1] * (this.m[6] * this.m[15] - this.m[14] * this.m[7]) - this.m[5] * (this.m[2] * this.m[15] - this.m[14] * this.m[3]) + this.m[13] * (this.m[2] * this.m[7] - this.m[6] * this.m[3]));
        return f -= this.m[12] * (this.m[1] * (this.m[6] * this.m[11] - this.m[10] * this.m[7]) - this.m[5] * (this.m[2] * this.m[11] - this.m[10] * this.m[3]) + this.m[9] * (this.m[2] * this.m[7] - this.m[6] * this.m[3]));
    }

    public final Matrix4fb transpose() {
        float f = this.m[1];
        this.m[1] = this.m[4];
        this.m[4] = f;
        f = this.m[2];
        this.m[2] = this.m[8];
        this.m[8] = f;
        f = this.m[3];
        this.m[3] = this.m[12];
        this.m[12] = f;
        f = this.m[6];
        this.m[6] = this.m[9];
        this.m[9] = f;
        f = this.m[7];
        this.m[7] = this.m[13];
        this.m[13] = f;
        f = this.m[11];
        this.m[11] = this.m[14];
        this.m[14] = f;
        return this;
    }

    public final Matrix4fb transpose(Matrix4fb matrix4fb) {
        if (matrix4fb == this) {
            return this.transpose();
        }
        this.m[0] = matrix4fb.m[0];
        this.m[1] = matrix4fb.m[4];
        this.m[2] = matrix4fb.m[8];
        this.m[3] = matrix4fb.m[12];
        this.m[4] = matrix4fb.m[1];
        this.m[5] = matrix4fb.m[5];
        this.m[6] = matrix4fb.m[9];
        this.m[7] = matrix4fb.m[13];
        this.m[8] = matrix4fb.m[2];
        this.m[9] = matrix4fb.m[6];
        this.m[10] = matrix4fb.m[10];
        this.m[11] = matrix4fb.m[14];
        this.m[12] = matrix4fb.m[3];
        this.m[13] = matrix4fb.m[7];
        this.m[14] = matrix4fb.m[11];
        this.m[15] = matrix4fb.m[15];
        return this;
    }

    public boolean invert() {
        float f;
        float f2 = Math.abs(this.m[0]);
        for (int i = 1; i < 16; ++i) {
            f = Math.abs(this.m[i]);
            if (!(f > f2)) continue;
            f2 = f;
        }
        if (0.0f == f2) {
            return false;
        }
        float f3 = 1.0f / f2;
        f2 = this.m[0] * f3;
        float f4 = this.m[1] * f3;
        f = this.m[2] * f3;
        float f5 = this.m[3] * f3;
        float f6 = this.m[4] * f3;
        float f7 = this.m[5] * f3;
        float f8 = this.m[6] * f3;
        float f9 = this.m[7] * f3;
        float f10 = this.m[8] * f3;
        float f11 = this.m[9] * f3;
        float f12 = this.m[10] * f3;
        float f13 = this.m[11] * f3;
        float f14 = this.m[12] * f3;
        float f15 = this.m[13] * f3;
        float f16 = this.m[14] * f3;
        float f17 = this.m[15] * f3;
        float f18 = f7 * (f12 * f17 - f16 * f13) - f11 * (f8 * f17 - f16 * f9) + f15 * (f8 * f13 - f12 * f9);
        float f19 = -(f4 * (f12 * f17 - f16 * f13) - f11 * (f * f17 - f16 * f5) + f15 * (f * f13 - f12 * f5));
        float f20 = f4 * (f8 * f17 - f16 * f9) - f7 * (f * f17 - f16 * f5) + f15 * (f * f9 - f8 * f5);
        float f21 = -(f4 * (f8 * f13 - f12 * f9) - f7 * (f * f13 - f12 * f5) + f11 * (f * f9 - f8 * f5));
        float f22 = -(f6 * (f12 * f17 - f16 * f13) - f10 * (f8 * f17 - f16 * f9) + f14 * (f8 * f13 - f12 * f9));
        float f23 = f2 * (f12 * f17 - f16 * f13) - f10 * (f * f17 - f16 * f5) + f14 * (f * f13 - f12 * f5);
        float f24 = -(f2 * (f8 * f17 - f16 * f9) - f6 * (f * f17 - f16 * f5) + f14 * (f * f9 - f8 * f5));
        float f25 = f2 * (f8 * f13 - f12 * f9) - f6 * (f * f13 - f12 * f5) + f10 * (f * f9 - f8 * f5);
        float f26 = f6 * (f11 * f17 - f15 * f13) - f10 * (f7 * f17 - f15 * f9) + f14 * (f7 * f13 - f11 * f9);
        float f27 = -(f2 * (f11 * f17 - f15 * f13) - f10 * (f4 * f17 - f15 * f5) + f14 * (f4 * f13 - f11 * f5));
        float f28 = f2 * (f7 * f17 - f15 * f9) - f6 * (f4 * f17 - f15 * f5) + f14 * (f4 * f9 - f7 * f5);
        float f29 = -(f2 * (f7 * f13 - f11 * f9) - f6 * (f4 * f13 - f11 * f5) + f10 * (f4 * f9 - f7 * f5));
        float f30 = -(f6 * (f11 * f16 - f15 * f12) - f10 * (f7 * f16 - f15 * f8) + f14 * (f7 * f12 - f11 * f8));
        float f31 = f2 * (f11 * f16 - f15 * f12) - f10 * (f4 * f16 - f15 * f) + f14 * (f4 * f12 - f11 * f);
        float f32 = -(f2 * (f7 * f16 - f15 * f8) - f6 * (f4 * f16 - f15 * f) + f14 * (f4 * f8 - f7 * f));
        float f33 = f2 * (f7 * f12 - f11 * f8) - f6 * (f4 * f12 - f11 * f) + f10 * (f4 * f8 - f7 * f);
        float f34 = (f2 * f18 + f6 * f19 + f10 * f20 + f14 * f21) / f3;
        if (0.0f == f34) {
            return false;
        }
        float f35 = 1.0f / f34;
        this.m[0] = f18 * f35;
        this.m[1] = f19 * f35;
        this.m[2] = f20 * f35;
        this.m[3] = f21 * f35;
        this.m[4] = f22 * f35;
        this.m[5] = f23 * f35;
        this.m[6] = f24 * f35;
        this.m[7] = f25 * f35;
        this.m[8] = f26 * f35;
        this.m[9] = f27 * f35;
        this.m[10] = f28 * f35;
        this.m[11] = f29 * f35;
        this.m[12] = f30 * f35;
        this.m[13] = f31 * f35;
        this.m[14] = f32 * f35;
        this.m[15] = f33 * f35;
        return true;
    }

    public boolean invert(Matrix4fb matrix4fb) {
        float f;
        float f2 = Math.abs(matrix4fb.m[0]);
        for (int i = 1; i < 16; ++i) {
            f = Math.abs(matrix4fb.m[i]);
            if (!(f > f2)) continue;
            f2 = f;
        }
        if (0.0f == f2) {
            return false;
        }
        float f3 = 1.0f / f2;
        f2 = matrix4fb.m[0] * f3;
        float f4 = matrix4fb.m[1] * f3;
        f = matrix4fb.m[2] * f3;
        float f5 = matrix4fb.m[3] * f3;
        float f6 = matrix4fb.m[4] * f3;
        float f7 = matrix4fb.m[5] * f3;
        float f8 = matrix4fb.m[6] * f3;
        float f9 = matrix4fb.m[7] * f3;
        float f10 = matrix4fb.m[8] * f3;
        float f11 = matrix4fb.m[9] * f3;
        float f12 = matrix4fb.m[10] * f3;
        float f13 = matrix4fb.m[11] * f3;
        float f14 = matrix4fb.m[12] * f3;
        float f15 = matrix4fb.m[13] * f3;
        float f16 = matrix4fb.m[14] * f3;
        float f17 = matrix4fb.m[15] * f3;
        float f18 = f7 * (f12 * f17 - f16 * f13) - f11 * (f8 * f17 - f16 * f9) + f15 * (f8 * f13 - f12 * f9);
        float f19 = -(f4 * (f12 * f17 - f16 * f13) - f11 * (f * f17 - f16 * f5) + f15 * (f * f13 - f12 * f5));
        float f20 = f4 * (f8 * f17 - f16 * f9) - f7 * (f * f17 - f16 * f5) + f15 * (f * f9 - f8 * f5);
        float f21 = -(f4 * (f8 * f13 - f12 * f9) - f7 * (f * f13 - f12 * f5) + f11 * (f * f9 - f8 * f5));
        float f22 = -(f6 * (f12 * f17 - f16 * f13) - f10 * (f8 * f17 - f16 * f9) + f14 * (f8 * f13 - f12 * f9));
        float f23 = f2 * (f12 * f17 - f16 * f13) - f10 * (f * f17 - f16 * f5) + f14 * (f * f13 - f12 * f5);
        float f24 = -(f2 * (f8 * f17 - f16 * f9) - f6 * (f * f17 - f16 * f5) + f14 * (f * f9 - f8 * f5));
        float f25 = f2 * (f8 * f13 - f12 * f9) - f6 * (f * f13 - f12 * f5) + f10 * (f * f9 - f8 * f5);
        float f26 = f6 * (f11 * f17 - f15 * f13) - f10 * (f7 * f17 - f15 * f9) + f14 * (f7 * f13 - f11 * f9);
        float f27 = -(f2 * (f11 * f17 - f15 * f13) - f10 * (f4 * f17 - f15 * f5) + f14 * (f4 * f13 - f11 * f5));
        float f28 = f2 * (f7 * f17 - f15 * f9) - f6 * (f4 * f17 - f15 * f5) + f14 * (f4 * f9 - f7 * f5);
        float f29 = -(f2 * (f7 * f13 - f11 * f9) - f6 * (f4 * f13 - f11 * f5) + f10 * (f4 * f9 - f7 * f5));
        float f30 = -(f6 * (f11 * f16 - f15 * f12) - f10 * (f7 * f16 - f15 * f8) + f14 * (f7 * f12 - f11 * f8));
        float f31 = f2 * (f11 * f16 - f15 * f12) - f10 * (f4 * f16 - f15 * f) + f14 * (f4 * f12 - f11 * f);
        float f32 = -(f2 * (f7 * f16 - f15 * f8) - f6 * (f4 * f16 - f15 * f) + f14 * (f4 * f8 - f7 * f));
        float f33 = f2 * (f7 * f12 - f11 * f8) - f6 * (f4 * f12 - f11 * f) + f10 * (f4 * f8 - f7 * f);
        float f34 = (f2 * f18 + f6 * f19 + f10 * f20 + f14 * f21) / f3;
        if (0.0f == f34) {
            return false;
        }
        float f35 = 1.0f / f34;
        this.m[0] = f18 * f35;
        this.m[1] = f19 * f35;
        this.m[2] = f20 * f35;
        this.m[3] = f21 * f35;
        this.m[4] = f22 * f35;
        this.m[5] = f23 * f35;
        this.m[6] = f24 * f35;
        this.m[7] = f25 * f35;
        this.m[8] = f26 * f35;
        this.m[9] = f27 * f35;
        this.m[10] = f28 * f35;
        this.m[11] = f29 * f35;
        this.m[12] = f30 * f35;
        this.m[13] = f31 * f35;
        this.m[14] = f32 * f35;
        this.m[15] = f33 * f35;
        return true;
    }

    public final Matrix4fb mul(Matrix4fb matrix4fb) {
        float f = matrix4fb.m[0];
        float f2 = matrix4fb.m[1];
        float f3 = matrix4fb.m[2];
        float f4 = matrix4fb.m[3];
        float f5 = matrix4fb.m[4];
        float f6 = matrix4fb.m[5];
        float f7 = matrix4fb.m[6];
        float f8 = matrix4fb.m[7];
        float f9 = matrix4fb.m[8];
        float f10 = matrix4fb.m[9];
        float f11 = matrix4fb.m[10];
        float f12 = matrix4fb.m[11];
        float f13 = matrix4fb.m[12];
        float f14 = matrix4fb.m[13];
        float f15 = matrix4fb.m[14];
        float f16 = matrix4fb.m[15];
        float f17 = this.m[0];
        float f18 = this.m[4];
        float f19 = this.m[8];
        float f20 = this.m[12];
        this.m[0] = f17 * f + f18 * f2 + f19 * f3 + f20 * f4;
        this.m[4] = f17 * f5 + f18 * f6 + f19 * f7 + f20 * f8;
        this.m[8] = f17 * f9 + f18 * f10 + f19 * f11 + f20 * f12;
        this.m[12] = f17 * f13 + f18 * f14 + f19 * f15 + f20 * f16;
        f17 = this.m[1];
        f18 = this.m[5];
        f19 = this.m[9];
        f20 = this.m[13];
        this.m[1] = f17 * f + f18 * f2 + f19 * f3 + f20 * f4;
        this.m[5] = f17 * f5 + f18 * f6 + f19 * f7 + f20 * f8;
        this.m[9] = f17 * f9 + f18 * f10 + f19 * f11 + f20 * f12;
        this.m[13] = f17 * f13 + f18 * f14 + f19 * f15 + f20 * f16;
        f17 = this.m[2];
        f18 = this.m[6];
        f19 = this.m[10];
        f20 = this.m[14];
        this.m[2] = f17 * f + f18 * f2 + f19 * f3 + f20 * f4;
        this.m[6] = f17 * f5 + f18 * f6 + f19 * f7 + f20 * f8;
        this.m[10] = f17 * f9 + f18 * f10 + f19 * f11 + f20 * f12;
        this.m[14] = f17 * f13 + f18 * f14 + f19 * f15 + f20 * f16;
        f17 = this.m[3];
        f18 = this.m[7];
        f19 = this.m[11];
        f20 = this.m[15];
        this.m[3] = f17 * f + f18 * f2 + f19 * f3 + f20 * f4;
        this.m[7] = f17 * f5 + f18 * f6 + f19 * f7 + f20 * f8;
        this.m[11] = f17 * f9 + f18 * f10 + f19 * f11 + f20 * f12;
        this.m[15] = f17 * f13 + f18 * f14 + f19 * f15 + f20 * f16;
        return this;
    }

    public final Matrix4fb mul(Matrix4fb matrix4fb, Matrix4fb matrix4fb2) {
        float f = matrix4fb2.m[0];
        float f2 = matrix4fb2.m[1];
        float f3 = matrix4fb2.m[2];
        float f4 = matrix4fb2.m[3];
        float f5 = matrix4fb2.m[4];
        float f6 = matrix4fb2.m[5];
        float f7 = matrix4fb2.m[6];
        float f8 = matrix4fb2.m[7];
        float f9 = matrix4fb2.m[8];
        float f10 = matrix4fb2.m[9];
        float f11 = matrix4fb2.m[10];
        float f12 = matrix4fb2.m[11];
        float f13 = matrix4fb2.m[12];
        float f14 = matrix4fb2.m[13];
        float f15 = matrix4fb2.m[14];
        float f16 = matrix4fb2.m[15];
        float f17 = matrix4fb.m[0];
        float f18 = matrix4fb.m[4];
        float f19 = matrix4fb.m[8];
        float f20 = matrix4fb.m[12];
        this.m[0] = f17 * f + f18 * f2 + f19 * f3 + f20 * f4;
        this.m[4] = f17 * f5 + f18 * f6 + f19 * f7 + f20 * f8;
        this.m[8] = f17 * f9 + f18 * f10 + f19 * f11 + f20 * f12;
        this.m[12] = f17 * f13 + f18 * f14 + f19 * f15 + f20 * f16;
        f17 = matrix4fb.m[1];
        f18 = matrix4fb.m[5];
        f19 = matrix4fb.m[9];
        f20 = matrix4fb.m[13];
        this.m[1] = f17 * f + f18 * f2 + f19 * f3 + f20 * f4;
        this.m[5] = f17 * f5 + f18 * f6 + f19 * f7 + f20 * f8;
        this.m[9] = f17 * f9 + f18 * f10 + f19 * f11 + f20 * f12;
        this.m[13] = f17 * f13 + f18 * f14 + f19 * f15 + f20 * f16;
        f17 = matrix4fb.m[2];
        f18 = matrix4fb.m[6];
        f19 = matrix4fb.m[10];
        f20 = matrix4fb.m[14];
        this.m[2] = f17 * f + f18 * f2 + f19 * f3 + f20 * f4;
        this.m[6] = f17 * f5 + f18 * f6 + f19 * f7 + f20 * f8;
        this.m[10] = f17 * f9 + f18 * f10 + f19 * f11 + f20 * f12;
        this.m[14] = f17 * f13 + f18 * f14 + f19 * f15 + f20 * f16;
        f17 = matrix4fb.m[3];
        f18 = matrix4fb.m[7];
        f19 = matrix4fb.m[11];
        f20 = matrix4fb.m[15];
        this.m[3] = f17 * f + f18 * f2 + f19 * f3 + f20 * f4;
        this.m[7] = f17 * f5 + f18 * f6 + f19 * f7 + f20 * f8;
        this.m[11] = f17 * f9 + f18 * f10 + f19 * f11 + f20 * f12;
        this.m[15] = f17 * f13 + f18 * f14 + f19 * f15 + f20 * f16;
        return this;
    }

    public final float[] mulVec4f(float[] fArray, float[] fArray2) {
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = fArray[2];
        float f4 = fArray[3];
        fArray2[0] = f * this.m[0] + f2 * this.m[4] + f3 * this.m[8] + f4 * this.m[12];
        fArray2[1] = f * this.m[1] + f2 * this.m[5] + f3 * this.m[9] + f4 * this.m[13];
        fArray2[2] = f * this.m[2] + f2 * this.m[6] + f3 * this.m[10] + f4 * this.m[14];
        fArray2[3] = f * this.m[3] + f2 * this.m[7] + f3 * this.m[11] + f4 * this.m[15];
        return fArray2;
    }

    public final Vec4f mulVec4f(Vec4f vec4f, Vec4f vec4f2) {
        float f = vec4f.x();
        float f2 = vec4f.y();
        float f3 = vec4f.z();
        float f4 = vec4f.w();
        vec4f2.set(f * this.m[0] + f2 * this.m[4] + f3 * this.m[8] + f4 * this.m[12], f * this.m[1] + f2 * this.m[5] + f3 * this.m[9] + f4 * this.m[13], f * this.m[2] + f2 * this.m[6] + f3 * this.m[10] + f4 * this.m[14], f * this.m[3] + f2 * this.m[7] + f3 * this.m[11] + f4 * this.m[15]);
        return vec4f2;
    }

    public final float[] mulVec3f(float[] fArray, float[] fArray2) {
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = fArray[2];
        fArray2[0] = f * this.m[0] + f2 * this.m[4] + f3 * this.m[8] + 1.0f * this.m[12];
        fArray2[1] = f * this.m[1] + f2 * this.m[5] + f3 * this.m[9] + 1.0f * this.m[13];
        fArray2[2] = f * this.m[2] + f2 * this.m[6] + f3 * this.m[10] + 1.0f * this.m[14];
        return fArray2;
    }

    public final Vec3f mulVec3f(Vec3f vec3f, Vec3f vec3f2) {
        float f = vec3f.x();
        float f2 = vec3f.y();
        float f3 = vec3f.z();
        vec3f2.set(f * this.m[0] + f2 * this.m[4] + f3 * this.m[8] + 1.0f * this.m[12], f * this.m[1] + f2 * this.m[5] + f3 * this.m[9] + 1.0f * this.m[13], f * this.m[2] + f2 * this.m[6] + f3 * this.m[10] + 1.0f * this.m[14]);
        return vec3f2;
    }

    public final Matrix4fb setToTranslation(float f, float f2, float f3) {
        this.m[15] = 1.0f;
        this.m[10] = 1.0f;
        this.m[5] = 1.0f;
        this.m[0] = 1.0f;
        this.m[12] = f;
        this.m[13] = f2;
        this.m[14] = f3;
        this.m[11] = 0.0f;
        this.m[7] = 0.0f;
        this.m[3] = 0.0f;
        this.m[6] = 0.0f;
        this.m[2] = 0.0f;
        this.m[9] = 0.0f;
        this.m[1] = 0.0f;
        this.m[8] = 0.0f;
        this.m[4] = 0.0f;
        return this;
    }

    public final Matrix4fb setToTranslation(Vec3f vec3f) {
        return this.setToTranslation(vec3f.x(), vec3f.y(), vec3f.z());
    }

    public final Matrix4fb setToScale(float f, float f2, float f3) {
        this.m[15] = 1.0f;
        this.m[0] = f;
        this.m[5] = f2;
        this.m[10] = f3;
        this.m[11] = 0.0f;
        this.m[7] = 0.0f;
        this.m[3] = 0.0f;
        this.m[14] = 0.0f;
        this.m[6] = 0.0f;
        this.m[2] = 0.0f;
        this.m[13] = 0.0f;
        this.m[9] = 0.0f;
        this.m[1] = 0.0f;
        this.m[12] = 0.0f;
        this.m[8] = 0.0f;
        this.m[4] = 0.0f;
        return this;
    }

    public final Matrix4fb setToRotationAxis(float f, float f2, float f3, float f4) {
        float f5 = FloatUtil.cos(f);
        float f6 = 1.0f - f5;
        float f7 = FloatUtil.sin(f);
        float[] fArray = new float[]{f2, f3, f4};
        VectorUtil.normalizeVec3(fArray);
        f2 = fArray[0];
        f3 = fArray[1];
        f4 = fArray[2];
        float f8 = f2 * f3;
        float f9 = f2 * f4;
        float f10 = f2 * f7;
        float f11 = f3 * f7;
        float f12 = f3 * f4;
        float f13 = f4 * f7;
        this.m[0] = f2 * f2 * f6 + f5;
        this.m[1] = f8 * f6 + f13;
        this.m[2] = f9 * f6 - f11;
        this.m[3] = 0.0f;
        this.m[4] = f8 * f6 - f13;
        this.m[5] = f3 * f3 * f6 + f5;
        this.m[6] = f12 * f6 + f10;
        this.m[7] = 0.0f;
        this.m[8] = f9 * f6 + f11;
        this.m[9] = f12 * f6 - f10;
        this.m[10] = f4 * f4 * f6 + f5;
        this.m[11] = 0.0f;
        this.m[12] = 0.0f;
        this.m[13] = 0.0f;
        this.m[14] = 0.0f;
        this.m[15] = 1.0f;
        return this;
    }

    public final Matrix4fb setToRotationAxis(float f, Vec3f vec3f) {
        return this.setToRotationAxis(f, vec3f.x(), vec3f.y(), vec3f.z());
    }

    public Matrix4fb setToRotationEuler(float f, float f2, float f3) {
        float f4 = FloatUtil.cos(f2);
        float f5 = FloatUtil.sin(f2);
        float f6 = FloatUtil.cos(f3);
        float f7 = FloatUtil.sin(f3);
        float f8 = FloatUtil.cos(f);
        float f9 = FloatUtil.sin(f);
        this.m[0] = f4 * f6;
        this.m[1] = f7;
        this.m[2] = -f5 * f6;
        this.m[3] = 0.0f;
        this.m[4] = f5 * f9 - f4 * f7 * f8;
        this.m[5] = f6 * f8;
        this.m[6] = f5 * f7 * f8 + f4 * f9;
        this.m[7] = 0.0f;
        this.m[8] = f4 * f7 * f9 + f5 * f8;
        this.m[9] = -f6 * f9;
        this.m[10] = -f5 * f7 * f9 + f4 * f8;
        this.m[11] = 0.0f;
        this.m[12] = 0.0f;
        this.m[13] = 0.0f;
        this.m[14] = 0.0f;
        this.m[15] = 1.0f;
        return this;
    }

    public final Matrix4fb setToRotation(Quaternion quaternion) {
        float f = quaternion.magnitudeSquared();
        if (FloatUtil.isZero(f)) {
            this.loadIdentity();
            return this;
        }
        float f2 = FloatUtil.isEqual(1.0f, f) ? 2.0f : 2.0f / f;
        float f3 = quaternion.x();
        float f4 = quaternion.y();
        float f5 = quaternion.z();
        float f6 = quaternion.w();
        float f7 = f2 * f3;
        float f8 = f2 * f4;
        float f9 = f2 * f5;
        float f10 = f3 * f7;
        float f11 = f3 * f8;
        float f12 = f3 * f9;
        float f13 = f7 * f6;
        float f14 = f4 * f8;
        float f15 = f4 * f9;
        float f16 = f8 * f6;
        float f17 = f5 * f9;
        float f18 = f9 * f6;
        this.m[0] = 1.0f - (f14 + f17);
        this.m[4] = f11 - f18;
        this.m[8] = f12 + f16;
        this.m[12] = 0.0f;
        this.m[1] = f11 + f18;
        this.m[5] = 1.0f - (f10 + f17);
        this.m[9] = f15 - f13;
        this.m[13] = 0.0f;
        this.m[2] = f12 - f16;
        this.m[6] = f15 + f13;
        this.m[10] = 1.0f - (f10 + f14);
        this.m[14] = 0.0f;
        this.m[11] = 0.0f;
        this.m[7] = 0.0f;
        this.m[3] = 0.0f;
        this.m[15] = 1.0f;
        return this;
    }

    public final Quaternion getRotation(Quaternion quaternion) {
        quaternion.setFromMat(this.m[0], this.m[4], this.m[8], this.m[1], this.m[5], this.m[9], this.m[2], this.m[6], this.m[10]);
        return quaternion;
    }

    public Matrix4fb setToOrtho(float f, float f2, float f3, float f4, float f5, float f6) {
        this.m[3] = 0.0f;
        this.m[2] = 0.0f;
        this.m[1] = 0.0f;
        this.m[7] = 0.0f;
        this.m[6] = 0.0f;
        this.m[4] = 0.0f;
        this.m[11] = 0.0f;
        this.m[9] = 0.0f;
        this.m[8] = 0.0f;
        float f7 = f2 - f;
        float f8 = f4 - f3;
        float f9 = f6 - f5;
        float f10 = -1.0f * (f2 + f) / f7;
        float f11 = -1.0f * (f4 + f3) / f8;
        float f12 = -1.0f * (f6 + f5) / f9;
        this.m[0] = 2.0f / f7;
        this.m[5] = 2.0f / f8;
        this.m[10] = -2.0f / f9;
        this.m[12] = f10;
        this.m[13] = f11;
        this.m[14] = f12;
        this.m[15] = 1.0f;
        return this;
    }

    public Matrix4fb setToFrustum(float f, float f2, float f3, float f4, float f5, float f6) throws IllegalArgumentException {
        if (f5 <= 0.0f || f6 <= f5) {
            throw new IllegalArgumentException("Requirements zNear > 0 and zFar > zNear, but zNear " + f5 + ", zFar " + f6);
        }
        if (f == f2 || f4 == f3) {
            throw new IllegalArgumentException("GL_INVALID_VALUE: top,bottom and left,right must not be equal");
        }
        this.m[3] = 0.0f;
        this.m[2] = 0.0f;
        this.m[1] = 0.0f;
        this.m[7] = 0.0f;
        this.m[6] = 0.0f;
        this.m[4] = 0.0f;
        this.m[13] = 0.0f;
        this.m[12] = 0.0f;
        float f7 = 2.0f * f5;
        float f8 = f2 - f;
        float f9 = f4 - f3;
        float f10 = f6 - f5;
        float f11 = (f2 + f) / f8;
        float f12 = (f4 + f3) / f9;
        float f13 = -1.0f * (f6 + f5) / f10;
        float f14 = -2.0f * (f6 * f5) / f10;
        this.m[0] = f7 / f8;
        this.m[5] = f7 / f9;
        this.m[8] = f11;
        this.m[9] = f12;
        this.m[10] = f13;
        this.m[11] = -1.0f;
        this.m[14] = f14;
        this.m[15] = 0.0f;
        return this;
    }

    public Matrix4fb setToPerspective(float f, float f2, float f3, float f4) throws IllegalArgumentException {
        float f5 = FloatUtil.tan(f / 2.0f) * f3;
        float f6 = -1.0f * f5;
        float f7 = f2 * f6;
        float f8 = f2 * f5;
        return this.setToFrustum(f7, f8, f6, f5, f3, f4);
    }

    public Matrix4fb setToPerspective(FovHVHalves fovHVHalves, float f, float f2) throws IllegalArgumentException {
        FovHVHalves fovHVHalves2 = fovHVHalves.toTangents();
        float f3 = fovHVHalves2.top * f;
        float f4 = -1.0f * fovHVHalves2.bottom * f;
        float f5 = -1.0f * fovHVHalves2.left * f;
        float f6 = fovHVHalves2.right * f;
        return this.setToFrustum(f5, f6, f4, f3, f, f2);
    }

    public void updateFrustumPlanes(Frustum frustum) {
        Frustum.Plane plane = frustum.getPlanes()[0];
        Object object = plane.n;
        ((Vec3f)object).set(this.m[3] + this.m[0], this.m[7] + this.m[4], this.m[11] + this.m[8]);
        plane.d = this.m[15] + this.m[12];
        plane = frustum.getPlanes()[1];
        object = plane.n;
        ((Vec3f)object).set(this.m[3] - this.m[0], this.m[7] - this.m[4], this.m[11] - this.m[8]);
        plane.d = this.m[15] - this.m[12];
        plane = frustum.getPlanes()[2];
        object = plane.n;
        ((Vec3f)object).set(this.m[3] + this.m[1], this.m[7] + this.m[5], this.m[11] + this.m[9]);
        plane.d = this.m[15] + this.m[13];
        plane = frustum.getPlanes()[3];
        object = plane.n;
        ((Vec3f)object).set(this.m[3] - this.m[1], this.m[7] - this.m[5], this.m[11] - this.m[9]);
        plane.d = this.m[15] - this.m[13];
        plane = frustum.getPlanes()[4];
        object = plane.n;
        ((Vec3f)object).set(this.m[3] + this.m[2], this.m[7] + this.m[6], this.m[11] + this.m[10]);
        plane.d = this.m[15] + this.m[14];
        plane = frustum.getPlanes()[5];
        object = plane.n;
        ((Vec3f)object).set(this.m[3] - this.m[2], this.m[7] - this.m[6], this.m[11] - this.m[10]);
        plane.d = this.m[15] - this.m[14];
        for (int i = 0; i < 6; ++i) {
            object = frustum.getPlanes()[i];
            Vec3f vec3f = ((Frustum.Plane)object).n;
            float f = 1.0f / vec3f.length();
            vec3f.scale(f);
            ((Frustum.Plane)object).d *= f;
        }
    }

    public Matrix4fb setToLookAt(Vec3f vec3f, Vec3f vec3f2, Vec3f vec3f3, Matrix4fb matrix4fb) {
        Vec3f vec3f4 = new Vec3f(vec3f2.x() - vec3f.x(), vec3f2.y() - vec3f.y(), vec3f2.z() - vec3f.z()).normalize();
        Vec3f vec3f5 = vec3f4.cross(vec3f3).normalize();
        Vec3f vec3f6 = vec3f5.cross(vec3f4);
        this.m[0] = vec3f5.x();
        this.m[1] = vec3f6.x();
        this.m[2] = -vec3f4.x();
        this.m[3] = 0.0f;
        this.m[4] = vec3f5.y();
        this.m[5] = vec3f6.y();
        this.m[6] = -vec3f4.y();
        this.m[7] = 0.0f;
        this.m[8] = vec3f5.z();
        this.m[9] = vec3f6.z();
        this.m[10] = -vec3f4.z();
        this.m[11] = 0.0f;
        this.m[12] = 0.0f;
        this.m[13] = 0.0f;
        this.m[14] = 0.0f;
        this.m[15] = 1.0f;
        return this.mul(matrix4fb.setToTranslation(-vec3f.x(), -vec3f.y(), -vec3f.z()));
    }

    public final Matrix4fb rotate(float f, float f2, float f3, float f4, Matrix4fb matrix4fb) {
        return this.mul(matrix4fb.setToRotationAxis(f, f2, f3, f4));
    }

    public final Matrix4fb rotate(float f, Vec3f vec3f, Matrix4fb matrix4fb) {
        return this.mul(matrix4fb.setToRotationAxis(f, vec3f));
    }

    public final Matrix4fb rotate(Quaternion quaternion, Matrix4fb matrix4fb) {
        return this.mul(matrix4fb.setToRotation(quaternion));
    }

    public final Matrix4fb translate(float f, float f2, float f3, Matrix4fb matrix4fb) {
        return this.mul(matrix4fb.setToTranslation(f, f2, f3));
    }

    public final Matrix4fb translate(Vec3f vec3f, Matrix4fb matrix4fb) {
        return this.mul(matrix4fb.setToTranslation(vec3f));
    }

    public final Matrix4fb scale(float f, float f2, float f3, Matrix4fb matrix4fb) {
        return this.mul(matrix4fb.setToScale(f, f2, f3));
    }

    public final Matrix4fb scale(float f, Matrix4fb matrix4fb) {
        return this.mul(matrix4fb.setToScale(f, f, f));
    }

    public final void push() {
        this.stack.push(this);
    }

    public final void pop() {
        this.stack.pop(this);
    }

    public boolean isEqual(Matrix4fb matrix4fb, float f) {
        if (this == matrix4fb) {
            return true;
        }
        for (int i = 0; i < 16; ++i) {
            if (FloatUtil.isEqual(this.m[i], matrix4fb.m[i], f)) continue;
            return false;
        }
        return true;
    }

    public boolean isEqual(Matrix4fb matrix4fb) {
        return this.isEqual(matrix4fb, 1.1920929E-7f);
    }

    public boolean equals(Object object) {
        if (object instanceof Matrix4fb) {
            return this.isEqual((Matrix4fb)object, 1.1920929E-7f);
        }
        return false;
    }

    public static boolean mapObjToWin(Vec3f vec3f, Matrix4fb matrix4fb, Matrix4fb matrix4fb2, int[] nArray, float[] fArray) {
        Vec4f vec4f = new Vec4f(vec3f, 1.0f);
        Vec4f vec4f2 = matrix4fb.mulVec4f(vec4f, new Vec4f());
        Vec4f vec4f3 = matrix4fb2.mulVec4f(vec4f2, vec4f);
        if (vec4f3.w() == 0.0f) {
            return false;
        }
        float f = 1.0f / vec4f3.w() * 0.5f;
        vec4f3.scale(f).add(0.5f, 0.5f, 0.5f, 0.0f);
        fArray[0] = vec4f3.x() * (float)nArray[2] + (float)nArray[0];
        fArray[1] = vec4f3.y() * (float)nArray[3] + (float)nArray[1];
        fArray[2] = vec4f3.z();
        return true;
    }

    public static boolean mapObjToWin(Vec3f vec3f, Matrix4fb matrix4fb, int[] nArray, float[] fArray) {
        Vec4f vec4f = new Vec4f(vec3f, 1.0f);
        Vec4f vec4f2 = matrix4fb.mulVec4f(vec4f, new Vec4f());
        if (vec4f2.w() == 0.0f) {
            return false;
        }
        float f = 1.0f / vec4f2.w() * 0.5f;
        vec4f2.scale(f).add(0.5f, 0.5f, 0.5f, 0.0f);
        fArray[0] = vec4f2.x() * (float)nArray[2] + (float)nArray[0];
        fArray[1] = vec4f2.y() * (float)nArray[3] + (float)nArray[1];
        fArray[2] = vec4f2.z();
        return true;
    }

    public static boolean mapWinToObj(float f, float f2, float f3, Matrix4fb matrix4fb, Matrix4fb matrix4fb2, int[] nArray, Vec3f vec3f, Matrix4fb matrix4fb3) {
        Matrix4fb matrix4fb4 = matrix4fb3.mul(matrix4fb2, matrix4fb);
        if (!matrix4fb4.invert()) {
            return false;
        }
        Vec4f vec4f = new Vec4f(f, f2, f3, 1.0f);
        vec4f.add(-nArray[0], -nArray[1], 0.0f, 0.0f).mul(1.0f / (float)nArray[2], 1.0f / (float)nArray[3], 1.0f, 1.0f);
        vec4f.mul(2.0f, 2.0f, 2.0f, 1.0f).add(-1.0f, -1.0f, -1.0f, 0.0f);
        Vec4f vec4f2 = matrix4fb4.mulVec4f(vec4f, new Vec4f());
        if (vec4f2.w() == 0.0f) {
            return false;
        }
        vec3f.set(vec4f2.scale(1.0f / vec4f2.w()));
        return true;
    }

    public static boolean mapWinToObj(float f, float f2, float f3, Matrix4fb matrix4fb, int[] nArray, Vec3f vec3f, Matrix4fb matrix4fb2) {
        Vec4f vec4f = new Vec4f(f, f2, f3, 1.0f);
        vec4f.add(-nArray[0], -nArray[1], 0.0f, 0.0f).mul(1.0f / (float)nArray[2], 1.0f / (float)nArray[3], 1.0f, 1.0f);
        vec4f.mul(2.0f, 2.0f, 2.0f, 1.0f).add(-1.0f, -1.0f, -1.0f, 0.0f);
        Vec4f vec4f2 = matrix4fb.mulVec4f(vec4f, new Vec4f());
        if (vec4f2.w() == 0.0f) {
            return false;
        }
        vec3f.set(vec4f2.scale(1.0f / vec4f2.w()));
        return true;
    }

    public static boolean mapWinToObj(float f, float f2, float f3, float f4, Matrix4fb matrix4fb, int[] nArray, Vec3f vec3f, Vec3f vec3f2, Matrix4fb matrix4fb2) {
        Vec4f vec4f = new Vec4f(f, f2, f3, 1.0f);
        vec4f.add(-nArray[0], -nArray[1], 0.0f, 0.0f).mul(1.0f / (float)nArray[2], 1.0f / (float)nArray[3], 1.0f, 1.0f);
        vec4f.mul(2.0f, 2.0f, 2.0f, 1.0f).add(-1.0f, -1.0f, -1.0f, 0.0f);
        Vec4f vec4f2 = matrix4fb.mulVec4f(vec4f, new Vec4f());
        if (vec4f2.w() == 0.0f) {
            return false;
        }
        vec3f.set(vec4f2.scale(1.0f / vec4f2.w()));
        vec4f.setZ(f4 * 2.0f - 1.0f);
        matrix4fb.mulVec4f(vec4f, vec4f2);
        if (vec4f2.w() == 0.0f) {
            return false;
        }
        vec3f2.set(vec4f2.scale(1.0f / vec4f2.w()));
        return true;
    }

    public static boolean mapWinToObj4(float f, float f2, float f3, float f4, Matrix4fb matrix4fb, Matrix4fb matrix4fb2, int[] nArray, float f5, float f6, Vec4f vec4f, Matrix4fb matrix4fb3) {
        Matrix4fb matrix4fb4 = matrix4fb3.mul(matrix4fb2, matrix4fb);
        if (!matrix4fb4.invert()) {
            return false;
        }
        Vec4f vec4f2 = new Vec4f(f, f2, f3, f4);
        vec4f2.add(-nArray[0], -nArray[1], -f5, 0.0f).mul(1.0f / (float)nArray[2], 1.0f / (float)nArray[3], 1.0f / (f6 - f5), 1.0f);
        vec4f2.mul(2.0f, 2.0f, 2.0f, 1.0f).add(-1.0f, -1.0f, -1.0f, 0.0f);
        matrix4fb4.mulVec4f(vec4f2, vec4f);
        return vec4f.w() != 0.0f;
    }

    public static boolean mapWinToRay(float f, float f2, float f3, float f4, Matrix4fb matrix4fb, Matrix4fb matrix4fb2, int[] nArray, Ray ray, Matrix4fb matrix4fb3, Matrix4fb matrix4fb4) {
        Matrix4fb matrix4fb5 = matrix4fb3.mul(matrix4fb2, matrix4fb);
        if (!matrix4fb5.invert()) {
            return false;
        }
        if (Matrix4fb.mapWinToObj(f, f2, f3, f4, matrix4fb5, nArray, ray.orig, ray.dir, matrix4fb4)) {
            ray.dir.sub(ray.orig).normalize();
            return true;
        }
        return false;
    }

    public StringBuilder toString(StringBuilder stringBuilder, String string, String string2) {
        float[] fArray = new float[16];
        this.get(fArray);
        return FloatUtil.matrixToString(stringBuilder, string, string2, fArray, 0, 4, 4, false);
    }

    public String toString() {
        return this.toString(null, null, "%10.5f").toString();
    }

    private static class Stack {
        private int position = 0;
        private float[] buffer;
        private final int growSize;

        public Stack(int n, int n2) {
            this.growSize = n2;
            this.buffer = new float[n];
        }

        private final void growIfNecessary(int n) throws IndexOutOfBoundsException {
            if (this.position + n > this.buffer.length) {
                if (0 >= this.growSize) {
                    throw new IndexOutOfBoundsException("Out of fixed stack size: " + this);
                }
                float[] fArray = new float[this.buffer.length + this.growSize];
                System.arraycopy(this.buffer, 0, fArray, 0, this.position);
                this.buffer = fArray;
            }
        }

        public final Matrix4fb push(Matrix4fb matrix4fb) throws IndexOutOfBoundsException {
            this.growIfNecessary(16);
            matrix4fb.get(this.buffer, this.position);
            this.position += 16;
            return matrix4fb;
        }

        public final Matrix4fb pop(Matrix4fb matrix4fb) throws IndexOutOfBoundsException {
            this.position -= 16;
            matrix4fb.load(this.buffer, this.position);
            return matrix4fb;
        }
    }
}

