/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.util.texture;

import com.jogamp.common.util.IOUtil;
import com.jogamp.nativewindow.NativeSurfaceHolder;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.awt.AWTKeyAdapter;
import com.jogamp.newt.event.awt.AWTWindowAdapter;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.test.junit.jogl.demos.TextureDraw01Accessor;
import com.jogamp.opengl.test.junit.jogl.demos.es2.TextureDraw01ES2Listener;
import com.jogamp.opengl.test.junit.jogl.demos.gl2.TextureDraw01GL2Listener;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.GLReadBufferUtil;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.TextureIO;
import com.jogamp.opengl.util.texture.spi.awt.IIOTextureProvider;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import javax.swing.SwingUtilities;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestPNGTextureFromFileAWT
extends UITestCase {
    static boolean showFPS = false;
    static long duration = 100L;
    InputStream grayTextureStream;
    InputStream testTextureStream;

    @BeforeClass
    public static void initClass() {
    }

    @Before
    public void initTest() throws IOException {
        this.grayTextureStream = TestPNGTextureFromFileAWT.class.getResourceAsStream("grayscale_texture.png");
        Assert.assertNotNull(this.grayTextureStream);
        URLConnection uRLConnection = IOUtil.getResource("test-ntscN_3-01-160x90.png", this.getClass().getClassLoader(), this.getClass());
        Assert.assertNotNull(uRLConnection);
        this.testTextureStream = uRLConnection.getInputStream();
        Assert.assertNotNull(this.testTextureStream);
    }

    @After
    public void cleanupTest() {
        this.grayTextureStream = null;
        this.testTextureStream = null;
    }

    public void testImpl(boolean bl, InputStream inputStream, boolean bl2) throws InterruptedException, IOException {
        TextureData textureData;
        Object object;
        GLProfile gLProfile;
        final GLReadBufferUtil gLReadBufferUtil = new GLReadBufferUtil(true, false);
        if (bl && GLProfile.isAvailable("GL2")) {
            gLProfile = GLProfile.getMaxFixedFunc(true);
        } else if (!bl && GLProfile.isAvailable("GL2ES2")) {
            gLProfile = GLProfile.getGL2ES2();
        } else {
            System.err.println(this.getSimpleTestName(".") + ": GLProfile n/a, useFFP: " + bl);
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        if (bl2) {
            object = new IIOTextureProvider();
            textureData = object.newTextureData(gLProfile, inputStream, 0, 0, false, "png");
        } else {
            textureData = TextureIO.newTextureData(gLProfile, inputStream, false, "png");
        }
        System.err.println("TextureData: " + textureData);
        object = new GLCanvas(gLCapabilities);
        Dimension dimension = new Dimension(textureData.getWidth(), textureData.getHeight());
        ((Component)object).setMinimumSize(dimension);
        ((Component)object).setPreferredSize(dimension);
        final Frame frame = new Frame("TestPNGTextureGL2FromFileAWT");
        Assert.assertNotNull(frame);
        frame.add((Component)object);
        final GLEventListener gLEventListener = bl ? new TextureDraw01GL2Listener(textureData) : new TextureDraw01ES2Listener(textureData, 0);
        ((GLCanvas)object).addGLEventListener(gLEventListener);
        ((GLCanvas)object).addGLEventListener(new GLEventListener(){
            boolean shot = false;

            @Override
            public void init(GLAutoDrawable gLAutoDrawable) {
            }

            @Override
            public void display(GLAutoDrawable gLAutoDrawable) {
                if (null != ((TextureDraw01Accessor)((Object)gLEventListener)).getTexture() && !this.shot) {
                    this.shot = true;
                    TestPNGTextureFromFileAWT.this.snapshot(0, null, gLAutoDrawable.getGL(), gLReadBufferUtil, "png", null);
                }
            }

            @Override
            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }

            @Override
            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            }
        });
        QuitAdapter quitAdapter = new QuitAdapter();
        new AWTKeyAdapter((KeyListener)quitAdapter, (NativeSurfaceHolder)object).addTo((Component)object);
        new AWTWindowAdapter((WindowListener)quitAdapter, (NativeSurfaceHolder)object).addTo((Component)object);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.pack();
                    frame.setVisible(true);
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException(throwable);
        }
        Animator animator = new Animator((GLAutoDrawable)object);
        animator.setUpdateFPSFrames(60, showFPS ? System.err : null);
        animator.start();
        while (!quitAdapter.shouldQuit() && animator.isAnimating() && animator.getTotalFPSDuration() < duration) {
            Thread.sleep(100L);
        }
        animator.stop();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){
                final /* synthetic */ GLCanvas val$glc;
                {
                    this.val$glc = gLCanvas;
                }

                @Override
                public void run() {
                    frame.setVisible(false);
                    frame.remove(this.val$glc);
                    frame.dispose();
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException(throwable);
        }
    }

    @Test
    public void testGrayAWTILoaderGL2() throws InterruptedException, IOException {
        this.testImpl(true, this.grayTextureStream, true);
    }

    @Test
    public void testGrayAWTILoaderES2() throws InterruptedException, IOException {
        this.testImpl(false, this.grayTextureStream, true);
    }

    @Test
    public void testGrayPNGJLoaderGL2() throws InterruptedException, IOException {
        this.testImpl(true, this.grayTextureStream, false);
    }

    @Test
    public void testGrayPNGJLoaderES2() throws InterruptedException, IOException {
        this.testImpl(false, this.grayTextureStream, false);
    }

    @Test
    public void testTestAWTILoaderGL2() throws InterruptedException, IOException {
        this.testImpl(true, this.testTextureStream, true);
    }

    @Test
    public void testTestAWTILoaderES2() throws InterruptedException, IOException {
        this.testImpl(false, this.testTextureStream, true);
    }

    @Test
    public void testTestPNGJLoaderGL2() throws InterruptedException, IOException {
        this.testImpl(true, this.testTextureStream, false);
    }

    @Test
    public void testTestPNGJLoaderES2() throws InterruptedException, IOException {
        this.testImpl(false, this.testTextureStream, false);
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            duration = MiscUtils.atol(stringArray[++i], duration);
        }
        JUnitCore.main(TestPNGTextureFromFileAWT.class.getName());
    }
}

