/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.perf;

import com.jogamp.common.os.Platform;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestPerf001GLWindowInit03NEWT
extends UITestCase {
    final long INIT_TIMEOUT = 10000L;
    static GLCapabilitiesImmutable caps = null;
    static long duration = 0L;
    static boolean wait = false;
    static boolean mainRun = false;
    static int width = 800;
    static int height = 600;
    static int frameCount = 25;
    AtomicInteger initCount = new AtomicInteger(0);

    @BeforeClass
    public static void initClass() {
        GLProfile.initSingleton();
    }

    public void test(GLCapabilitiesImmutable gLCapabilitiesImmutable, boolean bl, int n, int n2, int n3, boolean bl2) {
        long l;
        int n4;
        int n5 = (int)Math.round(Math.sqrt(n3));
        int n6 = n3 / n5;
        int n7 = n / n5;
        int n8 = n2 / n6;
        GLWindow[] gLWindowArray = new GLWindow[n3];
        long[] lArray = new long[10];
        if (wait) {
            UITestCase.waitForKey("Pre-Init");
        }
        System.err.println("INIT START");
        this.initCount.set(0);
        lArray[0] = Platform.currentTimeMillis();
        int n9 = 32;
        int n10 = 32;
        for (n4 = 0; n4 < n3; ++n4) {
            Screen screen = NewtFactory.createScreen(NewtFactory.createDisplay(null, bl2), 0);
            gLWindowArray[n4] = GLWindow.create(screen, gLCapabilitiesImmutable);
            gLWindowArray[n4].setTitle("frame_" + n4 + "/" + n3);
            gLWindowArray[n4].setPosition(n9, n10);
            if ((n9 += n7 + 32) >= n) {
                n9 = 32;
                n10 += n8 + 32;
            }
            gLWindowArray[n4].setSize(n7, n8);
            if (bl) {
                gLWindowArray[n4].addGLEventListener(new GearsES2());
            }
            gLWindowArray[n4].addGLEventListener(new GLEventListener(){

                @Override
                public void init(GLAutoDrawable gLAutoDrawable) {
                    TestPerf001GLWindowInit03NEWT.this.initCount.incrementAndGet();
                }

                @Override
                public void dispose(GLAutoDrawable gLAutoDrawable) {
                }

                @Override
                public void display(GLAutoDrawable gLAutoDrawable) {
                }

                @Override
                public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
                }
            });
        }
        lArray[1] = Platform.currentTimeMillis();
        for (n4 = 0; n4 < n3; ++n4) {
            gLWindowArray[n4].setVisible(false, true);
        }
        lArray[2] = Platform.currentTimeMillis();
        long l2 = l = System.currentTimeMillis();
        while (n3 > this.initCount.get() && 10000L > l2 - l) {
            try {
                Thread.sleep(100L);
                System.err.println("Sleep initialized: " + this.initCount + "/" + n3);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            l2 = System.currentTimeMillis();
        }
        lArray[3] = Platform.currentTimeMillis();
        double d = this.initCount.get();
        System.err.printf("P: %d GLWindow:%n\tctor\t%6d/t %6.2f/1%n\tvisible\t%6d/t %6.2f/1%n\tsum-i\t%6d/t %6.2f/1%n", this.initCount.get(), lArray[1] - lArray[0], (double)(lArray[1] - lArray[0]) / d, lArray[3] - lArray[1], (double)(lArray[3] - lArray[1]) / d, lArray[3] - lArray[0], (double)(lArray[3] - lArray[0]) / d);
        System.err.println("INIT END: " + this.initCount + "/" + n3);
        if (wait) {
            UITestCase.waitForKey("Post-Init");
        }
        try {
            Thread.sleep(duration);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        lArray[4] = Platform.currentTimeMillis();
        for (int i = 0; i < n3; ++i) {
            gLWindowArray[i].destroy();
        }
        long l3 = lArray[4] - lArray[0] - duration;
        System.err.printf("T: duration %d %d%n\ttotal-d\t%6d/t %6.2f/1%n\ttotal-i\t%6d/t %6.2f/1%n", duration, lArray[4] - lArray[3], lArray[4] - lArray[0], (double)(lArray[4] - lArray[0]) / d, l3, (double)l3 / d);
        System.err.println("Total: " + (lArray[4] - lArray[0]));
    }

    @Test
    public void test01NopGLWindowNoReuse() throws InterruptedException, InvocationTargetException {
        if (!mainRun) {
            System.err.println("Disabled for auto unit test until further analysis - Windows/ATI driver crash");
            return;
        }
        this.test(new GLCapabilities(null), false, width, height, frameCount, false);
    }

    @Test
    public void test02NopGLWindowReuse() throws InterruptedException, InvocationTargetException {
        this.test(new GLCapabilities(null), false, width, height, frameCount, true);
    }

    public static void main(String[] stringArray) {
        mainRun = true;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                duration = MiscUtils.atol(stringArray[++i], duration);
                continue;
            }
            if (stringArray[i].equals("-width")) {
                width = MiscUtils.atoi(stringArray[++i], width);
                continue;
            }
            if (stringArray[i].equals("-height")) {
                height = MiscUtils.atoi(stringArray[++i], height);
                continue;
            }
            if (stringArray[i].equals("-count")) {
                frameCount = MiscUtils.atoi(stringArray[++i], frameCount);
                continue;
            }
            if (stringArray[i].equals("-gears")) {
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-wait")) {
                wait = true;
                bl2 = true;
                continue;
            }
            if (stringArray[i].equals("-waitMain")) {
                bl3 = true;
                bl2 = true;
                continue;
            }
            if (!stringArray[i].equals("-manual")) continue;
            bl2 = true;
        }
        if (bl3) {
            UITestCase.waitForKey("Main-Start");
        }
        if (bl2) {
            GLProfile.initSingleton();
            TestPerf001GLWindowInit03NEWT testPerf001GLWindowInit03NEWT = new TestPerf001GLWindowInit03NEWT();
            testPerf001GLWindowInit03NEWT.test(null, bl, width, height, frameCount, false);
        } else {
            JUnitCore.main(TestPerf001GLWindowInit03NEWT.class.getName());
        }
    }
}

