/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.glsl;

import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es2.RedSquareES2;
import com.jogamp.opengl.test.junit.util.GLSLSimpleProgram;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.io.IOException;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGLSLSimple01NEWT
extends UITestCase {
    static long durationPerTest = 100L;

    @Test(timeout=60000L)
    public void testGLSLCompilation01() {
        GLProfile gLProfile = GLProfile.get("GL2ES2");
        Assert.assertNotNull(gLProfile);
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        Assert.assertNotNull(gLCapabilities);
        GLWindow gLWindow = GLWindow.create(gLCapabilities);
        Assert.assertNotNull(gLWindow);
        gLWindow.setSize(800, 600);
        gLWindow.setVisible(true);
        Assert.assertTrue(gLWindow.isNativeValid());
        GLContext gLContext = gLWindow.getContext();
        gLWindow.display();
        Assert.assertTrue(gLWindow.isRealized());
        Assert.assertTrue(gLWindow.getContext().isCreated());
        gLContext.makeCurrent();
        GL2ES2 gL2ES2 = gLContext.getGL().getGL2ES2();
        GLSLSimpleProgram gLSLSimpleProgram = GLSLSimpleProgram.create(gL2ES2, " #ifdef GL_ES\n  precision mediump float;\n  precision mediump int;\n#endif\n\n#if __VERSION__ >= 130\n  #define attribute in\n  #define varying out\n#endif\n\nuniform mat4    mgl_PMVMatrix[2];\nattribute vec4    mgl_Vertex;\nattribute vec4    mgl_Color;\nvarying vec4    frontColor;\n\nvoid main(void)\n{\n  frontColor=mgl_Color;\n  gl_Position = mgl_PMVMatrix[0] * mgl_PMVMatrix[1] * mgl_Vertex;\n}\n", " #ifdef GL_ES\n  precision mediump float;\n  precision mediump int;\n#endif\n\n#if __VERSION__ >= 130\n  #define varying in\n  out vec4 mgl_FragColor;\n#else\n  #define mgl_FragColor gl_FragColor\n#endif\n\nvarying   vec4    frontColor;\n\nvoid main (void)\n{\n    mgl_FragColor = frontColor;\n}\n", true);
        gLSLSimpleProgram.release(gL2ES2);
        gLContext.release();
        gLWindow.destroy();
    }

    @Test(timeout=60000L)
    public void testGLSLUse01() throws InterruptedException {
        GLProfile gLProfile = GLProfile.get("GL2ES2");
        Assert.assertNotNull(gLProfile);
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        Assert.assertNotNull(gLCapabilities);
        GLWindow gLWindow = GLWindow.create(gLCapabilities);
        Assert.assertNotNull(gLWindow);
        gLWindow.setSize(800, 600);
        gLWindow.setVisible(true);
        Assert.assertTrue(gLWindow.isNativeValid());
        gLWindow.addGLEventListener(new RedSquareES2());
        Animator animator = new Animator(gLWindow);
        animator.setUpdateFPSFrames(1, null);
        animator.start();
        Assert.assertEquals(true, animator.isAnimating());
        while (animator.isAnimating() && animator.getTotalFPSDuration() < durationPerTest) {
            Thread.sleep(100L);
        }
        Assert.assertEquals(true, animator.isAnimating());
        gLWindow.destroy();
        animator.stop();
    }

    public static void main(String[] stringArray) throws IOException {
        System.err.println("main - start");
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            durationPerTest = MiscUtils.atoi(stringArray[++i], (int)durationPerTest);
        }
        String string = TestGLSLSimple01NEWT.class.getName();
        JUnitCore.main(string);
        System.err.println("main - end");
    }
}

