/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.demos.gl4.newt;

import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.gl4.TessellationShader01aGLSL440CoreHardcoded;
import com.jogamp.opengl.test.junit.jogl.demos.gl4.TessellationShader01bGL4;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.io.IOException;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestTessellationShader01GL4NEWT
extends UITestCase {
    static long duration = 500L;

    static GLCapabilities getCaps(String string) {
        if (!GLProfile.isAvailable(string)) {
            System.err.println("Profile " + string + " n/a");
            return null;
        }
        return new GLCapabilities(GLProfile.get(string));
    }

    @Test
    public void test01_01a() throws InterruptedException {
        GLCapabilities gLCapabilities = TestTessellationShader01GL4NEWT.getCaps("GL4");
        if (null == gLCapabilities) {
            return;
        }
        this.testImpl(gLCapabilities, new TessellationShader01aGLSL440CoreHardcoded());
    }

    @Test
    public void test02_01b() throws InterruptedException {
        GLCapabilities gLCapabilities = TestTessellationShader01GL4NEWT.getCaps("GL4");
        if (null == gLCapabilities) {
            return;
        }
        this.testImpl(gLCapabilities, new TessellationShader01bGL4());
    }

    private void testImpl(GLCapabilities gLCapabilities, GLEventListener gLEventListener) throws InterruptedException {
        GLWindow gLWindow = GLWindow.create(gLCapabilities);
        Assert.assertNotNull(gLWindow);
        gLWindow.setSize(800, 600);
        gLWindow.setVisible(true);
        gLWindow.setTitle("JOGL Tessellation Shader Test");
        Assert.assertTrue(gLWindow.isNativeValid());
        QuitAdapter quitAdapter = new QuitAdapter();
        gLWindow.addKeyListener(quitAdapter);
        gLWindow.addWindowListener(quitAdapter);
        gLWindow.addGLEventListener(gLEventListener);
        UITestCase.SnapshotGLEventListener snapshotGLEventListener = new UITestCase.SnapshotGLEventListener(this);
        gLWindow.addGLEventListener(snapshotGLEventListener);
        Animator animator = new Animator(gLWindow);
        animator.start();
        animator.setUpdateFPSFrames(60, System.err);
        snapshotGLEventListener.setMakeSnapshot();
        while (!quitAdapter.shouldQuit() && animator.isAnimating() && animator.getTotalFPSDuration() < duration) {
            Thread.sleep(100L);
        }
        animator.stop();
        gLWindow.destroy();
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            duration = MiscUtils.atol(stringArray[++i], duration);
        }
        JUnitCore.main(TestTessellationShader01GL4NEWT.class.getName());
    }
}

