/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.demos.es2.newt;

import com.jogamp.common.util.IOUtil;
import com.jogamp.nativewindow.util.Dimension;
import com.jogamp.nativewindow.util.DimensionImmutable;
import com.jogamp.newt.Display;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.newt.opengl.util.NEWTDemoListener;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.PNGPixelRect;
import java.io.IOException;
import java.net.URLConnection;
import jogamp.newt.driver.PNGIcon;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGearsES2SimpleNEWT
extends UITestCase {
    static final DimensionImmutable wsize = new Dimension(800, 600);
    static final float[] reqSurfacePixelScale = new float[]{0.0f, 0.0f};
    static final int swapInterval = 1;
    static long duration = 500L;
    static boolean opaque = true;

    private void setTitle(Window window, GLCapabilitiesImmutable gLCapabilitiesImmutable) {
        float[] fArray = window.getPixelsPerMM(new float[2]);
        fArray[0] = fArray[0] * 25.4f;
        fArray[1] = fArray[1] * 25.4f;
        window.setTitle("GLWindow: swapI 1, win: " + window.getBounds() + ", pix: " + window.getSurfaceWidth() + "x" + window.getSurfaceHeight() + ", sDPI " + fArray[0] + " x " + fArray[1]);
    }

    protected void runTestGL(final GLCapabilitiesImmutable gLCapabilitiesImmutable, boolean bl) throws InterruptedException {
        long l;
        System.err.println("requested: vsync 1, " + gLCapabilitiesImmutable);
        Display display = NewtFactory.createDisplay(null);
        Screen screen = NewtFactory.createScreen(display, 0);
        final GLWindow gLWindow = GLWindow.create(screen, gLCapabilitiesImmutable);
        gLWindow.setSurfaceScale(reqSurfacePixelScale);
        float[] fArray = gLWindow.getRequestedSurfaceScale(new float[2]);
        gLWindow.setSize(wsize.getWidth(), wsize.getHeight());
        gLWindow.setUndecorated(bl);
        GearsES2 gearsES2 = new GearsES2(1);
        gearsES2.setValidateBuffers(true);
        gLWindow.addGLEventListener(gearsES2);
        UITestCase.SnapshotGLEventListener snapshotGLEventListener = new UITestCase.SnapshotGLEventListener(this);
        gLWindow.addGLEventListener(snapshotGLEventListener);
        Animator animator = new Animator(0);
        QuitAdapter quitAdapter = new QuitAdapter();
        gLWindow.addKeyListener(quitAdapter);
        gLWindow.addWindowListener(quitAdapter);
        gLWindow.addWindowListener(new WindowAdapter(){

            @Override
            public void windowResized(WindowEvent windowEvent) {
                System.err.println("window resized: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getSurfaceWidth() + "x" + gLWindow.getSurfaceHeight());
                TestGearsES2SimpleNEWT.this.setTitle(gLWindow, gLCapabilitiesImmutable);
            }

            @Override
            public void windowMoved(WindowEvent windowEvent) {
                System.err.println("window moved:   " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getSurfaceWidth() + "x" + gLWindow.getSurfaceHeight());
                TestGearsES2SimpleNEWT.this.setTitle(gLWindow, gLCapabilitiesImmutable);
            }
        });
        Display.PointerIcon[] pointerIconArray = new Display.PointerIcon[]{null, null, null, null, null};
        Object object = gLWindow.getScreen().getDisplay();
        ((Display)object).createNative();
        int n = 0;
        Display.PointerIcon pointerIcon = null;
        IOUtil.ClassResources classResources = new IOUtil.ClassResources(new String[]{"jogamp/newt/assets/cross-grey-alpha-16x16.png"}, gLWindow.getClass().getClassLoader(), null);
        try {
            pointerIcon = ((Display)object).createPointerIcon(classResources, 8, 8);
            System.err.printf("Create PointerIcon #%02d: %s%n", n, pointerIcon.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        pointerIconArray[n] = pointerIcon;
        ++n;
        pointerIcon = null;
        classResources = new IOUtil.ClassResources(new String[]{"jogamp/newt/assets/pointer-grey-alpha-16x24.png"}, gLWindow.getClass().getClassLoader(), null);
        try {
            pointerIcon = ((Display)object).createPointerIcon(classResources, 0, 0);
            System.err.printf("Create PointerIcon #%02d: %s%n", n, pointerIcon.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        pointerIconArray[n] = pointerIcon;
        ++n;
        pointerIcon = null;
        classResources = new IOUtil.ClassResources(new String[]{"arrow-red-alpha-64x64.png"}, gLWindow.getClass().getClassLoader(), null);
        try {
            pointerIcon = ((Display)object).createPointerIcon(classResources, 0, 0);
            System.err.printf("Create PointerIcon #%02d: %s%n", n, pointerIcon.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        pointerIconArray[n] = pointerIcon;
        ++n;
        pointerIcon = null;
        classResources = new IOUtil.ClassResources(new String[]{"arrow-blue-alpha-64x64.png"}, gLWindow.getClass().getClassLoader(), null);
        try {
            pointerIcon = ((Display)object).createPointerIcon(classResources, 0, 0);
            System.err.printf("Create PointerIcon #%02d: %s%n", n, pointerIcon.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        pointerIconArray[n] = pointerIcon;
        ++n;
        if (PNGIcon.isAvailable()) {
            pointerIcon = null;
            classResources = new IOUtil.ClassResources(new String[]{"jogamp-pointer-64x64.png"}, gLWindow.getClass().getClassLoader(), null);
            try {
                URLConnection uRLConnection = classResources.resolve(0);
                PNGPixelRect pNGPixelRect = PNGPixelRect.read(uRLConnection.getInputStream(), null, false, 0, false);
                System.err.printf("Create PointerIcon #%02d: %s%n", n, pNGPixelRect.toString());
                pointerIcon = ((Display)object).createPointerIcon(pNGPixelRect, 32, 0);
                System.err.printf("Create PointerIcon #%02d: %s%n", n, pointerIcon.toString());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            pointerIconArray[n] = pointerIcon;
        }
        ++n;
        object = new NEWTDemoListener(gLWindow, pointerIconArray);
        gLWindow.addKeyListener((KeyListener)object);
        gLWindow.addMouseListener((MouseListener)object);
        animator.add(gLWindow);
        animator.start();
        gLWindow.setVisible(true);
        animator.setUpdateFPSFrames(60, System.err);
        System.err.println("NW chosen: " + gLWindow.getDelegatedWindow().getChosenCapabilities());
        System.err.println("GL chosen: " + gLWindow.getChosenCapabilities());
        System.err.println("window pos/siz: " + gLWindow.getX() + "/" + gLWindow.getY() + "[wu] " + gLWindow.getWidth() + "x" + gLWindow.getHeight() + "[wu] " + gLWindow.getSurfaceWidth() + "x" + gLWindow.getSurfaceHeight() + "[px], " + gLWindow.getInsets());
        float[] fArray2 = gLWindow.getCurrentSurfaceScale(new float[2]);
        System.err.println("HiDPI PixelScale: " + reqSurfacePixelScale[0] + "x" + reqSurfacePixelScale[1] + " (req) -> " + fArray[0] + "x" + fArray[1] + " (val) -> " + fArray2[0] + "x" + fArray2[1] + " (has)");
        this.setTitle(gLWindow, gLCapabilitiesImmutable);
        snapshotGLEventListener.setMakeSnapshot();
        long l2 = l = System.currentTimeMillis();
        while (!quitAdapter.shouldQuit() && l2 - l < duration) {
            Thread.sleep(100L);
            l2 = System.currentTimeMillis();
        }
        animator.stop();
        gLWindow.destroy();
    }

    @Test
    public void test01_GL2ES2() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setBackgroundOpaque(opaque);
        this.runTestGL(gLCapabilities, false);
    }

    public static void main(String[] stringArray) throws IOException {
        duration = 1000000L;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                duration = MiscUtils.atol(stringArray[++i], duration);
                continue;
            }
            if (!stringArray[i].equals("-translucent")) continue;
            opaque = false;
        }
        JUnitCore.main(TestGearsES2SimpleNEWT.class.getName());
    }
}

