/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.demos.es2.newt;

import com.jogamp.nativewindow.NativeWindowFactory;
import com.jogamp.nativewindow.swt.SWTAccessor;
import com.jogamp.nativewindow.util.Dimension;
import com.jogamp.nativewindow.util.DimensionImmutable;
import com.jogamp.nativewindow.util.Point;
import com.jogamp.nativewindow.util.PointImmutable;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.event.KeyAdapter;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.newt.opengl.util.NEWTDemoListener;
import com.jogamp.newt.swt.NewtCanvasSWT;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.GLTestUtil;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.NewtTestUtil;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.test.junit.util.SWTTestUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import jogamp.nativewindow.macosx.OSXUtil;
import jogamp.newt.DisplayImpl;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGearsES2NewtCanvasSWT
extends UITestCase {
    static int screenIdx = 0;
    static PointImmutable wpos;
    static DimensionImmutable wsize;
    static DimensionImmutable rwsize;
    static long duration;
    static boolean opaque;
    static int forceAlpha;
    static boolean fullscreen;
    static int swapInterval;
    static boolean showFPS;
    static int loops;
    static boolean loop_shutdown;
    static boolean forceES2;
    static boolean forceGL3;
    static boolean mainRun;
    static boolean exclusiveContext;
    Display display = null;
    Shell shell = null;
    Composite composite = null;
    com.jogamp.newt.Display swtNewtDisplay = null;

    @BeforeClass
    public static void initClass() {
        if (null == wsize) {
            wsize = new Dimension(640, 480);
        }
    }

    @AfterClass
    public static void releaseClass() {
    }

    @Before
    public void init() {
        SWTAccessor.invokeOnOSTKThread(true, new Runnable(){

            @Override
            public void run() {
                TestGearsES2NewtCanvasSWT.this.display = new Display();
                Assert.assertNotNull(TestGearsES2NewtCanvasSWT.this.display);
            }
        });
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                TestGearsES2NewtCanvasSWT.this.shell = new Shell(TestGearsES2NewtCanvasSWT.this.display);
                Assert.assertNotNull(TestGearsES2NewtCanvasSWT.this.shell);
                TestGearsES2NewtCanvasSWT.this.shell.setLayout((Layout)new FillLayout());
                TestGearsES2NewtCanvasSWT.this.composite = new Composite((Composite)TestGearsES2NewtCanvasSWT.this.shell, 0);
                TestGearsES2NewtCanvasSWT.this.composite.setLayout((Layout)new FillLayout());
                Assert.assertNotNull(TestGearsES2NewtCanvasSWT.this.composite);
            }
        });
        this.swtNewtDisplay = NewtFactory.createDisplay(null, false);
    }

    @After
    public void release() {
        Assert.assertNotNull(this.display);
        Assert.assertNotNull(this.shell);
        Assert.assertNotNull(this.composite);
        try {
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    TestGearsES2NewtCanvasSWT.this.composite.dispose();
                    TestGearsES2NewtCanvasSWT.this.shell.dispose();
                }
            });
            SWTAccessor.invokeOnOSTKThread(true, new Runnable(){

                @Override
                public void run() {
                    TestGearsES2NewtCanvasSWT.this.display.dispose();
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException(throwable);
        }
        this.swtNewtDisplay = null;
        this.display = null;
        this.shell = null;
        this.composite = null;
    }

    private String isOSXMainThread() {
        if (NativeWindowFactory.getNativeWindowType(true) == ".macosx") {
            return ", isOSX-Main-Thread: " + OSXUtil.IsMainThread();
        }
        return "";
    }

    protected void runTestGL(GLCapabilitiesImmutable gLCapabilitiesImmutable) throws InterruptedException, InvocationTargetException {
        System.err.println("CCC00: Run Thread: " + Thread.currentThread() + this.isOSXMainThread());
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                System.err.println("CCC01: SWT Thread: " + Thread.currentThread() + TestGearsES2NewtCanvasSWT.this.isOSXMainThread());
            }
        });
        Object object = (DisplayImpl)NewtFactory.createDisplay(null);
        ((DisplayImpl)object).runOnEDTIfAvail(true, new Runnable(){

            @Override
            public void run() {
                System.err.println("CCC02: NEWT EDT Thread: " + Thread.currentThread() + TestGearsES2NewtCanvasSWT.this.isOSXMainThread());
            }
        });
        System.err.println("requested: vsync " + swapInterval + ", " + gLCapabilitiesImmutable);
        object = NewtFactory.createScreen(this.swtNewtDisplay, screenIdx);
        final GLWindow gLWindow = GLWindow.create((Screen)object, gLCapabilitiesImmutable);
        Assert.assertNotNull(gLWindow);
        GearsES2 gearsES2 = new GearsES2(swapInterval);
        gLWindow.addGLEventListener(gearsES2);
        Animator animator = new Animator(0);
        animator.setExclusiveContext(exclusiveContext);
        QuitAdapter quitAdapter = new QuitAdapter();
        gLWindow.addKeyListener(quitAdapter);
        gLWindow.addWindowListener(quitAdapter);
        gLWindow.addWindowListener(new WindowAdapter(){

            @Override
            public void windowResized(WindowEvent windowEvent) {
                System.err.println("window resized: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getSurfaceWidth() + "x" + gLWindow.getSurfaceHeight());
            }

            @Override
            public void windowMoved(WindowEvent windowEvent) {
                System.err.println("window moved:   " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getSurfaceWidth() + "x" + gLWindow.getSurfaceHeight());
            }
        });
        gLWindow.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (!keyEvent.isPrintableKey() || keyEvent.isAutoRepeat()) {
                    return;
                }
                if (keyEvent.getKeyChar() == 'f') {
                    gLWindow.invokeOnNewThread(null, false, new Runnable(){

                        @Override
                        public void run() {
                            System.err.println("[set fullscreen  pre]: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getSurfaceWidth() + "x" + gLWindow.getSurfaceHeight() + ", f " + gLWindow.isFullscreen() + ", a " + gLWindow.isAlwaysOnTop() + ", " + gLWindow.getInsets());
                            gLWindow.setFullscreen(!gLWindow.isFullscreen());
                            System.err.println("[set fullscreen post]: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getSurfaceWidth() + "x" + gLWindow.getSurfaceHeight() + ", f " + gLWindow.isFullscreen() + ", a " + gLWindow.isAlwaysOnTop() + ", " + gLWindow.getInsets());
                        }
                    });
                }
            }
        });
        NEWTDemoListener nEWTDemoListener = new NEWTDemoListener(gLWindow);
        nEWTDemoListener.quitAdapterEnable(false);
        gLWindow.addKeyListener(nEWTDemoListener);
        gLWindow.addMouseListener(nEWTDemoListener);
        gLWindow.addWindowListener(nEWTDemoListener);
        animator.add(gLWindow);
        animator.start();
        Assert.assertTrue(animator.isStarted());
        Assert.assertTrue(animator.isAnimating());
        Assert.assertEquals(exclusiveContext ? animator.getThread() : null, gLWindow.getExclusiveContextThread());
        final NewtCanvasSWT newtCanvasSWT = NewtCanvasSWT.create(this.composite, 0, gLWindow);
        Assert.assertNotNull(newtCanvasSWT);
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                TestGearsES2NewtCanvasSWT.this.shell.setText(TestGearsES2NewtCanvasSWT.this.getSimpleTestName("."));
                TestGearsES2NewtCanvasSWT.this.shell.setSize(wsize.getWidth(), wsize.getHeight());
                if (null != wpos) {
                    TestGearsES2NewtCanvasSWT.this.shell.setLocation(wpos.getX(), wpos.getY());
                }
                TestGearsES2NewtCanvasSWT.this.shell.open();
            }
        });
        animator.setUpdateFPSFrames(60, showFPS ? System.err : null);
        SWTTestUtil.WaitAction waitAction = new SWTTestUtil.WaitAction(this.display, true, 10L);
        Assert.assertEquals(true, NewtTestUtil.waitForVisible(gLWindow, true, waitAction));
        Assert.assertEquals(true, GLTestUtil.waitForRealized(gLWindow, true, waitAction));
        System.err.println("NW chosen: " + gLWindow.getDelegatedWindow().getChosenCapabilities());
        System.err.println("GL chosen: " + gLWindow.getChosenCapabilities());
        System.err.println("window pos/siz: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getSurfaceWidth() + "x" + gLWindow.getSurfaceHeight() + ", " + gLWindow.getInsets());
        if (null != rwsize) {
            for (int i = 0; i < 50; ++i) {
                waitAction.run();
            }
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    TestGearsES2NewtCanvasSWT.this.shell.setSize(rwsize.getWidth(), rwsize.getHeight());
                }
            });
            System.err.println("window resize pos/siz: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getSurfaceWidth() + "x" + gLWindow.getSurfaceHeight() + ", " + gLWindow.getInsets());
        }
        while (!quitAdapter.shouldQuit() && animator.isAnimating() && animator.getTotalFPSDuration() < duration) {
            waitAction.run();
        }
        Assert.assertEquals(exclusiveContext ? animator.getThread() : null, gLWindow.getExclusiveContextThread());
        animator.stop();
        Assert.assertFalse(animator.isAnimating());
        Assert.assertFalse(animator.isStarted());
        Assert.assertEquals(null, gLWindow.getExclusiveContextThread());
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                newtCanvasSWT.dispose();
            }
        });
        gLWindow.destroy();
        Assert.assertEquals(true, NewtTestUtil.waitForRealized(gLWindow, false, null));
    }

    @Test
    public void test01GL2ES2() throws InterruptedException, InvocationTargetException {
        for (int i = 1; i <= loops; ++i) {
            System.err.println("Loop " + i + "/" + loops);
            GLProfile gLProfile = forceGL3 ? GLProfile.get("GL3") : (forceES2 ? GLProfile.get("GLES2") : GLProfile.getGL2ES2());
            GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
            gLCapabilities.setBackgroundOpaque(opaque);
            if (-1 < forceAlpha) {
                gLCapabilities.setAlphaBits(forceAlpha);
            }
            this.runTestGL(gLCapabilities);
            if (!loop_shutdown) continue;
            GLProfile.shutdown();
        }
    }

    @Test
    public void test02GL3() throws InterruptedException, InvocationTargetException {
        if (mainRun) {
            return;
        }
        if (!GLProfile.isAvailable("GL3")) {
            System.err.println("GL3 n/a");
            return;
        }
        GLProfile gLProfile = GLProfile.get("GL3");
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL(gLCapabilities);
    }

    public static void main(String[] stringArray) throws IOException {
        mainRun = true;
        int n = 0;
        int n2 = 0;
        int n3 = 640;
        int n4 = 480;
        int n5 = -1;
        int n6 = -1;
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                duration = MiscUtils.atol(stringArray[++i], duration);
                continue;
            }
            if (stringArray[i].equals("-translucent")) {
                opaque = false;
                continue;
            }
            if (stringArray[i].equals("-forceAlpha")) {
                forceAlpha = MiscUtils.atoi(stringArray[++i], 0);
                continue;
            }
            if (stringArray[i].equals("-fullscreen")) {
                fullscreen = true;
                continue;
            }
            if (stringArray[i].equals("-vsync")) {
                swapInterval = MiscUtils.atoi(stringArray[++i], swapInterval);
                continue;
            }
            if (stringArray[i].equals("-exclctx")) {
                exclusiveContext = true;
                continue;
            }
            if (stringArray[i].equals("-es2")) {
                forceES2 = true;
                continue;
            }
            if (stringArray[i].equals("-gl3")) {
                forceGL3 = true;
                continue;
            }
            if (stringArray[i].equals("-showFPS")) {
                showFPS = true;
                continue;
            }
            if (stringArray[i].equals("-width")) {
                n3 = MiscUtils.atoi(stringArray[++i], n3);
                continue;
            }
            if (stringArray[i].equals("-height")) {
                n4 = MiscUtils.atoi(stringArray[++i], n4);
                continue;
            }
            if (stringArray[i].equals("-x")) {
                n = MiscUtils.atoi(stringArray[++i], n);
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-y")) {
                n2 = MiscUtils.atoi(stringArray[++i], n2);
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-rwidth")) {
                n5 = MiscUtils.atoi(stringArray[++i], n5);
                continue;
            }
            if (stringArray[i].equals("-rheight")) {
                n6 = MiscUtils.atoi(stringArray[++i], n6);
                continue;
            }
            if (stringArray[i].equals("-screen")) {
                screenIdx = MiscUtils.atoi(stringArray[++i], 0);
                continue;
            }
            if (stringArray[i].equals("-loops")) {
                loops = MiscUtils.atoi(stringArray[++i], 1);
                continue;
            }
            if (!stringArray[i].equals("-loop-shutdown")) continue;
            loop_shutdown = true;
        }
        wsize = new Dimension(n3, n4);
        if (0 < n5 && 0 < n6) {
            rwsize = new Dimension(n5, n6);
        }
        if (bl) {
            wpos = new Point(n, n2);
        }
        System.err.println("position " + wpos);
        System.err.println("size " + wsize);
        System.err.println("resize " + rwsize);
        System.err.println("screen " + screenIdx);
        System.err.println("translucent " + !opaque);
        System.err.println("forceAlpha " + forceAlpha);
        System.err.println("fullscreen " + fullscreen);
        System.err.println("loops " + loops);
        System.err.println("loop shutdown " + loop_shutdown);
        System.err.println("forceES2 " + forceES2);
        System.err.println("forceGL3 " + forceGL3);
        System.err.println("swapInterval " + swapInterval);
        System.err.println("exclusiveContext " + exclusiveContext);
        JUnitCore.main(TestGearsES2NewtCanvasSWT.class.getName());
    }

    static {
        rwsize = null;
        duration = 500L;
        opaque = true;
        forceAlpha = -1;
        fullscreen = false;
        swapInterval = 1;
        showFPS = false;
        loops = 1;
        loop_shutdown = false;
        forceES2 = false;
        forceGL3 = false;
        mainRun = false;
        exclusiveContext = false;
    }
}

