/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.caps;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLOffscreenAutoDrawable;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.GLReadBufferUtil;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestBug605FlippedImageNEWT
extends UITestCase {
    static final int green = 65280;
    static final int red = 0xFF0000;

    private int getRGB(ByteBuffer byteBuffer, int n) {
        return (byteBuffer.get(n + 0) & 0xFF) << 16 | (byteBuffer.get(n + 1) & 0xFF) << 8 | byteBuffer.get(n + 2) & 0xFF;
    }

    private void testFlipped(ByteBuffer byteBuffer, int n, int n2, int n3) {
        int n4 = this.getRGB(byteBuffer, 0);
        System.err.println("below: 0x" + Integer.toHexString(n4));
        int n5 = this.getRGB(byteBuffer, (n2 - 1) * (n * n3));
        System.err.println("above: 0x" + Integer.toHexString(n5));
        if (n5 == 65280 && n4 == 0xFF0000) {
            System.out.println("Image right side up");
        } else if (n5 == 0xFF0000 && n4 == 65280) {
            Assert.assertTrue("Image is flipped", false);
        } else {
            Assert.assertTrue("Error in test", false);
        }
    }

    private void test(GLCapabilitiesImmutable gLCapabilitiesImmutable) {
        GLReadBufferUtil gLReadBufferUtil = new GLReadBufferUtil(false, false);
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory(gLCapabilitiesImmutable.getGLProfile());
        GLOffscreenAutoDrawable gLOffscreenAutoDrawable = gLDrawableFactory.createOffscreenAutoDrawable(null, gLCapabilitiesImmutable, null, 256, 256);
        FlippedImageTest flippedImageTest = new FlippedImageTest();
        gLOffscreenAutoDrawable.addGLEventListener(flippedImageTest);
        UITestCase.SnapshotGLEventListener snapshotGLEventListener = new UITestCase.SnapshotGLEventListener(this, gLReadBufferUtil);
        gLOffscreenAutoDrawable.addGLEventListener(snapshotGLEventListener);
        snapshotGLEventListener.setMakeSnapshotAlways(true);
        gLOffscreenAutoDrawable.display();
        System.err.println("XXX " + gLOffscreenAutoDrawable.getChosenGLCapabilities());
        System.err.println("XXX " + gLOffscreenAutoDrawable.getContext().getGLVersion());
        this.testFlipped((ByteBuffer)gLReadBufferUtil.getPixelBuffer().buffer, gLOffscreenAutoDrawable.getSurfaceWidth(), gLOffscreenAutoDrawable.getSurfaceHeight(), 3);
        gLOffscreenAutoDrawable.destroy();
    }

    @Test
    public void test01DefaultFBO() {
        GLProfile gLProfile = GLProfile.get("GL2");
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setFBO(true);
        this.test(gLCapabilities);
    }

    @Test
    public void test01StencilFBO() {
        GLProfile gLProfile = GLProfile.get("GL2");
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setStencilBits(8);
        gLCapabilities.setFBO(true);
        this.test(gLCapabilities);
    }

    @Test
    public void test01DefaultPBuffer() {
        GLProfile gLProfile = GLProfile.get("GL2");
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setPBuffer(true);
        this.test(gLCapabilities);
    }

    @Test
    public void test01AccumStencilPBuffer() {
        GLProfile gLProfile = GLProfile.get("GL2");
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setAccumRedBits(16);
        gLCapabilities.setAccumGreenBits(16);
        gLCapabilities.setAccumBlueBits(16);
        gLCapabilities.setStencilBits(8);
        gLCapabilities.setPBuffer(true);
        this.test(gLCapabilities);
    }

    public static void main(String[] stringArray) {
        JUnitCore.main(TestBug605FlippedImageNEWT.class.getName());
    }

    static class FlippedImageTest
    implements GLEventListener {
        FlippedImageTest() {
        }

        @Override
        public void display(GLAutoDrawable gLAutoDrawable) {
            GL2 gL2 = gLAutoDrawable.getGL().getGL2();
            gL2.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            gL2.glClear(18176);
            gL2.glMatrixMode(5889);
            gL2.glLoadIdentity();
            gL2.glMatrixMode(5888);
            gL2.glLoadIdentity();
            gL2.glColor3f(1.0f, 0.0f, 0.0f);
            gL2.glRectf(-1.0f, -1.0f, 1.0f, 0.0f);
            gL2.glColor3f(0.0f, 1.0f, 0.0f);
            gL2.glRectf(-1.0f, 0.0f, 1.0f, 1.0f);
            gL2.glFinish();
            GLCapabilitiesImmutable gLCapabilitiesImmutable = gLAutoDrawable.getChosenGLCapabilities();
            if (gLCapabilitiesImmutable.getAccumGreenBits() > 0) {
                gL2.glAccum(256, 1.0f);
                gL2.glAccum(258, 1.0f);
            }
            gL2.glFinish();
        }

        @Override
        public void init(GLAutoDrawable gLAutoDrawable) {
            GL gL = gLAutoDrawable.getGL();
            System.err.println("GL_RENDERER: " + gL.glGetString(7937));
            System.err.println("GL_VERSION: " + gL.glGetString(7938));
        }

        @Override
        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        }

        public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
        }

        @Override
        public void dispose(GLAutoDrawable gLAutoDrawable) {
        }
    }
}

