/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.awt;

import com.jogamp.nativewindow.NativeSurfaceHolder;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.awt.AWTKeyAdapter;
import com.jogamp.newt.event.awt.AWTWindowAdapter;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLJPanel;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.jogl.demos.es2.RedSquareES2;
import com.jogamp.opengl.test.junit.jogl.demos.es2.TextureDraw02ES2ListenerFBO;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.GLReadBufferUtil;
import com.jogamp.opengl.util.texture.TextureState;
import java.awt.Dimension;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGLJPanelTextureStateAWT
extends UITestCase {
    static boolean showFPS = false;
    static long duration = 250L;

    @BeforeClass
    public static void initClass() {
    }

    static void setFrameSize(final JFrame jFrame, final boolean bl, final Dimension dimension) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    jFrame.setSize(dimension);
                    if (bl) {
                        jFrame.validate();
                    }
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException(throwable);
        }
    }

    public void testImpl(final boolean bl, int n) throws InterruptedException, IOException {
        GLReadBufferUtil gLReadBufferUtil = new GLReadBufferUtil(true, false);
        if (!GLProfile.isAvailable("GL2ES2")) {
            System.err.println(this.getSimpleTestName(".") + ": GLProfile n/a");
            return;
        }
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        final GLJPanel gLJPanel = new GLJPanel(gLCapabilities);
        Dimension dimension = new Dimension(640, 480);
        Dimension dimension2 = new Dimension(800, 400);
        gLJPanel.setMinimumSize(dimension);
        gLJPanel.setPreferredSize(dimension);
        final JFrame jFrame = new JFrame("TestGLJPanelTextureStateAWT");
        Assert.assertNotNull(jFrame);
        jFrame.getContentPane().add(gLJPanel);
        final GLEventListener gLEventListener = new GearsES2(0);
        Object object = new TextureDraw02ES2ListenerFBO(gLEventListener, 1, n);
        ((TextureDraw02ES2ListenerFBO)object).setKeepTextureBound(bl);
        ((TextureDraw02ES2ListenerFBO)object).setClearBuffers(false);
        final TextureDraw02ES2ListenerFBO textureDraw02ES2ListenerFBO = object;
        object = new RedSquareES2(1);
        ((RedSquareES2)object).setClearBuffers(false);
        gLEventListener = object;
        object = new boolean[]{false};
        gLJPanel.addGLEventListener(new GLEventListener(){
            int gle0X;
            int gle0Y;
            int gle0W;
            int gle0H;
            int gle1X;
            int gle1Y;
            int gle1W;
            int gle1H;
            int tX;
            int tY;
            int tW;
            int tH;
            int shot = 0;
            final int border = 5;
            final /* synthetic */ boolean[] val$glelError;
            final /* synthetic */ GLReadBufferUtil val$screenshot;
            final /* synthetic */ int val$texUnit;
            {
                this.val$glelError = blArray;
                this.val$screenshot = gLReadBufferUtil;
                this.val$texUnit = n;
            }

            void setupTex(GL gL) {
                if (bl) {
                    gL.glTexParameteri(3553, 10240, 9729);
                    gL.glTexParameteri(3553, 10241, 9729);
                    gL.glTexParameteri(3553, 10242, 10497);
                    gL.glTexParameteri(3553, 10243, 10497);
                }
            }

            @Override
            public void init(GLAutoDrawable gLAutoDrawable) {
                GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
                gL2ES2.glActiveTexture(33985);
                gL2ES2.glBindTexture(3553, 0);
                gL2ES2.glTexParameteri(3553, 10240, 9729);
                gL2ES2.glTexParameteri(3553, 10241, 9728);
                gL2ES2.glTexParameteri(3553, 10242, 10497);
                gL2ES2.glTexParameteri(3553, 10243, 10497);
                gL2ES2.glActiveTexture(33984);
                gL2ES2.glBindTexture(3553, 0);
                gL2ES2.glTexParameteri(3553, 10240, 9729);
                gL2ES2.glTexParameteri(3553, 10241, 9728);
                gL2ES2.glTexParameteri(3553, 10242, 10497);
                gL2ES2.glTexParameteri(3553, 10243, 10497);
                textureDraw02ES2ListenerFBO.init(gLAutoDrawable);
                gLEventListener.init(gLAutoDrawable);
                this.setupTex(gL2ES2);
            }

            @Override
            public void dispose(GLAutoDrawable gLAutoDrawable) {
                textureDraw02ES2ListenerFBO.dispose(gLAutoDrawable);
                gLEventListener.dispose(gLAutoDrawable);
            }

            @Override
            public void display(GLAutoDrawable gLAutoDrawable) {
                GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
                gL2ES2.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
                gL2ES2.glClear(16640);
                Object object = new int[]{0, 0, 0, 0};
                gL2ES2.glGetIntegerv(2978, (int[])object, 0);
                if (this.gle1X != object[0] || this.gle1Y != object[1] || this.gle1W != object[2] || this.gle1H != object[3]) {
                    String string = "Expected " + this.gle1X + "/" + this.gle1Y + " " + this.gle1W + "x" + this.gle1H + ", actual " + object[0] + "/" + object[1] + " " + object[2] + "x" + object[3];
                    Assert.assertTrue("Viewport not restored: " + string, false);
                    this.val$glelError[0] = true;
                }
                gL2ES2.glViewport(this.gle0X, this.gle0Y, this.gle0W, this.gle0H);
                textureDraw02ES2ListenerFBO.display(gLAutoDrawable);
                gL2ES2.glViewport(this.gle1X, this.gle1Y, this.gle1W, this.gle1H);
                gLEventListener.display(gLAutoDrawable);
                ++this.shot;
                if (4 == this.shot) {
                    gL2ES2.glViewport(this.tX, this.tY, this.tW, this.tH);
                    TestGLJPanelTextureStateAWT.this.snapshot(0, null, gLAutoDrawable.getGL(), this.val$screenshot, "png", null);
                    gL2ES2.glViewport(this.gle1X, this.gle1Y, this.gle1W, this.gle1H);
                }
                object = new TextureState(gLAutoDrawable.getGL(), 3553);
                Assert.assertEquals("Texture unit changed", 33984 + this.val$texUnit, ((TextureState)object).getUnit());
                if (bl) {
                    Assert.assertEquals("Texture mag-filter changed: " + object, 9729L, ((TextureState)object).getMagFilter());
                    Assert.assertEquals("Texture mag-filter changed: " + object, 9729L, ((TextureState)object).getMinFilter());
                    Assert.assertEquals("Texture wrap-s changed: " + object, 10497L, ((TextureState)object).getWrapS());
                    Assert.assertEquals("Texture wrap-t changed: " + object, 10497L, ((TextureState)object).getWrapT());
                    this.val$glelError[0] = 9729 != ((TextureState)object).getMagFilter() || 9729 != ((TextureState)object).getMinFilter() || 10497 != ((TextureState)object).getWrapS() || 10497 != ((TextureState)object).getWrapT();
                }
            }

            @Override
            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
                this.gle0X = n + 5;
                this.gle0Y = n2;
                this.gle0W = n3 / 2 - 10;
                this.gle0H = n4;
                this.gle1X = this.gle0X + this.gle0W + 10;
                this.gle1Y = n2;
                this.gle1W = n3 / 2 - 10;
                this.gle1H = n4;
                this.tX = n;
                this.tY = n2;
                this.tW = n3;
                this.tH = n4;
                GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
                gL2ES2.glViewport(this.gle0X, this.gle0Y, this.gle0W, this.gle0H);
                textureDraw02ES2ListenerFBO.reshape(gLAutoDrawable, 0, 0, this.gle0W, this.gle0H);
                gL2ES2.glViewport(this.gle1X, this.gle1Y, this.gle1W, this.gle1H);
                gLEventListener.reshape(gLAutoDrawable, 0, 0, this.gle1W, this.gle1H);
                if (bl) {
                    this.setupTex(gL2ES2);
                }
            }
        });
        QuitAdapter quitAdapter = new QuitAdapter();
        new AWTKeyAdapter((KeyListener)quitAdapter, (NativeSurfaceHolder)gLJPanel).addTo(gLJPanel);
        new AWTWindowAdapter((WindowListener)quitAdapter, (NativeSurfaceHolder)gLJPanel).addTo(gLJPanel);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    jFrame.pack();
                    jFrame.setVisible(true);
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException(throwable);
        }
        Assert.assertTrue("Component didn't become visible", AWTRobotUtil.waitForVisible(gLJPanel, true, null));
        Assert.assertTrue("Component didn't become realized", AWTRobotUtil.waitForRealized(gLJPanel, true, null));
        Thread.sleep(100L);
        TestGLJPanelTextureStateAWT.setFrameSize(jFrame, true, dimension2);
        System.err.println("window resize pos/siz: " + gLJPanel.getX() + "/" + gLJPanel.getY() + " " + gLJPanel.getSurfaceWidth() + "x" + gLJPanel.getSurfaceHeight());
        Thread.sleep(100L);
        long l = System.currentTimeMillis();
        while (!quitAdapter.shouldQuit() && System.currentTimeMillis() - l < duration) {
            gLJPanel.display();
            Thread.sleep(100L);
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    jFrame.setVisible(false);
                    jFrame.remove(gLJPanel);
                    jFrame.dispose();
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException(throwable);
        }
        Assume.assumeFalse("Error occured in GLEL .. see log file above", (boolean)object[0]);
    }

    @Test
    public void test01_texUnit0_keepTex0_ES2() throws InterruptedException, IOException {
        this.testImpl(false, 0);
    }

    @Test
    public void test02_texUnit0_keepTex1_ES2() throws InterruptedException, IOException {
        this.testImpl(true, 0);
    }

    @Test
    public void test03_texUnit1_keepTex1_ES2() throws InterruptedException, IOException {
        this.testImpl(true, 1);
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            duration = MiscUtils.atol(stringArray[++i], duration);
        }
        JUnitCore.main(TestGLJPanelTextureStateAWT.class.getName());
    }
}

