/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.awt;

import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.awt.Dimension;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGLCanvasResize01AWT
extends UITestCase {
    static Dimension[] esize00 = new Dimension[]{new Dimension(281, 151), new Dimension(282, 151), new Dimension(283, 151), new Dimension(284, 151), new Dimension(284, 152), new Dimension(283, 152), new Dimension(282, 152), new Dimension(281, 152), new Dimension(291, 153), new Dimension(292, 153), new Dimension(293, 153), new Dimension(294, 153), new Dimension(281, 154), new Dimension(282, 154), new Dimension(283, 154), new Dimension(284, 154)};
    static Dimension[] esize01 = new Dimension[]{new Dimension(283, 154), new Dimension(291, 154), new Dimension(282, 154)};
    static Dimension[] esize02 = new Dimension[]{new Dimension(291, 154), new Dimension(282, 154)};
    static GLCapabilitiesImmutable caps = null;
    static long duration = 600L;

    @BeforeClass
    public static void initClass() {
        GLProfile.initSingleton();
    }

    public void test(final GLCapabilitiesImmutable gLCapabilitiesImmutable, final Dimension[] dimensionArray) {
        final int n = dimensionArray.length / 4 + (dimensionArray.length % 4 > 0 ? 1 : 0);
        final JFrame[] jFrameArray = new JFrame[]{null};
        System.err.println("Frame size: cols x rows 4x" + n);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    jFrameArray[0] = new JFrame();
                    jFrameArray[0].setLocation(64, 64);
                    JPanel jPanel = new JPanel();
                    jPanel.setLayout(null);
                    jPanel.setDoubleBuffered(false);
                    jFrameArray[0].getContentPane().add(jPanel);
                    int n6 = 4;
                    int n2 = 4;
                    int n3 = 0;
                    for (int i = 0; i < n; ++i) {
                        int n4;
                        int n5 = 0;
                        for (int j = 0; j < 4 && (n4 = i * 4 + j) < dimensionArray.length; ++j) {
                            Dimension dimension = dimensionArray[n4];
                            if (dimension.height > n5) {
                                n5 = dimension.height;
                            }
                            GLCanvas gLCanvas = TestGLCanvasResize01AWT.this.createGLJPanel(gLCapabilitiesImmutable, dimension, "[r " + i + ", c " + j + "]");
                            jPanel.add(gLCanvas);
                            gLCanvas.setLocation(n6, n2);
                            n6 += dimension.width + 4;
                        }
                        if (n6 > n3) {
                            n3 = n6;
                        }
                        n6 = 4;
                        n2 += n5 + 4;
                    }
                    jFrameArray[0].setSize(n3 + 4 + 64, n2 + 4 + 64);
                    jFrameArray[0].setVisible(true);
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException(throwable);
        }
        try {
            Thread.sleep(duration);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    jFrameArray[0].dispose();
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private GLCanvas createGLJPanel(GLCapabilitiesImmutable gLCapabilitiesImmutable, Dimension dimension, String string) {
        GLCanvas gLCanvas = new GLCanvas(gLCapabilitiesImmutable);
        gLCanvas.setName(string);
        gLCanvas.setSize(dimension);
        gLCanvas.setPreferredSize(dimension);
        gLCanvas.setMinimumSize(dimension);
        GearsES2 gearsES2 = new GearsES2(0);
        gLCanvas.addGLEventListener(gearsES2);
        return gLCanvas;
    }

    public void test00() throws InterruptedException, InvocationTargetException {
        this.test(new GLCapabilities(null), esize00);
    }

    @Test
    public void test01() throws InterruptedException, InvocationTargetException {
        this.test(new GLCapabilities(null), esize01);
    }

    @Test
    public void test02() throws InterruptedException, InvocationTargetException {
        this.test(new GLCapabilities(null), esize02);
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                duration = MiscUtils.atol(stringArray[++i], duration);
                continue;
            }
            if (!stringArray[i].equals("-manual")) continue;
            bl = true;
        }
        if (bl) {
            GLProfile.initSingleton();
            TestGLCanvasResize01AWT testGLCanvasResize01AWT = new TestGLCanvasResize01AWT();
            testGLCanvasResize01AWT.test(new GLCapabilities(null), esize01);
        } else {
            JUnitCore.main(TestGLCanvasResize01AWT.class.getName());
        }
    }
}

