/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.awt;

import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.AnimatorBase;
import com.jogamp.opengl.util.FPSAnimator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.SwingUtilities;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGLCanvasAWTActionDeadlock00AWT
extends UITestCase {
    static long durationPerTest = 1000L;
    static final int width = 512;
    static final int height = 512;
    GLEventListener gle1 = null;
    GLEventListener gle2 = null;
    int frameCount = 0;

    @Test
    public void test01Animator() throws InterruptedException {
        this.testImpl(new Animator(), 0, false);
    }

    @Test
    public void test02FPSAnimator() throws InterruptedException {
        this.testImpl(new FPSAnimator(30), 0, false);
    }

    @Test
    public void test02FPSAnimator_RestartOnAWTEDT() throws InterruptedException {
        this.testImpl(new FPSAnimator(30), 100, false);
    }

    void testImpl(final AnimatorBase animatorBase, int n, boolean bl) throws InterruptedException {
        final Frame frame = new Frame("Frame 1");
        this.gle1 = new GLEventListener(){

            @Override
            public void init(GLAutoDrawable gLAutoDrawable) {
            }

            @Override
            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }

            @Override
            public void display(GLAutoDrawable gLAutoDrawable) {
                frame.setTitle("f " + TestGLCanvasAWTActionDeadlock00AWT.this.frameCount + ", fps " + animatorBase.getLastFPS());
                ++TestGLCanvasAWTActionDeadlock00AWT.this.frameCount;
            }

            @Override
            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            }
        };
        this.gle2 = new GearsES2();
        Assert.assertNotNull(frame);
        Serializable serializable = frame.getInsets();
        int n2 = 512 + ((Insets)serializable).left + ((Insets)serializable).right;
        int n3 = 512 + ((Insets)serializable).top + ((Insets)serializable).bottom;
        frame.setSize(n2, n3);
        frame.setLocation(0, 0);
        frame.setTitle("Generic Title");
        serializable = this.createGLCanvas();
        ((GLCanvas)serializable).addGLEventListener(this.gle1);
        ((GLCanvas)serializable).addGLEventListener(this.gle2);
        animatorBase.setUpdateFPSFrames(60, System.err);
        animatorBase.add((GLAutoDrawable)((Object)serializable));
        animatorBase.start();
        this.attachGLCanvas(frame, (GLCanvas)serializable, false);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.setVisible(true);
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException(throwable);
        }
        long l = 0 < n ? (long)n : 100L;
        for (long i = durationPerTest; 0L < i; i -= l) {
            if (0 < n) {
                serializable = this.restart(frame, (GLCanvas)serializable, bl);
            }
            Thread.sleep(l);
        }
        this.dispose(frame, (GLCanvas)serializable);
        animatorBase.stop();
        this.gle1 = null;
        this.gle2 = null;
    }

    void dispose(final Frame frame, final GLCanvas gLCanvas) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    gLCanvas.destroy();
                    frame.dispose();
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException(throwable);
        }
    }

    GLCanvas restart(Frame frame, GLCanvas gLCanvas, boolean bl) throws InterruptedException {
        gLCanvas.disposeGLEventListener(this.gle1, true);
        gLCanvas.disposeGLEventListener(this.gle2, true);
        this.detachGLCanvas(frame, gLCanvas, bl);
        gLCanvas = this.createGLCanvas();
        this.attachGLCanvas(frame, gLCanvas, bl);
        gLCanvas.addGLEventListener(this.gle1);
        gLCanvas.addGLEventListener(this.gle2);
        return gLCanvas;
    }

    void attachGLCanvas(final Frame frame, final GLCanvas gLCanvas, boolean bl) {
        System.err.println("*** attachGLCanvas.0 on-current-thread " + bl + ", currentThread " + Thread.currentThread().getName());
        if (bl) {
            frame.setLayout(new BorderLayout());
            frame.add((Component)gLCanvas, "Center");
            frame.validate();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        frame.setLayout(new BorderLayout());
                        frame.add((Component)gLCanvas, "Center");
                        frame.validate();
                    }
                });
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                Assume.assumeNoException(throwable);
            }
        }
        System.err.println("*** attachGLCanvas.X");
    }

    void detachGLCanvas(final Frame frame, final GLCanvas gLCanvas, boolean bl) {
        System.err.println("*** detachGLCanvas.0 on-current-thread " + bl + ", currentThread " + Thread.currentThread().getName());
        if (bl) {
            frame.remove(gLCanvas);
            frame.validate();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        frame.remove(gLCanvas);
                        frame.validate();
                    }
                });
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                Assume.assumeNoException(throwable);
            }
        }
        System.err.println("*** detachGLCanvas.X");
    }

    GLCanvas createGLCanvas() {
        System.err.println("*** createGLCanvas.0");
        GLCanvas gLCanvas = new GLCanvas();
        gLCanvas.setBounds(0, 0, 512, 512);
        Assert.assertNotNull(gLCanvas);
        System.err.println("*** createGLCanvas.X");
        return gLCanvas;
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            durationPerTest = MiscUtils.atoi(stringArray[++i], (int)durationPerTest);
        }
        JUnitCore.main(TestGLCanvasAWTActionDeadlock00AWT.class.getName());
    }
}

