/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore.anim;

import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.awt.GLJPanel;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.GLTestUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.awt.Frame;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestAnimatorGLJPanel01AWT
extends UITestCase {
    static final int width = 400;
    static final int height = 400;
    static long duration = 1500L;

    protected GLJPanel createGLJPanel(GLCapabilities gLCapabilities, Frame frame, int n, int n2, GearsES2 gearsES2) throws InterruptedException {
        GLJPanel gLJPanel = new GLJPanel(gLCapabilities);
        Assert.assertNotNull(gLJPanel);
        gLJPanel.addGLEventListener(gearsES2);
        frame.add(gLJPanel);
        frame.setLocation(n, n2);
        frame.setSize(400, 400);
        frame.setTitle("GLJPanel: " + n + "/" + n2);
        return gLJPanel;
    }

    static void pauseAnimator(Animator animator, boolean bl) {
        if (bl) {
            animator.pause();
            Assert.assertEquals(true, animator.isStarted());
            Assert.assertEquals(true, animator.isPaused());
            Assert.assertEquals(false, animator.isAnimating());
        } else {
            animator.resume();
            Assert.assertEquals(true, animator.isStarted());
            Assert.assertEquals(false, animator.isPaused());
            Assert.assertEquals(true, animator.isAnimating());
        }
    }

    static void stopAnimator(Animator animator) {
        animator.stop();
        Assert.assertEquals(false, animator.isStarted());
        Assert.assertEquals(false, animator.isPaused());
        Assert.assertEquals(false, animator.isAnimating());
    }

    @Test
    public void test01SyncedOneAnimator() throws InterruptedException, InvocationTargetException {
        GLCapabilities gLCapabilities = new GLCapabilities(null);
        final Frame frame = new Frame();
        Animator animator = new Animator();
        animator.start();
        Assert.assertEquals(true, animator.isStarted());
        Assert.assertEquals(true, animator.isPaused());
        Assert.assertEquals(false, animator.isAnimating());
        GearsES2 gearsES2 = new GearsES2(0);
        GLJPanel gLJPanel = this.createGLJPanel(gLCapabilities, frame, 0, 0, gearsES2);
        animator.add(gLJPanel);
        Assert.assertEquals(true, animator.isStarted());
        Assert.assertEquals(false, animator.isPaused());
        Assert.assertEquals(true, animator.isAnimating());
        final Frame frame2 = new Frame();
        GearsES2 gearsES22 = new GearsES2(0);
        GLJPanel gLJPanel2 = this.createGLJPanel(gLCapabilities, frame2, frame.getX() + 400, frame.getY() + 0, gearsES22);
        animator.add(gLJPanel2);
        final Frame frame3 = new Frame();
        GearsES2 gearsES23 = new GearsES2(0);
        GLJPanel gLJPanel3 = this.createGLJPanel(gLCapabilities, frame3, frame.getX() + 0, frame.getY() + 400, gearsES23);
        animator.add(gLJPanel3);
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setVisible(true);
                frame2.setVisible(true);
                frame3.setVisible(true);
            }
        });
        Assert.assertTrue(AWTRobotUtil.waitForRealized(gLJPanel, true, null));
        Assert.assertTrue(AWTRobotUtil.waitForVisible(gLJPanel, true, null));
        Assert.assertTrue(GLTestUtil.waitForContextCreated(gLJPanel, true, null));
        Assert.assertTrue("Gears1 not initialized", gearsES2.waitForInit(true));
        Assert.assertTrue(AWTRobotUtil.waitForRealized(gLJPanel2, true, null));
        Assert.assertTrue(AWTRobotUtil.waitForVisible(gLJPanel2, true, null));
        Assert.assertTrue(GLTestUtil.waitForContextCreated(gLJPanel2, true, null));
        Assert.assertTrue("Gears2 not initialized", gearsES22.waitForInit(true));
        Assert.assertTrue(AWTRobotUtil.waitForRealized(gLJPanel3, true, null));
        Assert.assertTrue(AWTRobotUtil.waitForVisible(gLJPanel3, true, null));
        Assert.assertTrue(GLTestUtil.waitForContextCreated(gLJPanel3, true, null));
        Assert.assertTrue("Gears3 not initialized", gearsES23.waitForInit(true));
        try {
            Thread.sleep(duration / 3L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        TestAnimatorGLJPanel01AWT.pauseAnimator(animator, true);
        try {
            Thread.sleep(duration / 3L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        TestAnimatorGLJPanel01AWT.pauseAnimator(animator, false);
        try {
            Thread.sleep(duration / 3L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        TestAnimatorGLJPanel01AWT.stopAnimator(animator);
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    frame.dispose();
                    frame2.dispose();
                    frame3.dispose();
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            }
        });
        Assert.assertTrue(AWTRobotUtil.waitForRealized(gLJPanel, false, null));
        Assert.assertTrue(AWTRobotUtil.waitForRealized(gLJPanel2, false, null));
        Assert.assertTrue(AWTRobotUtil.waitForRealized(gLJPanel3, false, null));
    }

    @Test
    public void test02AsyncEachAnimator() throws InterruptedException, InvocationTargetException {
        GLCapabilities gLCapabilities = new GLCapabilities(null);
        final Frame frame = new Frame();
        Animator animator = new Animator();
        GearsES2 gearsES2 = new GearsES2(0);
        GLJPanel gLJPanel = this.createGLJPanel(gLCapabilities, frame, 0, 0, gearsES2);
        animator.add(gLJPanel);
        animator.start();
        Assert.assertEquals(true, animator.isStarted());
        Assert.assertEquals(false, animator.isPaused());
        Assert.assertEquals(true, animator.isAnimating());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setVisible(true);
            }
        });
        final Frame frame2 = new Frame();
        Animator animator2 = new Animator();
        GearsES2 gearsES22 = new GearsES2(0);
        GLJPanel gLJPanel2 = this.createGLJPanel(gLCapabilities, frame2, frame.getX() + 400, frame.getY() + 0, gearsES22);
        animator2.add(gLJPanel2);
        animator2.start();
        Assert.assertEquals(true, animator2.isStarted());
        Assert.assertEquals(false, animator2.isPaused());
        Assert.assertEquals(true, animator2.isAnimating());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame2.setVisible(true);
            }
        });
        final Frame frame3 = new Frame();
        Animator animator3 = new Animator();
        GearsES2 gearsES23 = new GearsES2(0);
        GLJPanel gLJPanel3 = this.createGLJPanel(gLCapabilities, frame3, frame.getX() + 0, frame.getY() + 400, gearsES23);
        animator3.add(gLJPanel3);
        animator3.start();
        Assert.assertEquals(true, animator3.isStarted());
        Assert.assertEquals(false, animator3.isPaused());
        Assert.assertEquals(true, animator3.isAnimating());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame3.setVisible(true);
            }
        });
        Assert.assertTrue(AWTRobotUtil.waitForRealized(gLJPanel, true, null));
        Assert.assertTrue(AWTRobotUtil.waitForVisible(gLJPanel, true, null));
        Assert.assertTrue(GLTestUtil.waitForContextCreated(gLJPanel, true, null));
        Assert.assertTrue("Gears1 not initialized", gearsES2.waitForInit(true));
        Assert.assertTrue(AWTRobotUtil.waitForRealized(gLJPanel2, true, null));
        Assert.assertTrue(AWTRobotUtil.waitForVisible(gLJPanel2, true, null));
        Assert.assertTrue(GLTestUtil.waitForContextCreated(gLJPanel2, true, null));
        Assert.assertTrue("Gears2 not initialized", gearsES22.waitForInit(true));
        Assert.assertTrue(AWTRobotUtil.waitForRealized(gLJPanel3, true, null));
        Assert.assertTrue(AWTRobotUtil.waitForVisible(gLJPanel3, true, null));
        Assert.assertTrue(GLTestUtil.waitForContextCreated(gLJPanel3, true, null));
        Assert.assertTrue("Gears3 not initialized", gearsES23.waitForInit(true));
        try {
            Thread.sleep(duration / 3L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        TestAnimatorGLJPanel01AWT.pauseAnimator(animator, true);
        TestAnimatorGLJPanel01AWT.pauseAnimator(animator2, true);
        TestAnimatorGLJPanel01AWT.pauseAnimator(animator3, true);
        try {
            Thread.sleep(duration / 3L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        TestAnimatorGLJPanel01AWT.pauseAnimator(animator, false);
        TestAnimatorGLJPanel01AWT.pauseAnimator(animator2, false);
        TestAnimatorGLJPanel01AWT.pauseAnimator(animator3, false);
        try {
            Thread.sleep(duration / 3L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        TestAnimatorGLJPanel01AWT.stopAnimator(animator);
        TestAnimatorGLJPanel01AWT.stopAnimator(animator2);
        TestAnimatorGLJPanel01AWT.stopAnimator(animator3);
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    frame.dispose();
                    frame2.dispose();
                    frame3.dispose();
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            }
        });
        Assert.assertTrue(AWTRobotUtil.waitForRealized(gLJPanel, false, null));
        Assert.assertTrue(AWTRobotUtil.waitForRealized(gLJPanel2, false, null));
        Assert.assertTrue(AWTRobotUtil.waitForRealized(gLJPanel3, false, null));
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            ++i;
            try {
                duration = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        JUnitCore.main(TestAnimatorGLJPanel01AWT.class.getName());
    }
}

