/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.nio.Buffers;
import com.jogamp.nativewindow.WindowClosingProtocol;
import com.jogamp.newt.Window;
import com.jogamp.newt.awt.NewtCanvasAWT;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.TestUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jogamp.opengl.GLAutoDrawableBase;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestSingleGLInJSliderNewtAWT
extends UITestCase {
    static long durationPerTest = 1000L;
    private static Semaphore disposalCompleteSemaphore = new Semaphore(0);
    private static final Set<String> errorSet = new HashSet<String>();

    @BeforeClass
    public static void initClass() {
        if (!GLProfile.isAvailable("GL2")) {
            TestSingleGLInJSliderNewtAWT.setTestSupported(false);
        }
    }

    public static void logAnyErrorCodes(Object object, GL gL, String string) {
        String string2;
        int n;
        String string3;
        int n2 = gL.glGetError();
        if (n2 != 0 && errorSet.add(string3 = "GL-Error: " + string + " on obj 0x" + Integer.toHexString(object.hashCode()) + ", OpenGL error: 0x" + Integer.toHexString(n2))) {
            System.err.println(string3);
            ExceptionUtils.dumpStack(System.err);
        }
        if ((n = gL.glCheckFramebufferStatus(36160)) != 36053 && errorSet.add(string2 = "GL-Error: " + string + " on obj 0x" + Integer.toHexString(object.hashCode()) + ", glCheckFramebufferStatus: 0x" + Integer.toHexString(n))) {
            System.err.println(string2);
            ExceptionUtils.dumpStack(System.err);
        }
    }

    public static float setupViewFrustum(GL2 gL2, int n, int n2, float f, float f2, float f3) {
        assert (f > 0.0f);
        assert (f2 > 0.0f);
        assert (f3 > 0.0f);
        GLU gLU = new GLU();
        float f4 = (float)n / (float)n2;
        float f5 = f / f2;
        float f6 = f4 > 1.0f ? f3 : f4 * f3;
        float f7 = (float)((double)f5 / Math.sin((double)f6 / 2.0 * (Math.PI / 180)));
        gL2.glMatrixMode(5889);
        gL2.glLoadIdentity();
        gLU.gluPerspective((double)f3, (double)f4, 0.1 * (double)f7, (double)(f7 + f5));
        return f7;
    }

    @Test
    public void test01UseAWTNotShared() throws InterruptedException, InvocationTargetException {
        this.testCreateVisibleDestroy(false);
    }

    @Test
    public void test10UseNEWTNotShared() throws InterruptedException, InvocationTargetException {
        this.testCreateVisibleDestroy(true);
    }

    public void testCreateVisibleDestroy(final boolean bl) throws InterruptedException, InvocationTargetException {
        boolean bl2;
        WindowClosingProtocol windowClosingProtocol;
        WindowClosingProtocol windowClosingProtocol2;
        Component component;
        Object object;
        final JFrame jFrame = new JFrame("JSlider with " + (bl ? "NEWT" : "AWT") + "-OpenGL Widget");
        TestUtil.WindowClosingListener windowClosingListener = AWTRobotUtil.addClosingListener(jFrame);
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.get("GL2"));
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        final TwoTriangles twoTriangles = new TwoTriangles(480, 480);
        if (bl) {
            object = GLWindow.create(gLCapabilities);
            component = new NewtCanvasAWT((Window)object);
            component.setPreferredSize(new Dimension(twoTriangles.canvasWidth, twoTriangles.canvasHeight));
            ((GLAutoDrawableBase)object).addGLEventListener(twoTriangles);
            windowClosingProtocol2 = component;
            windowClosingProtocol = object;
        } else {
            object = new GLCanvas(gLCapabilities);
            ((Component)object).setSize(twoTriangles.canvasWidth, twoTriangles.canvasHeight);
            ((GLCanvas)object).addGLEventListener(twoTriangles);
            windowClosingProtocol2 = object;
            windowClosingProtocol = object;
        }
        object = new JSlider(1, -180, 180, 1);
        ((JSlider)object).setPaintTicks(false);
        ((JSlider)object).setPaintLabels(false);
        ((JSlider)object).setSnapToTicks(false);
        ((JSlider)object).addChangeListener(new ChangeListener(){
            final /* synthetic */ JSlider val$xAxisRotationSlider;
            {
                this.val$xAxisRotationSlider = jSlider;
            }

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                twoTriangles.setXAxisRotation(this.val$xAxisRotationSlider.getValue());
            }
        });
        component = new JLabel("X-Axis Rotation");
        final JSlider jSlider = new JSlider(0, -180, 180, 1);
        jSlider.setPaintTicks(false);
        jSlider.setPaintLabels(false);
        jSlider.setSnapToTicks(false);
        jSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                twoTriangles.setYAxisRotation(jSlider.getValue());
            }
        });
        JLabel jLabel = new JLabel("Y-Axis Rotation");
        final JSlider jSlider2 = new JSlider(0, 0, 100, 10);
        jSlider2.setPaintTicks(false);
        jSlider2.setPaintLabels(false);
        jSlider2.setSnapToTicks(false);
        jSlider2.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                twoTriangles.setViewDistanceFactor((float)jSlider2.getValue() / 10.0f);
            }
        });
        JLabel jLabel2 = new JLabel("View Distance Factor");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        jPanel.add(Box.createVerticalGlue());
        jPanel.add(jSlider2);
        jPanel.add(jLabel2);
        jPanel.add(Box.createVerticalGlue());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 2));
        jPanel2.add((Component)((Object)windowClosingProtocol2));
        jPanel2.add(Box.createHorizontalStrut(5));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 3));
        jPanel3.add(jPanel2);
        jPanel3.add(Box.createVerticalGlue());
        jPanel3.add(jSlider);
        jPanel3.add(jLabel);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 2));
        jPanel4.add((Component)object);
        jPanel4.add(component);
        JPanel jPanel5 = (JPanel)jFrame.getContentPane();
        jPanel5.setLayout(new BoxLayout(jPanel5, 2));
        jPanel5.add(jPanel);
        jPanel5.add(Box.createHorizontalGlue());
        jPanel5.add(jPanel3);
        jPanel5.add(Box.createHorizontalGlue());
        jPanel5.add(jPanel4);
        Animator animator = new Animator(Thread.currentThread().getThreadGroup());
        animator.setUpdateFPSFrames(1, null);
        animator.add((GLAutoDrawable)((Object)windowClosingProtocol));
        final Semaphore semaphore = new Semaphore(0);
        final Semaphore semaphore2 = new Semaphore(0);
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                semaphore2.release();
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                jFrame.pack();
                jFrame.setVisible(true);
                semaphore.release();
            }
        });
        try {
            bl2 = semaphore.tryAcquire(5000L, TimeUnit.MILLISECONDS);
            Assert.assertEquals(true, bl2);
        }
        catch (InterruptedException interruptedException) {
            System.err.println("Closing wait interrupted: " + interruptedException.getMessage());
        }
        animator.start();
        try {
            while (animator.isAnimating() && animator.getTotalFPSDuration() < durationPerTest) {
                Thread.sleep(100L);
            }
            AWTRobotUtil.closeWindow(jFrame, true, windowClosingListener, null);
            bl2 = semaphore2.tryAcquire(5000L, TimeUnit.MILLISECONDS);
            Assert.assertEquals(true, bl2);
        }
        catch (InterruptedException interruptedException) {
            System.err.println("Closing wait interrupted: " + interruptedException.getMessage());
        }
        animator.stop();
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ Component val$openGLComponent1;
            final /* synthetic */ Semaphore val$closingSemaphore;
            {
                this.val$openGLComponent1 = component;
                this.val$closingSemaphore = semaphore;
            }

            @Override
            public void run() {
                jFrame.setVisible(false);
                jFrame.dispose();
                if (bl) {
                    ((NewtCanvasAWT)this.val$openGLComponent1).destroy();
                }
                this.val$closingSemaphore.release();
            }
        });
        try {
            boolean bl3 = semaphore2.tryAcquire(5000L, TimeUnit.MILLISECONDS);
            Assert.assertEquals(true, bl3);
        }
        catch (InterruptedException interruptedException) {
            System.err.println("Closing wait interrupted: " + interruptedException.getMessage());
        }
        int n = 0;
        try {
            boolean bl4 = disposalCompleteSemaphore.tryAcquire(5000L, TimeUnit.MILLISECONDS);
            if (bl4) {
                ++n;
            }
        }
        catch (InterruptedException interruptedException) {
            System.err.println("Clean exit interrupted: " + interruptedException.getMessage());
        }
        Assert.assertEquals(true, n == 1);
    }

    static int atoi(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time") || ++i >= stringArray.length) continue;
            durationPerTest = TestSingleGLInJSliderNewtAWT.atoi(stringArray[i]);
        }
        JUnitCore.main(TestSingleGLInJSliderNewtAWT.class.getName());
    }

    static class TwoTriangles
    implements GLEventListener {
        int canvasWidth;
        int canvasHeight;
        private static final float boundsRadius = 2.0f;
        private float viewDistance;
        private static float viewDistanceFactor = 1.0f;
        private float xAxisRotation;
        private float yAxisRotation;
        private static final float viewFovDegrees = 15.0f;
        private final int[] privateVertexBufferObjects = new int[]{0};
        private final int[] privateIndexBufferObjects = new int[]{0};

        public static int createVertexBuffer(GL2 gL2) {
            FloatBuffer floatBuffer = Buffers.newDirectFloatBuffer(18);
            floatBuffer.put(new float[]{1.0f, -0.5f, 0.0f, 0.0f, 0.0f, 1.0f, 1.5f, -0.5f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.5f, 0.0f, 0.0f, 0.0f, 1.0f});
            floatBuffer.position(0);
            int[] nArray = new int[]{0};
            gL2.glGenBuffers(1, nArray, 0);
            gL2.glBindBuffer(34962, nArray[0]);
            gL2.glBufferData(34962, floatBuffer.capacity() * 4, floatBuffer, 35044);
            gL2.glBindBuffer(34962, 0);
            return nArray[0];
        }

        public static int createVertexIndexBuffer(GL2 gL2) {
            IntBuffer intBuffer = Buffers.newDirectIntBuffer(3);
            intBuffer.put(new int[]{0, 1, 2});
            intBuffer.position(0);
            int[] nArray = new int[]{0};
            gL2.glGenBuffers(1, nArray, 0);
            gL2.glBindBuffer(34963, nArray[0]);
            gL2.glBufferData(34963, intBuffer.capacity() * 4, intBuffer, 35044);
            gL2.glBindBuffer(34963, 0);
            return nArray[0];
        }

        TwoTriangles(int n, int n2) {
            this.canvasWidth = n;
            this.canvasHeight = n2;
        }

        public void setXAxisRotation(float f) {
            this.xAxisRotation = f;
        }

        public void setYAxisRotation(float f) {
            this.yAxisRotation = f;
        }

        public void setViewDistanceFactor(float f) {
            viewDistanceFactor = f;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void init(GLAutoDrawable gLAutoDrawable) {
            GL2 gL2 = gLAutoDrawable.getGL().getGL2();
            System.err.println("INIT GL IS: " + gL2.getClass().getName());
            gL2.setSwapInterval(0);
            gL2.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            TwoTriangles twoTriangles = this;
            synchronized (twoTriangles) {
                System.err.println("Using local VBOs on slave 0x" + Integer.toHexString(this.hashCode()));
                int[] nArray = this.privateVertexBufferObjects;
                int[] nArray2 = this.privateIndexBufferObjects;
                System.err.println("Creating vertex VBO on slave 0x" + Integer.toHexString(this.hashCode()));
                nArray[0] = TwoTriangles.createVertexBuffer(gL2);
                if (gL2.glIsBuffer(nArray[0])) {
                    gL2.glBindBuffer(34962, nArray[0]);
                    gL2.glEnableClientState(32884);
                    gL2.glVertexPointer(3, 5126, 24, 0L);
                    gL2.glEnableClientState(32885);
                    gL2.glNormalPointer(5126, 24, 12L);
                } else {
                    System.err.println("Vertex VBO is not a buffer on slave 0x" + Integer.toHexString(this.hashCode()));
                }
                System.err.println("Creating index VBO on slave 0x" + Integer.toHexString(this.hashCode()));
                nArray2[0] = TwoTriangles.createVertexIndexBuffer(gL2);
                if (gL2.glIsBuffer(nArray2[0])) {
                    gL2.glBindBuffer(34963, nArray2[0]);
                } else {
                    System.err.println("Index VBO is not a buffer on slave 0x" + Integer.toHexString(this.hashCode()));
                }
                gL2.glBindBuffer(34963, 0);
                gL2.glBindBuffer(34962, 0);
                gL2.glDisableClientState(32884);
                gL2.glDisableClientState(32885);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispose(GLAutoDrawable gLAutoDrawable) {
            TwoTriangles twoTriangles = this;
            synchronized (twoTriangles) {
                GL2 gL2 = gLAutoDrawable.getGL().getGL2();
                int[] nArray = this.privateVertexBufferObjects;
                int[] nArray2 = this.privateIndexBufferObjects;
                gL2.glDeleteBuffers(1, nArray, 0);
                TestSingleGLInJSliderNewtAWT.logAnyErrorCodes(this, gL2, "dispose.2");
                gL2.glDeleteBuffers(1, nArray2, 0);
                TestSingleGLInJSliderNewtAWT.logAnyErrorCodes(this, gL2, "dispose.3");
                nArray[0] = 0;
                nArray2[0] = 0;
                disposalCompleteSemaphore.release();
            }
        }

        @Override
        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            System.err.println("reshape: " + this.canvasWidth + "x" + this.canvasHeight + " -> " + n3 + "x" + n4 + ", [drawable pixel " + gLAutoDrawable.getSurfaceWidth() + "x" + gLAutoDrawable.getSurfaceHeight() + "]");
            this.canvasWidth = n3;
            this.canvasHeight = n4;
            GL2 gL2 = gLAutoDrawable.getGL().getGL2();
            this.viewDistance = TestSingleGLInJSliderNewtAWT.setupViewFrustum(gL2, this.canvasWidth, this.canvasHeight, 2.0f, 1.0f, 15.0f);
        }

        @Override
        public void display(GLAutoDrawable gLAutoDrawable) {
            GL2 gL2 = gLAutoDrawable.getGL().getGL2();
            GLU gLU = new GLU();
            TestSingleGLInJSliderNewtAWT.logAnyErrorCodes(this, gL2, "display.0");
            gL2.glClear(16640);
            gL2.glViewport(0, 0, this.canvasWidth, this.canvasHeight);
            gL2.glMatrixMode(5889);
            gL2.glLoadIdentity();
            gLU.gluPerspective(15.0f, (float)this.canvasWidth / (float)this.canvasHeight, this.viewDistance * viewDistanceFactor - 2.0f, this.viewDistance * viewDistanceFactor + 2.0f);
            gL2.glMatrixMode(5888);
            gL2.glLoadIdentity();
            gL2.glPushAttrib(1048575);
            gL2.glPushMatrix();
            gLU.gluLookAt(0.0f, 0.0f, 0.0f + this.viewDistance * viewDistanceFactor, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
            gL2.glRotatef(this.xAxisRotation, 1.0f, 0.0f, 0.0f);
            gL2.glRotatef(this.yAxisRotation, 0.0f, 1.0f, 0.0f);
            gL2.glDisable(2884);
            gL2.glEnable(2929);
            TestSingleGLInJSliderNewtAWT.logAnyErrorCodes(this, gL2, "display.1");
            this.drawTwoTriangles(gL2);
            gL2.glPopMatrix();
            gL2.glPopAttrib();
            gL2.glFlush();
            TestSingleGLInJSliderNewtAWT.logAnyErrorCodes(this, gL2, "display.X");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void drawTwoTriangles(GL2 gL2) {
            boolean bl;
            int[] nArray;
            int[] nArray2;
            gL2.glColor3f(1.0f, 0.0f, 0.0f);
            gL2.glBegin(4);
            gL2.glVertex3d(-1.5, -0.5, 0.0);
            gL2.glNormal3d(0.0, 0.0, 1.0);
            gL2.glVertex3d(-0.5, -0.5, 0.0);
            gL2.glNormal3d(0.0, 0.0, 1.0);
            gL2.glVertex3d(-0.75, 0.5, 0.0);
            gL2.glNormal3d(0.0, 0.0, 1.0);
            gL2.glEnd();
            TestSingleGLInJSliderNewtAWT.logAnyErrorCodes(this, gL2, "drawTwoTriangles.1");
            boolean bl2 = false;
            TwoTriangles twoTriangles = this;
            synchronized (twoTriangles) {
                nArray2 = this.privateVertexBufferObjects;
                nArray = this.privateIndexBufferObjects;
            }
            boolean bl3 = gL2.glIsBuffer(nArray[0]);
            boolean bl4 = gL2.glIsBuffer(nArray2[0]);
            boolean bl5 = bl = bl3 && bl4;
            if (bl) {
                gL2.glBindBuffer(34962, nArray2[0]);
                gL2.glBindBuffer(34963, nArray[0]);
                gL2.glEnableClientState(32884);
                gL2.glEnableClientState(32885);
                bl2 = true;
            }
            TestSingleGLInJSliderNewtAWT.logAnyErrorCodes(this, gL2, "drawTwoTriangles.2");
            if (bl2) {
                gL2.glColor3f(0.0f, 0.0f, 1.0f);
                gL2.glDrawElements(4, 3, 5125, 0L);
                gL2.glBindBuffer(34962, 0);
                gL2.glBindBuffer(34963, 0);
                gL2.glDisableClientState(32884);
                gL2.glDisableClientState(32885);
            }
            TestSingleGLInJSliderNewtAWT.logAnyErrorCodes(this, gL2, "drawTwoTriangles.3");
        }

        public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
        }
    }
}

