/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.nativewindow.util.InsetsImmutable;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.GLTestUtil;
import com.jogamp.opengl.test.junit.util.NewtTestUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.AnimatorBase;
import java.util.List;
import jogamp.opengl.GLContextShareSet;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestSharedContextVBOES2NEWT5
extends UITestCase {
    static GLProfile glp;
    static GLCapabilities caps;
    static final int width = 128;
    static final int height = 128;
    static long duration;
    static boolean mainRun;

    @BeforeClass
    public static void initClass() {
        if (GLProfile.isAvailable("GL2ES2")) {
            glp = GLProfile.get("GL2ES2");
            Assert.assertNotNull(glp);
            caps = new GLCapabilities(glp);
            Assert.assertNotNull(caps);
        } else {
            TestSharedContextVBOES2NEWT5.setTestSupported(false);
        }
    }

    protected GLWindow createGLWindow(int n, int n2, GearsES2 gearsES2) throws InterruptedException {
        GLWindow gLWindow = GLWindow.create(caps);
        Assert.assertNotNull(gLWindow);
        gLWindow.setPosition(n, n2);
        gLWindow.setTitle("Shared Gears NEWT Test: " + n + "/" + n2 + " shared true");
        gLWindow.setSize(128, 128);
        gLWindow.addGLEventListener(gearsES2);
        return gLWindow;
    }

    @Test
    public void test01CleanDtorOrder() throws InterruptedException {
        this.asyncEachAnimator(true, 3);
    }

    public void test02DirtyDtorOrder() throws InterruptedException {
        this.asyncEachAnimator(false, 3);
    }

    public void asyncEachAnimator(boolean bl, int n) throws InterruptedException {
        Animator animator = new Animator(0);
        GearsES2 gearsES2 = new GearsES2(0);
        gearsES2.setVerbose(false);
        gearsES2.setSyncObjects(gearsES2);
        gearsES2.setUseMappedBuffers(true);
        gearsES2.setValidateBuffers(true);
        GLWindow gLWindow = this.createGLWindow(0, 0, gearsES2);
        animator.add(gLWindow);
        animator.start();
        gLWindow.setVisible(true);
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow, true, null));
        Assert.assertTrue(NewtTestUtil.waitForVisible(gLWindow, true, null));
        Assert.assertTrue(GLTestUtil.waitForContextCreated(gLWindow, true, null));
        Assert.assertTrue("Gears1 not initialized", gearsES2.waitForInit(true));
        System.err.println("XXX-0-C-M - GLContextShareSet.Map");
        GLContextShareSet.printMap(System.err);
        InsetsImmutable insetsImmutable = gLWindow.getInsets();
        GLContext gLContext = gLWindow.getContext();
        for (int i = 0; i < n; ++i) {
            int n2;
            Object object;
            Animator[] animatorArray = new Animator[10];
            GearsES2[] gearsES2Array = new GearsES2[10];
            GLWindow[] gLWindowArray = new GLWindow[10];
            GLContext[] gLContextArray = new GLContext[10];
            for (int j = 0; j < 10; ++j) {
                object = new Animator(0);
                GearsES2 gearsES22 = new GearsES2(0);
                gearsES22.setVerbose(false);
                gearsES22.setSharedGears(gearsES2);
                int n3 = 1 + j / 4;
                int n4 = j % 4;
                GLWindow gLWindow2 = this.createGLWindow(128 * n4, insetsImmutable.getTotalHeight() + 128 * n3, gearsES22);
                gLWindow2.setUndecorated(true);
                gLWindow2.setSharedAutoDrawable(gLWindow);
                ((AnimatorBase)object).add(gLWindow2);
                ((Animator)object).start();
                gLWindow2.setVisible(true);
                Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow2, true, null));
                Assert.assertTrue(NewtTestUtil.waitForVisible(gLWindow2, true, null));
                Assert.assertTrue(GLTestUtil.waitForContextCreated(gLWindow2, true, null));
                Assert.assertTrue("Gears2 not initialized", gearsES22.waitForInit(true));
                animatorArray[j] = object;
                gearsES2Array[j] = gearsES22;
                gLWindowArray[j] = gLWindow2;
                gLContextArray[j] = gLWindow2.getContext();
            }
            List<GLContext> list = gLContext.getCreatedShares();
            Assert.assertTrue("Gears1 is shared", !gearsES2.usesSharedGears());
            Assert.assertTrue("Ctx1 is not shared", gLContext.isShared());
            Assert.assertEquals("Ctx1 has unexpected number of created shares", 10L, list.size());
            Assert.assertEquals("Ctx1 Master Context is different", gLContext, gLContext.getSharedMaster());
            for (int j = 0; j < 10; ++j) {
                object = gLContextArray[j].getCreatedShares();
                Assert.assertTrue("Gears2 is not shared", gearsES2Array[j].usesSharedGears());
                Assert.assertTrue("CtxS[" + j + "] is not shared", gLContextArray[j].isShared());
                Assert.assertEquals("CtxS[" + j + "] has unexpected number of created shares", 10L, object.size());
                Assert.assertEquals("CtxS[" + j + "] Master Context is different", gLContext, gLContextArray[j].getSharedMaster());
            }
            System.err.println("XXX-" + i + "-C - GLContextShareSet.Map");
            GLContextShareSet.printMap(System.err);
            try {
                Thread.sleep(duration);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (bl) {
                System.err.println("XXX Destroy in clean order");
                for (n2 = 9; 0 <= n2; --n2) {
                    animatorArray[n2].stop();
                    gLWindowArray[n2].destroy();
                    Assert.assertTrue(NewtTestUtil.waitForVisible(gLWindowArray[n2], false, null));
                    Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindowArray[n2], false, null));
                }
            } else {
                System.err.println("XXX Destroy in creation order (but Master) - Driver Impl. May trigger driver Bug i.e. not postponing GL ctx destruction after releasing all refs.");
                for (n2 = 0; n2 < 10; ++n2) {
                    animatorArray[n2].stop();
                    gLWindowArray[n2].destroy();
                    Assert.assertTrue(NewtTestUtil.waitForVisible(gLWindowArray[n2], false, null));
                    Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindowArray[n2], false, null));
                }
            }
            System.err.println("XXX-" + i + "-X-SX1 - GLContextShareSet.Map");
            GLContextShareSet.printMap(System.err);
            Assert.assertEquals("GLContextShareSet ctx1.createdCount is not 1", 1L, GLContextShareSet.getCreatedShareCount(gLContext));
            Assert.assertEquals("GLContextShareSet ctx1.destroyedCount is not slaveCount", 10L, GLContextShareSet.getDestroyedShareCount(gLContext));
            for (n2 = 0; n2 < 10; ++n2) {
                animatorArray[n2] = null;
                gearsES2Array[n2] = null;
                gLWindowArray[n2] = null;
                gLContextArray[n2] = null;
            }
            System.gc();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.gc();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.err.println("XXX-" + i + "-X-SX2 - GLContextShareSet.Map");
            GLContextShareSet.printMap(System.err);
            Assert.assertEquals("GLContextShareSet ctx1.createdCount is not 1", 1L, GLContextShareSet.getCreatedShareCount(gLContext));
            Assert.assertEquals("GLContextShareSet ctx1.destroyedCount is not 0", 0L, GLContextShareSet.getDestroyedShareCount(gLContext));
        }
        System.gc();
        System.err.println("XXX-X-X-M1 - GLContextShareSet.Map");
        GLContextShareSet.printMap(System.err);
        Assert.assertEquals("GLContextShareSet ctx1.createdCount is not 1", 1L, GLContextShareSet.getCreatedShareCount(gLContext));
        Assert.assertEquals("GLContextShareSet ctx1.destroyedCount is not 0", 0L, GLContextShareSet.getDestroyedShareCount(gLContext));
        Assert.assertEquals("GLContextShareSet is not 1", 1L, GLContextShareSet.getSize());
        animator.stop();
        gLWindow.destroy();
        System.err.println("XXX-X-X-M2 - GLContextShareSet.Map");
        GLContextShareSet.printMap(System.err);
        Assert.assertTrue(NewtTestUtil.waitForVisible(gLWindow, false, null));
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow, false, null));
        Assert.assertEquals("GLContextShareSet ctx1.createdCount is not 0", 0L, GLContextShareSet.getCreatedShareCount(gLContext));
        Assert.assertEquals("GLContextShareSet ctx1.destroyedCount is not 0", 0L, GLContextShareSet.getDestroyedShareCount(gLContext));
        List<GLContext> list = gLContext.getCreatedShares();
        Assert.assertFalse("Ctx1 is still shared", gLContext.isShared());
        Assert.assertEquals("Ctx1 still has created shares", 0L, list.size());
        Assert.assertEquals("Ctx1 Master Context is not null", null, gLContext.getSharedMaster());
        Assert.assertEquals("GLContextShareSet is not 0", 0L, GLContextShareSet.getSize());
    }

    public static void main(String[] stringArray) {
        mainRun = true;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            ++i;
            try {
                duration = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        JUnitCore.main(TestSharedContextVBOES2NEWT5.class.getName());
    }

    static {
        duration = 1000L;
        mainRun = false;
    }
}

