/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.nativewindow.util.InsetsImmutable;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.GLTestUtil;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.NewtTestUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.util.List;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestSharedContextVBOES2NEWT3
extends UITestCase {
    static GLProfile glp;
    static GLCapabilities caps;
    static int width;
    static int height;
    static long duration;
    static long durationPostDestroy;
    static boolean mainRun;

    @BeforeClass
    public static void initClass() {
        if (GLProfile.isAvailable("GL2ES2")) {
            glp = GLProfile.get("GL2ES2");
            Assert.assertNotNull(glp);
            caps = new GLCapabilities(glp);
            Assert.assertNotNull(caps);
            width = 256;
            height = 256;
        } else {
            TestSharedContextVBOES2NEWT3.setTestSupported(false);
        }
    }

    protected GLWindow createGLWindow(int n, int n2, GearsES2 gearsES2) throws InterruptedException {
        GLWindow gLWindow = GLWindow.create(caps);
        Assert.assertNotNull(gLWindow);
        gLWindow.setPosition(n, n2);
        gLWindow.setTitle("Shared Gears NEWT Test: " + n + "/" + n2 + " shared true");
        gLWindow.setSize(width, height);
        gLWindow.addGLEventListener(gearsES2);
        return gLWindow;
    }

    @Test
    public void test01SyncedOneAnimatorCleanDtorOrderCopyBuffer() throws InterruptedException {
        this.syncedOneAnimator(true, false);
    }

    @Test
    public void test02SyncedOneAnimatorCleanDtorOrderMapBuffer() throws InterruptedException {
        this.syncedOneAnimator(true, true);
    }

    @Test
    public void test03SyncedOneAnimatorDirtyDtorOrderCopyBuffer() throws InterruptedException {
        this.syncedOneAnimator(false, false);
    }

    @Test
    public void test04SyncedOneAnimatorDirtyDtorOrderMapBuffer() throws InterruptedException {
        this.syncedOneAnimator(false, true);
    }

    public void syncedOneAnimator(boolean bl, boolean bl2) throws InterruptedException {
        Animator animator = new Animator(0);
        animator.start();
        GearsES2 gearsES2 = new GearsES2(0);
        gearsES2.setUseMappedBuffers(bl2);
        gearsES2.setValidateBuffers(true);
        GLWindow gLWindow = this.createGLWindow(0, 0, gearsES2);
        animator.add(gLWindow);
        InsetsImmutable insetsImmutable = gLWindow.getInsets();
        GearsES2 gearsES22 = new GearsES2(0);
        gearsES22.setSharedGears(gearsES2);
        GLWindow gLWindow2 = this.createGLWindow(gLWindow.getX() + width + insetsImmutable.getTotalWidth(), gLWindow.getY() + 0, gearsES22);
        gLWindow2.setSharedAutoDrawable(gLWindow);
        animator.add(gLWindow2);
        gLWindow2.setVisible(true);
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow, false, null));
        Assert.assertTrue(NewtTestUtil.waitForVisible(gLWindow, false, null));
        Assert.assertTrue(GLTestUtil.waitForContextCreated(gLWindow, false, null));
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow2, true, null));
        Assert.assertTrue(NewtTestUtil.waitForVisible(gLWindow2, true, null));
        Assert.assertTrue(GLTestUtil.waitForContextCreated(gLWindow2, false, null));
        gLWindow.setVisible(true);
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow, true, null));
        Assert.assertTrue(NewtTestUtil.waitForVisible(gLWindow, true, null));
        Assert.assertTrue(GLTestUtil.waitForContextCreated(gLWindow, true, null));
        Assert.assertTrue("Gears1 not initialized", gearsES2.waitForInit(true));
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow2, true, null));
        Assert.assertTrue(NewtTestUtil.waitForVisible(gLWindow2, true, null));
        Assert.assertTrue(GLTestUtil.waitForContextCreated(gLWindow2, true, null));
        Assert.assertTrue("Gears2 not initialized", gearsES22.waitForInit(true));
        GearsES2 gearsES23 = new GearsES2(0);
        gearsES23.setSharedGears(gearsES2);
        GLWindow gLWindow3 = this.createGLWindow(gLWindow.getX() + 0, gLWindow.getY() + height + insetsImmutable.getTotalHeight(), gearsES23);
        gLWindow3.setSharedAutoDrawable(gLWindow);
        animator.add(gLWindow3);
        gLWindow3.setVisible(true);
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow3, true, null));
        Assert.assertTrue(NewtTestUtil.waitForVisible(gLWindow3, true, null));
        Assert.assertTrue(GLTestUtil.waitForContextCreated(gLWindow3, true, null));
        Assert.assertTrue("Gears3 not initialized", gearsES23.waitForInit(true));
        GLContext gLContext = gLWindow.getContext();
        GLContext gLContext2 = gLWindow2.getContext();
        GLContext gLContext3 = gLWindow3.getContext();
        List<GLContext> list = gLContext.getCreatedShares();
        List<GLContext> list2 = gLContext2.getCreatedShares();
        List<GLContext> list3 = gLContext3.getCreatedShares();
        MiscUtils.dumpSharedGLContext("XXX-C-3.1", gLContext);
        MiscUtils.dumpSharedGLContext("XXX-C-3.2", gLContext2);
        MiscUtils.dumpSharedGLContext("XXX-C-3.3", gLContext3);
        Assert.assertTrue("Ctx1 is not shared", gLContext.isShared());
        Assert.assertTrue("Ctx2 is not shared", gLContext2.isShared());
        Assert.assertTrue("Ctx3 is not shared", gLContext3.isShared());
        Assert.assertEquals("Ctx1 has unexpected number of created shares", 2L, list.size());
        Assert.assertEquals("Ctx2 has unexpected number of created shares", 2L, list2.size());
        Assert.assertEquals("Ctx3 has unexpected number of created shares", 2L, list3.size());
        Assert.assertEquals("Ctx1 Master Context is different", gLContext, gLContext.getSharedMaster());
        Assert.assertEquals("Ctx2 Master Context is different", gLContext, gLContext2.getSharedMaster());
        Assert.assertEquals("Ctx3 Master Context is different", gLContext, gLContext3.getSharedMaster());
        Assert.assertTrue("Gears1 is shared", !gearsES2.usesSharedGears());
        Assert.assertTrue("Gears2 is not shared", gearsES22.usesSharedGears());
        Assert.assertTrue("Gears3 is not shared", gearsES23.usesSharedGears());
        try {
            Thread.sleep(duration);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (bl) {
            System.err.println("XXX Destroy in clean order NOW");
            gLWindow3.destroy();
            try {
                Thread.sleep(durationPostDestroy);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            gLWindow2.destroy();
            try {
                Thread.sleep(durationPostDestroy);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            gLWindow.destroy();
            try {
                Thread.sleep(durationPostDestroy);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            System.err.println("XXX Destroy in creation order NOW - Driver Impl. Ma trigger driver Bug i.e. not postponing GL ctx destruction after releasing all refs.");
            animator.pause();
            gLWindow.destroy();
            animator.resume();
            try {
                Thread.sleep(durationPostDestroy);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            animator.pause();
            gLWindow2.destroy();
            animator.resume();
            try {
                Thread.sleep(durationPostDestroy);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            gLWindow3.destroy();
            try {
                Thread.sleep(durationPostDestroy);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        Assert.assertTrue(NewtTestUtil.waitForVisible(gLWindow, false, null));
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow, false, null));
        Assert.assertTrue(NewtTestUtil.waitForVisible(gLWindow2, false, null));
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow2, false, null));
        Assert.assertTrue(NewtTestUtil.waitForVisible(gLWindow3, false, null));
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow3, false, null));
        animator.stop();
        list = gLContext.getCreatedShares();
        list2 = gLContext2.getCreatedShares();
        list3 = gLContext3.getCreatedShares();
        MiscUtils.dumpSharedGLContext("XXX-C-3.1", gLContext);
        MiscUtils.dumpSharedGLContext("XXX-C-3.2", gLContext2);
        MiscUtils.dumpSharedGLContext("XXX-C-3.3", gLContext3);
        Assert.assertTrue("Ctx1 is shared", !gLContext.isShared());
        Assert.assertTrue("Ctx2 is shared", !gLContext2.isShared());
        Assert.assertTrue("Ctx3 is shared", !gLContext3.isShared());
        Assert.assertEquals("Ctx1 has unexpected number of created shares", 0L, list.size());
        Assert.assertEquals("Ctx2 has unexpected number of created shares", 0L, list2.size());
        Assert.assertEquals("Ctx3 has unexpected number of created shares", 0L, list3.size());
        Assert.assertEquals("Ctx1 Master Context is set", null, gLContext.getSharedMaster());
        Assert.assertEquals("Ctx2 Master Context is set", null, gLContext2.getSharedMaster());
        Assert.assertEquals("Ctx3 Master Context is set", null, gLContext3.getSharedMaster());
    }

    @Test
    public void test11ASyncEachAnimatorCleanDtorOrderCopyBuffer() throws InterruptedException {
        this.asyncEachAnimator(true, false);
    }

    @Test
    public void test12ASyncEachAnimatorCleanDtorOrderMapBuffer() throws InterruptedException {
        this.asyncEachAnimator(true, true);
    }

    @Test
    public void test13AsyncEachAnimatorDirtyDtorOrderCopyBuffers() throws InterruptedException {
        this.asyncEachAnimator(false, false);
    }

    @Test
    public void test14AsyncEachAnimatorDirtyDtorOrderMapBuffers() throws InterruptedException {
        this.asyncEachAnimator(false, true);
    }

    public void asyncEachAnimator(boolean bl, boolean bl2) throws InterruptedException {
        Animator animator = new Animator(0);
        GearsES2 gearsES2 = new GearsES2(0);
        gearsES2.setSyncObjects(gearsES2);
        gearsES2.setUseMappedBuffers(bl2);
        gearsES2.setValidateBuffers(true);
        GLWindow gLWindow = this.createGLWindow(0, 0, gearsES2);
        animator.add(gLWindow);
        animator.start();
        InsetsImmutable insetsImmutable = gLWindow.getInsets();
        Animator animator2 = new Animator(0);
        GearsES2 gearsES22 = new GearsES2(0);
        gearsES22.setSharedGears(gearsES2);
        GLWindow gLWindow2 = this.createGLWindow(gLWindow.getX() + width + insetsImmutable.getTotalWidth(), gLWindow.getY() + 0, gearsES22);
        gLWindow2.setSharedAutoDrawable(gLWindow);
        animator2.add(gLWindow2);
        animator2.start();
        gLWindow2.setVisible(true);
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow, false, null));
        Assert.assertTrue(NewtTestUtil.waitForVisible(gLWindow, false, null));
        Assert.assertTrue(GLTestUtil.waitForContextCreated(gLWindow, false, null));
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow2, true, null));
        Assert.assertTrue(NewtTestUtil.waitForVisible(gLWindow2, true, null));
        Assert.assertTrue(GLTestUtil.waitForContextCreated(gLWindow2, false, null));
        gLWindow.setVisible(true);
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow, true, null));
        Assert.assertTrue(NewtTestUtil.waitForVisible(gLWindow, true, null));
        Assert.assertTrue(GLTestUtil.waitForContextCreated(gLWindow, true, null));
        Assert.assertTrue("Gears1 not initialized", gearsES2.waitForInit(true));
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow2, true, null));
        Assert.assertTrue(NewtTestUtil.waitForVisible(gLWindow2, true, null));
        Assert.assertTrue(GLTestUtil.waitForContextCreated(gLWindow2, true, null));
        Assert.assertTrue("Gears2 not initialized", gearsES22.waitForInit(true));
        Animator animator3 = new Animator(0);
        GearsES2 gearsES23 = new GearsES2(0);
        gearsES23.setSharedGears(gearsES2);
        GLWindow gLWindow3 = this.createGLWindow(gLWindow.getX() + 0, gLWindow.getY() + height + insetsImmutable.getTotalHeight(), gearsES23);
        gLWindow3.setSharedAutoDrawable(gLWindow);
        animator3.add(gLWindow3);
        animator3.start();
        gLWindow3.setVisible(true);
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow3, true, null));
        Assert.assertTrue(NewtTestUtil.waitForVisible(gLWindow3, true, null));
        Assert.assertTrue(GLTestUtil.waitForContextCreated(gLWindow3, true, null));
        Assert.assertTrue("Gears3 not initialized", gearsES23.waitForInit(true));
        GLContext gLContext = gLWindow.getContext();
        GLContext gLContext2 = gLWindow2.getContext();
        GLContext gLContext3 = gLWindow3.getContext();
        List<GLContext> list = gLContext.getCreatedShares();
        List<GLContext> list2 = gLContext2.getCreatedShares();
        List<GLContext> list3 = gLContext3.getCreatedShares();
        MiscUtils.dumpSharedGLContext("XXX-C-3.1", gLContext);
        MiscUtils.dumpSharedGLContext("XXX-C-3.2", gLContext2);
        MiscUtils.dumpSharedGLContext("XXX-C-3.3", gLContext3);
        Assert.assertTrue("Ctx1 is not shared", gLContext.isShared());
        Assert.assertTrue("Ctx2 is not shared", gLContext2.isShared());
        Assert.assertTrue("Ctx3 is not shared", gLContext3.isShared());
        Assert.assertEquals("Ctx1 has unexpected number of created shares", 2L, list.size());
        Assert.assertEquals("Ctx2 has unexpected number of created shares", 2L, list2.size());
        Assert.assertEquals("Ctx3 has unexpected number of created shares", 2L, list3.size());
        Assert.assertEquals("Ctx1 Master Context is different", gLContext, gLContext.getSharedMaster());
        Assert.assertEquals("Ctx2 Master Context is different", gLContext, gLContext2.getSharedMaster());
        Assert.assertEquals("Ctx3 Master Context is different", gLContext, gLContext3.getSharedMaster());
        Assert.assertTrue("Gears1 is shared", !gearsES2.usesSharedGears());
        Assert.assertTrue("Gears2 is not shared", gearsES22.usesSharedGears());
        Assert.assertTrue("Gears3 is not shared", gearsES23.usesSharedGears());
        try {
            Thread.sleep(duration);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (bl) {
            System.err.println("XXX Destroy in clean order NOW");
            animator3.stop();
            gLWindow3.destroy();
            try {
                Thread.sleep(durationPostDestroy);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            animator2.stop();
            gLWindow2.destroy();
            try {
                Thread.sleep(durationPostDestroy);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            animator.stop();
            gLWindow.destroy();
            try {
                Thread.sleep(durationPostDestroy);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            System.err.println("XXX Destroy in creation order NOW - Driver Impl. May trigger driver Bug i.e. not postponing GL ctx destruction after releasing all refs.");
            animator.stop();
            animator2.pause();
            animator3.pause();
            gLWindow.destroy();
            animator2.resume();
            animator3.resume();
            try {
                Thread.sleep(durationPostDestroy);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            animator2.stop();
            animator3.pause();
            gLWindow2.destroy();
            animator3.resume();
            try {
                Thread.sleep(durationPostDestroy);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            animator3.stop();
            gLWindow3.destroy();
            try {
                Thread.sleep(durationPostDestroy);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        Assert.assertTrue(NewtTestUtil.waitForVisible(gLWindow, false, null));
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow, false, null));
        Assert.assertTrue(NewtTestUtil.waitForVisible(gLWindow2, false, null));
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow2, false, null));
        Assert.assertTrue(NewtTestUtil.waitForVisible(gLWindow3, false, null));
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow3, false, null));
    }

    public static void main(String[] stringArray) {
        mainRun = true;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            ++i;
            try {
                duration = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        JUnitCore.main(TestSharedContextVBOES2NEWT3.class.getName());
    }

    static {
        duration = 1000L;
        durationPostDestroy = 170L;
        mainRun = false;
    }
}

