/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.nativewindow.util.InsetsImmutable;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.GLTestUtil;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.NewtTestUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestSharedContextVBOES2NEWT1
extends UITestCase {
    static GLProfile glp;
    static GLCapabilities caps;
    static int width;
    static int height;
    GLAutoDrawable sharedDrawable;
    GearsES2 sharedGears;
    static long duration;

    @BeforeClass
    public static void initClass() {
        if (GLProfile.isAvailable("GL2ES2")) {
            glp = GLProfile.get("GL2ES2");
            Assert.assertNotNull(glp);
            caps = new GLCapabilities(glp);
            Assert.assertNotNull(caps);
            width = 256;
            height = 256;
        } else {
            TestSharedContextVBOES2NEWT1.setTestSupported(false);
        }
    }

    private void initShared(boolean bl) throws InterruptedException {
        GLAutoDrawable gLAutoDrawable;
        if (bl) {
            gLAutoDrawable = GLWindow.create(caps);
            Assert.assertNotNull(gLAutoDrawable);
            gLAutoDrawable.setSize(width, height);
            gLAutoDrawable.setVisible(true);
            this.sharedDrawable = gLAutoDrawable;
        } else {
            this.sharedDrawable = GLDrawableFactory.getFactory(glp).createDummyAutoDrawable(null, true, caps, null);
        }
        Assert.assertNotNull(this.sharedDrawable);
        gLAutoDrawable = this.sharedDrawable;
        Assert.assertTrue(GLTestUtil.waitForRealized(gLAutoDrawable, true, null));
        this.sharedGears = new GearsES2();
        Assert.assertNotNull(this.sharedGears);
        this.sharedDrawable.addGLEventListener(this.sharedGears);
        this.sharedDrawable.display();
        GLContext gLContext = this.sharedDrawable.getContext();
        Assert.assertTrue("Master ctx not created", GLTestUtil.waitForContextCreated(this.sharedDrawable, true, null));
        Assert.assertTrue("Master Ctx is shared before shared creation", !gLContext.isShared());
        Assert.assertTrue("Master Gears not initialized", this.sharedGears.waitForInit(true));
        System.err.println("Master Gears Init done: " + this.sharedGears);
        Assert.assertTrue("Master Gears is shared", !this.sharedGears.usesSharedGears());
    }

    private void releaseShared() {
        Assert.assertNotNull(this.sharedDrawable);
        this.sharedDrawable.destroy();
        this.sharedDrawable = null;
    }

    protected GLWindow runTestGL(Animator animator, int n, int n2, boolean bl, boolean bl2) throws InterruptedException {
        GLWindow gLWindow = GLWindow.create(caps);
        Assert.assertNotNull(gLWindow);
        gLWindow.setPosition(n, n2);
        gLWindow.setTitle("Shared Gears NEWT Test: " + n + "/" + n2 + " shared " + bl);
        if (bl) {
            gLWindow.setSharedAutoDrawable(this.sharedDrawable);
        }
        gLWindow.setSize(width, height);
        GearsES2 gearsES2 = new GearsES2(bl2 ? 1 : 0);
        if (bl) {
            gearsES2.setSharedGears(this.sharedGears);
        }
        gLWindow.addGLEventListener(gearsES2);
        animator.add(gLWindow);
        animator.start();
        gLWindow.setVisible(true);
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow, true, null));
        Assert.assertTrue(NewtTestUtil.waitForVisible(gLWindow, true, null));
        Assert.assertTrue(GLTestUtil.waitForContextCreated(gLWindow, true, null));
        GLContext gLContext = this.sharedDrawable.getContext();
        MiscUtils.dumpSharedGLContext("Master Context", gLContext);
        MiscUtils.dumpSharedGLContext("New    Context", gLWindow.getContext());
        if (bl) {
            Assert.assertEquals("Master Context not shared as expected", true, gLContext.isShared());
            Assert.assertEquals("Master Context is different", gLContext, gLWindow.getContext().getSharedMaster());
        } else {
            Assert.assertEquals("Master Context is not null", null, gLWindow.getContext().getSharedMaster());
        }
        Assert.assertEquals("New    Context not shared as expected", bl, gLWindow.getContext().isShared());
        Assert.assertTrue("Gears not initialized", gearsES2.waitForInit(true));
        System.err.println("Slave Gears Init done: " + gearsES2);
        Assert.assertEquals("Gears is not shared as expected", bl, gearsES2.usesSharedGears());
        return gLWindow;
    }

    @Test
    public void test01CommonAnimatorSharedOnscreen() throws InterruptedException {
        this.initShared(true);
        Animator animator = new Animator(0);
        GLWindow gLWindow = this.runTestGL(animator, 0, 0, true, false);
        InsetsImmutable insetsImmutable = gLWindow.getInsets();
        GLWindow gLWindow2 = this.runTestGL(animator, gLWindow.getX() + width + insetsImmutable.getTotalWidth(), gLWindow.getY() + 0, true, false);
        GLWindow gLWindow3 = this.runTestGL(animator, gLWindow.getX() + 0, gLWindow.getY() + height + insetsImmutable.getTotalHeight(), true, false);
        try {
            Thread.sleep(duration);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        animator.stop();
        gLWindow.destroy();
        gLWindow2.destroy();
        gLWindow3.destroy();
        Assert.assertTrue(NewtTestUtil.waitForVisible(gLWindow, false, null));
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow, false, null));
        Assert.assertTrue(GLTestUtil.waitForContextCreated(gLWindow, false, null));
        Assert.assertTrue(NewtTestUtil.waitForVisible(gLWindow2, false, null));
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow2, false, null));
        Assert.assertTrue(GLTestUtil.waitForContextCreated(gLWindow2, false, null));
        Assert.assertTrue(NewtTestUtil.waitForVisible(gLWindow3, false, null));
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow3, false, null));
        Assert.assertTrue(GLTestUtil.waitForContextCreated(gLWindow3, false, null));
        this.releaseShared();
    }

    @Test
    public void test02EachWithAnimatorSharedOnscreen() throws InterruptedException {
        this.initShared(true);
        Animator animator = new Animator(0);
        Animator animator2 = new Animator(0);
        Animator animator3 = new Animator(0);
        GLWindow gLWindow = this.runTestGL(animator, 0, 0, true, false);
        InsetsImmutable insetsImmutable = gLWindow.getInsets();
        GLWindow gLWindow2 = this.runTestGL(animator2, gLWindow.getX() + width + insetsImmutable.getTotalWidth(), gLWindow.getY() + 0, true, false);
        GLWindow gLWindow3 = this.runTestGL(animator3, gLWindow.getX() + 0, gLWindow.getY() + height + insetsImmutable.getTotalHeight(), true, false);
        try {
            Thread.sleep(duration);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        animator.stop();
        animator2.stop();
        animator3.stop();
        gLWindow.destroy();
        gLWindow2.destroy();
        gLWindow3.destroy();
        Assert.assertTrue(NewtTestUtil.waitForVisible(gLWindow, false, null));
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow, false, null));
        Assert.assertTrue(GLTestUtil.waitForContextCreated(gLWindow, false, null));
        Assert.assertTrue(NewtTestUtil.waitForVisible(gLWindow2, false, null));
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow2, false, null));
        Assert.assertTrue(GLTestUtil.waitForContextCreated(gLWindow2, false, null));
        Assert.assertTrue(NewtTestUtil.waitForVisible(gLWindow3, false, null));
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow3, false, null));
        Assert.assertTrue(GLTestUtil.waitForContextCreated(gLWindow3, false, null));
        this.releaseShared();
    }

    @Test
    public void test11CommonAnimatorSharedOffscreen() throws InterruptedException {
        this.initShared(false);
        Animator animator = new Animator(0);
        GLWindow gLWindow = this.runTestGL(animator, 0, 0, true, false);
        InsetsImmutable insetsImmutable = gLWindow.getInsets();
        GLWindow gLWindow2 = this.runTestGL(animator, gLWindow.getX() + width + insetsImmutable.getTotalWidth(), gLWindow.getY() + 0, true, false);
        GLWindow gLWindow3 = this.runTestGL(animator, gLWindow.getX() + 0, gLWindow.getY() + height + insetsImmutable.getTotalHeight(), true, false);
        try {
            Thread.sleep(duration);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        animator.stop();
        gLWindow.destroy();
        gLWindow2.destroy();
        gLWindow3.destroy();
        Assert.assertTrue(NewtTestUtil.waitForVisible(gLWindow, false, null));
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow, false, null));
        Assert.assertTrue(GLTestUtil.waitForContextCreated(gLWindow, false, null));
        Assert.assertTrue(NewtTestUtil.waitForVisible(gLWindow2, false, null));
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow2, false, null));
        Assert.assertTrue(GLTestUtil.waitForContextCreated(gLWindow2, false, null));
        Assert.assertTrue(NewtTestUtil.waitForVisible(gLWindow3, false, null));
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow3, false, null));
        Assert.assertTrue(GLTestUtil.waitForContextCreated(gLWindow3, false, null));
        this.releaseShared();
    }

    @Test
    public void test12EachWithAnimatorSharedOffscreen() throws InterruptedException {
        this.initShared(false);
        Animator animator = new Animator(0);
        Animator animator2 = new Animator(0);
        Animator animator3 = new Animator(0);
        GLWindow gLWindow = this.runTestGL(animator, 0, 0, true, false);
        InsetsImmutable insetsImmutable = gLWindow.getInsets();
        GLWindow gLWindow2 = this.runTestGL(animator2, gLWindow.getX() + width + insetsImmutable.getTotalWidth(), gLWindow.getY() + 0, true, false);
        GLWindow gLWindow3 = this.runTestGL(animator3, gLWindow.getX() + 0, gLWindow.getY() + height + insetsImmutable.getTotalHeight(), true, false);
        try {
            Thread.sleep(duration);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        animator.stop();
        animator2.stop();
        animator3.stop();
        gLWindow.destroy();
        gLWindow2.destroy();
        gLWindow3.destroy();
        Assert.assertTrue(NewtTestUtil.waitForVisible(gLWindow, false, null));
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow, false, null));
        Assert.assertTrue(GLTestUtil.waitForContextCreated(gLWindow, false, null));
        Assert.assertTrue(NewtTestUtil.waitForVisible(gLWindow2, false, null));
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow2, false, null));
        Assert.assertTrue(GLTestUtil.waitForContextCreated(gLWindow2, false, null));
        Assert.assertTrue(NewtTestUtil.waitForVisible(gLWindow3, false, null));
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow3, false, null));
        Assert.assertTrue(GLTestUtil.waitForContextCreated(gLWindow3, false, null));
        this.releaseShared();
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            ++i;
            try {
                duration = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        JUnitCore.main(TestSharedContextVBOES2NEWT1.class.getName());
    }

    static {
        duration = 1000L;
    }
}

