/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.nativewindow.util.InsetsImmutable;
import com.jogamp.newt.Window;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.GLTestUtil;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.NewtTestUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.util.List;
import jogamp.opengl.GLAutoDrawableBase;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestSharedContextVBOES2NEWT0
extends UITestCase {
    static GLProfile glp;
    static GLCapabilities caps;
    static int width;
    static int height;
    static long duration;
    static long durationPostDestroy;

    @BeforeClass
    public static void initClass() {
        if (GLProfile.isAvailable("GL2ES2")) {
            glp = GLProfile.get("GL2ES2");
            Assert.assertNotNull(glp);
            caps = new GLCapabilities(glp);
            Assert.assertNotNull(caps);
            width = 256;
            height = 256;
        } else {
            TestSharedContextVBOES2NEWT0.setTestSupported(false);
        }
    }

    protected GLWindow runTestGL(Animator animator, int n, int n2, GearsES2 gearsES2, GLAutoDrawable gLAutoDrawable) throws InterruptedException {
        boolean bl = null != gLAutoDrawable;
        GLWindow gLWindow = GLWindow.create(caps);
        Assert.assertNotNull(gLWindow);
        gLWindow.setPosition(n, n2);
        gLWindow.setTitle("Shared Gears NEWT Test: " + n + "/" + n2 + " shared " + bl);
        if (bl) {
            gLWindow.setSharedAutoDrawable(gLAutoDrawable);
        }
        gLWindow.setSize(width, height);
        gLWindow.addGLEventListener(gearsES2);
        animator.add(gLWindow);
        gLWindow.setVisible(true);
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow, true, null));
        Assert.assertTrue(NewtTestUtil.waitForVisible(gLWindow, true, null));
        gLWindow.display();
        Assert.assertTrue(GLTestUtil.waitForContextCreated(gLWindow, true, null));
        Assert.assertTrue("Gears not initialized", gearsES2.waitForInit(true));
        return gLWindow;
    }

    @Test
    public void test01CommonAnimatorSharedCopyBuffer() throws InterruptedException {
        this.testCommonAnimatorSharedImpl(false);
    }

    @Test
    public void test02CommonAnimatorMapBuffer() throws InterruptedException {
        this.testCommonAnimatorSharedImpl(true);
    }

    private void testCommonAnimatorSharedImpl(boolean bl) throws InterruptedException {
        Animator animator = new Animator(0);
        GearsES2 gearsES2 = new GearsES2(0);
        gearsES2.setUseMappedBuffers(bl);
        gearsES2.setValidateBuffers(true);
        GLWindow gLWindow = this.runTestGL(animator, 0, 0, gearsES2, null);
        GLContext gLContext = gLWindow.getContext();
        Assert.assertTrue("Ctx is shared before shared creation", !gLContext.isShared());
        InsetsImmutable insetsImmutable = gLWindow.getInsets();
        MiscUtils.dumpSharedGLContext("XXX-C-1.1", gLContext);
        GearsES2 gearsES22 = new GearsES2(0);
        gearsES22.setSharedGears(gearsES2);
        GLWindow gLWindow2 = this.runTestGL(animator, gLWindow.getX() + width + insetsImmutable.getTotalWidth(), gLWindow.getY() + 0, gearsES22, gLWindow);
        GLContext gLContext2 = gLWindow2.getContext();
        Assert.assertTrue("Ctx1 is not shared", gLContext.isShared());
        Assert.assertTrue("Ctx2 is not shared", gLContext2.isShared());
        Object object = gLContext.getCreatedShares();
        Object object2 = gLContext2.getCreatedShares();
        MiscUtils.dumpSharedGLContext("XXX-C-2.1", gLContext);
        MiscUtils.dumpSharedGLContext("XXX-C-2.2", gLContext2);
        Assert.assertEquals("Ctx1 has unexpected number of created shares", 1L, object.size());
        Assert.assertEquals("Ctx2 has unexpected number of created shares", 1L, object2.size());
        object = new GearsES2(0);
        ((GearsES2)object).setSharedGears(gearsES2);
        object2 = this.runTestGL(animator, gLWindow.getX() + 0, gLWindow.getY() + height + insetsImmutable.getTotalHeight(), (GearsES2)object, gLWindow);
        GLContext gLContext3 = ((GLAutoDrawableBase)object2).getContext();
        Assert.assertTrue("Ctx1 is not shared", gLContext.isShared());
        Assert.assertTrue("Ctx2 is not shared", gLContext2.isShared());
        Assert.assertTrue("Ctx3 is not shared", gLContext3.isShared());
        List<GLContext> list = gLContext.getCreatedShares();
        List<GLContext> list2 = gLContext2.getCreatedShares();
        List<GLContext> list3 = gLContext3.getCreatedShares();
        MiscUtils.dumpSharedGLContext("XXX-C-3.1", gLContext);
        MiscUtils.dumpSharedGLContext("XXX-C-3.2", gLContext2);
        MiscUtils.dumpSharedGLContext("XXX-C-3.3", gLContext3);
        Assert.assertEquals("Ctx1 has unexpected number of created shares", 2L, list.size());
        Assert.assertEquals("Ctx2 has unexpected number of created shares", 2L, list2.size());
        Assert.assertEquals("Ctx3 has unexpected number of created shares", 2L, list3.size());
        Assert.assertTrue("Gears1 is shared", !gearsES2.usesSharedGears());
        Assert.assertTrue("Gears2 is not shared", gearsES22.usesSharedGears());
        Assert.assertTrue("Gears3 is not shared", ((GearsES2)object).usesSharedGears());
        animator.start();
        try {
            Thread.sleep(duration);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        ((GLWindow)object2).destroy();
        Assert.assertTrue(NewtTestUtil.waitForVisible((Window)object2, false, null));
        Assert.assertTrue(NewtTestUtil.waitForRealized((Window)object2, false, null));
        Assert.assertTrue(GLTestUtil.waitForContextCreated((GLAutoDrawable)object2, false, null));
        list = gLContext.getCreatedShares();
        list2 = gLContext2.getCreatedShares();
        list3 = gLContext3.getCreatedShares();
        MiscUtils.dumpSharedGLContext("XXX-D-0.1", gLContext);
        MiscUtils.dumpSharedGLContext("XXX-D-0.2", gLContext2);
        MiscUtils.dumpSharedGLContext("XXX-D-0.3", gLContext3);
        Assert.assertTrue("Ctx1 is shared", gLContext.isShared());
        Assert.assertTrue("Ctx2 is shared", gLContext2.isShared());
        Assert.assertTrue("Ctx3 is shared", gLContext3.isShared());
        Assert.assertEquals("Ctx1 has unexpected number of created shares", 1L, list.size());
        Assert.assertEquals("Ctx2 has unexpected number of created shares", 1L, list2.size());
        Assert.assertEquals("Ctx3 has unexpected number of created shares", 2L, list3.size());
        try {
            Thread.sleep(durationPostDestroy);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        gLWindow2.destroy();
        Assert.assertTrue(NewtTestUtil.waitForVisible(gLWindow2, false, null));
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow2, false, null));
        Assert.assertTrue(GLTestUtil.waitForContextCreated(gLWindow2, false, null));
        list = gLContext.getCreatedShares();
        list2 = gLContext2.getCreatedShares();
        list3 = gLContext3.getCreatedShares();
        MiscUtils.dumpSharedGLContext("XXX-D-1.1", gLContext);
        MiscUtils.dumpSharedGLContext("XXX-D-1.2", gLContext2);
        MiscUtils.dumpSharedGLContext("XXX-D-1.3", gLContext3);
        Assert.assertTrue("Ctx1 is not shared", gLContext.isShared());
        Assert.assertTrue("Ctx2 is not shared", gLContext2.isShared());
        Assert.assertTrue("Ctx3 is not shared", gLContext3.isShared());
        Assert.assertEquals("Ctx1 has unexpected number of created shares", 0L, list.size());
        Assert.assertEquals("Ctx2 has unexpected number of created shares", 1L, list2.size());
        Assert.assertEquals("Ctx3 has unexpected number of created shares", 1L, list3.size());
        try {
            Thread.sleep(durationPostDestroy);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        gLWindow.destroy();
        Assert.assertTrue(NewtTestUtil.waitForVisible(gLWindow, false, null));
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow, false, null));
        Assert.assertTrue(GLTestUtil.waitForContextCreated(gLWindow, false, null));
        list = gLContext.getCreatedShares();
        list2 = gLContext2.getCreatedShares();
        list3 = gLContext3.getCreatedShares();
        MiscUtils.dumpSharedGLContext("XXX-D-2.1", gLContext);
        MiscUtils.dumpSharedGLContext("XXX-D-2.2", gLContext2);
        MiscUtils.dumpSharedGLContext("XXX-D-2.3", gLContext3);
        Assert.assertTrue("Ctx1 is not shared", !gLContext.isShared());
        Assert.assertTrue("Ctx2 is not shared", !gLContext2.isShared());
        Assert.assertTrue("Ctx3 is not shared", !gLContext3.isShared());
        Assert.assertEquals("Ctx1 has unexpected number of created shares", 0L, list.size());
        Assert.assertEquals("Ctx2 has unexpected number of created shares", 0L, list2.size());
        Assert.assertEquals("Ctx3 has unexpected number of created shares", 0L, list3.size());
        try {
            Thread.sleep(durationPostDestroy);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        animator.stop();
        Assert.assertEquals(false, animator.isAnimating());
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            ++i;
            try {
                duration = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        JUnitCore.main(TestSharedContextVBOES2NEWT0.class.getName());
    }

    static {
        duration = 1000L;
        durationPostDestroy = 1000L;
    }
}

